<?
require '../includes/init.php'
?>
<!DOCTYPE html>
<html lang="<?echo $site_lang; ?>">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Log-in | LaBakeca.eu</title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <?require '../includes/inc_head.php';?>
    <style type="text/css">
    .page {

        display: flex;
        flex-direction: column;
        height: calc(100% - 40px);

        place-content: center;
        width: calc(100% - 40px);
    }

    @media (max-width: 767px) {
        .page {
            height: auto;
            margin-bottom: 20px;
            padding-bottom: 20px;
        }
    }

    .containerlog {
        display: flex;
        height: 320px;
        margin: 0 auto;
        width: 640px;
    }

    @media (max-width: 767px) {
        .containerlog {
            flex-direction: column;
            height: 630px;
            width: 320px;
        }
    }

    .left {
        background: white;
        height: calc(100% - 40px);
        top: 20px;
        position: relative;
        width: 50%;
    }

    @media (max-width: 767px) {
        .left {
            height: 100%;
            left: 20px;
            width: calc(100% - 40px);
            max-height: 270px;
        }
    }

    .login {
        font-size: 50px;
        font-weight: 900;
        margin: 50px 40px 40px;
    }

    .eula {
        color: #999;
        font-size: 14px;
        line-height: 1.5;
        margin: 40px;
    }

    .right {
        background: #474A59;
        box-shadow: 0px 0px 40px 16px rgba(0, 0, 0, 0.22);
        color: #F1F1F2;
        position: relative;
        width: 50%;
    }

    @media (max-width: 767px) {
        .right {
            flex-shrink: 0;
            height: 100%;
            width: 100%;
            max-height: 350px;
        }
    }

    .svgLog {
        position: absolute;
        width: 320px;
    }

    path {
        fill: none;
        stroke: url(#linearGradient);
        ;
        stroke-width: 4;
        stroke-dasharray: 240 1386;
    }

    .form {
        margin: 40px;
        position: absolute;
    }

    .labellog {
        color: #c2c2c5;
        display: block;
        font-size: 14px;
        height: 16px;
        margin-top: 20px;
        margin-bottom: 5px;
    }

    input[type="email"],
    input[type="password"],
    .inputlog,
    #txtUsr,
    #txtPippo {
        background: transparent !important;
        border: 0;
        color: #f2f2f2;
        font-size: 20px;
        height: 30px;
        line-height: 30px;
        outline: none !important;
        width: 100%;
    }

    .inputlog::-moz-focus-inner {
        border: 0;
    }

    #submit {
        color: #707075;
        margin-top: 40px;
        transition: color 300ms;
    }

    #submit:focus {
        color: #f2f2f2;
    }

    #submit:active {
        color: #d0d0d2;
    }

    #overlay {
        background-color: #ccc;
        /*or semitransparent image*/
        display: none;
        height: 100%;
        width: 100%;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 100;
    }
    /* Change Autocomplete styles in Chrome*/
input:-webkit-autofill,
input:-webkit-autofill:hover, 
input:-webkit-autofill:focus,
textarea:-webkit-autofill,
textarea:-webkit-autofill:hover,
textarea:-webkit-autofill:focus,
select:-webkit-autofill,
select:-webkit-autofill:hover,
select:-webkit-autofill:focus {
  
  -webkit-text-fill-color: #fff;
  -webkit-box-shadow: 0 0 0px 1000px transparent inset;
  transition: background-color 5000s ease-in-out 0s;
}
    </style>
</head>
<body>
    <!-- ======= Header ======= -->
    <?require '../includes/inc_topbar.php'?>
    <main id="main">
        <!-- ======= Breadcrumbs ======= -->
        <div class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <h2>Login</h2>
                </div>
            </div>
        </div><!-- End Breadcrumbs -->
        <!-- ======= Blog Section ======= -->
        <?if (1 == 1 and $_SERVER['REMOTE_ADDR'] != "93.32.123.231") {?>
        <!-- ======= Blog Section ======= -->
        <section class="inner-page">
            <div class="container" data-aos="fade-up">
                <div class="section-header">
                    <h2>Novità in arrivo!</h2>
                </div>
                <div class="container-fluid cs img-fluid">
                </div>
                <div class="section-header pt-4 m-4" style="color:black;background-color: #0000000d;">
                    <a href="/signup/registrazione/index" class="">Iscriviti e Torna presto</a> per scoprire cosa bolle in pentola..
                </div>
            </div>
        </section><!-- End Inner Page -->
        <?} else {?>
        <section class="inner-page">
            <div class="page">
                <div class="containerlog">
                    <div class="left">
                        <div class="login">Login</div>
                        <div class="eula">By logging in you agree to the terms of service.</div>
                        <div class="eula"> <a class="btn-getstarted mt-3" onclick="openRecovery()">
                                <i class="fa fa-sign-in"></i> Hai dimenticato la password?
                            </a></div>
                    </div>
                    <div class="right">
                        <svg class="svgLog" viewBox="0 0 320 300">
                            <defs>
                                <linearGradient inkscape:collect="always" id="linearGradient" x1="13" y1="193.49992" x2="307" y2="193.49992" gradientUnits="userSpaceOnUse">
                                    <stop style="stop-color:var(--color-primary);" offset="0" id="stop876" />
                                    <stop style="stop-color:var(--color-primary-dark);" offset="1" id="stop878" />
                                </linearGradient>
                            </defs>
                            <path d="m 40,120.00016 239.99984,-3.2e-4 c 0,0 24.99263,0.79932 25.00016,35.00016 0.008,34.20084 -25.00016,35 -25.00016,35 h -239.99984 c 0,-0.0205 -25,4.01348 -25,38.5 0,34.48652 25,38.5 25,38.5 h 215 c 0,0 20,-0.99604 20,-25 0,-24.00396 -20,-25 -20,-25 h -190 c 0,0 -20,1.71033 -20,25 0,24.00396 20,25 20,25 h 168.57143" />
                        </svg>
                        <div class="form">
                            <form id="frmLogin" method="POST" name="frmLogin" onsubmit="tryLogin();return false;">
                                <label class="labellog" for="email">Email</label>
                                <input class="inputlog" name="txtUsr" id="txtUsr" type="email" id="email" required>
                                <label class="labellog" for="password">Password</label>
                                <input class="inputlog" name="txtPippo" id="txtPippo" type="password" id="password" required>
                                <input class="inputlog" type="submit" id="submit" value="Submit">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Inner Page -->
        <!-- Recover password Modal -->
        <div class="modal fade" id="mdlRecovery" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitleRecvoery" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalCenterTitleRecvoery">Recupera la password!</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="frmRecovery" method="POST" name="frmRecovery" onsubmit="ajaxRecovery(this);return false;">
                            <div class="form-group row">
                                <label class="col-5 col-form-label" for="txtMailRecover">Inserisci la tua mail!</label>
                                <div class="col-7">
                                    <input id="txtMailRecover" name="txtMailRecover" placeholder="Inserisci qua la tua email.." type="email" class="form-control" required="required">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="offset-5 col-7">
                                    <button name="submit" type="submit" class="btn-getstarted"> Recupera </button>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="offset-5 col-7">
                                    <a>
                                        <i class="fa fa-sign-in"></i> Verrà inviata una mail a questo indirizzo.
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                    <hr>
                    <!--<p><a href="#" class="tooltip-test" title="Ti verrà inviata una mail con le istruzioni.">Hai dimenticato la password?</a> </p>-->
                    <hr>
                </div>
            </div>
        </div>
        <?}?>
     </main><!-- End #main -->
    <!-- ======= Footer ======= -->
    <footer id="footer" class="footer">
        <?require '../includes/inc_footer_' . $site_lang . '.php';?>
        <?require '../includes/inc_footer_copyright.php';?>
    </footer><!-- End Footer -->
    <a href="#" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
    <div id="preloader"></div>
    <?require '../includes/inc_script.php'?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/2.2.0/anime.min.js" integrity="sha512-X8lZKRjcVNiBSXn7PNdIncguzX4v8peKIuD9DpNQJqOmKrH4KFvYkDBYdJikYBmghypYSQ+nBlclJsACfDhaKw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script type="text/javascript">
    var current = null;
    document.querySelector('#txtUsr').addEventListener('focus', function(e) {
        if (current) current.pause();
        current = anime({
            targets: 'path',
            strokeDashoffset: {
                value: 0,
                duration: 700,
                easing: 'easeOutQuart'
            },
            strokeDasharray: {
                value: '240 1386',
                duration: 700,
                easing: 'easeOutQuart'
            }
        });
    });
    document.querySelector('#txtPippo').addEventListener('focus', function(e) {
        if (current) current.pause();
        current = anime({
            targets: 'path',
            strokeDashoffset: {
                value: -336,
                duration: 700,
                easing: 'easeOutQuart'
            },
            strokeDasharray: {
                value: '240 1386',
                duration: 700,
                easing: 'easeOutQuart'
            }
        });
    });
    document.querySelector('#submit').addEventListener('focus', function(e) {
        if (current) current.pause();
        current = anime({
            targets: 'path',
            strokeDashoffset: {
                value: -730,
                duration: 700,
                easing: 'easeOutQuart'
            },
            strokeDasharray: {
                value: '530 1386',
                duration: 700,
                easing: 'easeOutQuart'
            }
        });
    });
    </script>
 <script type="text/javascript">
    function tryLogin() {

        //costruzione di qs concatenando i parametri
        var qs = "";
        var parser, xmlDoc, errore, msgErr;
        var username, password;
        username = $("#txtUsr").val();
        password = $("#txtPippo").val();
        qs = "?l=" + "<?echo $site_lang;?>";
        qs = qs + "&txtUsr=" + username;
        qs = qs + "&txtPippo=" + password;

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.status == 500) {
                $("#mdlLogin").modal("hide");
                alert("Dati Incorretti");
            }
            if (this.readyState == 4 && this.status == 200) {

                $("#mdlLogin").modal("hide");
                //alert(this.responseText);
                if (this.responseText == "Yis") {
                    // alert("Benvenuto");
                    location.replace("https://labakeca.eu/<?echo $site_lang;?>/index");
                } else if ((this.responseText == "Incorrectdata") || (this.responseText == "Queryfallita")) {
                    alert("Combinazione di mail e password incorretta.");

                }

            }
        };
        xhttp.open("POST", "../signup/users/loginLogic.php", false);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        if (qs.length > 2) {
            qs = qs.slice(1);
        }
        //alert(qs);
        xhttp.send(qs);
    }


    function openRecovery() {
        $("#mdlLogin").modal("hide");
        $("#mdlRecovery").modal("show");
    }

    function ajaxRecovery() {
        //costruzione di qs concatenando i parametri
        indir = txtMailRecover.value;
        qs = "?mail=" + indir;

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if (this.status == 500) {
                alert("C'è stato un problema. Riprova più tardi.");
            }
            if (this.readyState == 4 && this.status == 200) {
                $("#mdlRecovery").modal("hide");


                if (this.responseText !== "Nope") {

                    alert("Richiesta inviata con successo! Controlla la tua mail..");
                } else {
                    alert(this.responseText); //location.reload();

                }
            }
        };
        xhttp.open("POST", "../signup/scripts/recoverPassword.php", true);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        if (qs.length > 2) {
            qs = qs.slice(1);
        }
        //alert(qs);
        xhttp.send(qs);
    }
    </script>
</body>

</html>