"use strict";

// Class definition
var KTWizard4 = function () {
	// Base elements
	var wizardEl;
	var formEl;
	var validator;
	var wizard;

	var dz1finish = false;
	var dz2finish = false;
	var dz3finish = false;
	var dz4finish = false;
	var dz5finish = false;
	var dz6finish = false;

	// Private functions
	var initWizard = function () {
		// Initialize form wizard
		wizard = new KTWizard('kt_wizard_v4', {
			startStep: 1, // initial active step number
			clickableSteps: true  // allow step clicking
		});

		// Validation before going to next page
		wizard.on('beforeNext', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  // don't go to the next step
			}
		});

		wizard.on('beforePrev', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  // don't go to the next step
			}
		});

		// Change event
		wizard.on('change', function(wizard) {
			KTUtil.scrollTop();
		});

		if($(".switchProfilazione").is(":checked"))
		{
			$(".profilazione").show()
			}
			else
			{
				$(".profilazione").hide()
			}
		

		$(".switchProfilazione").click(function(){if(this.checked == true)
			{
				$(".profilazione").show()
			}else
			{
				$(".profilazione").hide()
			}}
			)
	}

	var initValidation = function() {
		validator = formEl.validate({
			// Validate only visible fields
			ignore: ":hidden",

			// Validation rules
			rules: {
				//= Step 1
				campaignName: {
					required: true
				}
				,
				agencyName: {
					required: true
				},
				campaignLink: {
					required: true
				},
				campaignTitle: {
					required: true
				},
				campaignDescription: {
					required: true
				},
				campaignOwner: {
					required: true
				}
				,
				campaignLanguage:{
					required: true
				},
				campaignStartDate: {
					required: true
				},
				campaignEndDate: {
					required: true
				}

			},


			// Display error
			invalidHandler: function(event, validator) {
				KTUtil.scrollTop();

				swal.fire({
					"title": "",
					"text": "Alcuni dati sono errati o mancanti, correggili prima di proseguire",
					"type": "error",
					"confirmButtonClass": "btn btn-secondary"
				});
			},

			// Submit valid form
			submitHandler: function (form) {

			}
		});


	}

	var checkSending = function(){
		console.log("Controllo la fine degli upload");
		console.log(dz1finish);
		console.log(dz2finish);
		console.log(dz3finish);
		console.log(dz4finish);
		console.log(dz5finish);
		console.log(dz6finish);

		if(dz1finish == true && dz2finish == true && dz3finish == true && dz4finish == true && dz5finish == true && dz6finish == true)
                    {

                    	sendForm();
                    }
	}

	var initSubmit = function() {

		var btn = formEl.find('[data-ktwizard-type="action-submit"]');

		btn.on('click', function(e) {
			e.preventDefault();

			dz1finish = false;
			if(window.myDropzone.getQueuedFiles().length == 0)
			{
				dz1finish = true;
			}
			dz2finish = false;
			if(window.myDropzone2.getQueuedFiles().length == 0)
			{
				dz2finish = true;
			}
			dz3finish = false;
			if(window.myDropzone3.getQueuedFiles().length == 0)
			{
				dz3finish = true;
			}

			dz4finish = false;
			if(window.myDropzone4.getQueuedFiles().length == 0)
			{
				dz4finish = true;
			}

			dz5finish = false;
			if(window.myDropzone5.getQueuedFiles().length == 0)
			{
				dz5finish = true;
			}

			dz6finish = false;
			if(window.myDropzone6.getQueuedFiles().length == 0)
			{
				dz6finish = true;
			}


			if(dz1finish == true && dz2finish == true && dz3finish == true && dz4finish == true && dz5finish == true && dz6finish == true)
			{
				checkSending();
			}
			else
			{
			
                 window.myDropzone.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file1',
    name: 'file1',
    value: file.name
}).appendTo(formEl);
                 	dz1finish = true;
                    checkSending();
                 })

                 window.myDropzone2.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file2',
    name: 'file2',
    value: file.name
}).appendTo(formEl);
                 	dz2finish = true;
                 	checkSending();
                 })

                   window.myDropzone3.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file3',
    name: 'file3',
    value: file.name
}).appendTo(formEl);
                 	dz3finish = true;
                 	checkSending();
                 })

window.myDropzone4.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file4',
    name: 'file4',
    value: file.name
}).appendTo(formEl);
                 	dz4finish = true;
                 	checkSending();
                 });

window.myDropzone5.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file5',
    name: 'file5',
    value: file.name
}).appendTo(formEl);
                 	dz5finish = true;
                 	checkSending();
                 });

window.myDropzone6.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file6',
    name: 'file6',
    value: file.name
}).appendTo(formEl);
                 	dz6finish = true;
                 	checkSending();
                 });

			window.myDropzone.processQueue();
			window.myDropzone2.processQueue();
			window.myDropzone3.processQueue();

			window.myDropzone4.processQueue();
			window.myDropzone5.processQueue();
			window.myDropzone6.processQueue();

		}

		});
	}


var sendForm = function(){
	console.log("Invio il form");
	var btn = formEl.find('[data-ktwizard-type="action-submit"]');

	if (validator.form()) {
				// See: src\js\framework\base\app.js
				KTApp.progress(btn);
				//KTApp.block(formEl);

				// See: http://malsup.com/jquery/form/#ajaxSubmit
				formEl.ajaxSubmit({
					success: function(data) {
						console.log(data)
						KTApp.unprogress(btn);
						//KTApp.unblock(formEl);

						swal.fire({
							"title": "",
							"text": "Campagna inserita con successo!",
							"type": "success",
							"confirmButtonClass": "btn btn-secondary"
						});
					}
				});
			}
}

	return {
		// public functions
		init: function() {
			wizardEl = KTUtil.get('kt_wizard_v4');
			formEl = $('#kt_form');

			initWizard();
			initValidation();
			initSubmit();
		}
	};
}();

jQuery(document).ready(function() {
	KTWizard4.init();
});
