"use strict";

// Class definition
var KTWizard4 = function () {
	
	var wizardEl;
	var formEl;
	var validator;
	var wizard;

	
	var initWizard = function () {
		
		wizard = new KTWizard('kt_wizard_v4', {
			startStep: 1, 
			clickableSteps: true  
		});

		
		wizard.on('beforeNext', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  
			}
		});

		wizard.on('beforePrev', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop(); 
			}
		});

/*		
		wizard.on('change', function(wizard) {
			KTUtil.scrollTop();
		});
		*/

		if($(".switchProfilazione").is(":checked"))
		{
			$(".profilazione").show()
			}
			else
			{
				$(".profilazione").hide()
			}
		

		$(".switchProfilazione").click(function(){if(this.checked == true)
			{
				$(".profilazione").show()
			}else
			{
				$(".profilazione").hide()
			}}
			)
	}

	var initValidation = function() {
		validator = formEl.validate({
			ignore: ":hidden",

			rules: {
				campaignName: {
					required: true
				}
				,
				campaignOwner: {
					required: true
				}
				,
				campaignLanguage:{
					required: true
				},
				campaignStartDate: {
					required: true
				}

				
			},


			// Display error
			invalidHandler: function(event, validator) {
				KTUtil.scrollTop();

				swal.fire({
					"title": "",
					"text": "Alcuni dati sono errati o mancanti, correggili prima di proseguire",
					"type": "error",
					"confirmButtonClass": "btn btn-secondary"
				});
			},

			// Submit valid form
			submitHandler: function (form) {

			}
		});


	}


	var initSubmit = function() {

		var btn = formEl.find('[data-ktwizard-type="action-submit"]');

		btn.on('click', function(e) {
			e.preventDefault();

			var dz1finish = false;
			if(window.myDropzone.getQueuedFiles().length == 0)
			{
				dz1finish = true;
			}
			var dz2finish = false;
			if(window.myDropzone2.getQueuedFiles().length == 0)
			{
				dz2finish = true;
			}
			var dz3finish = false;
			if(window.myDropzone3.getQueuedFiles().length == 0)
			{
				dz3finish = true;
			}

			if(dz1finish == true && dz2finish == true && dz3finish == true)
			{
				sendForm();
			}
			else
			{
			
                 window.myDropzone.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file1',
    name: 'file1',
    value: file.name
}).appendTo(formEl);
                 	dz1finish = true

                    if(dz2finish == true && dz3finish == true)
                    {
                    	sendForm();
                    }
                 })

                 window.myDropzone2.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file2',
    name: 'file2',
    value: file.name
}).appendTo(formEl);
                 	dz2finish = true;
                 
                    if(dz1finish == true && dz3finish == true)
                    {
                 	   sendForm();
                	}
                 })

                   window.myDropzone3.on("success", function(file, serverFileName){
                 	$('<input>').attr({
    type: 'hidden',
    id: 'file3',
    name: 'file3',
    value: file.name
}).appendTo(formEl);
                 	dz3finish = true;
                 	
                    if(dz1finish == true && dz2finish == true)
                    {
                 	   sendForm();
                	}
                 })


			window.myDropzone.processQueue();
			window.myDropzone2.processQueue();
			window.myDropzone3.processQueue();

		}

		});
	}


var sendForm = function(){
	
	var btn = formEl.find('[data-ktwizard-type="action-submit"]');

	if (validator.form()) {
				
				KTApp.progress(btn);
				
				formEl.ajaxSubmit({
					success: function(data) {
						console.log(data)
						KTApp.unprogress(btn);
						//KTApp.unblock(formEl);

						swal.fire({
							"title": "",
							"text": "Campagna inserita con successo!",
							"type": "success",
							"confirmButtonClass": "btn btn-secondary"
						});
					}
				});
			}
}

	return {
		// public functions
		init: function() {
			wizardEl = KTUtil.get('kt_wizard_v4');
			formEl = $('#kt_form');

			initWizard();
			initValidation();
			initSubmit();
		}
	};
}();

jQuery(document).ready(function() {
	KTWizard4.init();
});
