<?php 
$setList = $connection->query("SELECT * FROM customers ORDER BY name ASC");
$customers = $setList->fetchAll();

?>
<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
							<div class="kt-portlet kt-portlet--mobile">
								<div class="kt-portlet__head kt-portlet__head--lg">
									<div class="kt-portlet__head-label">
										<span class="kt-portlet__head-icon">
											<i class="kt-font-brand flaticon2-line-chart"></i>
										</span>
										<h3 class="kt-portlet__head-title">
											Lista clienti
										</h3>
									</div>
									
								</div>
								<div class="kt-portlet__body">

									<!--begin: Datatable -->
									<table class="table table-striped- table-bordered table-hover table-checkable" id="kt_table_1">
										<thead>
											<tr>
												<th>Nome cliente</th>
												<th></th>
												<th></th>
											</tr>
										</thead>
										<tbody>
											
												<?php 
												for($c = 0; $c < count($customers); $c++)
												{
													$id = $customers[$c]['id'];
													$customerName = $customers[$c]['name'];
												?>
											<tr>
											<td><?php echo $customerName ?></td>	
											<td><a href="?p=18&id=<?php echo $id; ?>"><button type="button" class="btn btn-info btn-custom">Modifica</button></a></td>
											<td><button type="button" class="btn btn-danger btn-custom elimina" data-id="<?php echo $id ?>">Elimina</button></a></td>
											</tr>
												<?php	
												}
												?>
												
											</tr>

										</tbody>
									</table>

									<!--end: Datatable -->
								</div>
							</div>
						</div>
<script>
$(document).ready(function() {	
var table = $('#kt_table_1').DataTable();
$('.elimina').click(function(e) {

	var idCustomer = $(this).data("id");
	var riga = $(this).parents('tr'); 
            swal.fire({
                title: 'Sei sicuro?',
                text: "Non potrai più ripristinare il cliente!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sì, eliminalo!'
            }).then(function(result) {
                if (result.value) {
                	console.log("Confermato");
                	$.post("be_services/delete.php", {
            values: {"what" : "customer","who" : idCustomer}
        }, function(res) {
        	console.log("Tornato");
        	console.log(res.success)
            if (res.success)
            {
            	console.log(table.row( $(this).parents('tr')));
            	 table.row( riga ).remove().draw();
            	 swal.fire(
                        'Fatto!',
                        'Cliente eliminato con successo',
                        'success'
                    )
            }
                else {
                    // eliminazione fallita per qualche ragione
                } 
        }, "json")

                   
                }
            });
        });
})
</script>						