function Form(locale, externalId) {
    BaseForm.apply(this, arguments);

    this.availableControls = {
        cid: $("#cid"),
        eid: $("#eid"),
        gender: $(".gender"),
        firstName: $("#first-name"),
        lastName: $("#last-name"),
        email: $("#email"),
        birthDateDay: $("#bdate-day"),
        birthDateMonth: $("#bdate-month"),
        birthDateYear: $("#bdate-year"),
        postcode: $("#postcode"),
        phone: $("#phone"),
        termsAgree: $("#terms-agree"),
        termsAgree2: $("#terms-agree2"),
		termsAgree3: $("#terms-agree3"),
        termsAgree4: $("#terms-agree4"),
        termsAgree5: $("#terms-agree5"),
        termsAgree6: $("#terms-agree6"),
        termsAgree7: $("#terms-agree7"),
        termsAgree8: $("#terms-agree8"),
        city: $("#city"),
        id_state: $("#state"),
        houseNumber: $("#house-number"),
        houseNumberAddition: $("#house-number-addition"),
        street: $("#street"),
        address: $("#address"),
        nationality: $("#nationality"),
        talon: $("#talon")
    };

    this.getSelectedCoSponsors = function () {
        var ids = {};

        $(".coreg-sponsor").each(function () {
            var el = $(this);
            ids[el.data('id')] = el.is(':checked') ? el.val() : null;
        });

        $(".coreg-sponsor-dd").each(function () {
            var el = $(this);
            ids[el.data('id')] = el.val();
        });

        return ids;
    };
}

Form.prototype = Object.create(BaseForm.prototype);
Form.prototype.constructor = Form;

Form.prototype.beforeValidate = function(controlName) {
    BaseForm.prototype.beforeValidate.apply(this, arguments);

    if (controlName === 'email') {
        this.getControl('email').addClass('loading').prop('disabled', true);
    }
};

Form.prototype.afterValidate = function(controlName, value, success, message) {
    BaseForm.prototype.afterValidate.apply(this, arguments);

    if (controlName === 'email') {
        this.getControl('email').removeClass('loading').prop('disabled', false);
    }
};

Form.prototype.setInvalid = function (control, message) {
    if (control === "birthDate") {
        this.setInvalid("birthDateYear", message);
        this.setInvalid("birthDateMonth", message);
        this.setInvalid("birthDateDay", message);
    } else {
        this.getControl(control).addClass("invalid").removeClass("valid").data('valid', 0);
        this.showErrorMessage(control, message);
    }
};

Form.prototype.setValid = function (control) {
    if (control === "birthDate") {
        this.setValid("birthDateYear");
        this.setValid("birthDateMonth");
        this.setValid("birthDateDay");
    } else {
        this.getControl(control).addClass("valid").removeClass("invalid").data('valid', 1);
        this.hideErrorMessage(control);
    }
};

Form.prototype.resetValid = function(control) {
    if (false === this.getControl(control).hasClass("dontReset")) {
        this.getControl(control).removeClass("valid").removeClass("invalid").data('valid', null);
        this.hideErrorMessage(control);
    }
};

Form.prototype.getErrorMessageBlock = function (control) {
    return this.getControl(control).closest(".user-info-control").find(".invalid-message");
};

Form.prototype.showErrorMessage = function (control, message) {
    this.getErrorMessageBlock(control).show().text(message);
};

Form.prototype.hideErrorMessage = function (control) {
    this.getErrorMessageBlock(control).hide();
};

Form.prototype.beforeLeadUpdate = function() {
    BaseForm.prototype.beforeLeadUpdate.apply(this, arguments);

    this.showFormLoader(this.step);
};
Form.prototype.afterLeadUpdate = function() {
    BaseForm.prototype.afterLeadUpdate.apply(this, arguments);

    this.hideFormLoader(this.step);
};

Form.prototype.showFormLoader = function (step) {
    $(".form-submit-step").prop('disabled', true);
    $("#form-loader-step" + step).show();
};

Form.prototype.hideFormLoader = function (step) {
    $(".form-submit-step").prop('disabled', false);
    $("#form-loader-step" + step).hide();
};

Form.prototype.getValues = function () {
    var values = BaseForm.prototype.getValues.apply(this, arguments);

    values['coSponsors'] = this.getSelectedCoSponsors();

    return values;
};

Form.prototype.setInputMask = function (input, mask) {
    BaseForm.prototype.setInputMask.call(this, input, mask);
};
