/*
 jQuery JavaScript Library v3.2.1
 https://jquery.com/

 Includes Sizzle.js
 https://sizzlejs.com/

 Copyright JS Foundation and other contributors
 Released under the MIT license
 https://jquery.org/license

 Date: 2017-03-20T18:59Z
 Sizzle CSS Selector Engine v2.3.3
 https://sizzlejs.com/

 Copyright jQuery Foundation and other contributors
 Released under the MIT license
 http://jquery.org/license

 Date: 2016-08-08
 jQuery UI - v1.12.1 - 2017-05-31
 http://jqueryui.com
 Includes: widget.js, position.js, keycode.js, unique-id.js, widgets/autocomplete.js, widgets/menu.js
 Copyright jQuery Foundation and other contributors; Licensed MIT  The Final Countdown for jQuery v2.2.0 (http://hilios.github.io/jQuery.countdown/)
 Copyright (c) 2016 Edson Hilios

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in
 the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 the Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 inputmask.min.js
 https://github.com/RobinHerbots/Inputmask
 Copyright (c) 2010 - 2017 Robin Herbots
 Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
 Version: 3.3.11
 jquery.inputmask.min.js
 https://github.com/RobinHerbots/Inputmask
 Copyright (c) 2010 - 2017 Robin Herbots
 Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)
 Version: 3.3.11
 Select2 4.0.6-rc.1 | https://github.com/select2/select2/blob/master/LICENSE.md */
(function(global, factory) {
    if (typeof module === "object" && typeof module.exports === "object") module.exports = global.document ? factory(global, true) : function(w) {
        if (!w.document) throw new Error("jQuery requires a window with a document");
        return factory(w)
    };
    else factory(global)
})(typeof window !== "undefined" ? window : this, function(window, noGlobal) {
    var arr = [];
    var document = window.document;
    var getProto = Object.getPrototypeOf;
    var slice = arr.slice;
    var concat = arr.concat;
    var push = arr.push;
    var indexOf = arr.indexOf;
    var class2type = {};
    var toString = class2type.toString;
    var hasOwn = class2type.hasOwnProperty;
    var fnToString = hasOwn.toString;
    var ObjectFunctionString = fnToString.call(Object);
    var support = {};

    function DOMEval(code, doc) {
        doc = doc || document;
        var script = doc.createElement("script");
        script.text = code;
        doc.head.appendChild(script).parentNode.removeChild(script)
    }
    var version = "3.2.1",
        jQuery = function(selector, context) {
            return new jQuery.fn.init(selector, context)
        },
        rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,
        rmsPrefix = /^-ms-/,
        rdashAlpha = /-([a-z])/g,
        fcamelCase = function(all, letter) {
            return letter.toUpperCase()
        };
    jQuery.fn = jQuery.prototype = {
        jquery: version,
        constructor: jQuery,
        length: 0,
        toArray: function() {
            return slice.call(this)
        },
        get: function(num) {
            if (num == null) return slice.call(this);
            return num < 0 ? this[num + this.length] : this[num]
        },
        pushStack: function(elems) {
            var ret = jQuery.merge(this.constructor(), elems);
            ret.prevObject = this;
            return ret
        },
        each: function(callback) {
            return jQuery.each(this, callback)
        },
        map: function(callback) {
            return this.pushStack(jQuery.map(this,
                function(elem, i) {
                    return callback.call(elem, i, elem)
                }))
        },
        slice: function() {
            return this.pushStack(slice.apply(this, arguments))
        },
        first: function() {
            return this.eq(0)
        },
        last: function() {
            return this.eq(-1)
        },
        eq: function(i) {
            var len = this.length,
                j = +i + (i < 0 ? len : 0);
            return this.pushStack(j >= 0 && j < len ? [this[j]] : [])
        },
        end: function() {
            return this.prevObject || this.constructor()
        },
        push: push,
        sort: arr.sort,
        splice: arr.splice
    };
    jQuery.extend = jQuery.fn.extend = function() {
        var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {},
            i = 1,
            length = arguments.length,
            deep = false;
        if (typeof target === "boolean") {
            deep = target;
            target = arguments[i] || {};
            i++
        }
        if (typeof target !== "object" && !jQuery.isFunction(target)) target = {};
        if (i === length) {
            target = this;
            i--
        }
        for (; i < length; i++)
            if ((options = arguments[i]) != null)
                for (name in options) {
                    src = target[name];
                    copy = options[name];
                    if (target === copy) continue;
                    if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = Array.isArray(copy)))) {
                        if (copyIsArray) {
                            copyIsArray = false;
                            clone = src && Array.isArray(src) ? src : []
                        } else clone =
                            src && jQuery.isPlainObject(src) ? src : {};
                        target[name] = jQuery.extend(deep, clone, copy)
                    } else if (copy !== undefined) target[name] = copy
                }
            return target
    };
    jQuery.extend({
        expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""),
        isReady: true,
        error: function(msg) {
            throw new Error(msg);
        },
        noop: function() {},
        isFunction: function(obj) {
            return jQuery.type(obj) === "function"
        },
        isWindow: function(obj) {
            return obj != null && obj === obj.window
        },
        isNumeric: function(obj) {
            var type = jQuery.type(obj);
            return (type === "number" || type === "string") &&
                !isNaN(obj - parseFloat(obj))
        },
        isPlainObject: function(obj) {
            var proto, Ctor;
            if (!obj || toString.call(obj) !== "[object Object]") return false;
            proto = getProto(obj);
            if (!proto) return true;
            Ctor = hasOwn.call(proto, "constructor") && proto.constructor;
            return typeof Ctor === "function" && fnToString.call(Ctor) === ObjectFunctionString
        },
        isEmptyObject: function(obj) {
            var name;
            for (name in obj) return false;
            return true
        },
        type: function(obj) {
            if (obj == null) return obj + "";
            return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] ||
                "object" : typeof obj
        },
        globalEval: function(code) {
            DOMEval(code)
        },
        camelCase: function(string) {
            return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase)
        },
        each: function(obj, callback) {
            var length, i = 0;
            if (isArrayLike(obj)) {
                length = obj.length;
                for (; i < length; i++)
                    if (callback.call(obj[i], i, obj[i]) === false) break
            } else
                for (i in obj)
                    if (callback.call(obj[i], i, obj[i]) === false) break; return obj
        },
        trim: function(text) {
            return text == null ? "" : (text + "").replace(rtrim, "")
        },
        makeArray: function(arr, results) {
            var ret = results || [];
            if (arr != null)
                if (isArrayLike(Object(arr))) jQuery.merge(ret, typeof arr === "string" ? [arr] : arr);
                else push.call(ret, arr);
            return ret
        },
        inArray: function(elem, arr, i) {
            return arr == null ? -1 : indexOf.call(arr, elem, i)
        },
        merge: function(first, second) {
            var len = +second.length,
                j = 0,
                i = first.length;
            for (; j < len; j++) first[i++] = second[j];
            first.length = i;
            return first
        },
        grep: function(elems, callback, invert) {
            var callbackInverse, matches = [],
                i = 0,
                length = elems.length,
                callbackExpect = !invert;
            for (; i < length; i++) {
                callbackInverse = !callback(elems[i],
                    i);
                if (callbackInverse !== callbackExpect) matches.push(elems[i])
            }
            return matches
        },
        map: function(elems, callback, arg) {
            var length, value, i = 0,
                ret = [];
            if (isArrayLike(elems)) {
                length = elems.length;
                for (; i < length; i++) {
                    value = callback(elems[i], i, arg);
                    if (value != null) ret.push(value)
                }
            } else
                for (i in elems) {
                    value = callback(elems[i], i, arg);
                    if (value != null) ret.push(value)
                }
            return concat.apply([], ret)
        },
        guid: 1,
        proxy: function(fn, context) {
            var tmp, args, proxy;
            if (typeof context === "string") {
                tmp = fn[context];
                context = fn;
                fn = tmp
            }
            if (!jQuery.isFunction(fn)) return undefined;
            args = slice.call(arguments, 2);
            proxy = function() {
                return fn.apply(context || this, args.concat(slice.call(arguments)))
            };
            proxy.guid = fn.guid = fn.guid || jQuery.guid++;
            return proxy
        },
        now: Date.now,
        support: support
    });
    if (typeof Symbol === "function") jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
    jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function(i, name) {
        class2type["[object " + name + "]"] = name.toLowerCase()
    });

    function isArrayLike(obj) {
        var length = !!obj && "length" in obj &&
            obj.length,
            type = jQuery.type(obj);
        if (type === "function" || jQuery.isWindow(obj)) return false;
        return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj
    }
    var Sizzle = function(window) {
        var i, support, Expr, getText, isXML, tokenize, compile, select, outermostContext, sortInput, hasDuplicate, setDocument, document, docElem, documentIsHTML, rbuggyQSA, rbuggyMatches, matches, contains, expando = "sizzle" + 1 * new Date,
            preferredDoc = window.document,
            dirruns = 0,
            done = 0,
            classCache = createCache(),
            tokenCache = createCache(),
            compilerCache = createCache(),
            sortOrder = function(a, b) {
                if (a === b) hasDuplicate = true;
                return 0
            },
            hasOwn = {}.hasOwnProperty,
            arr = [],
            pop = arr.pop,
            push_native = arr.push,
            push = arr.push,
            slice = arr.slice,
            indexOf = function(list, elem) {
                var i = 0,
                    len = list.length;
                for (; i < len; i++)
                    if (list[i] === elem) return i;
                return -1
            },
            booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",
            whitespace = "[\\x20\\t\\r\\n\\f]",
            identifier = "(?:\\\\.|[\\w-]|[^\x00-\\xa0])+",
            attributes =
            "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace + "*([*^$|!~]?=)" + whitespace + "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace + "*\\]",
            pseudos = ":(" + identifier + ")(?:\\((" + "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" + "((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" + ".*" + ")\\)|)",
            rwhitespace = new RegExp(whitespace + "+", "g"),
            rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),
            rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
            rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"),
            rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"),
            rpseudo = new RegExp(pseudos),
            ridentifier = new RegExp("^" + identifier + "$"),
            matchExpr = {
                "ID": new RegExp("^#(" + identifier + ")"),
                "CLASS": new RegExp("^\\.(" + identifier + ")"),
                "TAG": new RegExp("^(" + identifier + "|[*])"),
                "ATTR": new RegExp("^" + attributes),
                "PSEUDO": new RegExp("^" + pseudos),
                "CHILD": new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
                    whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
                "bool": new RegExp("^(?:" + booleans + ")$", "i"),
                "needsContext": new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
            },
            rinputs = /^(?:input|select|textarea|button)$/i,
            rheader = /^h\d$/i,
            rnative = /^[^{]+\{\s*\[native \w/,
            rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,
            rsibling = /[+~]/,
            runescape = new RegExp("\\\\([\\da-f]{1,6}" +
                whitespace + "?|(" + whitespace + ")|.)", "ig"),
            funescape = function(_, escaped, escapedWhitespace) {
                var high = "0x" + escaped - 65536;
                return high !== high || escapedWhitespace ? escaped : high < 0 ? String.fromCharCode(high + 65536) : String.fromCharCode(high >> 10 | 55296, high & 1023 | 56320)
            },
            rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
            fcssescape = function(ch, asCodePoint) {
                if (asCodePoint) {
                    if (ch === "\x00") return "\ufffd";
                    return ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " "
                }
                return "\\" + ch
            },
            unloadHandler =
            function() {
                setDocument()
            },
            disabledAncestor = addCombinator(function(elem) {
                return elem.disabled === true && ("form" in elem || "label" in elem)
            }, {
                dir: "parentNode",
                next: "legend"
            });
        try {
            push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes);
            arr[preferredDoc.childNodes.length].nodeType
        } catch (e) {
            push = {
                apply: arr.length ? function(target, els) {
                    push_native.apply(target, slice.call(els))
                } : function(target, els) {
                    var j = target.length,
                        i = 0;
                    while (target[j++] = els[i++]);
                    target.length = j - 1
                }
            }
        }

        function Sizzle(selector,
            context, results, seed) {
            var m, i, elem, nid, match, groups, newSelector, newContext = context && context.ownerDocument,
                nodeType = context ? context.nodeType : 9;
            results = results || [];
            if (typeof selector !== "string" || !selector || nodeType !== 1 && nodeType !== 9 && nodeType !== 11) return results;
            if (!seed) {
                if ((context ? context.ownerDocument || context : preferredDoc) !== document) setDocument(context);
                context = context || document;
                if (documentIsHTML) {
                    if (nodeType !== 11 && (match = rquickExpr.exec(selector)))
                        if (m = match[1])
                            if (nodeType === 9)
                                if (elem = context.getElementById(m)) {
                                    if (elem.id ===
                                        m) {
                                        results.push(elem);
                                        return results
                                    }
                                } else return results;
                    else {
                        if (newContext && (elem = newContext.getElementById(m)) && contains(context, elem) && elem.id === m) {
                            results.push(elem);
                            return results
                        }
                    } else if (match[2]) {
                        push.apply(results, context.getElementsByTagName(selector));
                        return results
                    } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {
                        push.apply(results, context.getElementsByClassName(m));
                        return results
                    }
                    if (support.qsa && !compilerCache[selector + " "] && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
                        if (nodeType !==
                            1) {
                            newContext = context;
                            newSelector = selector
                        } else if (context.nodeName.toLowerCase() !== "object") {
                            if (nid = context.getAttribute("id")) nid = nid.replace(rcssescape, fcssescape);
                            else context.setAttribute("id", nid = expando);
                            groups = tokenize(selector);
                            i = groups.length;
                            while (i--) groups[i] = "#" + nid + " " + toSelector(groups[i]);
                            newSelector = groups.join(",");
                            newContext = rsibling.test(selector) && testContext(context.parentNode) || context
                        }
                        if (newSelector) try {
                            push.apply(results, newContext.querySelectorAll(newSelector));
                            return results
                        } catch (qsaError) {} finally {
                            if (nid ===
                                expando) context.removeAttribute("id")
                        }
                    }
                }
            }
            return select(selector.replace(rtrim, "$1"), context, results, seed)
        }

        function createCache() {
            var keys = [];

            function cache(key, value) {
                if (keys.push(key + " ") > Expr.cacheLength) delete cache[keys.shift()];
                return cache[key + " "] = value
            }
            return cache
        }

        function markFunction(fn) {
            fn[expando] = true;
            return fn
        }

        function assert(fn) {
            var el = document.createElement("fieldset");
            try {
                return !!fn(el)
            } catch (e$0) {
                return false
            } finally {
                if (el.parentNode) el.parentNode.removeChild(el);
                el = null
            }
        }

        function addHandle(attrs,
            handler) {
            var arr = attrs.split("|"),
                i = arr.length;
            while (i--) Expr.attrHandle[arr[i]] = handler
        }

        function siblingCheck(a, b) {
            var cur = b && a,
                diff = cur && a.nodeType === 1 && b.nodeType === 1 && a.sourceIndex - b.sourceIndex;
            if (diff) return diff;
            if (cur)
                while (cur = cur.nextSibling)
                    if (cur === b) return -1;
            return a ? 1 : -1
        }

        function createInputPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return name === "input" && elem.type === type
            }
        }

        function createButtonPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return (name === "input" || name === "button") && elem.type === type
            }
        }

        function createDisabledPseudo(disabled) {
            return function(elem) {
                if ("form" in elem) {
                    if (elem.parentNode && elem.disabled === false) {
                        if ("label" in elem)
                            if ("label" in elem.parentNode) return elem.parentNode.disabled === disabled;
                            else return elem.disabled === disabled;
                        return elem.isDisabled === disabled || elem.isDisabled !== !disabled && disabledAncestor(elem) === disabled
                    }
                    return elem.disabled === disabled
                } else if ("label" in elem) return elem.disabled === disabled;
                return false
            }
        }

        function createPositionalPseudo(fn) {
            return markFunction(function(argument) {
                argument = +argument;
                return markFunction(function(seed, matches) {
                    var j, matchIndexes = fn([], seed.length, argument),
                        i = matchIndexes.length;
                    while (i--)
                        if (seed[j = matchIndexes[i]]) seed[j] = !(matches[j] = seed[j])
                })
            })
        }

        function testContext(context) {
            return context && typeof context.getElementsByTagName !== "undefined" && context
        }
        support = Sizzle.support = {};
        isXML = Sizzle.isXML = function(elem) {
            var documentElement = elem && (elem.ownerDocument || elem).documentElement;
            return documentElement ? documentElement.nodeName !== "HTML" : false
        };
        setDocument = Sizzle.setDocument = function(node) {
            var hasCompare, subWindow, doc = node ? node.ownerDocument || node : preferredDoc;
            if (doc === document || doc.nodeType !== 9 || !doc.documentElement) return document;
            document = doc;
            docElem = document.documentElement;
            documentIsHTML = !isXML(document);
            if (preferredDoc !== document && (subWindow = document.defaultView) && subWindow.top !== subWindow)
                if (subWindow.addEventListener) subWindow.addEventListener("unload", unloadHandler,
                    false);

                else if (subWindow.attachEvent) subWindow.attachEvent("onunload", unloadHandler);
            support.attributes = assert(function(el) {
                el.className = "i";
                return !el.getAttribute("className")
            });
            support.getElementsByTagName = assert(function(el) {
                el.appendChild(document.createComment(""));
                return !el.getElementsByTagName("*").length
            });
            support.getElementsByClassName = rnative.test(document.getElementsByClassName);
            support.getById = assert(function(el) {
                docElem.appendChild(el).id = expando;
                return !document.getElementsByName || !document.getElementsByName(expando).length
            });
            if (support.getById) {
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        return elem.getAttribute("id") === attrId
                    }
                };
                Expr.find["ID"] = function(id, context) {
                    if (typeof context.getElementById !== "undefined" && documentIsHTML) {
                        var elem = context.getElementById(id);
                        return elem ? [elem] : []
                    }
                }
            } else {
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        var node = typeof elem.getAttributeNode !== "undefined" && elem.getAttributeNode("id");
                        return node && node.value === attrId
                    }
                };
                Expr.find["ID"] = function(id, context) {
                    if (typeof context.getElementById !== "undefined" && documentIsHTML) {
                        var node, i, elems, elem = context.getElementById(id);
                        if (elem) {
                            node = elem.getAttributeNode("id");
                            if (node && node.value === id) return [elem];
                            elems = context.getElementsByName(id);
                            i = 0;
                            while (elem = elems[i++]) {
                                node = elem.getAttributeNode("id");
                                if (node && node.value === id) return [elem]
                            }
                        }
                        return []
                    }
                }
            }
            Expr.find["TAG"] = support.getElementsByTagName ? function(tag, context) {
                if (typeof context.getElementsByTagName !==
                    "undefined") return context.getElementsByTagName(tag);
                else if (support.qsa) return context.querySelectorAll(tag)
            } : function(tag, context) {
                var elem, tmp = [],
                    i = 0,
                    results = context.getElementsByTagName(tag);
                if (tag === "*") {
                    while (elem = results[i++])
                        if (elem.nodeType === 1) tmp.push(elem);
                    return tmp
                }
                return results
            };
            Expr.find["CLASS"] = support.getElementsByClassName && function(className, context) {
                if (typeof context.getElementsByClassName !== "undefined" && documentIsHTML) return context.getElementsByClassName(className)
            };
            rbuggyMatches = [];
            rbuggyQSA = [];
            if (support.qsa = rnative.test(document.querySelectorAll)) {
                assert(function(el) {
                    docElem.appendChild(el).innerHTML = "<a id='" + expando + "'></a>" + "<select id='" + expando + "-\r\\' msallowcapture=''>" + "<option selected=''></option></select>";
                    if (el.querySelectorAll("[msallowcapture^='']").length) rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")");
                    if (!el.querySelectorAll("[selected]").length) rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")");
                    if (!el.querySelectorAll("[id~=" + expando + "-]").length) rbuggyQSA.push("~=");
                    if (!el.querySelectorAll(":checked").length) rbuggyQSA.push(":checked");
                    if (!el.querySelectorAll("a#" + expando + "+*").length) rbuggyQSA.push(".#.+[+~]")
                });
                assert(function(el) {
                    el.innerHTML = "<a href='' disabled='disabled'></a>" + "<select disabled='disabled'><option/></select>";
                    var input = document.createElement("input");
                    input.setAttribute("type", "hidden");
                    el.appendChild(input).setAttribute("name", "D");
                    if (el.querySelectorAll("[name=d]").length) rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
                    if (el.querySelectorAll(":enabled").length !==
                        2) rbuggyQSA.push(":enabled", ":disabled");
                    docElem.appendChild(el).disabled = true;
                    if (el.querySelectorAll(":disabled").length !== 2) rbuggyQSA.push(":enabled", ":disabled");
                    el.querySelectorAll("*,:x");
                    rbuggyQSA.push(",.*:")
                })
            }
            if (support.matchesSelector = rnative.test(matches = docElem.matches || docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) assert(function(el) {
                support.disconnectedMatch = matches.call(el, "*");
                matches.call(el, "[s!='']:x");
                rbuggyMatches.push("!=",
                    pseudos)
            });
            rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
            rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));
            hasCompare = rnative.test(docElem.compareDocumentPosition);
            contains = hasCompare || rnative.test(docElem.contains) ? function(a, b) {
                var adown = a.nodeType === 9 ? a.documentElement : a,
                    bup = b && b.parentNode;
                return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16))
            } : function(a, b) {
                if (b)
                    while (b = b.parentNode)
                        if (b ===
                            a) return true;
                return false
            };
            sortOrder = hasCompare ? function(a, b) {
                if (a === b) {
                    hasDuplicate = true;
                    return 0
                }
                var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
                if (compare) return compare;
                compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1;
                if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {
                    if (a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) return -1;
                    if (b === document || b.ownerDocument === preferredDoc && contains(preferredDoc,
                            b)) return 1;
                    return sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0
                }
                return compare & 4 ? -1 : 1
            } : function(a, b) {
                if (a === b) {
                    hasDuplicate = true;
                    return 0
                }
                var cur, i = 0,
                    aup = a.parentNode,
                    bup = b.parentNode,
                    ap = [a],
                    bp = [b];
                if (!aup || !bup) return a === document ? -1 : b === document ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0;
                else if (aup === bup) return siblingCheck(a, b);
                cur = a;
                while (cur = cur.parentNode) ap.unshift(cur);
                cur = b;
                while (cur = cur.parentNode) bp.unshift(cur);
                while (ap[i] === bp[i]) i++;
                return i ? siblingCheck(ap[i],
                    bp[i]) : ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0
            };
            return document
        };
        Sizzle.matches = function(expr, elements) {
            return Sizzle(expr, null, null, elements)
        };
        Sizzle.matchesSelector = function(elem, expr) {
            if ((elem.ownerDocument || elem) !== document) setDocument(elem);
            expr = expr.replace(rattributeQuotes, "='$1']");
            if (support.matchesSelector && documentIsHTML && !compilerCache[expr + " "] && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) try {
                var ret = matches.call(elem, expr);
                if (ret || support.disconnectedMatch ||
                    elem.document && elem.document.nodeType !== 11) return ret
            } catch (e$1) {}
            return Sizzle(expr, document, null, [elem]).length > 0
        };
        Sizzle.contains = function(context, elem) {
            if ((context.ownerDocument || context) !== document) setDocument(context);
            return contains(context, elem)
        };
        Sizzle.attr = function(elem, name) {
            if ((elem.ownerDocument || elem) !== document) setDocument(elem);
            var fn = Expr.attrHandle[name.toLowerCase()],
                val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;
            return val !== undefined ?
                val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null
        };
        Sizzle.escape = function(sel) {
            return (sel + "").replace(rcssescape, fcssescape)
        };
        Sizzle.error = function(msg) {
            throw new Error("Syntax error, unrecognized expression: " + msg);
        };
        Sizzle.uniqueSort = function(results) {
            var elem, duplicates = [],
                j = 0,
                i = 0;
            hasDuplicate = !support.detectDuplicates;
            sortInput = !support.sortStable && results.slice(0);
            results.sort(sortOrder);
            if (hasDuplicate) {
                while (elem =
                    results[i++])
                    if (elem === results[i]) j = duplicates.push(i);
                while (j--) results.splice(duplicates[j], 1)
            }
            sortInput = null;
            return results
        };
        getText = Sizzle.getText = function(elem) {
            var node, ret = "",
                i = 0,
                nodeType = elem.nodeType;
            if (!nodeType)
                while (node = elem[i++]) ret += getText(node);
            else if (nodeType === 1 || nodeType === 9 || nodeType === 11)
                if (typeof elem.textContent === "string") return elem.textContent;
                else
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling) ret += getText(elem);
            else if (nodeType === 3 || nodeType === 4) return elem.nodeValue;
            return ret
        };
        Expr = Sizzle.selectors = {
            cacheLength: 50,
            createPseudo: markFunction,
            match: matchExpr,
            attrHandle: {},
            find: {},
            relative: {
                ">": {
                    dir: "parentNode",
                    first: true
                },
                " ": {
                    dir: "parentNode"
                },
                "+": {
                    dir: "previousSibling",
                    first: true
                },
                "~": {
                    dir: "previousSibling"
                }
            },
            preFilter: {
                "ATTR": function(match) {
                    match[1] = match[1].replace(runescape, funescape);
                    match[3] = (match[3] || match[4] || match[5] || "").replace(runescape, funescape);
                    if (match[2] === "~=") match[3] = " " + match[3] + " ";
                    return match.slice(0, 4)
                },
                "CHILD": function(match) {
                    match[1] =
                        match[1].toLowerCase();
                    if (match[1].slice(0, 3) === "nth") {
                        if (!match[3]) Sizzle.error(match[0]);
                        match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === "even" || match[3] === "odd"));
                        match[5] = +(match[7] + match[8] || match[3] === "odd")
                    } else if (match[3]) Sizzle.error(match[0]);
                    return match
                },
                "PSEUDO": function(match) {
                    var excess, unquoted = !match[6] && match[2];
                    if (matchExpr["CHILD"].test(match[0])) return null;
                    if (match[3]) match[2] = match[4] || match[5] || "";
                    else if (unquoted && rpseudo.test(unquoted) && (excess = tokenize(unquoted,
                            true)) && (excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {
                        match[0] = match[0].slice(0, excess);
                        match[2] = unquoted.slice(0, excess)
                    }
                    return match.slice(0, 3)
                }
            },
            filter: {
                "TAG": function(nodeNameSelector) {
                    var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
                    return nodeNameSelector === "*" ? function() {
                        return true
                    } : function(elem) {
                        return elem.nodeName && elem.nodeName.toLowerCase() === nodeName
                    }
                },
                "CLASS": function(className) {
                    var pattern = classCache[className + " "];
                    return pattern ||
                        (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                            return pattern.test(typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "")
                        })
                },
                "ATTR": function(name, operator, check) {
                    return function(elem) {
                        var result = Sizzle.attr(elem, name);
                        if (result == null) return operator === "!=";
                        if (!operator) return true;
                        result += "";
                        return operator === "=" ? result === check : operator === "!=" ? result !== check : operator ===
                            "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result.replace(rwhitespace, " ") + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : false
                    }
                },
                "CHILD": function(type, what, argument, first, last) {
                    var simple = type.slice(0, 3) !== "nth",
                        forward = type.slice(-4) !== "last",
                        ofType = what === "of-type";
                    return first === 1 && last === 0 ? function(elem) {
                            return !!elem.parentNode
                        } :
                        function(elem, context, xml) {
                            var cache, uniqueCache, outerCache, node, nodeIndex, start, dir = simple !== forward ? "nextSibling" : "previousSibling",
                                parent = elem.parentNode,
                                name = ofType && elem.nodeName.toLowerCase(),
                                useCache = !xml && !ofType,
                                diff = false;
                            if (parent) {
                                if (simple) {
                                    while (dir) {
                                        node = elem;
                                        while (node = node[dir])
                                            if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) return false;
                                        start = dir = type === "only" && !start && "nextSibling"
                                    }
                                    return true
                                }
                                start = [forward ? parent.firstChild : parent.lastChild];
                                if (forward && useCache) {
                                    node =
                                        parent;
                                    outerCache = node[expando] || (node[expando] = {});
                                    uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                                    cache = uniqueCache[type] || [];
                                    nodeIndex = cache[0] === dirruns && cache[1];
                                    diff = nodeIndex && cache[2];
                                    node = nodeIndex && parent.childNodes[nodeIndex];
                                    while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop())
                                        if (node.nodeType === 1 && ++diff && node === elem) {
                                            uniqueCache[type] = [dirruns, nodeIndex, diff];
                                            break
                                        }
                                } else {
                                    if (useCache) {
                                        node = elem;
                                        outerCache = node[expando] || (node[expando] = {});
                                        uniqueCache =
                                            outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                                        cache = uniqueCache[type] || [];
                                        nodeIndex = cache[0] === dirruns && cache[1];
                                        diff = nodeIndex
                                    }
                                    if (diff === false)
                                        while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop())
                                            if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {
                                                if (useCache) {
                                                    outerCache = node[expando] || (node[expando] = {});
                                                    uniqueCache = outerCache[node.uniqueID] || (outerCache[node.uniqueID] = {});
                                                    uniqueCache[type] = [dirruns, diff]
                                                }
                                                if (node === elem) break
                                            }
                                }
                                diff -= last;
                                return diff ===
                                    first || diff % first === 0 && diff / first >= 0
                            }
                        }
                },
                "PSEUDO": function(pseudo, argument) {
                    var args, fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo);
                    if (fn[expando]) return fn(argument);
                    if (fn.length > 1) {
                        args = [pseudo, pseudo, "", argument];
                        return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches) {
                                var idx, matched = fn(seed, argument),
                                    i = matched.length;
                                while (i--) {
                                    idx = indexOf(seed, matched[i]);
                                    seed[idx] = !(matches[idx] = matched[i])
                                }
                            }) :
                            function(elem) {
                                return fn(elem, 0, args)
                            }
                    }
                    return fn
                }
            },
            pseudos: {
                "not": markFunction(function(selector) {
                    var input = [],
                        results = [],
                        matcher = compile(selector.replace(rtrim, "$1"));
                    return matcher[expando] ? markFunction(function(seed, matches, context, xml) {
                        var elem, unmatched = matcher(seed, null, xml, []),
                            i = seed.length;
                        while (i--)
                            if (elem = unmatched[i]) seed[i] = !(matches[i] = elem)
                    }) : function(elem, context, xml) {
                        input[0] = elem;
                        matcher(input, null, xml, results);
                        input[0] = null;
                        return !results.pop()
                    }
                }),
                "has": markFunction(function(selector) {
                    return function(elem) {
                        return Sizzle(selector,
                            elem).length > 0
                    }
                }),
                "contains": markFunction(function(text) {
                    text = text.replace(runescape, funescape);
                    return function(elem) {
                        return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1
                    }
                }),
                "lang": markFunction(function(lang) {
                    if (!ridentifier.test(lang || "")) Sizzle.error("unsupported lang: " + lang);
                    lang = lang.replace(runescape, funescape).toLowerCase();
                    return function(elem) {
                        var elemLang;
                        do
                            if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) {
                                elemLang = elemLang.toLowerCase();
                                return elemLang === lang || elemLang.indexOf(lang + "-") === 0
                            }
                        while ((elem = elem.parentNode) && elem.nodeType === 1);
                        return false
                    }
                }),
                "target": function(elem) {
                    var hash = window.location && window.location.hash;
                    return hash && hash.slice(1) === elem.id
                },
                "root": function(elem) {
                    return elem === docElem
                },
                "focus": function(elem) {
                    return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex)
                },
                "enabled": createDisabledPseudo(false),
                "disabled": createDisabledPseudo(true),
                "checked": function(elem) {
                    var nodeName =
                        elem.nodeName.toLowerCase();
                    return nodeName === "input" && !!elem.checked || nodeName === "option" && !!elem.selected
                },
                "selected": function(elem) {
                    if (elem.parentNode) elem.parentNode.selectedIndex;
                    return elem.selected === true
                },
                "empty": function(elem) {
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling)
                        if (elem.nodeType < 6) return false;
                    return true
                },
                "parent": function(elem) {
                    return !Expr.pseudos["empty"](elem)
                },
                "header": function(elem) {
                    return rheader.test(elem.nodeName)
                },
                "input": function(elem) {
                    return rinputs.test(elem.nodeName)
                },
                "button": function(elem) {
                    var name = elem.nodeName.toLowerCase();
                    return name === "input" && elem.type === "button" || name === "button"
                },
                "text": function(elem) {
                    var attr;
                    return elem.nodeName.toLowerCase() === "input" && elem.type === "text" && ((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text")
                },
                "first": createPositionalPseudo(function() {
                    return [0]
                }),
                "last": createPositionalPseudo(function(matchIndexes, length) {
                    return [length - 1]
                }),
                "eq": createPositionalPseudo(function(matchIndexes, length, argument) {
                    return [argument <
                        0 ? argument + length : argument
                    ]
                }),
                "even": createPositionalPseudo(function(matchIndexes, length) {
                    var i = 0;
                    for (; i < length; i += 2) matchIndexes.push(i);
                    return matchIndexes
                }),
                "odd": createPositionalPseudo(function(matchIndexes, length) {
                    var i = 1;
                    for (; i < length; i += 2) matchIndexes.push(i);
                    return matchIndexes
                }),
                "lt": createPositionalPseudo(function(matchIndexes, length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (; --i >= 0;) matchIndexes.push(i);
                    return matchIndexes
                }),
                "gt": createPositionalPseudo(function(matchIndexes,
                    length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (; ++i < length;) matchIndexes.push(i);
                    return matchIndexes
                })
            }
        };
        Expr.pseudos["nth"] = Expr.pseudos["eq"];
        for (i in {
                radio: true,
                checkbox: true,
                file: true,
                password: true,
                image: true
            }) Expr.pseudos[i] = createInputPseudo(i);
        for (i in {
                submit: true,
                reset: true
            }) Expr.pseudos[i] = createButtonPseudo(i);

        function setFilters() {}
        setFilters.prototype = Expr.filters = Expr.pseudos;
        Expr.setFilters = new setFilters;
        tokenize = Sizzle.tokenize = function(selector, parseOnly) {
            var matched,
                match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
            if (cached) return parseOnly ? 0 : cached.slice(0);
            soFar = selector;
            groups = [];
            preFilters = Expr.preFilter;
            while (soFar) {
                if (!matched || (match = rcomma.exec(soFar))) {
                    if (match) soFar = soFar.slice(match[0].length) || soFar;
                    groups.push(tokens = [])
                }
                matched = false;
                if (match = rcombinators.exec(soFar)) {
                    matched = match.shift();
                    tokens.push({
                        value: matched,
                        type: match[0].replace(rtrim, " ")
                    });
                    soFar = soFar.slice(matched.length)
                }
                for (type in Expr.filter)
                    if ((match = matchExpr[type].exec(soFar)) &&
                        (!preFilters[type] || (match = preFilters[type](match)))) {
                        matched = match.shift();
                        tokens.push({
                            value: matched,
                            type: type,
                            matches: match
                        });
                        soFar = soFar.slice(matched.length)
                    }
                if (!matched) break
            }
            return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : tokenCache(selector, groups).slice(0)
        };

        function toSelector(tokens) {
            var i = 0,
                len = tokens.length,
                selector = "";
            for (; i < len; i++) selector += tokens[i].value;
            return selector
        }

        function addCombinator(matcher, combinator, base) {
            var dir = combinator.dir,
                skip = combinator.next,
                key = skip ||
                dir,
                checkNonElements = base && key === "parentNode",
                doneName = done++;
            return combinator.first ? function(elem, context, xml) {
                while (elem = elem[dir])
                    if (elem.nodeType === 1 || checkNonElements) return matcher(elem, context, xml);
                return false
            } : function(elem, context, xml) {
                var oldCache, uniqueCache, outerCache, newCache = [dirruns, doneName];
                if (xml)
                    while (elem = elem[dir]) {
                        if (elem.nodeType === 1 || checkNonElements)
                            if (matcher(elem, context, xml)) return true
                    } else
                        while (elem = elem[dir])
                            if (elem.nodeType === 1 || checkNonElements) {
                                outerCache = elem[expando] ||
                                    (elem[expando] = {});
                                uniqueCache = outerCache[elem.uniqueID] || (outerCache[elem.uniqueID] = {});
                                if (skip && skip === elem.nodeName.toLowerCase()) elem = elem[dir] || elem;
                                else if ((oldCache = uniqueCache[key]) && oldCache[0] === dirruns && oldCache[1] === doneName) return newCache[2] = oldCache[2];
                                else {
                                    uniqueCache[key] = newCache;
                                    if (newCache[2] = matcher(elem, context, xml)) return true
                                }
                            }
                return false
            }
        }

        function elementMatcher(matchers) {
            return matchers.length > 1 ? function(elem, context, xml) {
                var i = matchers.length;
                while (i--)
                    if (!matchers[i](elem,
                            context, xml)) return false;
                return true
            } : matchers[0]
        }

        function multipleContexts(selector, contexts, results) {
            var i = 0,
                len = contexts.length;
            for (; i < len; i++) Sizzle(selector, contexts[i], results);
            return results
        }

        function condense(unmatched, map, filter, context, xml) {
            var elem, newUnmatched = [],
                i = 0,
                len = unmatched.length,
                mapped = map != null;
            for (; i < len; i++)
                if (elem = unmatched[i])
                    if (!filter || filter(elem, context, xml)) {
                        newUnmatched.push(elem);
                        if (mapped) map.push(i)
                    }
            return newUnmatched
        }

        function setMatcher(preFilter, selector, matcher,
            postFilter, postFinder, postSelector) {
            if (postFilter && !postFilter[expando]) postFilter = setMatcher(postFilter);
            if (postFinder && !postFinder[expando]) postFinder = setMatcher(postFinder, postSelector);
            return markFunction(function(seed, results, context, xml) {
                var temp, i, elem, preMap = [],
                    postMap = [],
                    preexisting = results.length,
                    elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),
                    matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems,
                    matcherOut = matcher ? postFinder ||
                    (seed ? preFilter : preexisting || postFilter) ? [] : results : matcherIn;
                if (matcher) matcher(matcherIn, matcherOut, context, xml);
                if (postFilter) {
                    temp = condense(matcherOut, postMap);
                    postFilter(temp, [], context, xml);
                    i = temp.length;
                    while (i--)
                        if (elem = temp[i]) matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem)
                }
                if (seed) {
                    if (postFinder || preFilter) {
                        if (postFinder) {
                            temp = [];
                            i = matcherOut.length;
                            while (i--)
                                if (elem = matcherOut[i]) temp.push(matcherIn[i] = elem);
                            postFinder(null, matcherOut = [], temp, xml)
                        }
                        i = matcherOut.length;
                        while (i--)
                            if ((elem =
                                    matcherOut[i]) && (temp = postFinder ? indexOf(seed, elem) : preMap[i]) > -1) seed[temp] = !(results[temp] = elem)
                    }
                } else {
                    matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut);
                    if (postFinder) postFinder(null, results, matcherOut, xml);
                    else push.apply(results, matcherOut)
                }
            })
        }

        function matcherFromTokens(tokens) {
            var checkContext, matcher, j, len = tokens.length,
                leadingRelative = Expr.relative[tokens[0].type],
                implicitRelative = leadingRelative || Expr.relative[" "],
                i = leadingRelative ? 1 : 0,
                matchContext = addCombinator(function(elem) {
                    return elem === checkContext
                }, implicitRelative, true),
                matchAnyContext = addCombinator(function(elem) {
                    return indexOf(checkContext, elem) > -1
                }, implicitRelative, true),
                matchers = [function(elem, context, xml) {
                    var ret = !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml));
                    checkContext = null;
                    return ret
                }];
            for (; i < len; i++)
                if (matcher = Expr.relative[tokens[i].type]) matchers = [addCombinator(elementMatcher(matchers),
                    matcher)];
                else {
                    matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);
                    if (matcher[expando]) {
                        j = ++i;
                        for (; j < len; j++)
                            if (Expr.relative[tokens[j].type]) break;
                        return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector(tokens.slice(0, i - 1).concat({
                            value: tokens[i - 2].type === " " ? "*" : ""
                        })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens))
                    }
                    matchers.push(matcher)
                }
            return elementMatcher(matchers)
        }

        function matcherFromGroupMatchers(elementMatchers,
            setMatchers) {
            var bySet = setMatchers.length > 0,
                byElement = elementMatchers.length > 0,
                superMatcher = function(seed, context, xml, results, outermost) {
                    var elem, j, matcher, matchedCount = 0,
                        i = "0",
                        unmatched = seed && [],
                        setMatched = [],
                        contextBackup = outermostContext,
                        elems = seed || byElement && Expr.find["TAG"]("*", outermost),
                        dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || .1,
                        len = elems.length;
                    if (outermost) outermostContext = context === document || context || outermost;
                    for (; i !== len && (elem = elems[i]) != null; i++) {
                        if (byElement && elem) {
                            j =
                                0;
                            if (!context && elem.ownerDocument !== document) {
                                setDocument(elem);
                                xml = !documentIsHTML
                            }
                            while (matcher = elementMatchers[j++])
                                if (matcher(elem, context || document, xml)) {
                                    results.push(elem);
                                    break
                                }
                            if (outermost) dirruns = dirrunsUnique
                        }
                        if (bySet) {
                            if (elem = !matcher && elem) matchedCount--;
                            if (seed) unmatched.push(elem)
                        }
                    }
                    matchedCount += i;
                    if (bySet && i !== matchedCount) {
                        j = 0;
                        while (matcher = setMatchers[j++]) matcher(unmatched, setMatched, context, xml);
                        if (seed) {
                            if (matchedCount > 0)
                                while (i--)
                                    if (!(unmatched[i] || setMatched[i])) setMatched[i] =
                                        pop.call(results);
                            setMatched = condense(setMatched)
                        }
                        push.apply(results, setMatched);
                        if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) Sizzle.uniqueSort(results)
                    }
                    if (outermost) {
                        dirruns = dirrunsUnique;
                        outermostContext = contextBackup
                    }
                    return unmatched
                };
            return bySet ? markFunction(superMatcher) : superMatcher
        }
        compile = Sizzle.compile = function(selector, match) {
            var i, setMatchers = [],
                elementMatchers = [],
                cached = compilerCache[selector + " "];
            if (!cached) {
                if (!match) match = tokenize(selector);
                i = match.length;
                while (i--) {
                    cached = matcherFromTokens(match[i]);
                    if (cached[expando]) setMatchers.push(cached);
                    else elementMatchers.push(cached)
                }
                cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
                cached.selector = selector
            }
            return cached
        };
        select = Sizzle.select = function(selector, context, results, seed) {
            var i, tokens, token, type, find, compiled = typeof selector === "function" && selector,
                match = !seed && tokenize(selector = compiled.selector || selector);
            results = results || [];
            if (match.length === 1) {
                tokens = match[0] =
                    match[0].slice(0);
                if (tokens.length > 2 && (token = tokens[0]).type === "ID" && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
                    context = (Expr.find["ID"](token.matches[0].replace(runescape, funescape), context) || [])[0];
                    if (!context) return results;
                    else if (compiled) context = context.parentNode;
                    selector = selector.slice(tokens.shift().value.length)
                }
                i = matchExpr["needsContext"].test(selector) ? 0 : tokens.length;
                while (i--) {
                    token = tokens[i];
                    if (Expr.relative[type = token.type]) break;
                    if (find = Expr.find[type])
                        if (seed =
                            find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {
                            tokens.splice(i, 1);
                            selector = seed.length && toSelector(tokens);
                            if (!selector) {
                                push.apply(results, seed);
                                return results
                            }
                            break
                        }
                }
            }(compiled || compile(selector, match))(seed, context, !documentIsHTML, results, !context || rsibling.test(selector) && testContext(context.parentNode) || context);
            return results
        };
        support.sortStable = expando.split("").sort(sortOrder).join("") === expando;
        support.detectDuplicates = !!hasDuplicate;
        setDocument();
        support.sortDetached = assert(function(el) {
            return el.compareDocumentPosition(document.createElement("fieldset")) & 1
        });
        if (!assert(function(el) {
                el.innerHTML = "<a href='#'></a>";
                return el.firstChild.getAttribute("href") === "#"
            })) addHandle("type|href|height|width", function(elem, name, isXML) {
            if (!isXML) return elem.getAttribute(name, name.toLowerCase() === "type" ? 1 : 2)
        });
        if (!support.attributes || !assert(function(el) {
                el.innerHTML = "<input/>";
                el.firstChild.setAttribute("value", "");
                return el.firstChild.getAttribute("value") ===
                    ""
            })) addHandle("value", function(elem, name, isXML) {
            if (!isXML && elem.nodeName.toLowerCase() === "input") return elem.defaultValue
        });
        if (!assert(function(el) {
                return el.getAttribute("disabled") == null
            })) addHandle(booleans, function(elem, name, isXML) {
            var val;
            if (!isXML) return elem[name] === true ? name.toLowerCase() : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null
        });
        return Sizzle
    }(window);
    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors;
    jQuery.expr[":"] = jQuery.expr.pseudos;
    jQuery.uniqueSort = jQuery.unique =
        Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    jQuery.escapeSelector = Sizzle.escape;
    var dir = function(elem, dir, until) {
        var matched = [],
            truncate = until !== undefined;
        while ((elem = elem[dir]) && elem.nodeType !== 9)
            if (elem.nodeType === 1) {
                if (truncate && jQuery(elem).is(until)) break;
                matched.push(elem)
            }
        return matched
    };
    var siblings = function(n, elem) {
        var matched = [];
        for (; n; n = n.nextSibling)
            if (n.nodeType === 1 && n !== elem) matched.push(n);
        return matched
    };
    var rneedsContext =
        jQuery.expr.match.needsContext;

    function nodeName(elem, name) {
        return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase()
    }
    var rsingleTag = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;
    var risSimple = /^.[^:#\[\.,]*$/;

    function winnow(elements, qualifier, not) {
        if (jQuery.isFunction(qualifier)) return jQuery.grep(elements, function(elem, i) {
            return !!qualifier.call(elem, i, elem) !== not
        });
        if (qualifier.nodeType) return jQuery.grep(elements, function(elem) {
            return elem === qualifier !== not
        });
        if (typeof qualifier !== "string") return jQuery.grep(elements, function(elem) {
            return indexOf.call(qualifier, elem) > -1 !== not
        });
        if (risSimple.test(qualifier)) return jQuery.filter(qualifier, elements, not);
        qualifier = jQuery.filter(qualifier, elements);
        return jQuery.grep(elements, function(elem) {
            return indexOf.call(qualifier, elem) > -1 !== not && elem.nodeType === 1
        })
    }
    jQuery.filter = function(expr, elems, not) {
        var elem = elems[0];
        if (not) expr = ":not(" + expr + ")";
        if (elems.length === 1 && elem.nodeType === 1) return jQuery.find.matchesSelector(elem,
            expr) ? [elem] : [];
        return jQuery.find.matches(expr, jQuery.grep(elems, function(elem) {
            return elem.nodeType === 1
        }))
    };
    jQuery.fn.extend({
        find: function(selector) {
            var i, ret, len = this.length,
                self = this;
            if (typeof selector !== "string") return this.pushStack(jQuery(selector).filter(function() {
                for (i = 0; i < len; i++)
                    if (jQuery.contains(self[i], this)) return true
            }));
            ret = this.pushStack([]);
            for (i = 0; i < len; i++) jQuery.find(selector, self[i], ret);
            return len > 1 ? jQuery.uniqueSort(ret) : ret
        },
        filter: function(selector) {
            return this.pushStack(winnow(this,
                selector || [], false))
        },
        not: function(selector) {
            return this.pushStack(winnow(this, selector || [], true))
        },
        is: function(selector) {
            return !!winnow(this, typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length
        }
    });
    var rootjQuery, rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,
        init = jQuery.fn.init = function(selector, context, root) {
            var match, elem;
            if (!selector) return this;
            root = root || rootjQuery;
            if (typeof selector === "string") {
                if (selector[0] === "<" && selector[selector.length -
                        1] === ">" && selector.length >= 3) match = [null, selector, null];
                else match = rquickExpr.exec(selector);
                if (match && (match[1] || !context))
                    if (match[1]) {
                        context = context instanceof jQuery ? context[0] : context;
                        jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document, true));
                        if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context))
                            for (match in context)
                                if (jQuery.isFunction(this[match])) this[match](context[match]);
                                else this.attr(match, context[match]);
                        return this
                    } else {
                        elem =
                            document.getElementById(match[2]);
                        if (elem) {
                            this[0] = elem;
                            this.length = 1
                        }
                        return this
                    } else if (!context || context.jquery) return (context || root).find(selector);
                else return this.constructor(context).find(selector)
            } else if (selector.nodeType) {
                this[0] = selector;
                this.length = 1;
                return this
            } else if (jQuery.isFunction(selector)) return root.ready !== undefined ? root.ready(selector) : selector(jQuery);
            return jQuery.makeArray(selector, this)
        };
    init.prototype = jQuery.fn;
    rootjQuery = jQuery(document);
    var rparentsprev = /^(?:parents|prev(?:Until|All))/,
        guaranteedUnique = {
            children: true,
            contents: true,
            next: true,
            prev: true
        };
    jQuery.fn.extend({
        has: function(target) {
            var targets = jQuery(target, this),
                l = targets.length;
            return this.filter(function() {
                var i = 0;
                for (; i < l; i++)
                    if (jQuery.contains(this, targets[i])) return true
            })
        },
        closest: function(selectors, context) {
            var cur, i = 0,
                l = this.length,
                matched = [],
                targets = typeof selectors !== "string" && jQuery(selectors);
            if (!rneedsContext.test(selectors))
                for (; i < l; i++)
                    for (cur = this[i]; cur && cur !== context; cur = cur.parentNode)
                        if (cur.nodeType <
                            11 && (targets ? targets.index(cur) > -1 : cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) {
                            matched.push(cur);
                            break
                        }
            return this.pushStack(matched.length > 1 ? jQuery.uniqueSort(matched) : matched)
        },
        index: function(elem) {
            if (!elem) return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
            if (typeof elem === "string") return indexOf.call(jQuery(elem), this[0]);
            return indexOf.call(this, elem.jquery ? elem[0] : elem)
        },
        add: function(selector, context) {
            return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),
                jQuery(selector, context))))
        },
        addBack: function(selector) {
            return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector))
        }
    });

    function sibling(cur, dir) {
        while ((cur = cur[dir]) && cur.nodeType !== 1);
        return cur
    }
    jQuery.each({
        parent: function(elem) {
            var parent = elem.parentNode;
            return parent && parent.nodeType !== 11 ? parent : null
        },
        parents: function(elem) {
            return dir(elem, "parentNode")
        },
        parentsUntil: function(elem, i, until) {
            return dir(elem, "parentNode", until)
        },
        next: function(elem) {
            return sibling(elem, "nextSibling")
        },
        prev: function(elem) {
            return sibling(elem, "previousSibling")
        },
        nextAll: function(elem) {
            return dir(elem, "nextSibling")
        },
        prevAll: function(elem) {
            return dir(elem, "previousSibling")
        },
        nextUntil: function(elem, i, until) {
            return dir(elem, "nextSibling", until)
        },
        prevUntil: function(elem, i, until) {
            return dir(elem, "previousSibling", until)
        },
        siblings: function(elem) {
            return siblings((elem.parentNode || {}).firstChild, elem)
        },
        children: function(elem) {
            return siblings(elem.firstChild)
        },
        contents: function(elem) {
            if (nodeName(elem, "iframe")) return elem.contentDocument;
            if (nodeName(elem, "template")) elem = elem.content || elem;
            return jQuery.merge([], elem.childNodes)
        }
    }, function(name, fn) {
        jQuery.fn[name] = function(until, selector) {
            var matched = jQuery.map(this, fn, until);
            if (name.slice(-5) !== "Until") selector = until;
            if (selector && typeof selector === "string") matched = jQuery.filter(selector, matched);
            if (this.length > 1) {
                if (!guaranteedUnique[name]) jQuery.uniqueSort(matched);
                if (rparentsprev.test(name)) matched.reverse()
            }
            return this.pushStack(matched)
        }
    });
    var rnothtmlwhite = /[^\x20\t\r\n\f]+/g;

    function createOptions(options) {
        var object = {};
        jQuery.each(options.match(rnothtmlwhite) || [], function(_, flag) {
            object[flag] = true
        });
        return object
    }
    jQuery.Callbacks = function(options) {
        options = typeof options === "string" ? createOptions(options) : jQuery.extend({}, options);
        var firing, memory, fired, locked, list = [],
            queue = [],
            firingIndex = -1,
            fire = function() {
                locked = locked || options.once;
                fired = firing = true;
                for (; queue.length; firingIndex = -1) {
                    memory = queue.shift();
                    while (++firingIndex < list.length)
                        if (list[firingIndex].apply(memory[0],
                                memory[1]) === false && options.stopOnFalse) {
                            firingIndex = list.length;
                            memory = false
                        }
                }
                if (!options.memory) memory = false;
                firing = false;
                if (locked)
                    if (memory) list = [];
                    else list = ""
            },
            self = {
                add: function() {
                    if (list) {
                        if (memory && !firing) {
                            firingIndex = list.length - 1;
                            queue.push(memory)
                        }(function add(args) {
                            jQuery.each(args, function(_, arg) {
                                if (jQuery.isFunction(arg)) {
                                    if (!options.unique || !self.has(arg)) list.push(arg)
                                } else if (arg && arg.length && jQuery.type(arg) !== "string") add(arg)
                            })
                        })(arguments);
                        if (memory && !firing) fire()
                    }
                    return this
                },
                remove: function() {
                    jQuery.each(arguments, function(_, arg) {
                        var index;
                        while ((index = jQuery.inArray(arg, list, index)) > -1) {
                            list.splice(index, 1);
                            if (index <= firingIndex) firingIndex--
                        }
                    });
                    return this
                },
                has: function(fn) {
                    return fn ? jQuery.inArray(fn, list) > -1 : list.length > 0
                },
                empty: function() {
                    if (list) list = [];
                    return this
                },
                disable: function() {
                    locked = queue = [];
                    list = memory = "";
                    return this
                },
                disabled: function() {
                    return !list
                },
                lock: function() {
                    locked = queue = [];
                    if (!memory && !firing) list = memory = "";
                    return this
                },
                locked: function() {
                    return !!locked
                },
                fireWith: function(context, args) {
                    if (!locked) {
                        args = args || [];
                        args = [context, args.slice ? args.slice() : args];
                        queue.push(args);
                        if (!firing) fire()
                    }
                    return this
                },
                fire: function() {
                    self.fireWith(this, arguments);
                    return this
                },
                fired: function() {
                    return !!fired
                }
            };
        return self
    };

    function Identity(v) {
        return v
    }

    function Thrower(ex) {
        throw ex;
    }

    function adoptValue(value, resolve, reject, noValue) {
        var method;
        try {
            if (value && jQuery.isFunction(method = value.promise)) method.call(value).done(resolve).fail(reject);
            else if (value && jQuery.isFunction(method =
                    value.then)) method.call(value, resolve, reject);
            else resolve.apply(undefined, [value].slice(noValue))
        } catch (value$2) {
            reject.apply(undefined, [value$2])
        }
    }
    jQuery.extend({
        Deferred: function(func) {
            var tuples = [
                    ["notify", "progress", jQuery.Callbacks("memory"), jQuery.Callbacks("memory"), 2],
                    ["resolve", "done", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 0, "resolved"],
                    ["reject", "fail", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 1, "rejected"]
                ],
                state = "pending",
                promise = {
                    state: function() {
                        return state
                    },
                    always: function() {
                        deferred.done(arguments).fail(arguments);
                        return this
                    },
                    "catch": function(fn) {
                        return promise.then(null, fn)
                    },
                    pipe: function() {
                        var fns = arguments;
                        return jQuery.Deferred(function(newDefer) {
                            jQuery.each(tuples, function(i, tuple) {
                                var fn = jQuery.isFunction(fns[tuple[4]]) && fns[tuple[4]];
                                deferred[tuple[1]](function() {
                                    var returned = fn && fn.apply(this, arguments);
                                    if (returned && jQuery.isFunction(returned.promise)) returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject);
                                    else newDefer[tuple[0] + "With"](this, fn ? [returned] : arguments)
                                })
                            });
                            fns = null
                        }).promise()
                    },
                    then: function(onFulfilled, onRejected, onProgress) {
                        var maxDepth = 0;

                        function resolve(depth, deferred, handler, special) {
                            return function() {
                                var that = this,
                                    args = arguments,
                                    mightThrow = function() {
                                        var returned, then;
                                        if (depth < maxDepth) return;
                                        returned = handler.apply(that, args);
                                        if (returned === deferred.promise()) throw new TypeError("Thenable self-resolution");
                                        then = returned && (typeof returned === "object" || typeof returned === "function") &&
                                            returned.then;
                                        if (jQuery.isFunction(then))
                                            if (special) then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special));
                                            else {
                                                maxDepth++;
                                                then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special), resolve(maxDepth, deferred, Identity, deferred.notifyWith))
                                            } else {
                                            if (handler !== Identity) {
                                                that = undefined;
                                                args = [returned]
                                            }(special || deferred.resolveWith)(that, args)
                                        }
                                    },
                                    process = special ? mightThrow : function() {
                                        try {
                                            mightThrow()
                                        } catch (e) {
                                            if (jQuery.Deferred.exceptionHook) jQuery.Deferred.exceptionHook(e,
                                                process.stackTrace);
                                            if (depth + 1 >= maxDepth) {
                                                if (handler !== Thrower) {
                                                    that = undefined;
                                                    args = [e]
                                                }
                                                deferred.rejectWith(that, args)
                                            }
                                        }
                                    };
                                if (depth) process();
                                else {
                                    if (jQuery.Deferred.getStackHook) process.stackTrace = jQuery.Deferred.getStackHook();
                                    window.setTimeout(process)
                                }
                            }
                        }
                        return jQuery.Deferred(function(newDefer) {
                            tuples[0][3].add(resolve(0, newDefer, jQuery.isFunction(onProgress) ? onProgress : Identity, newDefer.notifyWith));
                            tuples[1][3].add(resolve(0, newDefer, jQuery.isFunction(onFulfilled) ? onFulfilled : Identity));
                            tuples[2][3].add(resolve(0,
                                newDefer, jQuery.isFunction(onRejected) ? onRejected : Thrower))
                        }).promise()
                    },
                    promise: function(obj) {
                        return obj != null ? jQuery.extend(obj, promise) : promise
                    }
                },
                deferred = {};
            jQuery.each(tuples, function(i, tuple) {
                var list = tuple[2],
                    stateString = tuple[5];
                promise[tuple[1]] = list.add;
                if (stateString) list.add(function() {
                    state = stateString
                }, tuples[3 - i][2].disable, tuples[0][2].lock);
                list.add(tuple[3].fire);
                deferred[tuple[0]] = function() {
                    deferred[tuple[0] + "With"](this === deferred ? undefined : this, arguments);
                    return this
                };
                deferred[tuple[0] +
                    "With"] = list.fireWith
            });
            promise.promise(deferred);
            if (func) func.call(deferred, deferred);
            return deferred
        },
        when: function(singleValue) {
            var remaining = arguments.length,
                i = remaining,
                resolveContexts = Array(i),
                resolveValues = slice.call(arguments),
                master = jQuery.Deferred(),
                updateFunc = function(i) {
                    return function(value) {
                        resolveContexts[i] = this;
                        resolveValues[i] = arguments.length > 1 ? slice.call(arguments) : value;
                        if (!--remaining) master.resolveWith(resolveContexts, resolveValues)
                    }
                };
            if (remaining <= 1) {
                adoptValue(singleValue,
                    master.done(updateFunc(i)).resolve, master.reject, !remaining);
                if (master.state() === "pending" || jQuery.isFunction(resolveValues[i] && resolveValues[i].then)) return master.then()
            }
            while (i--) adoptValue(resolveValues[i], updateFunc(i), master.reject);
            return master.promise()
        }
    });
    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;
    jQuery.Deferred.exceptionHook = function(error, stack) {
        if (window.console && window.console.warn && error && rerrorNames.test(error.name)) window.console.warn("jQuery.Deferred exception: " +
            error.message, error.stack, stack)
    };
    jQuery.readyException = function(error) {
        window.setTimeout(function() {
            throw error;
        })
    };
    var readyList = jQuery.Deferred();
    jQuery.fn.ready = function(fn) {
        readyList.then(fn).catch(function(error) {
            jQuery.readyException(error)
        });
        return this
    };
    jQuery.extend({
        isReady: false,
        readyWait: 1,
        ready: function(wait) {
            if (wait === true ? --jQuery.readyWait : jQuery.isReady) return;
            jQuery.isReady = true;
            if (wait !== true && --jQuery.readyWait > 0) return;
            readyList.resolveWith(document, [jQuery])
        }
    });
    jQuery.ready.then =
        readyList.then;

    function completed() {
        document.removeEventListener("DOMContentLoaded", completed);
        window.removeEventListener("load", completed);
        jQuery.ready()
    }
    if (document.readyState === "complete" || document.readyState !== "loading" && !document.documentElement.doScroll) window.setTimeout(jQuery.ready);
    else {
        document.addEventListener("DOMContentLoaded", completed);
        window.addEventListener("load", completed)
    }
    var access = function(elems, fn, key, value, chainable, emptyGet, raw) {
        var i = 0,
            len = elems.length,
            bulk = key == null;
        if (jQuery.type(key) ===
            "object") {
            chainable = true;
            for (i in key) access(elems, fn, i, key[i], true, emptyGet, raw)
        } else if (value !== undefined) {
            chainable = true;
            if (!jQuery.isFunction(value)) raw = true;
            if (bulk)
                if (raw) {
                    fn.call(elems, value);
                    fn = null
                } else {
                    bulk = fn;
                    fn = function(elem, key, value) {
                        return bulk.call(jQuery(elem), value)
                    }
                }
            if (fn)
                for (; i < len; i++) fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)))
        }
        if (chainable) return elems;
        if (bulk) return fn.call(elems);
        return len ? fn(elems[0], key) : emptyGet
    };
    var acceptData = function(owner) {
        return owner.nodeType ===
            1 || owner.nodeType === 9 || !+owner.nodeType
    };

    function Data() {
        this.expando = jQuery.expando + Data.uid++
    }
    Data.uid = 1;
    Data.prototype = {
        cache: function(owner) {
            var value = owner[this.expando];
            if (!value) {
                value = {};
                if (acceptData(owner))
                    if (owner.nodeType) owner[this.expando] = value;
                    else Object.defineProperty(owner, this.expando, {
                        value: value,
                        configurable: true
                    })
            }
            return value
        },
        set: function(owner, data, value) {
            var prop, cache = this.cache(owner);
            if (typeof data === "string") cache[jQuery.camelCase(data)] = value;
            else
                for (prop in data) cache[jQuery.camelCase(prop)] =
                    data[prop];
            return cache
        },
        get: function(owner, key) {
            return key === undefined ? this.cache(owner) : owner[this.expando] && owner[this.expando][jQuery.camelCase(key)]
        },
        access: function(owner, key, value) {
            if (key === undefined || key && typeof key === "string" && value === undefined) return this.get(owner, key);
            this.set(owner, key, value);
            return value !== undefined ? value : key
        },
        remove: function(owner, key) {
            var i, cache = owner[this.expando];
            if (cache === undefined) return;
            if (key !== undefined) {
                if (Array.isArray(key)) key = key.map(jQuery.camelCase);
                else {
                    key = jQuery.camelCase(key);
                    key = key in cache ? [key] : key.match(rnothtmlwhite) || []
                }
                i = key.length;
                while (i--) delete cache[key[i]]
            }
            if (key === undefined || jQuery.isEmptyObject(cache))
                if (owner.nodeType) owner[this.expando] = undefined;
                else delete owner[this.expando]
        },
        hasData: function(owner) {
            var cache = owner[this.expando];
            return cache !== undefined && !jQuery.isEmptyObject(cache)
        }
    };
    var dataPriv = new Data;
    var dataUser = new Data;
    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
        rmultiDash = /[A-Z]/g;

    function getData(data) {
        if (data ===
            "true") return true;
        if (data === "false") return false;
        if (data === "null") return null;
        if (data === +data + "") return +data;
        if (rbrace.test(data)) return JSON.parse(data);
        return data
    }

    function dataAttr(elem, key, data) {
        var name;
        if (data === undefined && elem.nodeType === 1) {
            name = "data-" + key.replace(rmultiDash, "-$&").toLowerCase();
            data = elem.getAttribute(name);
            if (typeof data === "string") {
                try {
                    data = getData(data)
                } catch (e) {}
                dataUser.set(elem, key, data)
            } else data = undefined
        }
        return data
    }
    jQuery.extend({
        hasData: function(elem) {
            return dataUser.hasData(elem) ||
                dataPriv.hasData(elem)
        },
        data: function(elem, name, data) {
            return dataUser.access(elem, name, data)
        },
        removeData: function(elem, name) {
            dataUser.remove(elem, name)
        },
        _data: function(elem, name, data) {
            return dataPriv.access(elem, name, data)
        },
        _removeData: function(elem, name) {
            dataPriv.remove(elem, name)
        }
    });
    jQuery.fn.extend({
        data: function(key, value) {
            var i, name, data, elem = this[0],
                attrs = elem && elem.attributes;
            if (key === undefined) {
                if (this.length) {
                    data = dataUser.get(elem);
                    if (elem.nodeType === 1 && !dataPriv.get(elem, "hasDataAttrs")) {
                        i =
                            attrs.length;
                        while (i--)
                            if (attrs[i]) {
                                name = attrs[i].name;
                                if (name.indexOf("data-") === 0) {
                                    name = jQuery.camelCase(name.slice(5));
                                    dataAttr(elem, name, data[name])
                                }
                            }
                        dataPriv.set(elem, "hasDataAttrs", true)
                    }
                }
                return data
            }
            if (typeof key === "object") return this.each(function() {
                dataUser.set(this, key)
            });
            return access(this, function(value) {
                var data;
                if (elem && value === undefined) {
                    data = dataUser.get(elem, key);
                    if (data !== undefined) return data;
                    data = dataAttr(elem, key);
                    if (data !== undefined) return data;
                    return
                }
                this.each(function() {
                    dataUser.set(this,
                        key, value)
                })
            }, null, value, arguments.length > 1, null, true)
        },
        removeData: function(key) {
            return this.each(function() {
                dataUser.remove(this, key)
            })
        }
    });
    jQuery.extend({
        queue: function(elem, type, data) {
            var queue;
            if (elem) {
                type = (type || "fx") + "queue";
                queue = dataPriv.get(elem, type);
                if (data)
                    if (!queue || Array.isArray(data)) queue = dataPriv.access(elem, type, jQuery.makeArray(data));
                    else queue.push(data);
                return queue || []
            }
        },
        dequeue: function(elem, type) {
            type = type || "fx";
            var queue = jQuery.queue(elem, type),
                startLength = queue.length,
                fn =
                queue.shift(),
                hooks = jQuery._queueHooks(elem, type),
                next = function() {
                    jQuery.dequeue(elem, type)
                };
            if (fn === "inprogress") {
                fn = queue.shift();
                startLength--
            }
            if (fn) {
                if (type === "fx") queue.unshift("inprogress");
                delete hooks.stop;
                fn.call(elem, next, hooks)
            }
            if (!startLength && hooks) hooks.empty.fire()
        },
        _queueHooks: function(elem, type) {
            var key = type + "queueHooks";
            return dataPriv.get(elem, key) || dataPriv.access(elem, key, {
                empty: jQuery.Callbacks("once memory").add(function() {
                    dataPriv.remove(elem, [type + "queue", key])
                })
            })
        }
    });
    jQuery.fn.extend({
        queue: function(type,
            data) {
            var setter = 2;
            if (typeof type !== "string") {
                data = type;
                type = "fx";
                setter--
            }
            if (arguments.length < setter) return jQuery.queue(this[0], type);
            return data === undefined ? this : this.each(function() {
                var queue = jQuery.queue(this, type, data);
                jQuery._queueHooks(this, type);
                if (type === "fx" && queue[0] !== "inprogress") jQuery.dequeue(this, type)
            })
        },
        dequeue: function(type) {
            return this.each(function() {
                jQuery.dequeue(this, type)
            })
        },
        clearQueue: function(type) {
            return this.queue(type || "fx", [])
        },
        promise: function(type, obj) {
            var tmp, count =
                1,
                defer = jQuery.Deferred(),
                elements = this,
                i = this.length,
                resolve = function() {
                    if (!--count) defer.resolveWith(elements, [elements])
                };
            if (typeof type !== "string") {
                obj = type;
                type = undefined
            }
            type = type || "fx";
            while (i--) {
                tmp = dataPriv.get(elements[i], type + "queueHooks");
                if (tmp && tmp.empty) {
                    count++;
                    tmp.empty.add(resolve)
                }
            }
            resolve();
            return defer.promise(obj)
        }
    });
    var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var rcssNum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i");
    var cssExpand = ["Top", "Right", "Bottom", "Left"];
    var isHiddenWithinTree = function(elem, el) {
        elem = el || elem;
        return elem.style.display === "none" || elem.style.display === "" && jQuery.contains(elem.ownerDocument, elem) && jQuery.css(elem, "display") === "none"
    };
    var swap = function(elem, options, callback, args) {
        var ret, name, old = {};
        for (name in options) {
            old[name] = elem.style[name];
            elem.style[name] = options[name]
        }
        ret = callback.apply(elem, args || []);
        for (name in options) elem.style[name] = old[name];
        return ret
    };

    function adjustCSS(elem, prop, valueParts, tween) {
        var adjusted, scale = 1,
            maxIterations = 20,
            currentValue = tween ? function() {
                return tween.cur()
            } : function() {
                return jQuery.css(elem, prop, "")
            },
            initial = currentValue(),
            unit = valueParts && valueParts[3] || (jQuery.cssNumber[prop] ? "" : "px"),
            initialInUnit = (jQuery.cssNumber[prop] || unit !== "px" && +initial) && rcssNum.exec(jQuery.css(elem, prop));
        if (initialInUnit && initialInUnit[3] !== unit) {
            unit = unit || initialInUnit[3];
            valueParts = valueParts || [];
            initialInUnit = +initial || 1;
            do {
                scale = scale || ".5";
                initialInUnit = initialInUnit / scale;
                jQuery.style(elem, prop, initialInUnit +
                    unit)
            } while (scale !== (scale = currentValue() / initial) && scale !== 1 && --maxIterations)
        }
        if (valueParts) {
            initialInUnit = +initialInUnit || +initial || 0;
            adjusted = valueParts[1] ? initialInUnit + (valueParts[1] + 1) * valueParts[2] : +valueParts[2];
            if (tween) {
                tween.unit = unit;
                tween.start = initialInUnit;
                tween.end = adjusted
            }
        }
        return adjusted
    }
    var defaultDisplayMap = {};

    function getDefaultDisplay(elem) {
        var temp, doc = elem.ownerDocument,
            nodeName = elem.nodeName,
            display = defaultDisplayMap[nodeName];
        if (display) return display;
        temp = doc.body.appendChild(doc.createElement(nodeName));
        display = jQuery.css(temp, "display");
        temp.parentNode.removeChild(temp);
        if (display === "none") display = "block";
        defaultDisplayMap[nodeName] = display;
        return display
    }

    function showHide(elements, show) {
        var display, elem, values = [],
            index = 0,
            length = elements.length;
        for (; index < length; index++) {
            elem = elements[index];
            if (!elem.style) continue;
            display = elem.style.display;
            if (show) {
                if (display === "none") {
                    values[index] = dataPriv.get(elem, "display") || null;
                    if (!values[index]) elem.style.display = ""
                }
                if (elem.style.display === "" && isHiddenWithinTree(elem)) values[index] =
                    getDefaultDisplay(elem)
            } else if (display !== "none") {
                values[index] = "none";
                dataPriv.set(elem, "display", display)
            }
        }
        for (index = 0; index < length; index++)
            if (values[index] != null) elements[index].style.display = values[index];
        return elements
    }
    jQuery.fn.extend({
        show: function() {
            return showHide(this, true)
        },
        hide: function() {
            return showHide(this)
        },
        toggle: function(state) {
            if (typeof state === "boolean") return state ? this.show() : this.hide();
            return this.each(function() {
                if (isHiddenWithinTree(this)) jQuery(this).show();
                else jQuery(this).hide()
            })
        }
    });
    var rcheckableType = /^(?:checkbox|radio)$/i;
    var rtagName = /<([a-z][^\/\0>\x20\t\r\n\f]+)/i;
    var rscriptType = /^$|\/(?:java|ecma)script/i;
    var wrapMap = {
        option: [1, "<select multiple='multiple'>", "</select>"],
        thead: [1, "<table>", "</table>"],
        col: [2, "<table><colgroup>", "</colgroup></table>"],
        tr: [2, "<table><tbody>", "</tbody></table>"],
        td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
        _default: [0, "", ""]
    };
    wrapMap.optgroup = wrapMap.option;
    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;

    function getAll(context, tag) {
        var ret;
        if (typeof context.getElementsByTagName !== "undefined") ret = context.getElementsByTagName(tag || "*");
        else if (typeof context.querySelectorAll !== "undefined") ret = context.querySelectorAll(tag || "*");
        else ret = [];
        if (tag === undefined || tag && nodeName(context, tag)) return jQuery.merge([context], ret);
        return ret
    }

    function setGlobalEval(elems, refElements) {
        var i = 0,
            l = elems.length;
        for (; i < l; i++) dataPriv.set(elems[i], "globalEval", !refElements || dataPriv.get(refElements[i],
            "globalEval"))
    }
    var rhtml = /<|&#?\w+;/;

    function buildFragment(elems, context, scripts, selection, ignored) {
        var elem, tmp, tag, wrap, contains, j, fragment = context.createDocumentFragment(),
            nodes = [],
            i = 0,
            l = elems.length;
        for (; i < l; i++) {
            elem = elems[i];
            if (elem || elem === 0)
                if (jQuery.type(elem) === "object") jQuery.merge(nodes, elem.nodeType ? [elem] : elem);
                else if (!rhtml.test(elem)) nodes.push(context.createTextNode(elem));
            else {
                tmp = tmp || fragment.appendChild(context.createElement("div"));
                tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
                wrap = wrapMap[tag] || wrapMap._default;
                tmp.innerHTML = wrap[1] + jQuery.htmlPrefilter(elem) + wrap[2];
                j = wrap[0];
                while (j--) tmp = tmp.lastChild;
                jQuery.merge(nodes, tmp.childNodes);
                tmp = fragment.firstChild;
                tmp.textContent = ""
            }
        }
        fragment.textContent = "";
        i = 0;
        while (elem = nodes[i++]) {
            if (selection && jQuery.inArray(elem, selection) > -1) {
                if (ignored) ignored.push(elem);
                continue
            }
            contains = jQuery.contains(elem.ownerDocument, elem);
            tmp = getAll(fragment.appendChild(elem), "script");
            if (contains) setGlobalEval(tmp);
            if (scripts) {
                j = 0;
                while (elem =
                    tmp[j++])
                    if (rscriptType.test(elem.type || "")) scripts.push(elem)
            }
        }
        return fragment
    }(function() {
        var fragment = document.createDocumentFragment(),
            div = fragment.appendChild(document.createElement("div")),
            input = document.createElement("input");
        input.setAttribute("type", "radio");
        input.setAttribute("checked", "checked");
        input.setAttribute("name", "t");
        div.appendChild(input);
        support.checkClone = div.cloneNode(true).cloneNode(true).lastChild.checked;
        div.innerHTML = "<textarea>x</textarea>";
        support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue
    })();
    var documentElement = document.documentElement;
    var rkeyEvent = /^key/,
        rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
        rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

    function returnTrue() {
        return true
    }

    function returnFalse() {
        return false
    }

    function safeActiveElement() {
        try {
            return document.activeElement
        } catch (err) {}
    }

    function on(elem, types, selector, data, fn, one) {
        var origFn, type;
        if (typeof types === "object") {
            if (typeof selector !== "string") {
                data = data || selector;
                selector = undefined
            }
            for (type in types) on(elem, type, selector,
                data, types[type], one);
            return elem
        }
        if (data == null && fn == null) {
            fn = selector;
            data = selector = undefined
        } else if (fn == null)
            if (typeof selector === "string") {
                fn = data;
                data = undefined
            } else {
                fn = data;
                data = selector;
                selector = undefined
            }
        if (fn === false) fn = returnFalse;
        else if (!fn) return elem;
        if (one === 1) {
            origFn = fn;
            fn = function(event) {
                jQuery().off(event);
                return origFn.apply(this, arguments)
            };
            fn.guid = origFn.guid || (origFn.guid = jQuery.guid++)
        }
        return elem.each(function() {
            jQuery.event.add(this, types, fn, data, selector)
        })
    }
    jQuery.event = {
        global: {},
        add: function(elem, types, handler, data, selector) {
            var handleObjIn, eventHandle, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = dataPriv.get(elem);
            if (!elemData) return;
            if (handler.handler) {
                handleObjIn = handler;
                handler = handleObjIn.handler;
                selector = handleObjIn.selector
            }
            if (selector) jQuery.find.matchesSelector(documentElement, selector);
            if (!handler.guid) handler.guid = jQuery.guid++;
            if (!(events = elemData.events)) events = elemData.events = {};
            if (!(eventHandle = elemData.handle)) eventHandle =
                elemData.handle = function(e) {
                    return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ? jQuery.event.dispatch.apply(elem, arguments) : undefined
                };
            types = (types || "").match(rnothtmlwhite) || [""];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                if (!type) continue;
                special = jQuery.event.special[type] || {};
                type = (selector ? special.delegateType : special.bindType) || type;
                special = jQuery.event.special[type] || {};
                handleObj = jQuery.extend({
                    type: type,
                    origType: origType,
                    data: data,
                    handler: handler,
                    guid: handler.guid,
                    selector: selector,
                    needsContext: selector && jQuery.expr.match.needsContext.test(selector),
                    namespace: namespaces.join(".")
                }, handleObjIn);
                if (!(handlers = events[type])) {
                    handlers = events[type] = [];
                    handlers.delegateCount = 0;
                    if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false)
                        if (elem.addEventListener) elem.addEventListener(type, eventHandle)
                }
                if (special.add) {
                    special.add.call(elem, handleObj);
                    if (!handleObj.handler.guid) handleObj.handler.guid =
                        handler.guid
                }
                if (selector) handlers.splice(handlers.delegateCount++, 0, handleObj);
                else handlers.push(handleObj);
                jQuery.event.global[type] = true
            }
        },
        remove: function(elem, types, handler, selector, mappedTypes) {
            var j, origCount, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = dataPriv.hasData(elem) && dataPriv.get(elem);
            if (!elemData || !(events = elemData.events)) return;
            types = (types || "").match(rnothtmlwhite) || [""];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType =
                    tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                if (!type) {
                    for (type in events) jQuery.event.remove(elem, type + types[t], handler, selector, true);
                    continue
                }
                special = jQuery.event.special[type] || {};
                type = (selector ? special.delegateType : special.bindType) || type;
                handlers = events[type] || [];
                tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)");
                origCount = j = handlers.length;
                while (j--) {
                    handleObj = handlers[j];
                    if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) &&
                        (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
                        handlers.splice(j, 1);
                        if (handleObj.selector) handlers.delegateCount--;
                        if (special.remove) special.remove.call(elem, handleObj)
                    }
                }
                if (origCount && !handlers.length) {
                    if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) jQuery.removeEvent(elem, type, elemData.handle);
                    delete events[type]
                }
            }
            if (jQuery.isEmptyObject(events)) dataPriv.remove(elem, "handle events")
        },
        dispatch: function(nativeEvent) {
            var event =
                jQuery.event.fix(nativeEvent);
            var i, j, ret, matched, handleObj, handlerQueue, args = new Array(arguments.length),
                handlers = (dataPriv.get(this, "events") || {})[event.type] || [],
                special = jQuery.event.special[event.type] || {};
            args[0] = event;
            for (i = 1; i < arguments.length; i++) args[i] = arguments[i];
            event.delegateTarget = this;
            if (special.preDispatch && special.preDispatch.call(this, event) === false) return;
            handlerQueue = jQuery.event.handlers.call(this, event, handlers);
            i = 0;
            while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) {
                event.currentTarget =
                    matched.elem;
                j = 0;
                while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped())
                    if (!event.rnamespace || event.rnamespace.test(handleObj.namespace)) {
                        event.handleObj = handleObj;
                        event.data = handleObj.data;
                        ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args);
                        if (ret !== undefined)
                            if ((event.result = ret) === false) {
                                event.preventDefault();
                                event.stopPropagation()
                            }
                    }
            }
            if (special.postDispatch) special.postDispatch.call(this, event);
            return event.result
        },
        handlers: function(event, handlers) {
            var i, handleObj, sel, matchedHandlers, matchedSelectors, handlerQueue = [],
                delegateCount = handlers.delegateCount,
                cur = event.target;
            if (delegateCount && cur.nodeType && !(event.type === "click" && event.button >= 1))
                for (; cur !== this; cur = cur.parentNode || this)
                    if (cur.nodeType === 1 && !(event.type === "click" && cur.disabled === true)) {
                        matchedHandlers = [];
                        matchedSelectors = {};
                        for (i = 0; i < delegateCount; i++) {
                            handleObj = handlers[i];
                            sel = handleObj.selector + " ";
                            if (matchedSelectors[sel] === undefined) matchedSelectors[sel] =
                                handleObj.needsContext ? jQuery(sel, this).index(cur) > -1 : jQuery.find(sel, this, null, [cur]).length;
                            if (matchedSelectors[sel]) matchedHandlers.push(handleObj)
                        }
                        if (matchedHandlers.length) handlerQueue.push({
                            elem: cur,
                            handlers: matchedHandlers
                        })
                    }
            cur = this;
            if (delegateCount < handlers.length) handlerQueue.push({
                elem: cur,
                handlers: handlers.slice(delegateCount)
            });
            return handlerQueue
        },
        addProp: function(name, hook) {
            Object.defineProperty(jQuery.Event.prototype, name, {
                enumerable: true,
                configurable: true,
                get: jQuery.isFunction(hook) ?
                    function() {
                        if (this.originalEvent) return hook(this.originalEvent)
                    } : function() {
                        if (this.originalEvent) return this.originalEvent[name]
                    },
                set: function(value) {
                    Object.defineProperty(this, name, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value
                    })
                }
            })
        },
        fix: function(originalEvent) {
            return originalEvent[jQuery.expando] ? originalEvent : new jQuery.Event(originalEvent)
        },
        special: {
            load: {
                noBubble: true
            },
            focus: {
                trigger: function() {
                    if (this !== safeActiveElement() && this.focus) {
                        this.focus();
                        return false
                    }
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    if (this === safeActiveElement() && this.blur) {
                        this.blur();
                        return false
                    }
                },
                delegateType: "focusout"
            },
            click: {
                trigger: function() {
                    if (this.type === "checkbox" && this.click && nodeName(this, "input")) {
                        this.click();
                        return false
                    }
                },
                _default: function(event) {
                    return nodeName(event.target, "a")
                }
            },
            beforeunload: {
                postDispatch: function(event) {
                    if (event.result !== undefined && event.originalEvent) event.originalEvent.returnValue = event.result
                }
            }
        }
    };
    jQuery.removeEvent = function(elem, type, handle) {
        if (elem.removeEventListener) elem.removeEventListener(type,
            handle)
    };
    jQuery.Event = function(src, props) {
        if (!(this instanceof jQuery.Event)) return new jQuery.Event(src, props);
        if (src && src.type) {
            this.originalEvent = src;
            this.type = src.type;
            this.isDefaultPrevented = src.defaultPrevented || src.defaultPrevented === undefined && src.returnValue === false ? returnTrue : returnFalse;
            this.target = src.target && src.target.nodeType === 3 ? src.target.parentNode : src.target;
            this.currentTarget = src.currentTarget;
            this.relatedTarget = src.relatedTarget
        } else this.type = src;
        if (props) jQuery.extend(this,
            props);
        this.timeStamp = src && src.timeStamp || jQuery.now();
        this[jQuery.expando] = true
    };
    jQuery.Event.prototype = {
        constructor: jQuery.Event,
        isDefaultPrevented: returnFalse,
        isPropagationStopped: returnFalse,
        isImmediatePropagationStopped: returnFalse,
        isSimulated: false,
        preventDefault: function() {
            var e = this.originalEvent;
            this.isDefaultPrevented = returnTrue;
            if (e && !this.isSimulated) e.preventDefault()
        },
        stopPropagation: function() {
            var e = this.originalEvent;
            this.isPropagationStopped = returnTrue;
            if (e && !this.isSimulated) e.stopPropagation()
        },
        stopImmediatePropagation: function() {
            var e = this.originalEvent;
            this.isImmediatePropagationStopped = returnTrue;
            if (e && !this.isSimulated) e.stopImmediatePropagation();
            this.stopPropagation()
        }
    };
    jQuery.each({
        altKey: true,
        bubbles: true,
        cancelable: true,
        changedTouches: true,
        ctrlKey: true,
        detail: true,
        eventPhase: true,
        metaKey: true,
        pageX: true,
        pageY: true,
        shiftKey: true,
        view: true,
        "char": true,
        charCode: true,
        key: true,
        keyCode: true,
        button: true,
        buttons: true,
        clientX: true,
        clientY: true,
        offsetX: true,
        offsetY: true,
        pointerId: true,
        pointerType: true,
        screenX: true,
        screenY: true,
        targetTouches: true,
        toElement: true,
        touches: true,
        which: function(event) {
            var button = event.button;
            if (event.which == null && rkeyEvent.test(event.type)) return event.charCode != null ? event.charCode : event.keyCode;
            if (!event.which && button !== undefined && rmouseEvent.test(event.type)) {
                if (button & 1) return 1;
                if (button & 2) return 3;
                if (button & 4) return 2;
                return 0
            }
            return event.which
        }
    }, jQuery.event.addProp);
    jQuery.each({
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout"
        },
        function(orig, fix) {
            jQuery.event.special[orig] = {
                delegateType: fix,
                bindType: fix,
                handle: function(event) {
                    var ret, target = this,
                        related = event.relatedTarget,
                        handleObj = event.handleObj;
                    if (!related || related !== target && !jQuery.contains(target, related)) {
                        event.type = handleObj.origType;
                        ret = handleObj.handler.apply(this, arguments);
                        event.type = fix
                    }
                    return ret
                }
            }
        });
    jQuery.fn.extend({
        on: function(types, selector, data, fn) {
            return on(this, types, selector, data, fn)
        },
        one: function(types, selector, data, fn) {
            return on(this, types, selector,
                data, fn, 1)
        },
        off: function(types, selector, fn) {
            var handleObj, type;
            if (types && types.preventDefault && types.handleObj) {
                handleObj = types.handleObj;
                jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler);
                return this
            }
            if (typeof types === "object") {
                for (type in types) this.off(type, selector, types[type]);
                return this
            }
            if (selector === false || typeof selector === "function") {
                fn = selector;
                selector = undefined
            }
            if (fn === false) fn = returnFalse;
            return this.each(function() {
                jQuery.event.remove(this, types, fn, selector)
            })
        }
    });
    var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,
        rnoInnerhtml = /<script|<style|<link/i,
        rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
        rscriptTypeMasked = /^true\/(.*)/,
        rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

    function manipulationTarget(elem, content) {
        if (nodeName(elem, "table") && nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr")) return jQuery(">tbody",
            elem)[0] || elem;
        return elem
    }

    function disableScript(elem) {
        elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type;
        return elem
    }

    function restoreScript(elem) {
        var match = rscriptTypeMasked.exec(elem.type);
        if (match) elem.type = match[1];
        else elem.removeAttribute("type");
        return elem
    }

    function cloneCopyEvent(src, dest) {
        var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;
        if (dest.nodeType !== 1) return;
        if (dataPriv.hasData(src)) {
            pdataOld = dataPriv.access(src);
            pdataCur = dataPriv.set(dest, pdataOld);
            events = pdataOld.events;
            if (events) {
                delete pdataCur.handle;
                pdataCur.events = {};
                for (type in events)
                    for (i = 0, l = events[type].length; i < l; i++) jQuery.event.add(dest, type, events[type][i])
            }
        }
        if (dataUser.hasData(src)) {
            udataOld = dataUser.access(src);
            udataCur = jQuery.extend({}, udataOld);
            dataUser.set(dest, udataCur)
        }
    }

    function fixInput(src, dest) {
        var nodeName = dest.nodeName.toLowerCase();
        if (nodeName === "input" && rcheckableType.test(src.type)) dest.checked = src.checked;
        else if (nodeName === "input" || nodeName === "textarea") dest.defaultValue = src.defaultValue
    }

    function domManip(collection, args, callback, ignored) {
        args = concat.apply([], args);
        var fragment, first, scripts, hasScripts, node, doc, i = 0,
            l = collection.length,
            iNoClone = l - 1,
            value = args[0],
            isFunction = jQuery.isFunction(value);
        if (isFunction || l > 1 && typeof value === "string" && !support.checkClone && rchecked.test(value)) return collection.each(function(index) {
            var self = collection.eq(index);
            if (isFunction) args[0] = value.call(this, index, self.html());
            domManip(self, args, callback, ignored)
        });
        if (l) {
            fragment = buildFragment(args, collection[0].ownerDocument,
                false, collection, ignored);
            first = fragment.firstChild;
            if (fragment.childNodes.length === 1) fragment = first;
            if (first || ignored) {
                scripts = jQuery.map(getAll(fragment, "script"), disableScript);
                hasScripts = scripts.length;
                for (; i < l; i++) {
                    node = fragment;
                    if (i !== iNoClone) {
                        node = jQuery.clone(node, true, true);
                        if (hasScripts) jQuery.merge(scripts, getAll(node, "script"))
                    }
                    callback.call(collection[i], node, i)
                }
                if (hasScripts) {
                    doc = scripts[scripts.length - 1].ownerDocument;
                    jQuery.map(scripts, restoreScript);
                    for (i = 0; i < hasScripts; i++) {
                        node =
                            scripts[i];
                        if (rscriptType.test(node.type || "") && !dataPriv.access(node, "globalEval") && jQuery.contains(doc, node))
                            if (node.src) {
                                if (jQuery._evalUrl) jQuery._evalUrl(node.src)
                            } else DOMEval(node.textContent.replace(rcleanScript, ""), doc)
                    }
                }
            }
        }
        return collection
    }

    function remove(elem, selector, keepData) {
        var node, nodes = selector ? jQuery.filter(selector, elem) : elem,
            i = 0;
        for (;
            (node = nodes[i]) != null; i++) {
            if (!keepData && node.nodeType === 1) jQuery.cleanData(getAll(node));
            if (node.parentNode) {
                if (keepData && jQuery.contains(node.ownerDocument,
                        node)) setGlobalEval(getAll(node, "script"));
                node.parentNode.removeChild(node)
            }
        }
        return elem
    }
    jQuery.extend({
        htmlPrefilter: function(html) {
            return html.replace(rxhtmlTag, "<$1></$2>")
        },
        clone: function(elem, dataAndEvents, deepDataAndEvents) {
            var i, l, srcElements, destElements, clone = elem.cloneNode(true),
                inPage = jQuery.contains(elem.ownerDocument, elem);
            if (!support.noCloneChecked && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem)) {
                destElements = getAll(clone);
                srcElements = getAll(elem);
                for (i = 0, l = srcElements.length; i <
                    l; i++) fixInput(srcElements[i], destElements[i])
            }
            if (dataAndEvents)
                if (deepDataAndEvents) {
                    srcElements = srcElements || getAll(elem);
                    destElements = destElements || getAll(clone);
                    for (i = 0, l = srcElements.length; i < l; i++) cloneCopyEvent(srcElements[i], destElements[i])
                } else cloneCopyEvent(elem, clone);
            destElements = getAll(clone, "script");
            if (destElements.length > 0) setGlobalEval(destElements, !inPage && getAll(elem, "script"));
            return clone
        },
        cleanData: function(elems) {
            var data, elem, type, special = jQuery.event.special,
                i = 0;
            for (;
                (elem =
                    elems[i]) !== undefined; i++)
                if (acceptData(elem)) {
                    if (data = elem[dataPriv.expando]) {
                        if (data.events)
                            for (type in data.events)
                                if (special[type]) jQuery.event.remove(elem, type);
                                else jQuery.removeEvent(elem, type, data.handle);
                        elem[dataPriv.expando] = undefined
                    }
                    if (elem[dataUser.expando]) elem[dataUser.expando] = undefined
                }
        }
    });
    jQuery.fn.extend({
        detach: function(selector) {
            return remove(this, selector, true)
        },
        remove: function(selector) {
            return remove(this, selector)
        },
        text: function(value) {
            return access(this, function(value) {
                return value ===
                    undefined ? jQuery.text(this) : this.empty().each(function() {
                        if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) this.textContent = value
                    })
            }, null, value, arguments.length)
        },
        append: function() {
            return domManip(this, arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target = manipulationTarget(this, elem);
                    target.appendChild(elem)
                }
            })
        },
        prepend: function() {
            return domManip(this, arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target =
                        manipulationTarget(this, elem);
                    target.insertBefore(elem, target.firstChild)
                }
            })
        },
        before: function() {
            return domManip(this, arguments, function(elem) {
                if (this.parentNode) this.parentNode.insertBefore(elem, this)
            })
        },
        after: function() {
            return domManip(this, arguments, function(elem) {
                if (this.parentNode) this.parentNode.insertBefore(elem, this.nextSibling)
            })
        },
        empty: function() {
            var elem, i = 0;
            for (;
                (elem = this[i]) != null; i++)
                if (elem.nodeType === 1) {
                    jQuery.cleanData(getAll(elem, false));
                    elem.textContent = ""
                }
            return this
        },
        clone: function(dataAndEvents,
            deepDataAndEvents) {
            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;
            return this.map(function() {
                return jQuery.clone(this, dataAndEvents, deepDataAndEvents)
            })
        },
        html: function(value) {
            return access(this, function(value) {
                var elem = this[0] || {},
                    i = 0,
                    l = this.length;
                if (value === undefined && elem.nodeType === 1) return elem.innerHTML;
                if (typeof value === "string" && !rnoInnerhtml.test(value) && !wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {
                    value =
                        jQuery.htmlPrefilter(value);
                    try {
                        for (; i < l; i++) {
                            elem = this[i] || {};
                            if (elem.nodeType === 1) {
                                jQuery.cleanData(getAll(elem, false));
                                elem.innerHTML = value
                            }
                        }
                        elem = 0
                    } catch (e) {}
                }
                if (elem) this.empty().append(value)
            }, null, value, arguments.length)
        },
        replaceWith: function() {
            var ignored = [];
            return domManip(this, arguments, function(elem) {
                var parent = this.parentNode;
                if (jQuery.inArray(this, ignored) < 0) {
                    jQuery.cleanData(getAll(this));
                    if (parent) parent.replaceChild(elem, this)
                }
            }, ignored)
        }
    });
    jQuery.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function(name, original) {
        jQuery.fn[name] = function(selector) {
            var elems, ret = [],
                insert = jQuery(selector),
                last = insert.length - 1,
                i = 0;
            for (; i <= last; i++) {
                elems = i === last ? this : this.clone(true);
                jQuery(insert[i])[original](elems);
                push.apply(ret, elems.get())
            }
            return this.pushStack(ret)
        }
    });
    var rmargin = /^margin/;
    var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");
    var getStyles = function(elem) {
        var view = elem.ownerDocument.defaultView;
        if (!view || !view.opener) view =
            window;
        return view.getComputedStyle(elem)
    };
    (function() {
        function computeStyleTests() {
            if (!div) return;
            div.style.cssText = "box-sizing:border-box;" + "position:relative;display:block;" + "margin:auto;border:1px;padding:1px;" + "top:1%;width:50%";
            div.innerHTML = "";
            documentElement.appendChild(container);
            var divStyle = window.getComputedStyle(div);
            pixelPositionVal = divStyle.top !== "1%";
            reliableMarginLeftVal = divStyle.marginLeft === "2px";
            boxSizingReliableVal = divStyle.width === "4px";
            div.style.marginRight = "50%";
            pixelMarginRightVal =
                divStyle.marginRight === "4px";
            documentElement.removeChild(container);
            div = null
        }
        var pixelPositionVal, boxSizingReliableVal, pixelMarginRightVal, reliableMarginLeftVal, container = document.createElement("div"),
            div = document.createElement("div");
        if (!div.style) return;
        div.style.backgroundClip = "content-box";
        div.cloneNode(true).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";
        container.style.cssText = "border:0;width:8px;height:0;top:0;left:-9999px;" + "padding:0;margin-top:1px;position:absolute";
        container.appendChild(div);
        jQuery.extend(support, {
            pixelPosition: function() {
                computeStyleTests();
                return pixelPositionVal
            },
            boxSizingReliable: function() {
                computeStyleTests();
                return boxSizingReliableVal
            },
            pixelMarginRight: function() {
                computeStyleTests();
                return pixelMarginRightVal
            },
            reliableMarginLeft: function() {
                computeStyleTests();
                return reliableMarginLeftVal
            }
        })
    })();

    function curCSS(elem, name, computed) {
        var width, minWidth, maxWidth, ret, style = elem.style;
        computed = computed || getStyles(elem);
        if (computed) {
            ret = computed.getPropertyValue(name) ||
                computed[name];
            if (ret === "" && !jQuery.contains(elem.ownerDocument, elem)) ret = jQuery.style(elem, name);
            if (!support.pixelMarginRight() && rnumnonpx.test(ret) && rmargin.test(name)) {
                width = style.width;
                minWidth = style.minWidth;
                maxWidth = style.maxWidth;
                style.minWidth = style.maxWidth = style.width = ret;
                ret = computed.width;
                style.width = width;
                style.minWidth = minWidth;
                style.maxWidth = maxWidth
            }
        }
        return ret !== undefined ? ret + "" : ret
    }

    function addGetHookIf(conditionFn, hookFn) {
        return {
            get: function() {
                if (conditionFn()) {
                    delete this.get;
                    return
                }
                return (this.get = hookFn).apply(this, arguments)
            }
        }
    }
    var rdisplayswap = /^(none|table(?!-c[ea]).+)/,
        rcustomProp = /^--/,
        cssShow = {
            position: "absolute",
            visibility: "hidden",
            display: "block"
        },
        cssNormalTransform = {
            letterSpacing: "0",
            fontWeight: "400"
        },
        cssPrefixes = ["Webkit", "Moz", "ms"],
        emptyStyle = document.createElement("div").style;

    function vendorPropName(name) {
        if (name in emptyStyle) return name;
        var capName = name[0].toUpperCase() + name.slice(1),
            i = cssPrefixes.length;
        while (i--) {
            name = cssPrefixes[i] + capName;
            if (name in
                emptyStyle) return name
        }
    }

    function finalPropName(name) {
        var ret = jQuery.cssProps[name];
        if (!ret) ret = jQuery.cssProps[name] = vendorPropName(name) || name;
        return ret
    }

    function setPositiveNumber(elem, value, subtract) {
        var matches = rcssNum.exec(value);
        return matches ? Math.max(0, matches[2] - (subtract || 0)) + (matches[3] || "px") : value
    }

    function augmentWidthOrHeight(elem, name, extra, isBorderBox, styles) {
        var i, val = 0;
        if (extra === (isBorderBox ? "border" : "content")) i = 4;
        else i = name === "width" ? 1 : 0;
        for (; i < 4; i += 2) {
            if (extra === "margin") val +=
                jQuery.css(elem, extra + cssExpand[i], true, styles);
            if (isBorderBox) {
                if (extra === "content") val -= jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                if (extra !== "margin") val -= jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles)
            } else {
                val += jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                if (extra !== "padding") val += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles)
            }
        }
        return val
    }

    function getWidthOrHeight(elem, name, extra) {
        var valueIsBorderBox, styles = getStyles(elem),
            val = curCSS(elem, name, styles),
            isBorderBox = jQuery.css(elem, "boxSizing", false, styles) === "border-box";
        if (rnumnonpx.test(val)) return val;
        valueIsBorderBox = isBorderBox && (support.boxSizingReliable() || val === elem.style[name]);
        if (val === "auto") val = elem["offset" + name[0].toUpperCase() + name.slice(1)];
        val = parseFloat(val) || 0;
        return val + augmentWidthOrHeight(elem, name, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles) + "px"
    }
    jQuery.extend({
        cssHooks: {
            opacity: {
                get: function(elem, computed) {
                    if (computed) {
                        var ret = curCSS(elem, "opacity");
                        return ret ===
                            "" ? "1" : ret
                    }
                }
            }
        },
        cssNumber: {
            "animationIterationCount": true,
            "columnCount": true,
            "fillOpacity": true,
            "flexGrow": true,
            "flexShrink": true,
            "fontWeight": true,
            "lineHeight": true,
            "opacity": true,
            "order": true,
            "orphans": true,
            "widows": true,
            "zIndex": true,
            "zoom": true
        },
        cssProps: {
            "float": "cssFloat"
        },
        style: function(elem, name, value, extra) {
            if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) return;
            var ret, type, hooks, origName = jQuery.camelCase(name),
                isCustomProp = rcustomProp.test(name),
                style = elem.style;
            if (!isCustomProp) name =
                finalPropName(origName);
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            if (value !== undefined) {
                type = typeof value;
                if (type === "string" && (ret = rcssNum.exec(value)) && ret[1]) {
                    value = adjustCSS(elem, name, ret);
                    type = "number"
                }
                if (value == null || value !== value) return;
                if (type === "number") value += ret && ret[3] || (jQuery.cssNumber[origName] ? "" : "px");
                if (!support.clearCloneStyle && value === "" && name.indexOf("background") === 0) style[name] = "inherit";
                if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined)
                    if (isCustomProp) style.setProperty(name,
                        value);
                    else style[name] = value
            } else {
                if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) return ret;
                return style[name]
            }
        },
        css: function(elem, name, extra, styles) {
            var val, num, hooks, origName = jQuery.camelCase(name),
                isCustomProp = rcustomProp.test(name);
            if (!isCustomProp) name = finalPropName(origName);
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            if (hooks && "get" in hooks) val = hooks.get(elem, true, extra);
            if (val === undefined) val = curCSS(elem, name, styles);
            if (val === "normal" && name in cssNormalTransform) val =
                cssNormalTransform[name];
            if (extra === "" || extra) {
                num = parseFloat(val);
                return extra === true || isFinite(num) ? num || 0 : val
            }
            return val
        }
    });
    jQuery.each(["height", "width"], function(i, name) {
        jQuery.cssHooks[name] = {
            get: function(elem, computed, extra) {
                if (computed) return rdisplayswap.test(jQuery.css(elem, "display")) && (!elem.getClientRects().length || !elem.getBoundingClientRect().width) ? swap(elem, cssShow, function() {
                    return getWidthOrHeight(elem, name, extra)
                }) : getWidthOrHeight(elem, name, extra)
            },
            set: function(elem, value, extra) {
                var matches,
                    styles = extra && getStyles(elem),
                    subtract = extra && augmentWidthOrHeight(elem, name, extra, jQuery.css(elem, "boxSizing", false, styles) === "border-box", styles);
                if (subtract && (matches = rcssNum.exec(value)) && (matches[3] || "px") !== "px") {
                    elem.style[name] = value;
                    value = jQuery.css(elem, name)
                }
                return setPositiveNumber(elem, value, subtract)
            }
        }
    });
    jQuery.cssHooks.marginLeft = addGetHookIf(support.reliableMarginLeft, function(elem, computed) {
        if (computed) return (parseFloat(curCSS(elem, "marginLeft")) || elem.getBoundingClientRect().left -
            swap(elem, {
                marginLeft: 0
            }, function() {
                return elem.getBoundingClientRect().left
            })) + "px"
    });
    jQuery.each({
        margin: "",
        padding: "",
        border: "Width"
    }, function(prefix, suffix) {
        jQuery.cssHooks[prefix + suffix] = {
            expand: function(value) {
                var i = 0,
                    expanded = {},
                    parts = typeof value === "string" ? value.split(" ") : [value];
                for (; i < 4; i++) expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
                return expanded
            }
        };
        if (!rmargin.test(prefix)) jQuery.cssHooks[prefix + suffix].set = setPositiveNumber
    });
    jQuery.fn.extend({
        css: function(name,
            value) {
            return access(this, function(elem, name, value) {
                var styles, len, map = {},
                    i = 0;
                if (Array.isArray(name)) {
                    styles = getStyles(elem);
                    len = name.length;
                    for (; i < len; i++) map[name[i]] = jQuery.css(elem, name[i], false, styles);
                    return map
                }
                return value !== undefined ? jQuery.style(elem, name, value) : jQuery.css(elem, name)
            }, name, value, arguments.length > 1)
        }
    });

    function Tween(elem, options, prop, end, easing) {
        return new Tween.prototype.init(elem, options, prop, end, easing)
    }
    jQuery.Tween = Tween;
    Tween.prototype = {
        constructor: Tween,
        init: function(elem,
            options, prop, end, easing, unit) {
            this.elem = elem;
            this.prop = prop;
            this.easing = easing || jQuery.easing._default;
            this.options = options;
            this.start = this.now = this.cur();
            this.end = end;
            this.unit = unit || (jQuery.cssNumber[prop] ? "" : "px")
        },
        cur: function() {
            var hooks = Tween.propHooks[this.prop];
            return hooks && hooks.get ? hooks.get(this) : Tween.propHooks._default.get(this)
        },
        run: function(percent) {
            var eased, hooks = Tween.propHooks[this.prop];
            if (this.options.duration) this.pos = eased = jQuery.easing[this.easing](percent, this.options.duration *
                percent, 0, 1, this.options.duration);
            else this.pos = eased = percent;
            this.now = (this.end - this.start) * eased + this.start;
            if (this.options.step) this.options.step.call(this.elem, this.now, this);
            if (hooks && hooks.set) hooks.set(this);
            else Tween.propHooks._default.set(this);
            return this
        }
    };
    Tween.prototype.init.prototype = Tween.prototype;
    Tween.propHooks = {
        _default: {
            get: function(tween) {
                var result;
                if (tween.elem.nodeType !== 1 || tween.elem[tween.prop] != null && tween.elem.style[tween.prop] == null) return tween.elem[tween.prop];
                result =
                    jQuery.css(tween.elem, tween.prop, "");
                return !result || result === "auto" ? 0 : result
            },
            set: function(tween) {
                if (jQuery.fx.step[tween.prop]) jQuery.fx.step[tween.prop](tween);
                else if (tween.elem.nodeType === 1 && (tween.elem.style[jQuery.cssProps[tween.prop]] != null || jQuery.cssHooks[tween.prop])) jQuery.style(tween.elem, tween.prop, tween.now + tween.unit);
                else tween.elem[tween.prop] = tween.now
            }
        }
    };
    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        set: function(tween) {
            if (tween.elem.nodeType && tween.elem.parentNode) tween.elem[tween.prop] =
                tween.now
        }
    };
    jQuery.easing = {
        linear: function(p) {
            return p
        },
        swing: function(p) {
            return .5 - Math.cos(p * Math.PI) / 2
        },
        _default: "swing"
    };
    jQuery.fx = Tween.prototype.init;
    jQuery.fx.step = {};
    var fxNow, inProgress, rfxtypes = /^(?:toggle|show|hide)$/,
        rrun = /queueHooks$/;

    function schedule() {
        if (inProgress) {
            if (document.hidden === false && window.requestAnimationFrame) window.requestAnimationFrame(schedule);
            else window.setTimeout(schedule, jQuery.fx.interval);
            jQuery.fx.tick()
        }
    }

    function createFxNow() {
        window.setTimeout(function() {
            fxNow =
                undefined
        });
        return fxNow = jQuery.now()
    }

    function genFx(type, includeWidth) {
        var which, i = 0,
            attrs = {
                height: type
            };
        includeWidth = includeWidth ? 1 : 0;
        for (; i < 4; i += 2 - includeWidth) {
            which = cssExpand[i];
            attrs["margin" + which] = attrs["padding" + which] = type
        }
        if (includeWidth) attrs.opacity = attrs.width = type;
        return attrs
    }

    function createTween(value, prop, animation) {
        var tween, collection = (Animation.tweeners[prop] || []).concat(Animation.tweeners["*"]),
            index = 0,
            length = collection.length;
        for (; index < length; index++)
            if (tween = collection[index].call(animation,
                    prop, value)) return tween
    }

    function defaultPrefilter(elem, props, opts) {
        var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display, isBox = "width" in props || "height" in props,
            anim = this,
            orig = {},
            style = elem.style,
            hidden = elem.nodeType && isHiddenWithinTree(elem),
            dataShow = dataPriv.get(elem, "fxshow");
        if (!opts.queue) {
            hooks = jQuery._queueHooks(elem, "fx");
            if (hooks.unqueued == null) {
                hooks.unqueued = 0;
                oldfire = hooks.empty.fire;
                hooks.empty.fire = function() {
                    if (!hooks.unqueued) oldfire()
                }
            }
            hooks.unqueued++;
            anim.always(function() {
                anim.always(function() {
                    hooks.unqueued--;
                    if (!jQuery.queue(elem, "fx").length) hooks.empty.fire()
                })
            })
        }
        for (prop in props) {
            value = props[prop];
            if (rfxtypes.test(value)) {
                delete props[prop];
                toggle = toggle || value === "toggle";
                if (value === (hidden ? "hide" : "show"))
                    if (value === "show" && dataShow && dataShow[prop] !== undefined) hidden = true;
                    else continue;
                orig[prop] = dataShow && dataShow[prop] || jQuery.style(elem, prop)
            }
        }
        propTween = !jQuery.isEmptyObject(props);
        if (!propTween && jQuery.isEmptyObject(orig)) return;
        if (isBox && elem.nodeType === 1) {
            opts.overflow = [style.overflow, style.overflowX,
                style.overflowY
            ];
            restoreDisplay = dataShow && dataShow.display;
            if (restoreDisplay == null) restoreDisplay = dataPriv.get(elem, "display");
            display = jQuery.css(elem, "display");
            if (display === "none")
                if (restoreDisplay) display = restoreDisplay;
                else {
                    showHide([elem], true);
                    restoreDisplay = elem.style.display || restoreDisplay;
                    display = jQuery.css(elem, "display");
                    showHide([elem])
                }
            if (display === "inline" || display === "inline-block" && restoreDisplay != null)
                if (jQuery.css(elem, "float") === "none") {
                    if (!propTween) {
                        anim.done(function() {
                            style.display =
                                restoreDisplay
                        });
                        if (restoreDisplay == null) {
                            display = style.display;
                            restoreDisplay = display === "none" ? "" : display
                        }
                    }
                    style.display = "inline-block"
                }
        }
        if (opts.overflow) {
            style.overflow = "hidden";
            anim.always(function() {
                style.overflow = opts.overflow[0];
                style.overflowX = opts.overflow[1];
                style.overflowY = opts.overflow[2]
            })
        }
        propTween = false;
        for (prop in orig) {
            if (!propTween) {
                if (dataShow) {
                    if ("hidden" in dataShow) hidden = dataShow.hidden
                } else dataShow = dataPriv.access(elem, "fxshow", {
                    display: restoreDisplay
                });
                if (toggle) dataShow.hidden = !hidden;
                if (hidden) showHide([elem], true);
                anim.done(function() {
                    if (!hidden) showHide([elem]);
                    dataPriv.remove(elem, "fxshow");
                    for (prop in orig) jQuery.style(elem, prop, orig[prop])
                })
            }
            propTween = createTween(hidden ? dataShow[prop] : 0, prop, anim);
            if (!(prop in dataShow)) {
                dataShow[prop] = propTween.start;
                if (hidden) {
                    propTween.end = propTween.start;
                    propTween.start = 0
                }
            }
        }
    }

    function propFilter(props, specialEasing) {
        var index, name, easing, value, hooks;
        for (index in props) {
            name = jQuery.camelCase(index);
            easing = specialEasing[name];
            value =
                props[index];
            if (Array.isArray(value)) {
                easing = value[1];
                value = props[index] = value[0]
            }
            if (index !== name) {
                props[name] = value;
                delete props[index]
            }
            hooks = jQuery.cssHooks[name];
            if (hooks && "expand" in hooks) {
                value = hooks.expand(value);
                delete props[name];
                for (index in value)
                    if (!(index in props)) {
                        props[index] = value[index];
                        specialEasing[index] = easing
                    }
            } else specialEasing[name] = easing
        }
    }

    function Animation(elem, properties, options) {
        var result, stopped, index = 0,
            length = Animation.prefilters.length,
            deferred = jQuery.Deferred().always(function() {
                delete tick.elem
            }),
            tick = function() {
                if (stopped) return false;
                var currentTime = fxNow || createFxNow(),
                    remaining = Math.max(0, animation.startTime + animation.duration - currentTime),
                    temp = remaining / animation.duration || 0,
                    percent = 1 - temp,
                    index = 0,
                    length = animation.tweens.length;
                for (; index < length; index++) animation.tweens[index].run(percent);
                deferred.notifyWith(elem, [animation, percent, remaining]);
                if (percent < 1 && length) return remaining;
                if (!length) deferred.notifyWith(elem, [animation, 1, 0]);
                deferred.resolveWith(elem, [animation]);
                return false
            },
            animation = deferred.promise({
                elem: elem,
                props: jQuery.extend({}, properties),
                opts: jQuery.extend(true, {
                    specialEasing: {},
                    easing: jQuery.easing._default
                }, options),
                originalProperties: properties,
                originalOptions: options,
                startTime: fxNow || createFxNow(),
                duration: options.duration,
                tweens: [],
                createTween: function(prop, end) {
                    var tween = jQuery.Tween(elem, animation.opts, prop, end, animation.opts.specialEasing[prop] || animation.opts.easing);
                    animation.tweens.push(tween);
                    return tween
                },
                stop: function(gotoEnd) {
                    var index = 0,
                        length =
                        gotoEnd ? animation.tweens.length : 0;
                    if (stopped) return this;
                    stopped = true;
                    for (; index < length; index++) animation.tweens[index].run(1);
                    if (gotoEnd) {
                        deferred.notifyWith(elem, [animation, 1, 0]);
                        deferred.resolveWith(elem, [animation, gotoEnd])
                    } else deferred.rejectWith(elem, [animation, gotoEnd]);
                    return this
                }
            }),
            props = animation.props;
        propFilter(props, animation.opts.specialEasing);
        for (; index < length; index++) {
            result = Animation.prefilters[index].call(animation, elem, props, animation.opts);
            if (result) {
                if (jQuery.isFunction(result.stop)) jQuery._queueHooks(animation.elem,
                    animation.opts.queue).stop = jQuery.proxy(result.stop, result);
                return result
            }
        }
        jQuery.map(props, createTween, animation);
        if (jQuery.isFunction(animation.opts.start)) animation.opts.start.call(elem, animation);
        animation.progress(animation.opts.progress).done(animation.opts.done, animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);
        jQuery.fx.timer(jQuery.extend(tick, {
            elem: elem,
            anim: animation,
            queue: animation.opts.queue
        }));
        return animation
    }
    jQuery.Animation = jQuery.extend(Animation, {
        tweeners: {
            "*": [function(prop,
                value) {
                var tween = this.createTween(prop, value);
                adjustCSS(tween.elem, prop, rcssNum.exec(value), tween);
                return tween
            }]
        },
        tweener: function(props, callback) {
            if (jQuery.isFunction(props)) {
                callback = props;
                props = ["*"]
            } else props = props.match(rnothtmlwhite);
            var prop, index = 0,
                length = props.length;
            for (; index < length; index++) {
                prop = props[index];
                Animation.tweeners[prop] = Animation.tweeners[prop] || [];
                Animation.tweeners[prop].unshift(callback)
            }
        },
        prefilters: [defaultPrefilter],
        prefilter: function(callback, prepend) {
            if (prepend) Animation.prefilters.unshift(callback);
            else Animation.prefilters.push(callback)
        }
    });
    jQuery.speed = function(speed, easing, fn) {
        var opt = speed && typeof speed === "object" ? jQuery.extend({}, speed) : {
            complete: fn || !fn && easing || jQuery.isFunction(speed) && speed,
            duration: speed,
            easing: fn && easing || easing && !jQuery.isFunction(easing) && easing
        };
        if (jQuery.fx.off) opt.duration = 0;
        else if (typeof opt.duration !== "number")
            if (opt.duration in jQuery.fx.speeds) opt.duration = jQuery.fx.speeds[opt.duration];
            else opt.duration = jQuery.fx.speeds._default;
        if (opt.queue == null || opt.queue ===
            true) opt.queue = "fx";
        opt.old = opt.complete;
        opt.complete = function() {
            if (jQuery.isFunction(opt.old)) opt.old.call(this);
            if (opt.queue) jQuery.dequeue(this, opt.queue)
        };
        return opt
    };
    jQuery.fn.extend({
        fadeTo: function(speed, to, easing, callback) {
            return this.filter(isHiddenWithinTree).css("opacity", 0).show().end().animate({
                opacity: to
            }, speed, easing, callback)
        },
        animate: function(prop, speed, easing, callback) {
            var empty = jQuery.isEmptyObject(prop),
                optall = jQuery.speed(speed, easing, callback),
                doAnimation = function() {
                    var anim =
                        Animation(this, jQuery.extend({}, prop), optall);
                    if (empty || dataPriv.get(this, "finish")) anim.stop(true)
                };
            doAnimation.finish = doAnimation;
            return empty || optall.queue === false ? this.each(doAnimation) : this.queue(optall.queue, doAnimation)
        },
        stop: function(type, clearQueue, gotoEnd) {
            var stopQueue = function(hooks) {
                var stop = hooks.stop;
                delete hooks.stop;
                stop(gotoEnd)
            };
            if (typeof type !== "string") {
                gotoEnd = clearQueue;
                clearQueue = type;
                type = undefined
            }
            if (clearQueue && type !== false) this.queue(type || "fx", []);
            return this.each(function() {
                var dequeue =
                    true,
                    index = type != null && type + "queueHooks",
                    timers = jQuery.timers,
                    data = dataPriv.get(this);
                if (index) {
                    if (data[index] && data[index].stop) stopQueue(data[index])
                } else
                    for (index in data)
                        if (data[index] && data[index].stop && rrun.test(index)) stopQueue(data[index]); for (index = timers.length; index--;)
                    if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
                        timers[index].anim.stop(gotoEnd);
                        dequeue = false;
                        timers.splice(index, 1)
                    }
                if (dequeue || !gotoEnd) jQuery.dequeue(this, type)
            })
        },
        finish: function(type) {
            if (type !==
                false) type = type || "fx";
            return this.each(function() {
                var index, data = dataPriv.get(this),
                    queue = data[type + "queue"],
                    hooks = data[type + "queueHooks"],
                    timers = jQuery.timers,
                    length = queue ? queue.length : 0;
                data.finish = true;
                jQuery.queue(this, type, []);
                if (hooks && hooks.stop) hooks.stop.call(this, true);
                for (index = timers.length; index--;)
                    if (timers[index].elem === this && timers[index].queue === type) {
                        timers[index].anim.stop(true);
                        timers.splice(index, 1)
                    }
                for (index = 0; index < length; index++)
                    if (queue[index] && queue[index].finish) queue[index].finish.call(this);
                delete data.finish
            })
        }
    });
    jQuery.each(["toggle", "show", "hide"], function(i, name) {
        var cssFn = jQuery.fn[name];
        jQuery.fn[name] = function(speed, easing, callback) {
            return speed == null || typeof speed === "boolean" ? cssFn.apply(this, arguments) : this.animate(genFx(name, true), speed, easing, callback)
        }
    });
    jQuery.each({
        slideDown: genFx("show"),
        slideUp: genFx("hide"),
        slideToggle: genFx("toggle"),
        fadeIn: {
            opacity: "show"
        },
        fadeOut: {
            opacity: "hide"
        },
        fadeToggle: {
            opacity: "toggle"
        }
    }, function(name, props) {
        jQuery.fn[name] = function(speed, easing,
            callback) {
            return this.animate(props, speed, easing, callback)
        }
    });
    jQuery.timers = [];
    jQuery.fx.tick = function() {
        var timer, i = 0,
            timers = jQuery.timers;
        fxNow = jQuery.now();
        for (; i < timers.length; i++) {
            timer = timers[i];
            if (!timer() && timers[i] === timer) timers.splice(i--, 1)
        }
        if (!timers.length) jQuery.fx.stop();
        fxNow = undefined
    };
    jQuery.fx.timer = function(timer) {
        jQuery.timers.push(timer);
        jQuery.fx.start()
    };
    jQuery.fx.interval = 13;
    jQuery.fx.start = function() {
        if (inProgress) return;
        inProgress = true;
        schedule()
    };
    jQuery.fx.stop = function() {
        inProgress =
            null
    };
    jQuery.fx.speeds = {
        slow: 600,
        fast: 200,
        _default: 400
    };
    jQuery.fn.delay = function(time, type) {
        time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
        type = type || "fx";
        return this.queue(type, function(next, hooks) {
            var timeout = window.setTimeout(next, time);
            hooks.stop = function() {
                window.clearTimeout(timeout)
            }
        })
    };
    (function() {
        var input = document.createElement("input"),
            select = document.createElement("select"),
            opt = select.appendChild(document.createElement("option"));
        input.type = "checkbox";
        support.checkOn = input.value !== "";
        support.optSelected = opt.selected;
        input = document.createElement("input");
        input.value = "t";
        input.type = "radio";
        support.radioValue = input.value === "t"
    })();
    var boolHook, attrHandle = jQuery.expr.attrHandle;
    jQuery.fn.extend({
        attr: function(name, value) {
            return access(this, jQuery.attr, name, value, arguments.length > 1)
        },
        removeAttr: function(name) {
            return this.each(function() {
                jQuery.removeAttr(this, name)
            })
        }
    });
    jQuery.extend({
        attr: function(elem, name, value) {
            var ret, hooks, nType = elem.nodeType;
            if (nType === 3 || nType === 8 || nType ===
                2) return;
            if (typeof elem.getAttribute === "undefined") return jQuery.prop(elem, name, value);
            if (nType !== 1 || !jQuery.isXMLDoc(elem)) hooks = jQuery.attrHooks[name.toLowerCase()] || (jQuery.expr.match.bool.test(name) ? boolHook : undefined);
            if (value !== undefined) {
                if (value === null) {
                    jQuery.removeAttr(elem, name);
                    return
                }
                if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) return ret;
                elem.setAttribute(name, value + "");
                return value
            }
            if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) return ret;
            ret = jQuery.find.attr(elem,
                name);
            return ret == null ? undefined : ret
        },
        attrHooks: {
            type: {
                set: function(elem, value) {
                    if (!support.radioValue && value === "radio" && nodeName(elem, "input")) {
                        var val = elem.value;
                        elem.setAttribute("type", value);
                        if (val) elem.value = val;
                        return value
                    }
                }
            }
        },
        removeAttr: function(elem, value) {
            var name, i = 0,
                attrNames = value && value.match(rnothtmlwhite);
            if (attrNames && elem.nodeType === 1)
                while (name = attrNames[i++]) elem.removeAttribute(name)
        }
    });
    boolHook = {
        set: function(elem, value, name) {
            if (value === false) jQuery.removeAttr(elem, name);
            else elem.setAttribute(name,
                name);
            return name
        }
    };
    jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function(i, name) {
        var getter = attrHandle[name] || jQuery.find.attr;
        attrHandle[name] = function(elem, name, isXML) {
            var ret, handle, lowercaseName = name.toLowerCase();
            if (!isXML) {
                handle = attrHandle[lowercaseName];
                attrHandle[lowercaseName] = ret;
                ret = getter(elem, name, isXML) != null ? lowercaseName : null;
                attrHandle[lowercaseName] = handle
            }
            return ret
        }
    });
    var rfocusable = /^(?:input|select|textarea|button)$/i,
        rclickable = /^(?:a|area)$/i;
    jQuery.fn.extend({
        prop: function(name,
            value) {
            return access(this, jQuery.prop, name, value, arguments.length > 1)
        },
        removeProp: function(name) {
            return this.each(function() {
                delete this[jQuery.propFix[name] || name]
            })
        }
    });
    jQuery.extend({
        prop: function(elem, name, value) {
            var ret, hooks, nType = elem.nodeType;
            if (nType === 3 || nType === 8 || nType === 2) return;
            if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
                name = jQuery.propFix[name] || name;
                hooks = jQuery.propHooks[name]
            }
            if (value !== undefined) {
                if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) return ret;
                return elem[name] =
                    value
            }
            if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) return ret;
            return elem[name]
        },
        propHooks: {
            tabIndex: {
                get: function(elem) {
                    var tabindex = jQuery.find.attr(elem, "tabindex");
                    if (tabindex) return parseInt(tabindex, 10);
                    if (rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href) return 0;
                    return -1
                }
            }
        },
        propFix: {
            "for": "htmlFor",
            "class": "className"
        }
    });
    if (!support.optSelected) jQuery.propHooks.selected = {
        get: function(elem) {
            var parent = elem.parentNode;
            if (parent && parent.parentNode) parent.parentNode.selectedIndex;
            return null
        },
        set: function(elem) {
            var parent = elem.parentNode;
            if (parent) {
                parent.selectedIndex;
                if (parent.parentNode) parent.parentNode.selectedIndex
            }
        }
    };
    jQuery.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function() {
        jQuery.propFix[this.toLowerCase()] = this
    });

    function stripAndCollapse(value) {
        var tokens = value.match(rnothtmlwhite) || [];
        return tokens.join(" ")
    }

    function getClass(elem) {
        return elem.getAttribute && elem.getAttribute("class") ||
            ""
    }
    jQuery.fn.extend({
        addClass: function(value) {
            var classes, elem, cur, curValue, clazz, j, finalValue, i = 0;
            if (jQuery.isFunction(value)) return this.each(function(j) {
                jQuery(this).addClass(value.call(this, j, getClass(this)))
            });
            if (typeof value === "string" && value) {
                classes = value.match(rnothtmlwhite) || [];
                while (elem = this[i++]) {
                    curValue = getClass(elem);
                    cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) + " ";
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++])

                            if (cur.indexOf(" " + clazz + " ") < 0) cur += clazz + " ";
                        finalValue = stripAndCollapse(cur);
                        if (curValue !== finalValue) elem.setAttribute("class", finalValue)
                    }
                }
            }
            return this
        },
        removeClass: function(value) {
            var classes, elem, cur, curValue, clazz, j, finalValue, i = 0;
            if (jQuery.isFunction(value)) return this.each(function(j) {
                jQuery(this).removeClass(value.call(this, j, getClass(this)))
            });
            if (!arguments.length) return this.attr("class", "");
            if (typeof value === "string" && value) {
                classes = value.match(rnothtmlwhite) || [];
                while (elem = this[i++]) {
                    curValue = getClass(elem);
                    cur = elem.nodeType === 1 && " " + stripAndCollapse(curValue) +
                        " ";
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++])
                            while (cur.indexOf(" " + clazz + " ") > -1) cur = cur.replace(" " + clazz + " ", " ");
                        finalValue = stripAndCollapse(cur);
                        if (curValue !== finalValue) elem.setAttribute("class", finalValue)
                    }
                }
            }
            return this
        },
        toggleClass: function(value, stateVal) {
            var type = typeof value;
            if (typeof stateVal === "boolean" && type === "string") return stateVal ? this.addClass(value) : this.removeClass(value);
            if (jQuery.isFunction(value)) return this.each(function(i) {
                jQuery(this).toggleClass(value.call(this, i, getClass(this),
                    stateVal), stateVal)
            });
            return this.each(function() {
                var className, i, self, classNames;
                if (type === "string") {
                    i = 0;
                    self = jQuery(this);
                    classNames = value.match(rnothtmlwhite) || [];
                    while (className = classNames[i++])
                        if (self.hasClass(className)) self.removeClass(className);
                        else self.addClass(className)
                } else if (value === undefined || type === "boolean") {
                    className = getClass(this);
                    if (className) dataPriv.set(this, "__className__", className);
                    if (this.setAttribute) this.setAttribute("class", className || value === false ? "" : dataPriv.get(this,
                        "__className__") || "")
                }
            })
        },
        hasClass: function(selector) {
            var className, elem, i = 0;
            className = " " + selector + " ";
            while (elem = this[i++])
                if (elem.nodeType === 1 && (" " + stripAndCollapse(getClass(elem)) + " ").indexOf(className) > -1) return true;
            return false
        }
    });
    var rreturn = /\r/g;
    jQuery.fn.extend({
        val: function(value) {
            var hooks, ret, isFunction, elem = this[0];
            if (!arguments.length) {
                if (elem) {
                    hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()];
                    if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !==
                        undefined) return ret;
                    ret = elem.value;
                    if (typeof ret === "string") return ret.replace(rreturn, "");
                    return ret == null ? "" : ret
                }
                return
            }
            isFunction = jQuery.isFunction(value);
            return this.each(function(i) {
                var val;
                if (this.nodeType !== 1) return;
                if (isFunction) val = value.call(this, i, jQuery(this).val());
                else val = value;
                if (val == null) val = "";
                else if (typeof val === "number") val += "";
                else if (Array.isArray(val)) val = jQuery.map(val, function(value) {
                    return value == null ? "" : value + ""
                });
                hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()];
                if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) this.value = val
            })
        }
    });
    jQuery.extend({
        valHooks: {
            option: {
                get: function(elem) {
                    var val = jQuery.find.attr(elem, "value");
                    return val != null ? val : stripAndCollapse(jQuery.text(elem))
                }
            },
            select: {
                get: function(elem) {
                    var value, option, i, options = elem.options,
                        index = elem.selectedIndex,
                        one = elem.type === "select-one",
                        values = one ? null : [],
                        max = one ? index + 1 : options.length;
                    if (index < 0) i = max;
                    else i = one ? index : 0;
                    for (; i < max; i++) {
                        option = options[i];
                        if ((option.selected ||
                                i === index) && !option.disabled && (!option.parentNode.disabled || !nodeName(option.parentNode, "optgroup"))) {
                            value = jQuery(option).val();
                            if (one) return value;
                            values.push(value)
                        }
                    }
                    return values
                },
                set: function(elem, value) {
                    var optionSet, option, options = elem.options,
                        values = jQuery.makeArray(value),
                        i = options.length;
                    while (i--) {
                        option = options[i];
                        if (option.selected = jQuery.inArray(jQuery.valHooks.option.get(option), values) > -1) optionSet = true
                    }
                    if (!optionSet) elem.selectedIndex = -1;
                    return values
                }
            }
        }
    });
    jQuery.each(["radio", "checkbox"],
        function() {
            jQuery.valHooks[this] = {
                set: function(elem, value) {
                    if (Array.isArray(value)) return elem.checked = jQuery.inArray(jQuery(elem).val(), value) > -1
                }
            };
            if (!support.checkOn) jQuery.valHooks[this].get = function(elem) {
                return elem.getAttribute("value") === null ? "on" : elem.value
            }
        });
    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/;
    jQuery.extend(jQuery.event, {
        trigger: function(event, data, elem, onlyHandlers) {
            var i, cur, tmp, bubbleType, ontype, handle, special, eventPath = [elem || document],
                type = hasOwn.call(event, "type") ? event.type :
                event,
                namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
            cur = tmp = elem = elem || document;
            if (elem.nodeType === 3 || elem.nodeType === 8) return;
            if (rfocusMorph.test(type + jQuery.event.triggered)) return;
            if (type.indexOf(".") > -1) {
                namespaces = type.split(".");
                type = namespaces.shift();
                namespaces.sort()
            }
            ontype = type.indexOf(":") < 0 && "on" + type;
            event = event[jQuery.expando] ? event : new jQuery.Event(type, typeof event === "object" && event);
            event.isTrigger = onlyHandlers ? 2 : 3;
            event.namespace = namespaces.join(".");
            event.rnamespace =
                event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
            event.result = undefined;
            if (!event.target) event.target = elem;
            data = data == null ? [event] : jQuery.makeArray(data, [event]);
            special = jQuery.event.special[type] || {};
            if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) return;
            if (!onlyHandlers && !special.noBubble && !jQuery.isWindow(elem)) {
                bubbleType = special.delegateType || type;
                if (!rfocusMorph.test(bubbleType + type)) cur = cur.parentNode;
                for (; cur; cur = cur.parentNode) {
                    eventPath.push(cur);
                    tmp = cur
                }
                if (tmp === (elem.ownerDocument || document)) eventPath.push(tmp.defaultView || tmp.parentWindow || window)
            }
            i = 0;
            while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
                event.type = i > 1 ? bubbleType : special.bindType || type;
                handle = (dataPriv.get(cur, "events") || {})[event.type] && dataPriv.get(cur, "handle");
                if (handle) handle.apply(cur, data);
                handle = ontype && cur[ontype];
                if (handle && handle.apply && acceptData(cur)) {
                    event.result = handle.apply(cur, data);
                    if (event.result === false) event.preventDefault()
                }
            }
            event.type = type;
            if (!onlyHandlers &&
                !event.isDefaultPrevented())
                if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && acceptData(elem))
                    if (ontype && jQuery.isFunction(elem[type]) && !jQuery.isWindow(elem)) {
                        tmp = elem[ontype];
                        if (tmp) elem[ontype] = null;
                        jQuery.event.triggered = type;
                        elem[type]();
                        jQuery.event.triggered = undefined;
                        if (tmp) elem[ontype] = tmp
                    }
            return event.result
        },
        simulate: function(type, elem, event) {
            var e = jQuery.extend(new jQuery.Event, event, {
                type: type,
                isSimulated: true
            });
            jQuery.event.trigger(e, null, elem)
        }
    });
    jQuery.fn.extend({
        trigger: function(type,
            data) {
            return this.each(function() {
                jQuery.event.trigger(type, data, this)
            })
        },
        triggerHandler: function(type, data) {
            var elem = this[0];
            if (elem) return jQuery.event.trigger(type, data, elem, true)
        }
    });
    jQuery.each(("blur focus focusin focusout resize scroll click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup contextmenu").split(" "), function(i, name) {
        jQuery.fn[name] = function(data, fn) {
            return arguments.length > 0 ? this.on(name, null, data,
                fn) : this.trigger(name)
        }
    });
    jQuery.fn.extend({
        hover: function(fnOver, fnOut) {
            return this.mouseenter(fnOver).mouseleave(fnOut || fnOver)
        }
    });
    support.focusin = "onfocusin" in window;
    if (!support.focusin) jQuery.each({
        focus: "focusin",
        blur: "focusout"
    }, function(orig, fix) {
        var handler = function(event) {
            jQuery.event.simulate(fix, event.target, jQuery.event.fix(event))
        };
        jQuery.event.special[fix] = {
            setup: function() {
                var doc = this.ownerDocument || this,
                    attaches = dataPriv.access(doc, fix);
                if (!attaches) doc.addEventListener(orig, handler,
                    true);
                dataPriv.access(doc, fix, (attaches || 0) + 1)
            },
            teardown: function() {
                var doc = this.ownerDocument || this,
                    attaches = dataPriv.access(doc, fix) - 1;
                if (!attaches) {
                    doc.removeEventListener(orig, handler, true);
                    dataPriv.remove(doc, fix)
                } else dataPriv.access(doc, fix, attaches)
            }
        }
    });
    var location = window.location;
    var nonce = jQuery.now();
    var rquery = /\?/;
    jQuery.parseXML = function(data) {
        var xml;
        if (!data || typeof data !== "string") return null;
        try {
            xml = (new window.DOMParser).parseFromString(data, "text/xml")
        } catch (e) {
            xml = undefined
        }
        if (!xml ||
            xml.getElementsByTagName("parsererror").length) jQuery.error("Invalid XML: " + data);
        return xml
    };
    var rbracket = /\[\]$/,
        rCRLF = /\r?\n/g,
        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
        rsubmittable = /^(?:input|select|textarea|keygen)/i;

    function buildParams(prefix, obj, traditional, add) {
        var name;
        if (Array.isArray(obj)) jQuery.each(obj, function(i, v) {
            if (traditional || rbracket.test(prefix)) add(prefix, v);
            else buildParams(prefix + "[" + (typeof v === "object" && v != null ? i : "") + "]", v, traditional, add)
        });
        else if (!traditional &&
            jQuery.type(obj) === "object")
            for (name in obj) buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
        else add(prefix, obj)
    }
    jQuery.param = function(a, traditional) {
        var prefix, s = [],
            add = function(key, valueOrFunction) {
                var value = jQuery.isFunction(valueOrFunction) ? valueOrFunction() : valueOrFunction;
                s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value == null ? "" : value)
            };
        if (Array.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) jQuery.each(a, function() {
            add(this.name, this.value)
        });
        else
            for (prefix in a) buildParams(prefix,
                a[prefix], traditional, add);
        return s.join("&")
    };
    jQuery.fn.extend({
        serialize: function() {
            return jQuery.param(this.serializeArray())
        },
        serializeArray: function() {
            return this.map(function() {
                var elements = jQuery.prop(this, "elements");
                return elements ? jQuery.makeArray(elements) : this
            }).filter(function() {
                var type = this.type;
                return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type))
            }).map(function(i, elem) {
                var val = jQuery(this).val();
                if (val == null) return null;
                if (Array.isArray(val)) return jQuery.map(val, function(val) {
                    return {
                        name: elem.name,
                        value: val.replace(rCRLF, "\r\n")
                    }
                });
                return {
                    name: elem.name,
                    value: val.replace(rCRLF, "\r\n")
                }
            }).get()
        }
    });
    var r20 = /%20/g,
        rhash = /#.*$/,
        rantiCache = /([?&])_=[^&]*/,
        rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,
        rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
        rnoContent = /^(?:GET|HEAD)$/,
        rprotocol = /^\/\//,
        prefilters = {},
        transports = {},
        allTypes = "*/".concat("*"),
        originAnchor = document.createElement("a");
    originAnchor.href = location.href;

    function addToPrefiltersOrTransports(structure) {
        return function(dataTypeExpression, func) {
            if (typeof dataTypeExpression !== "string") {
                func = dataTypeExpression;
                dataTypeExpression = "*"
            }
            var dataType, i = 0,
                dataTypes = dataTypeExpression.toLowerCase().match(rnothtmlwhite) || [];
            if (jQuery.isFunction(func))
                while (dataType = dataTypes[i++])
                    if (dataType[0] === "+") {
                        dataType = dataType.slice(1) || "*";
                        (structure[dataType] = structure[dataType] || []).unshift(func)
                    } else(structure[dataType] = structure[dataType] || []).push(func)
        }
    }

    function inspectPrefiltersOrTransports(structure, options, originalOptions, jqXHR) {
        var inspected = {},
            seekingTransport = structure === transports;

        function inspect(dataType) {
            var selected;
            inspected[dataType] = true;
            jQuery.each(structure[dataType] || [], function(_, prefilterOrFactory) {
                var dataTypeOrTransport = prefilterOrFactory(options, originalOptions, jqXHR);
                if (typeof dataTypeOrTransport === "string" && !seekingTransport && !inspected[dataTypeOrTransport]) {
                    options.dataTypes.unshift(dataTypeOrTransport);
                    inspect(dataTypeOrTransport);
                    return false
                } else if (seekingTransport) return !(selected = dataTypeOrTransport)
            });
            return selected
        }
        return inspect(options.dataTypes[0]) || !inspected["*"] && inspect("*")
    }

    function ajaxExtend(target, src) {
        var key, deep, flatOptions = jQuery.ajaxSettings.flatOptions || {};
        for (key in src)
            if (src[key] !== undefined)(flatOptions[key] ? target : deep || (deep = {}))[key] = src[key];
        if (deep) jQuery.extend(true, target, deep);
        return target
    }

    function ajaxHandleResponses(s, jqXHR, responses) {
        var ct, type, finalDataType, firstDataType, contents =
            s.contents,
            dataTypes = s.dataTypes;
        while (dataTypes[0] === "*") {
            dataTypes.shift();
            if (ct === undefined) ct = s.mimeType || jqXHR.getResponseHeader("Content-Type")
        }
        if (ct)
            for (type in contents)
                if (contents[type] && contents[type].test(ct)) {
                    dataTypes.unshift(type);
                    break
                }
        if (dataTypes[0] in responses) finalDataType = dataTypes[0];
        else {
            for (type in responses) {
                if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) {
                    finalDataType = type;
                    break
                }
                if (!firstDataType) firstDataType = type
            }
            finalDataType = finalDataType || firstDataType
        }
        if (finalDataType) {
            if (finalDataType !==
                dataTypes[0]) dataTypes.unshift(finalDataType);
            return responses[finalDataType]
        }
    }

    function ajaxConvert(s, response, jqXHR, isSuccess) {
        var conv2, current, conv, tmp, prev, converters = {},
            dataTypes = s.dataTypes.slice();
        if (dataTypes[1])
            for (conv in s.converters) converters[conv.toLowerCase()] = s.converters[conv];
        current = dataTypes.shift();
        while (current) {
            if (s.responseFields[current]) jqXHR[s.responseFields[current]] = response;
            if (!prev && isSuccess && s.dataFilter) response = s.dataFilter(response, s.dataType);
            prev = current;
            current =
                dataTypes.shift();
            if (current)
                if (current === "*") current = prev;
                else if (prev !== "*" && prev !== current) {
                conv = converters[prev + " " + current] || converters["* " + current];
                if (!conv)
                    for (conv2 in converters) {
                        tmp = conv2.split(" ");
                        if (tmp[1] === current) {
                            conv = converters[prev + " " + tmp[0]] || converters["* " + tmp[0]];
                            if (conv) {
                                if (conv === true) conv = converters[conv2];
                                else if (converters[conv2] !== true) {
                                    current = tmp[0];
                                    dataTypes.unshift(tmp[1])
                                }
                                break
                            }
                        }
                    }
                if (conv !== true)
                    if (conv && s.throws) response = conv(response);
                    else try {
                        response = conv(response)
                    } catch (e) {
                        return {
                            state: "parsererror",
                            error: conv ? e : "No conversion from " + prev + " to " + current
                        }
                    }
            }
        }
        return {
            state: "success",
            data: response
        }
    }
    jQuery.extend({
        active: 0,
        lastModified: {},
        etag: {},
        ajaxSettings: {
            url: location.href,
            type: "GET",
            isLocal: rlocalProtocol.test(location.protocol),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            accepts: {
                "*": allTypes,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },
            contents: {
                xml: /\bxml\b/,
                html: /\bhtml/,
                json: /\bjson\b/
            },
            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },
            converters: {
                "* text": String,
                "text html": true,
                "text json": JSON.parse,
                "text xml": jQuery.parseXML
            },
            flatOptions: {
                url: true,
                context: true
            }
        },
        ajaxSetup: function(target, settings) {
            return settings ? ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings) : ajaxExtend(jQuery.ajaxSettings, target)
        },
        ajaxPrefilter: addToPrefiltersOrTransports(prefilters),
        ajaxTransport: addToPrefiltersOrTransports(transports),
        ajax: function(url,
            options) {
            if (typeof url === "object") {
                options = url;
                url = undefined
            }
            options = options || {};
            var transport, cacheURL, responseHeadersString, responseHeaders, timeoutTimer, urlAnchor, completed, fireGlobals, i, uncached, s = jQuery.ajaxSetup({}, options),
                callbackContext = s.context || s,
                globalEventContext = s.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery(callbackContext) : jQuery.event,
                deferred = jQuery.Deferred(),
                completeDeferred = jQuery.Callbacks("once memory"),
                statusCode = s.statusCode || {},
                requestHeaders = {},
                requestHeadersNames = {},
                strAbort = "canceled",
                jqXHR = {
                    readyState: 0,
                    getResponseHeader: function(key) {
                        var match;
                        if (completed) {
                            if (!responseHeaders) {
                                responseHeaders = {};
                                while (match = rheaders.exec(responseHeadersString)) responseHeaders[match[1].toLowerCase()] = match[2]
                            }
                            match = responseHeaders[key.toLowerCase()]
                        }
                        return match == null ? null : match
                    },
                    getAllResponseHeaders: function() {
                        return completed ? responseHeadersString : null
                    },
                    setRequestHeader: function(name, value) {
                        if (completed == null) {
                            name = requestHeadersNames[name.toLowerCase()] = requestHeadersNames[name.toLowerCase()] ||
                                name;
                            requestHeaders[name] = value
                        }
                        return this
                    },
                    overrideMimeType: function(type) {
                        if (completed == null) s.mimeType = type;
                        return this
                    },
                    statusCode: function(map) {
                        var code;
                        if (map)
                            if (completed) jqXHR.always(map[jqXHR.status]);
                            else
                                for (code in map) statusCode[code] = [statusCode[code], map[code]];
                        return this
                    },
                    abort: function(statusText) {
                        var finalText = statusText || strAbort;
                        if (transport) transport.abort(finalText);
                        done(0, finalText);
                        return this
                    }
                };
            deferred.promise(jqXHR);
            s.url = ((url || s.url || location.href) + "").replace(rprotocol,
                location.protocol + "//");
            s.type = options.method || options.type || s.method || s.type;
            s.dataTypes = (s.dataType || "*").toLowerCase().match(rnothtmlwhite) || [""];
            if (s.crossDomain == null) {
                urlAnchor = document.createElement("a");
                try {
                    urlAnchor.href = s.url;
                    urlAnchor.href = urlAnchor.href;
                    s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host
                } catch (e) {
                    s.crossDomain = true
                }
            }
            if (s.data && s.processData && typeof s.data !== "string") s.data = jQuery.param(s.data, s.traditional);
            inspectPrefiltersOrTransports(prefilters,
                s, options, jqXHR);
            if (completed) return jqXHR;
            fireGlobals = jQuery.event && s.global;
            if (fireGlobals && jQuery.active++ === 0) jQuery.event.trigger("ajaxStart");
            s.type = s.type.toUpperCase();
            s.hasContent = !rnoContent.test(s.type);
            cacheURL = s.url.replace(rhash, "");
            if (!s.hasContent) {
                uncached = s.url.slice(cacheURL.length);
                if (s.data) {
                    cacheURL += (rquery.test(cacheURL) ? "&" : "?") + s.data;
                    delete s.data
                }
                if (s.cache === false) {
                    cacheURL = cacheURL.replace(rantiCache, "$1");
                    uncached = (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce++ + uncached
                }
                s.url =
                    cacheURL + uncached
            } else if (s.data && s.processData && (s.contentType || "").indexOf("application/x-www-form-urlencoded") === 0) s.data = s.data.replace(r20, "+");
            if (s.ifModified) {
                if (jQuery.lastModified[cacheURL]) jqXHR.setRequestHeader("If-Modified-Since", jQuery.lastModified[cacheURL]);
                if (jQuery.etag[cacheURL]) jqXHR.setRequestHeader("If-None-Match", jQuery.etag[cacheURL])
            }
            if (s.data && s.hasContent && s.contentType !== false || options.contentType) jqXHR.setRequestHeader("Content-Type", s.contentType);
            jqXHR.setRequestHeader("Accept",
                s.dataTypes[0] && s.accepts[s.dataTypes[0]] ? s.accepts[s.dataTypes[0]] + (s.dataTypes[0] !== "*" ? ", " + allTypes + "; q=0.01" : "") : s.accepts["*"]);
            for (i in s.headers) jqXHR.setRequestHeader(i, s.headers[i]);
            if (s.beforeSend && (s.beforeSend.call(callbackContext, jqXHR, s) === false || completed)) return jqXHR.abort();
            strAbort = "abort";
            completeDeferred.add(s.complete);
            jqXHR.done(s.success);
            jqXHR.fail(s.error);
            transport = inspectPrefiltersOrTransports(transports, s, options, jqXHR);
            if (!transport) done(-1, "No Transport");
            else {
                jqXHR.readyState =
                    1;
                if (fireGlobals) globalEventContext.trigger("ajaxSend", [jqXHR, s]);
                if (completed) return jqXHR;
                if (s.async && s.timeout > 0) timeoutTimer = window.setTimeout(function() {
                    jqXHR.abort("timeout")
                }, s.timeout);
                try {
                    completed = false;
                    transport.send(requestHeaders, done)
                } catch (e$3) {
                    if (completed) throw e$3;
                    done(-1, e$3)
                }
            }

            function done(status, nativeStatusText, responses, headers) {
                var isSuccess, success, error, response, modified, statusText = nativeStatusText;
                if (completed) return;
                completed = true;
                if (timeoutTimer) window.clearTimeout(timeoutTimer);
                transport = undefined;
                responseHeadersString = headers || "";
                jqXHR.readyState = status > 0 ? 4 : 0;
                isSuccess = status >= 200 && status < 300 || status === 304;
                if (responses) response = ajaxHandleResponses(s, jqXHR, responses);
                response = ajaxConvert(s, response, jqXHR, isSuccess);
                if (isSuccess) {
                    if (s.ifModified) {
                        modified = jqXHR.getResponseHeader("Last-Modified");
                        if (modified) jQuery.lastModified[cacheURL] = modified;
                        modified = jqXHR.getResponseHeader("etag");
                        if (modified) jQuery.etag[cacheURL] = modified
                    }
                    if (status === 204 || s.type === "HEAD") statusText =
                        "nocontent";
                    else if (status === 304) statusText = "notmodified";
                    else {
                        statusText = response.state;
                        success = response.data;
                        error = response.error;
                        isSuccess = !error
                    }
                } else {
                    error = statusText;
                    if (status || !statusText) {
                        statusText = "error";
                        if (status < 0) status = 0
                    }
                }
                jqXHR.status = status;
                jqXHR.statusText = (nativeStatusText || statusText) + "";
                if (isSuccess) deferred.resolveWith(callbackContext, [success, statusText, jqXHR]);
                else deferred.rejectWith(callbackContext, [jqXHR, statusText, error]);
                jqXHR.statusCode(statusCode);
                statusCode = undefined;
                if (fireGlobals) globalEventContext.trigger(isSuccess ? "ajaxSuccess" : "ajaxError", [jqXHR, s, isSuccess ? success : error]);
                completeDeferred.fireWith(callbackContext, [jqXHR, statusText]);
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxComplete", [jqXHR, s]);
                    if (!--jQuery.active) jQuery.event.trigger("ajaxStop")
                }
            }
            return jqXHR
        },
        getJSON: function(url, data, callback) {
            return jQuery.get(url, data, callback, "json")
        },
        getScript: function(url, callback) {
            return jQuery.get(url, undefined, callback, "script")
        }
    });
    jQuery.each(["get", "post"],
        function(i, method) {
            jQuery[method] = function(url, data, callback, type) {
                if (jQuery.isFunction(data)) {
                    type = type || callback;
                    callback = data;
                    data = undefined
                }
                return jQuery.ajax(jQuery.extend({
                    url: url,
                    type: method,
                    dataType: type,
                    data: data,
                    success: callback
                }, jQuery.isPlainObject(url) && url))
            }
        });
    jQuery._evalUrl = function(url) {
        return jQuery.ajax({
            url: url,
            type: "GET",
            dataType: "script",
            cache: true,
            async: false,
            global: false,
            "throws": true
        })
    };
    jQuery.fn.extend({
        wrapAll: function(html) {
            var wrap;
            if (this[0]) {
                if (jQuery.isFunction(html)) html =
                    html.call(this[0]);
                wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);
                if (this[0].parentNode) wrap.insertBefore(this[0]);
                wrap.map(function() {
                    var elem = this;
                    while (elem.firstElementChild) elem = elem.firstElementChild;
                    return elem
                }).append(this)
            }
            return this
        },
        wrapInner: function(html) {
            if (jQuery.isFunction(html)) return this.each(function(i) {
                jQuery(this).wrapInner(html.call(this, i))
            });
            return this.each(function() {
                var self = jQuery(this),
                    contents = self.contents();
                if (contents.length) contents.wrapAll(html);
                else self.append(html)
            })
        },
        wrap: function(html) {
            var isFunction = jQuery.isFunction(html);
            return this.each(function(i) {
                jQuery(this).wrapAll(isFunction ? html.call(this, i) : html)
            })
        },
        unwrap: function(selector) {
            this.parent(selector).not("body").each(function() {
                jQuery(this).replaceWith(this.childNodes)
            });
            return this
        }
    });
    jQuery.expr.pseudos.hidden = function(elem) {
        return !jQuery.expr.pseudos.visible(elem)
    };
    jQuery.expr.pseudos.visible = function(elem) {
        return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length)
    };
    jQuery.ajaxSettings.xhr =
        function() {
            try {
                return new window.XMLHttpRequest
            } catch (e) {}
        };
    var xhrSuccessStatus = {
            0: 200,
            1223: 204
        },
        xhrSupported = jQuery.ajaxSettings.xhr();
    support.cors = !!xhrSupported && "withCredentials" in xhrSupported;
    support.ajax = xhrSupported = !!xhrSupported;
    jQuery.ajaxTransport(function(options) {
        var callback, errorCallback;
        if (support.cors || xhrSupported && !options.crossDomain) return {
            send: function(headers, complete) {
                var i, xhr = options.xhr();
                xhr.open(options.type, options.url, options.async, options.username, options.password);
                if (options.xhrFields)
                    for (i in options.xhrFields) xhr[i] = options.xhrFields[i];
                if (options.mimeType && xhr.overrideMimeType) xhr.overrideMimeType(options.mimeType);
                if (!options.crossDomain && !headers["X-Requested-With"]) headers["X-Requested-With"] = "XMLHttpRequest";
                for (i in headers) xhr.setRequestHeader(i, headers[i]);
                callback = function(type) {
                    return function() {
                        if (callback) {
                            callback = errorCallback = xhr.onload = xhr.onerror = xhr.onabort = xhr.onreadystatechange = null;
                            if (type === "abort") xhr.abort();
                            else if (type === "error")
                                if (typeof xhr.status !==
                                    "number") complete(0, "error");
                                else complete(xhr.status, xhr.statusText);
                            else complete(xhrSuccessStatus[xhr.status] || xhr.status, xhr.statusText, (xhr.responseType || "text") !== "text" || typeof xhr.responseText !== "string" ? {
                                binary: xhr.response
                            } : {
                                text: xhr.responseText
                            }, xhr.getAllResponseHeaders())
                        }
                    }
                };
                xhr.onload = callback();
                errorCallback = xhr.onerror = callback("error");
                if (xhr.onabort !== undefined) xhr.onabort = errorCallback;
                else xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4) window.setTimeout(function() {
                        if (callback) errorCallback()
                    })
                };
                callback = callback("abort");
                try {
                    xhr.send(options.hasContent && options.data || null)
                } catch (e) {
                    if (callback) throw e;
                }
            },
            abort: function() {
                if (callback) callback()
            }
        }
    });
    jQuery.ajaxPrefilter(function(s) {
        if (s.crossDomain) s.contents.script = false
    });
    jQuery.ajaxSetup({
        accepts: {
            script: "text/javascript, application/javascript, " + "application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /\b(?:java|ecma)script\b/
        },
        converters: {
            "text script": function(text) {
                jQuery.globalEval(text);
                return text
            }
        }
    });
    jQuery.ajaxPrefilter("script",
        function(s) {
            if (s.cache === undefined) s.cache = false;
            if (s.crossDomain) s.type = "GET"
        });
    jQuery.ajaxTransport("script", function(s) {
        if (s.crossDomain) {
            var script, callback;
            return {
                send: function(_, complete) {
                    script = jQuery("<script>").prop({
                        charset: s.scriptCharset,
                        src: s.url
                    }).on("load error", callback = function(evt) {
                        script.remove();
                        callback = null;
                        if (evt) complete(evt.type === "error" ? 404 : 200, evt.type)
                    });
                    document.head.appendChild(script[0])
                },
                abort: function() {
                    if (callback) callback()
                }
            }
        }
    });
    var oldCallbacks = [],
        rjsonp = /(=)\?(?=&|$)|\?\?/;
    jQuery.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function() {
            var callback = oldCallbacks.pop() || jQuery.expando + "_" + nonce++;
            this[callback] = true;
            return callback
        }
    });
    jQuery.ajaxPrefilter("json jsonp", function(s, originalSettings, jqXHR) {
        var callbackName, overwritten, responseContainer, jsonProp = s.jsonp !== false && (rjsonp.test(s.url) ? "url" : typeof s.data === "string" && (s.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && rjsonp.test(s.data) && "data");
        if (jsonProp || s.dataTypes[0] === "jsonp") {
            callbackName =
                s.jsonpCallback = jQuery.isFunction(s.jsonpCallback) ? s.jsonpCallback() : s.jsonpCallback;
            if (jsonProp) s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName);
            else if (s.jsonp !== false) s.url += (rquery.test(s.url) ? "&" : "?") + s.jsonp + "=" + callbackName;
            s.converters["script json"] = function() {
                if (!responseContainer) jQuery.error(callbackName + " was not called");
                return responseContainer[0]
            };
            s.dataTypes[0] = "json";
            overwritten = window[callbackName];
            window[callbackName] = function() {
                responseContainer = arguments
            };
            jqXHR.always(function() {
                if (overwritten ===
                    undefined) jQuery(window).removeProp(callbackName);
                else window[callbackName] = overwritten;
                if (s[callbackName]) {
                    s.jsonpCallback = originalSettings.jsonpCallback;
                    oldCallbacks.push(callbackName)
                }
                if (responseContainer && jQuery.isFunction(overwritten)) overwritten(responseContainer[0]);
                responseContainer = overwritten = undefined
            });
            return "script"
        }
    });
    support.createHTMLDocument = function() {
        var body = document.implementation.createHTMLDocument("").body;
        body.innerHTML = "<form></form><form></form>";
        return body.childNodes.length ===
            2
    }();
    jQuery.parseHTML = function(data, context, keepScripts) {
        if (typeof data !== "string") return [];
        if (typeof context === "boolean") {
            keepScripts = context;
            context = false
        }
        var base, parsed, scripts;
        if (!context)
            if (support.createHTMLDocument) {
                context = document.implementation.createHTMLDocument("");
                base = context.createElement("base");
                base.href = document.location.href;
                context.head.appendChild(base)
            } else context = document;
        parsed = rsingleTag.exec(data);
        scripts = !keepScripts && [];
        if (parsed) return [context.createElement(parsed[1])];
        parsed = buildFragment([data], context, scripts);
        if (scripts && scripts.length) jQuery(scripts).remove();
        return jQuery.merge([], parsed.childNodes)
    };
    jQuery.fn.load = function(url, params, callback) {
        var selector, type, response, self = this,
            off = url.indexOf(" ");
        if (off > -1) {
            selector = stripAndCollapse(url.slice(off));
            url = url.slice(0, off)
        }
        if (jQuery.isFunction(params)) {
            callback = params;
            params = undefined
        } else if (params && typeof params === "object") type = "POST";
        if (self.length > 0) jQuery.ajax({
            url: url,
            type: type || "GET",
            dataType: "html",
            data: params
        }).done(function(responseText) {
            response = arguments;
            self.html(selector ? jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector) : responseText)
        }).always(callback && function(jqXHR, status) {
            self.each(function() {
                callback.apply(this, response || [jqXHR.responseText, status, jqXHR])
            })
        });
        return this
    };
    jQuery.each(["ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend"], function(i, type) {
        jQuery.fn[type] = function(fn) {
            return this.on(type, fn)
        }
    });
    jQuery.expr.pseudos.animated = function(elem) {
        return jQuery.grep(jQuery.timers,
            function(fn) {
                return elem === fn.elem
            }).length
    };
    jQuery.offset = {
        setOffset: function(elem, options, i) {
            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition, position = jQuery.css(elem, "position"),
                curElem = jQuery(elem),
                props = {};
            if (position === "static") elem.style.position = "relative";
            curOffset = curElem.offset();
            curCSSTop = jQuery.css(elem, "top");
            curCSSLeft = jQuery.css(elem, "left");
            calculatePosition = (position === "absolute" || position === "fixed") && (curCSSTop + curCSSLeft).indexOf("auto") > -1;
            if (calculatePosition) {
                curPosition =
                    curElem.position();
                curTop = curPosition.top;
                curLeft = curPosition.left
            } else {
                curTop = parseFloat(curCSSTop) || 0;
                curLeft = parseFloat(curCSSLeft) || 0
            }
            if (jQuery.isFunction(options)) options = options.call(elem, i, jQuery.extend({}, curOffset));
            if (options.top != null) props.top = options.top - curOffset.top + curTop;
            if (options.left != null) props.left = options.left - curOffset.left + curLeft;
            if ("using" in options) options.using.call(elem, props);
            else curElem.css(props)
        }
    };
    jQuery.fn.extend({
        offset: function(options) {
            if (arguments.length) return options ===
                undefined ? this : this.each(function(i) {
                    jQuery.offset.setOffset(this, options, i)
                });
            var doc, docElem, rect, win, elem = this[0];
            if (!elem) return;
            if (!elem.getClientRects().length) return {
                top: 0,
                left: 0
            };
            rect = elem.getBoundingClientRect();
            doc = elem.ownerDocument;
            docElem = doc.documentElement;
            win = doc.defaultView;
            return {
                top: rect.top + win.pageYOffset - docElem.clientTop,
                left: rect.left + win.pageXOffset - docElem.clientLeft
            }
        },
        position: function() {
            if (!this[0]) return;
            var offsetParent, offset, elem = this[0],
                parentOffset = {
                    top: 0,
                    left: 0
                };
            if (jQuery.css(elem, "position") === "fixed") offset = elem.getBoundingClientRect();
            else {
                offsetParent = this.offsetParent();
                offset = this.offset();
                if (!nodeName(offsetParent[0], "html")) parentOffset = offsetParent.offset();
                parentOffset = {
                    top: parentOffset.top + jQuery.css(offsetParent[0], "borderTopWidth", true),
                    left: parentOffset.left + jQuery.css(offsetParent[0], "borderLeftWidth", true)
                }
            }
            return {
                top: offset.top - parentOffset.top - jQuery.css(elem, "marginTop", true),
                left: offset.left - parentOffset.left - jQuery.css(elem, "marginLeft",
                    true)
            }
        },
        offsetParent: function() {
            return this.map(function() {
                var offsetParent = this.offsetParent;
                while (offsetParent && jQuery.css(offsetParent, "position") === "static") offsetParent = offsetParent.offsetParent;
                return offsetParent || documentElement
            })
        }
    });
    jQuery.each({
        scrollLeft: "pageXOffset",
        scrollTop: "pageYOffset"
    }, function(method, prop) {
        var top = "pageYOffset" === prop;
        jQuery.fn[method] = function(val) {
            return access(this, function(elem, method, val) {
                var win;
                if (jQuery.isWindow(elem)) win = elem;
                else if (elem.nodeType === 9) win =
                    elem.defaultView;
                if (val === undefined) return win ? win[prop] : elem[method];
                if (win) win.scrollTo(!top ? val : win.pageXOffset, top ? val : win.pageYOffset);
                else elem[method] = val
            }, method, val, arguments.length)
        }
    });
    jQuery.each(["top", "left"], function(i, prop) {
        jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function(elem, computed) {
            if (computed) {
                computed = curCSS(elem, prop);
                return rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed
            }
        })
    });
    jQuery.each({
        Height: "height",
        Width: "width"
    }, function(name, type) {
        jQuery.each({
            padding: "inner" +
                name,
            content: type,
            "": "outer" + name
        }, function(defaultExtra, funcName) {
            jQuery.fn[funcName] = function(margin, value) {
                var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
                    extra = defaultExtra || (margin === true || value === true ? "margin" : "border");
                return access(this, function(elem, type, value) {
                    var doc;
                    if (jQuery.isWindow(elem)) return funcName.indexOf("outer") === 0 ? elem["inner" + name] : elem.document.documentElement["client" + name];
                    if (elem.nodeType === 9) {
                        doc = elem.documentElement;
                        return Math.max(elem.body["scroll" +
                            name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name])
                    }
                    return value === undefined ? jQuery.css(elem, type, extra) : jQuery.style(elem, type, value, extra)
                }, type, chainable ? margin : undefined, chainable)
            }
        })
    });
    jQuery.fn.extend({
        bind: function(types, data, fn) {
            return this.on(types, null, data, fn)
        },
        unbind: function(types, fn) {
            return this.off(types, null, fn)
        },
        delegate: function(selector, types, data, fn) {
            return this.on(types, selector, data, fn)
        },
        undelegate: function(selector, types, fn) {
            return arguments.length ===
                1 ? this.off(selector, "**") : this.off(types, selector || "**", fn)
        }
    });
    jQuery.holdReady = function(hold) {
        if (hold) jQuery.readyWait++;
        else jQuery.ready(true)
    };
    jQuery.isArray = Array.isArray;
    jQuery.parseJSON = JSON.parse;
    jQuery.nodeName = nodeName;
    if (typeof define === "function" && define.amd) define("jquery", [], function() {
        return jQuery
    });
    var _jQuery = window.jQuery,
        _$ = window.$;
    jQuery.noConflict = function(deep) {
        if (window.$ === jQuery) window.$ = _$;
        if (deep && window.jQuery === jQuery) window.jQuery = _jQuery;
        return jQuery
    };
    if (!noGlobal) window.jQuery =
        window.$ = jQuery;
    return jQuery
});
(function() {
    function n(n) {
        function t(t, r, e, u, i, o) {
            for (; i >= 0 && o > i; i += n) {
                var a = u ? u[i] : i;
                e = r(e, t[a], a, t)
            }
            return e
        }
        return function(r, e, u, i) {
            e = b(e, i, 4);
            var o = !k(r) && m.keys(r),
                a = (o || r).length,
                c = n > 0 ? 0 : a - 1;
            return arguments.length < 3 && (u = r[o ? o[c] : c], c += n), t(r, e, u, o, c, a)
        }
    }

    function t(n) {
        return function(t, r, e) {
            r = x(r, e);
            for (var u = O(t), i = n > 0 ? 0 : u - 1; i >= 0 && u > i; i += n)
                if (r(t[i], i, t)) return i;
            return -1
        }
    }

    function r(n, t, r) {
        return function(e, u, i) {
            var o = 0,
                a = O(e);
            if ("number" == typeof i) n > 0 ? o = i >= 0 ? i : Math.max(i + a, o) : a = i >= 0 ? Math.min(i +
                1, a) : i + a + 1;
            else if (r && i && a) return i = r(e, u), e[i] === u ? i : -1;
            if (u !== u) return i = t(l.call(e, o, a), m.isNaN), i >= 0 ? i + o : -1;
            for (i = n > 0 ? o : a - 1; i >= 0 && a > i; i += n)
                if (e[i] === u) return i;
            return -1
        }
    }

    function e(n, t) {
        var r = I.length,
            e = n.constructor,
            u = m.isFunction(e) && e.prototype || a,
            i = "constructor";
        for (m.has(n, i) && !m.contains(t, i) && t.push(i); r--;) i = I[r], i in n && n[i] !== u[i] && !m.contains(t, i) && t.push(i)
    }
    var u = this,
        i = u._,
        o = Array.prototype,
        a = Object.prototype,
        c = Function.prototype,
        f = o.push,
        l = o.slice,
        s = a.toString,
        p = a.hasOwnProperty,
        h = Array.isArray,
        v = Object.keys,
        g = c.bind,
        y = Object.create,
        d = function() {},
        m = function(n) {
            return n instanceof m ? n : this instanceof m ? void(this._wrapped = n) : new m(n)
        };
    "undefined" != typeof exports ? ("undefined" != typeof module && module.exports && (exports = module.exports = m), exports._ = m) : u._ = m, m.VERSION = "1.8.3";
    var b = function(n, t, r) {
            if (t === void 0) return n;
            switch (null == r ? 3 : r) {
                case 1:
                    return function(r) {
                        return n.call(t, r)
                    };
                case 2:
                    return function(r, e) {
                        return n.call(t, r, e)
                    };
                case 3:
                    return function(r, e, u) {
                        return n.call(t,
                            r, e, u)
                    };
                case 4:
                    return function(r, e, u, i) {
                        return n.call(t, r, e, u, i)
                    }
            }
            return function() {
                return n.apply(t, arguments)
            }
        },
        x = function(n, t, r) {
            return null == n ? m.identity : m.isFunction(n) ? b(n, t, r) : m.isObject(n) ? m.matcher(n) : m.property(n)
        };
    m.iteratee = function(n, t) {
        return x(n, t, 1 / 0)
    };
    var _ = function(n, t) {
            return function(r) {
                var e = arguments.length;
                if (2 > e || null == r) return r;
                for (var u = 1; e > u; u++)
                    for (var i = arguments[u], o = n(i), a = o.length, c = 0; a > c; c++) {
                        var f = o[c];
                        t && r[f] !== void 0 || (r[f] = i[f])
                    }
                return r
            }
        },
        j = function(n) {
            if (!m.isObject(n)) return {};
            if (y) return y(n);
            d.prototype = n;
            var t = new d;
            return d.prototype = null, t
        },
        w = function(n) {
            return function(t) {
                return null == t ? void 0 : t[n]
            }
        },
        A = Math.pow(2, 53) - 1,
        O = w("length"),
        k = function(n) {
            var t = O(n);
            return "number" == typeof t && t >= 0 && A >= t
        };
    m.each = m.forEach = function(n, t, r) {
            t = b(t, r);
            var e, u;
            if (k(n))
                for (e = 0, u = n.length; u > e; e++) t(n[e], e, n);
            else {
                var i = m.keys(n);
                for (e = 0, u = i.length; u > e; e++) t(n[i[e]], i[e], n)
            }
            return n
        }, m.map = m.collect = function(n, t, r) {
            t = x(t, r);
            for (var e = !k(n) && m.keys(n), u = (e || n).length, i = Array(u), o = 0; u >
                o; o++) {
                var a = e ? e[o] : o;
                i[o] = t(n[a], a, n)
            }
            return i
        }, m.reduce = m.foldl = m.inject = n(1), m.reduceRight = m.foldr = n(-1), m.find = m.detect = function(n, t, r) {
            var e;
            return e = k(n) ? m.findIndex(n, t, r) : m.findKey(n, t, r), e !== void 0 && e !== -1 ? n[e] : void 0
        }, m.filter = m.select = function(n, t, r) {
            var e = [];
            return t = x(t, r), m.each(n, function(n, r, u) {
                t(n, r, u) && e.push(n)
            }), e
        }, m.reject = function(n, t, r) {
            return m.filter(n, m.negate(x(t)), r)
        }, m.every = m.all = function(n, t, r) {
            t = x(t, r);
            for (var e = !k(n) && m.keys(n), u = (e || n).length, i = 0; u > i; i++) {
                var o = e ?
                    e[i] : i;
                if (!t(n[o], o, n)) return !1
            }
            return !0
        }, m.some = m.any = function(n, t, r) {
            t = x(t, r);
            for (var e = !k(n) && m.keys(n), u = (e || n).length, i = 0; u > i; i++) {
                var o = e ? e[i] : i;
                if (t(n[o], o, n)) return !0
            }
            return !1
        }, m.contains = m.includes = m.include = function(n, t, r, e) {
            return k(n) || (n = m.values(n)), ("number" != typeof r || e) && (r = 0), m.indexOf(n, t, r) >= 0
        }, m.invoke = function(n, t) {
            var r = l.call(arguments, 2),
                e = m.isFunction(t);
            return m.map(n, function(n) {
                var u = e ? t : n[t];
                return null == u ? u : u.apply(n, r)
            })
        }, m.pluck = function(n, t) {
            return m.map(n, m.property(t))
        },
        m.where = function(n, t) {
            return m.filter(n, m.matcher(t))
        }, m.findWhere = function(n, t) {
            return m.find(n, m.matcher(t))
        }, m.max = function(n, t, r) {
            var e, u, i = -1 / 0,
                o = -1 / 0;
            if (null == t && null != n) {
                n = k(n) ? n : m.values(n);
                for (var a = 0, c = n.length; c > a; a++) e = n[a], e > i && (i = e)
            } else t = x(t, r), m.each(n, function(n, r, e) {
                u = t(n, r, e), (u > o || u === -1 / 0 && i === -1 / 0) && (i = n, o = u)
            });
            return i
        }, m.min = function(n, t, r) {
            var e, u, i = 1 / 0,
                o = 1 / 0;
            if (null == t && null != n) {
                n = k(n) ? n : m.values(n);
                for (var a = 0, c = n.length; c > a; a++) e = n[a], i > e && (i = e)
            } else t = x(t, r), m.each(n,
                function(n, r, e) {
                    u = t(n, r, e), (o > u || 1 / 0 === u && 1 / 0 === i) && (i = n, o = u)
                });
            return i
        }, m.shuffle = function(n) {
            for (var t, r = k(n) ? n : m.values(n), e = r.length, u = Array(e), i = 0; e > i; i++) t = m.random(0, i), t !== i && (u[i] = u[t]), u[t] = r[i];
            return u
        }, m.sample = function(n, t, r) {
            return null == t || r ? (k(n) || (n = m.values(n)), n[m.random(n.length - 1)]) : m.shuffle(n).slice(0, Math.max(0, t))
        }, m.sortBy = function(n, t, r) {
            return t = x(t, r), m.pluck(m.map(n, function(n, r, e) {
                return {
                    value: n,
                    index: r,
                    criteria: t(n, r, e)
                }
            }).sort(function(n, t) {
                var r = n.criteria,
                    e = t.criteria;
                if (r !== e) {
                    if (r > e || r === void 0) return 1;
                    if (e > r || e === void 0) return -1
                }
                return n.index - t.index
            }), "value")
        };
    var F = function(n) {
        return function(t, r, e) {
            var u = {};
            return r = x(r, e), m.each(t, function(e, i) {
                var o = r(e, i, t);
                n(u, e, o)
            }), u
        }
    };
    m.groupBy = F(function(n, t, r) {
        m.has(n, r) ? n[r].push(t) : n[r] = [t]
    }), m.indexBy = F(function(n, t, r) {
        n[r] = t
    }), m.countBy = F(function(n, t, r) {
        m.has(n, r) ? n[r]++ : n[r] = 1
    }), m.toArray = function(n) {
        return n ? m.isArray(n) ? l.call(n) : k(n) ? m.map(n, m.identity) : m.values(n) : []
    }, m.size = function(n) {
        return null ==
            n ? 0 : k(n) ? n.length : m.keys(n).length
    }, m.partition = function(n, t, r) {
        t = x(t, r);
        var e = [],
            u = [];
        return m.each(n, function(n, r, i) {
            (t(n, r, i) ? e : u).push(n)
        }), [e, u]
    }, m.first = m.head = m.take = function(n, t, r) {
        return null == n ? void 0 : null == t || r ? n[0] : m.initial(n, n.length - t)
    }, m.initial = function(n, t, r) {
        return l.call(n, 0, Math.max(0, n.length - (null == t || r ? 1 : t)))
    }, m.last = function(n, t, r) {
        return null == n ? void 0 : null == t || r ? n[n.length - 1] : m.rest(n, Math.max(0, n.length - t))
    }, m.rest = m.tail = m.drop = function(n, t, r) {
        return l.call(n, null == t ||
            r ? 1 : t)
    }, m.compact = function(n) {
        return m.filter(n, m.identity)
    };
    var S = function(n, t, r, e) {
        for (var u = [], i = 0, o = e || 0, a = O(n); a > o; o++) {
            var c = n[o];
            if (k(c) && (m.isArray(c) || m.isArguments(c))) {
                t || (c = S(c, t, r));
                var f = 0,
                    l = c.length;
                for (u.length += l; l > f;) u[i++] = c[f++]
            } else r || (u[i++] = c)
        }
        return u
    };
    m.flatten = function(n, t) {
            return S(n, t, !1)
        }, m.without = function(n) {
            return m.difference(n, l.call(arguments, 1))
        }, m.uniq = m.unique = function(n, t, r, e) {
            m.isBoolean(t) || (e = r, r = t, t = !1), null != r && (r = x(r, e));
            for (var u = [], i = [], o = 0, a = O(n); a >
                o; o++) {
                var c = n[o],
                    f = r ? r(c, o, n) : c;
                t ? (o && i === f || u.push(c), i = f) : r ? m.contains(i, f) || (i.push(f), u.push(c)) : m.contains(u, c) || u.push(c)
            }
            return u
        }, m.union = function() {
            return m.uniq(S(arguments, !0, !0))
        }, m.intersection = function(n) {
            for (var t = [], r = arguments.length, e = 0, u = O(n); u > e; e++) {
                var i = n[e];
                if (!m.contains(t, i)) {
                    for (var o = 1; r > o && m.contains(arguments[o], i); o++);
                    o === r && t.push(i)
                }
            }
            return t
        }, m.difference = function(n) {
            var t = S(arguments, !0, !0, 1);
            return m.filter(n, function(n) {
                return !m.contains(t, n)
            })
        }, m.zip = function() {
            return m.unzip(arguments)
        },
        m.unzip = function(n) {
            for (var t = n && m.max(n, O).length || 0, r = Array(t), e = 0; t > e; e++) r[e] = m.pluck(n, e);
            return r
        }, m.object = function(n, t) {
            for (var r = {}, e = 0, u = O(n); u > e; e++) t ? r[n[e]] = t[e] : r[n[e][0]] = n[e][1];
            return r
        }, m.findIndex = t(1), m.findLastIndex = t(-1), m.sortedIndex = function(n, t, r, e) {
            r = x(r, e, 1);
            for (var u = r(t), i = 0, o = O(n); o > i;) {
                var a = Math.floor((i + o) / 2);
                r(n[a]) < u ? i = a + 1 : o = a
            }
            return i
        }, m.indexOf = r(1, m.findIndex, m.sortedIndex), m.lastIndexOf = r(-1, m.findLastIndex), m.range = function(n, t, r) {
            null == t && (t = n || 0, n = 0), r = r ||
                1;
            for (var e = Math.max(Math.ceil((t - n) / r), 0), u = Array(e), i = 0; e > i; i++, n += r) u[i] = n;
            return u
        };
    var E = function(n, t, r, e, u) {
        if (!(e instanceof t)) return n.apply(r, u);
        var i = j(n.prototype),
            o = n.apply(i, u);
        return m.isObject(o) ? o : i
    };
    m.bind = function(n, t) {
        if (g && n.bind === g) return g.apply(n, l.call(arguments, 1));
        if (!m.isFunction(n)) throw new TypeError("Bind must be called on a function");
        var r = l.call(arguments, 2),
            e = function() {
                return E(n, e, t, this, r.concat(l.call(arguments)))
            };
        return e
    }, m.partial = function(n) {
        var t = l.call(arguments,
                1),
            r = function() {
                for (var e = 0, u = t.length, i = Array(u), o = 0; u > o; o++) i[o] = t[o] === m ? arguments[e++] : t[o];
                for (; e < arguments.length;) i.push(arguments[e++]);
                return E(n, r, this, this, i)
            };
        return r
    }, m.bindAll = function(n) {
        var t, r, e = arguments.length;
        if (1 >= e) throw new Error("bindAll must be passed function names");
        for (t = 1; e > t; t++) r = arguments[t], n[r] = m.bind(n[r], n);
        return n
    }, m.memoize = function(n, t) {
        var r = function(e) {
            var u = r.cache,
                i = "" + (t ? t.apply(this, arguments) : e);
            return m.has(u, i) || (u[i] = n.apply(this, arguments)), u[i]
        };
        return r.cache = {}, r
    }, m.delay = function(n, t) {
        var r = l.call(arguments, 2);
        return setTimeout(function() {
            return n.apply(null, r)
        }, t)
    }, m.defer = m.partial(m.delay, m, 1), m.throttle = function(n, t, r) {
        var e, u, i, o = null,
            a = 0;
        r || (r = {});
        var c = function() {
            a = r.leading === !1 ? 0 : m.now(), o = null, i = n.apply(e, u), o || (e = u = null)
        };
        return function() {
            var f = m.now();
            a || r.leading !== !1 || (a = f);
            var l = t - (f - a);
            return e = this, u = arguments, 0 >= l || l > t ? (o && (clearTimeout(o), o = null), a = f, i = n.apply(e, u), o || (e = u = null)) : o || r.trailing === !1 || (o = setTimeout(c,
                l)), i
        }
    }, m.debounce = function(n, t, r) {
        var e, u, i, o, a, c = function() {
            var f = m.now() - o;
            t > f && f >= 0 ? e = setTimeout(c, t - f) : (e = null, r || (a = n.apply(i, u), e || (i = u = null)))
        };
        return function() {
            i = this, u = arguments, o = m.now();
            var f = r && !e;
            return e || (e = setTimeout(c, t)), f && (a = n.apply(i, u), i = u = null), a
        }
    }, m.wrap = function(n, t) {
        return m.partial(t, n)
    }, m.negate = function(n) {
        return function() {
            return !n.apply(this, arguments)
        }
    }, m.compose = function() {
        var n = arguments,
            t = n.length - 1;
        return function() {
            for (var r = t, e = n[t].apply(this, arguments); r--;) e =
                n[r].call(this, e);
            return e
        }
    }, m.after = function(n, t) {
        return function() {
            return --n < 1 ? t.apply(this, arguments) : void 0
        }
    }, m.before = function(n, t) {
        var r;
        return function() {
            return --n > 0 && (r = t.apply(this, arguments)), 1 >= n && (t = null), r
        }
    }, m.once = m.partial(m.before, 2);
    var M = !{
            toString: null
        }.propertyIsEnumerable("toString"),
        I = ["valueOf", "isPrototypeOf", "toString", "propertyIsEnumerable", "hasOwnProperty", "toLocaleString"];
    m.keys = function(n) {
        if (!m.isObject(n)) return [];
        if (v) return v(n);
        var t = [];
        for (var r in n) m.has(n, r) &&
            t.push(r);
        return M && e(n, t), t
    }, m.allKeys = function(n) {
        if (!m.isObject(n)) return [];
        var t = [];
        for (var r in n) t.push(r);
        return M && e(n, t), t
    }, m.values = function(n) {
        for (var t = m.keys(n), r = t.length, e = Array(r), u = 0; r > u; u++) e[u] = n[t[u]];
        return e
    }, m.mapObject = function(n, t, r) {
        t = x(t, r);
        for (var e, u = m.keys(n), i = u.length, o = {}, a = 0; i > a; a++) e = u[a], o[e] = t(n[e], e, n);
        return o
    }, m.pairs = function(n) {
        for (var t = m.keys(n), r = t.length, e = Array(r), u = 0; r > u; u++) e[u] = [t[u], n[t[u]]];
        return e
    }, m.invert = function(n) {
        for (var t = {}, r = m.keys(n),
                e = 0, u = r.length; u > e; e++) t[n[r[e]]] = r[e];
        return t
    }, m.functions = m.methods = function(n) {
        var t = [];
        for (var r in n) m.isFunction(n[r]) && t.push(r);
        return t.sort()
    }, m.extend = _(m.allKeys), m.extendOwn = m.assign = _(m.keys), m.findKey = function(n, t, r) {
        t = x(t, r);
        for (var e, u = m.keys(n), i = 0, o = u.length; o > i; i++)
            if (e = u[i], t(n[e], e, n)) return e
    }, m.pick = function(n, t, r) {
        var e, u, i = {},
            o = n;
        if (null == o) return i;
        m.isFunction(t) ? (u = m.allKeys(o), e = b(t, r)) : (u = S(arguments, !1, !1, 1), e = function(n, t, r) {
            return t in r
        }, o = Object(o));
        for (var a =
                0, c = u.length; c > a; a++) {
            var f = u[a],
                l = o[f];
            e(l, f, o) && (i[f] = l)
        }
        return i
    }, m.omit = function(n, t, r) {
        if (m.isFunction(t)) t = m.negate(t);
        else {
            var e = m.map(S(arguments, !1, !1, 1), String);
            t = function(n, t) {
                return !m.contains(e, t)
            }
        }
        return m.pick(n, t, r)
    }, m.defaults = _(m.allKeys, !0), m.create = function(n, t) {
        var r = j(n);
        return t && m.extendOwn(r, t), r
    }, m.clone = function(n) {
        return m.isObject(n) ? m.isArray(n) ? n.slice() : m.extend({}, n) : n
    }, m.tap = function(n, t) {
        return t(n), n
    }, m.isMatch = function(n, t) {
        var r = m.keys(t),
            e = r.length;
        if (null ==
            n) return !e;
        for (var u = Object(n), i = 0; e > i; i++) {
            var o = r[i];
            if (t[o] !== u[o] || !(o in u)) return !1
        }
        return !0
    };
    var N = function(n, t, r, e) {
        if (n === t) return 0 !== n || 1 / n === 1 / t;
        if (null == n || null == t) return n === t;
        n instanceof m && (n = n._wrapped), t instanceof m && (t = t._wrapped);
        var u = s.call(n);
        if (u !== s.call(t)) return !1;
        switch (u) {
            case "[object RegExp]":
            case "[object String]":
                return "" + n == "" + t;
            case "[object Number]":
                return +n !== +n ? +t !== +t : 0 === +n ? 1 / +n === 1 / t : +n === +t;
            case "[object Date]":
            case "[object Boolean]":
                return +n === +t
        }
        var i =
            "[object Array]" === u;
        if (!i) {
            if ("object" != typeof n || "object" != typeof t) return !1;
            var o = n.constructor,
                a = t.constructor;
            if (o !== a && !(m.isFunction(o) && o instanceof o && m.isFunction(a) && a instanceof a) && "constructor" in n && "constructor" in t) return !1
        }
        r = r || [], e = e || [];
        for (var c = r.length; c--;)
            if (r[c] === n) return e[c] === t;
        if (r.push(n), e.push(t), i) {
            if (c = n.length, c !== t.length) return !1;
            for (; c--;)
                if (!N(n[c], t[c], r, e)) return !1
        } else {
            var f, l = m.keys(n);
            if (c = l.length, m.keys(t).length !== c) return !1;
            for (; c--;)
                if (f = l[c], !m.has(t,
                        f) || !N(n[f], t[f], r, e)) return !1
        }
        return r.pop(), e.pop(), !0
    };
    m.isEqual = function(n, t) {
            return N(n, t)
        }, m.isEmpty = function(n) {
            return null == n ? !0 : k(n) && (m.isArray(n) || m.isString(n) || m.isArguments(n)) ? 0 === n.length : 0 === m.keys(n).length
        }, m.isElement = function(n) {
            return !(!n || 1 !== n.nodeType)
        }, m.isArray = h || function(n) {
            return "[object Array]" === s.call(n)
        }, m.isObject = function(n) {
            var t = typeof n;
            return "function" === t || "object" === t && !!n
        }, m.each(["Arguments", "Function", "String", "Number", "Date", "RegExp", "Error"], function(n) {
            m["is" +
                n] = function(t) {
                return s.call(t) === "[object " + n + "]"
            }
        }), m.isArguments(arguments) || (m.isArguments = function(n) {
            return m.has(n, "callee")
        }), "function" != typeof /./ && "object" != typeof Int8Array && (m.isFunction = function(n) {
            return "function" == typeof n || !1
        }), m.isFinite = function(n) {
            return isFinite(n) && !isNaN(parseFloat(n))
        }, m.isNaN = function(n) {
            return m.isNumber(n) && n !== +n
        }, m.isBoolean = function(n) {
            return n === !0 || n === !1 || "[object Boolean]" === s.call(n)
        }, m.isNull = function(n) {
            return null === n
        }, m.isUndefined = function(n) {
            return n ===
                void 0
        }, m.has = function(n, t) {
            return null != n && p.call(n, t)
        }, m.noConflict = function() {
            return u._ = i, this
        }, m.identity = function(n) {
            return n
        }, m.constant = function(n) {
            return function() {
                return n
            }
        }, m.noop = function() {}, m.property = w, m.propertyOf = function(n) {
            return null == n ? function() {} : function(t) {
                return n[t]
            }
        }, m.matcher = m.matches = function(n) {
            return n = m.extendOwn({}, n),
                function(t) {
                    return m.isMatch(t, n)
                }
        }, m.times = function(n, t, r) {
            var e = Array(Math.max(0, n));
            t = b(t, r, 1);
            for (var u = 0; n > u; u++) e[u] = t(u);
            return e
        }, m.random =
        function(n, t) {
            return null == t && (t = n, n = 0), n + Math.floor(Math.random() * (t - n + 1))
        }, m.now = Date.now || function() {
            return (new Date).getTime()
        };
    var B = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': "&quot;",
            "'": "&#x27;",
            "`": "&#x60;"
        },
        T = m.invert(B),
        R = function(n) {
            var t = function(t) {
                    return n[t]
                },
                r = "(?:" + m.keys(n).join("|") + ")",
                e = RegExp(r),
                u = RegExp(r, "g");
            return function(n) {
                return n = null == n ? "" : "" + n, e.test(n) ? n.replace(u, t) : n
            }
        };
    m.escape = R(B), m.unescape = R(T), m.result = function(n, t, r) {
        var e = null == n ? void 0 : n[t];
        return e === void 0 &&
            (e = r), m.isFunction(e) ? e.call(n) : e
    };
    var q = 0;
    m.uniqueId = function(n) {
        var t = ++q + "";
        return n ? n + t : t
    }, m.templateSettings = {
        evaluate: /<%([\s\S]+?)%>/g,
        interpolate: /<%=([\s\S]+?)%>/g,
        escape: /<%-([\s\S]+?)%>/g
    };
    var K = /(.)^/,
        z = {
            "'": "'",
            "\\": "\\",
            "\r": "r",
            "\n": "n",
            "\u2028": "u2028",
            "\u2029": "u2029"
        },
        D = /\\|'|\r|\n|\u2028|\u2029/g,
        L = function(n) {
            return "\\" + z[n]
        };
    m.template = function(n, t, r) {
        !t && r && (t = r), t = m.defaults({}, t, m.templateSettings);
        var e = RegExp([(t.escape || K).source, (t.interpolate || K).source, (t.evaluate || K).source].join("|") +
                "|$", "g"),
            u = 0,
            i = "__p+='";
        n.replace(e, function(t, r, e, o, a) {
            return i += n.slice(u, a).replace(D, L), u = a + t.length, r ? i += "'+\n((__t=(" + r + "))==null?'':_.escape(__t))+\n'" : e ? i += "'+\n((__t=(" + e + "))==null?'':__t)+\n'" : o && (i += "';\n" + o + "\n__p+='"), t
        }), i += "';\n", t.variable || (i = "with(obj||{}){\n" + i + "}\n"), i = "var __t,__p='',__j=Array.prototype.join," + "print=function(){__p+=__j.call(arguments,'');};\n" + i + "return __p;\n";
        try {
            var o = new Function(t.variable || "obj", "_", i)
        } catch (a$4) {
            throw a$4.source = i, a$4;
        }
        var c = function(n) {
                return o.call(this,
                    n, m)
            },
            f = t.variable || "obj";
        return c.source = "function(" + f + "){\n" + i + "}", c
    }, m.chain = function(n) {
        var t = m(n);
        return t._chain = !0, t
    };
    var P = function(n, t) {
        return n._chain ? m(t).chain() : t
    };
    m.mixin = function(n) {
        m.each(m.functions(n), function(t) {
            var r = m[t] = n[t];
            m.prototype[t] = function() {
                var n = [this._wrapped];
                return f.apply(n, arguments), P(this, r.apply(m, n))
            }
        })
    }, m.mixin(m), m.each(["pop", "push", "reverse", "shift", "sort", "splice", "unshift"], function(n) {
        var t = o[n];
        m.prototype[n] = function() {
            var r = this._wrapped;
            return t.apply(r,
                arguments), "shift" !== n && "splice" !== n || 0 !== r.length || delete r[0], P(this, r)
        }
    }), m.each(["concat", "join", "slice"], function(n) {
        var t = o[n];
        m.prototype[n] = function() {
            return P(this, t.apply(this._wrapped, arguments))
        }
    }), m.prototype.value = function() {
        return this._wrapped
    }, m.prototype.valueOf = m.prototype.toJSON = m.prototype.value, m.prototype.toString = function() {
        return "" + this._wrapped
    }, "function" == typeof define && define.amd && define("underscore", [], function() {
        return m
    })
}).call(this);
(function($) {
    $.fn.alphanum = function(settings) {
        var combinedSettings = getCombinedSettingsAlphaNum(settings);
        var $collection = this;
        setupEventHandlers($collection, trimAlphaNum, combinedSettings);
        return this
    };
    $.fn.alpha = function(settings) {
        var defaultAlphaSettings = getCombinedSettingsAlphaNum("alpha");
        var combinedSettings = getCombinedSettingsAlphaNum(settings, defaultAlphaSettings);
        var $collection = this;
        setupEventHandlers($collection, trimAlphaNum, combinedSettings);
        return this
    };
    $.fn.numeric = function(settings) {
        var combinedSettings =
            getCombinedSettingsNum(settings);
        var $collection = this;
        setupEventHandlers($collection, trimNum, combinedSettings);
        $collection.blur(function() {
            numericField_Blur(this, settings)
        });
        return this
    };
    var DEFAULT_SETTINGS_ALPHANUM = {
        allow: "",
        disallow: "",
        allowSpace: true,
        allowNumeric: true,
        allowUpper: true,
        allowLower: true,
        allowCaseless: true,
        allowLatin: true,
        allowOtherCharSets: true,
        forceUpper: false,
        forceLower: false,
        maxLength: NaN
    };
    var DEFAULT_SETTINGS_NUM = {
        allowPlus: false,
        allowMinus: true,
        allowThouSep: true,
        allowDecSep: true,
        allowLeadingSpaces: false,
        maxDigits: NaN,
        maxDecimalPlaces: NaN,
        maxPreDecimalPlaces: NaN,
        max: NaN,
        min: NaN
    };
    var CONVENIENCE_SETTINGS_ALPHANUM = {
        "alpha": {
            allowNumeric: false
        },
        "upper": {
            allowNumeric: false,
            allowUpper: true,
            allowLower: false,
            allowCaseless: true
        },
        "lower": {
            allowNumeric: false,
            allowUpper: false,
            allowLower: true,
            allowCaseless: true
        }
    };
    var CONVENIENCE_SETTINGS_NUMERIC = {
        "integer": {
            allowPlus: false,
            allowMinus: true,
            allowThouSep: false,
            allowDecSep: false
        },
        "positiveInteger": {
            allowPlus: false,
            allowMinus: false,
            allowThouSep: false,
            allowDecSep: false
        }
    };
    var BLACKLIST = getBlacklistAscii() + getBlacklistNonAscii();
    var THOU_SEP = ",";
    var DEC_SEP = ".";
    var DIGITS = getDigitsMap();
    var LATIN_CHARS = getLatinCharsSet();

    function getBlacklistAscii() {
        var blacklist = "!@#$%^&*()+=[]\\';,/{}|\":<>?~`.-_";
        blacklist += " ";
        return blacklist
    }

    function getBlacklistNonAscii() {
        var blacklist = "\u00ac" + "\u20ac" + "\u00a3" + "\u00a6";
        return blacklist
    }

    function setupEventHandlers($textboxes, trimFunction, settings) {
        $textboxes.each(function() {
            var $textbox = $(this);
            $textbox.bind("keyup change paste",
                function(e) {
                    var pastedText = "";
                    if (e.originalEvent && e.originalEvent.clipboardData && e.originalEvent.clipboardData.getData) pastedText = e.originalEvent.clipboardData.getData("text/plain");
                    setTimeout(function() {
                        trimTextbox($textbox, trimFunction, settings, pastedText)
                    }, 0)
                });
            $textbox.bind("keypress", function(e) {
                var charCode = !e.charCode ? e.which : e.charCode;
                if (isControlKey(charCode) || e.ctrlKey || e.metaKey) return;
                var newChar = String.fromCharCode(charCode);
                var selectionObject = $textbox.selection();
                var start = selectionObject.start;
                var end = selectionObject.end;
                var textBeforeKeypress = $textbox.val();
                var potentialTextAfterKeypress = textBeforeKeypress.substring(0, start) + newChar + textBeforeKeypress.substring(end);
                var validatedText = trimFunction(potentialTextAfterKeypress, settings);
                if (validatedText != potentialTextAfterKeypress) e.preventDefault()
            })
        })
    }

    function numericField_Blur(inputBox, settings) {
        var fieldValueNumeric = parseFloat($(inputBox).val());
        var $inputBox = $(inputBox);
        if (isNaN(fieldValueNumeric)) {
            $inputBox.val("");
            return
        }
        if (isNumeric(settings.min) &&
            fieldValueNumeric < settings.min) $inputBox.val("");
        if (isNumeric(settings.max) && fieldValueNumeric > settings.max) $inputBox.val("")
    }

    function isNumeric(value) {
        return !isNaN(value)
    }

    function isControlKey(charCode) {
        if (charCode >= 32) return false;
        if (charCode == 10) return false;
        if (charCode == 13) return false;
        return true
    }

    function trimTextbox($textBox, trimFunction, settings, pastedText) {
        var inputString = $textBox.val();
        if (inputString == "" && pastedText.length > 0) inputString = pastedText;
        var outputString = trimFunction(inputString,
            settings);
        if (inputString == outputString) return;
        var caretPos = $textBox.alphanum_caret();
        $textBox.val(outputString);
        if (inputString.length == outputString.length + 1) $textBox.alphanum_caret(caretPos - 1);
        else $textBox.alphanum_caret(caretPos)
    }

    function getCombinedSettingsAlphaNum(settings, defaultSettings) {
        if (typeof defaultSettings == "undefined") defaultSettings = DEFAULT_SETTINGS_ALPHANUM;
        var userSettings, combinedSettings = {};
        if (typeof settings === "string") userSettings = CONVENIENCE_SETTINGS_ALPHANUM[settings];
        else if (typeof settings ==
            "undefined") userSettings = {};
        else userSettings = settings;
        $.extend(combinedSettings, defaultSettings, userSettings);
        if (typeof combinedSettings.blacklist == "undefined") combinedSettings.blacklistSet = getBlacklistSet(combinedSettings.allow, combinedSettings.disallow);
        return combinedSettings
    }

    function getCombinedSettingsNum(settings) {
        var userSettings, combinedSettings = {};
        if (typeof settings === "string") userSettings = CONVENIENCE_SETTINGS_NUMERIC[settings];
        else if (typeof settings == "undefined") userSettings = {};
        else userSettings =
            settings;
        $.extend(combinedSettings, DEFAULT_SETTINGS_NUM, userSettings);
        return combinedSettings
    }

    function alphanum_allowChar(validatedStringFragment, Char, settings) {
        if (settings.maxLength && validatedStringFragment.length >= settings.maxLength) return false;
        if (settings.allow.indexOf(Char) >= 0) return true;
        if (settings.allowSpace && Char == " ") return true;
        if (settings.blacklistSet.contains(Char)) return false;
        if (!settings.allowNumeric && DIGITS[Char]) return false;
        if (!settings.allowUpper && isUpper(Char)) return false;
        if (!settings.allowLower &&
            isLower(Char)) return false;
        if (!settings.allowCaseless && isCaseless(Char)) return false;
        if (!settings.allowLatin && LATIN_CHARS.contains(Char)) return false;
        if (!settings.allowOtherCharSets)
            if (DIGITS[Char] || LATIN_CHARS.contains(Char)) return true;
            else return false;
        return true
    }

    function numeric_allowChar(validatedStringFragment, Char, settings) {
        if (DIGITS[Char]) {
            if (isMaxDigitsReached(validatedStringFragment, settings)) return false;
            if (isMaxPreDecimalsReached(validatedStringFragment, settings)) return false;
            if (isMaxDecimalsReached(validatedStringFragment,
                    settings)) return false;
            if (isGreaterThanMax(validatedStringFragment + Char, settings)) return false;
            if (isLessThanMin(validatedStringFragment + Char, settings)) return false;
            return true
        }
        if (settings.allowPlus && Char == "+" && validatedStringFragment == "") return true;
        if (settings.allowMinus && Char == "-" && validatedStringFragment == "") return true;
        if (Char == THOU_SEP && settings.allowThouSep && allowThouSep(validatedStringFragment, Char)) return true;
        if (Char == DEC_SEP) {
            if (validatedStringFragment.indexOf(DEC_SEP) >= 0) return false;
            if (settings.allowDecSep) return true
        }
        return false
    }

    function countDigits(string) {
        string = string + "";
        return string.replace(/[^0-9]/g, "").length
    }

    function isMaxDigitsReached(string, settings) {
        var maxDigits = settings.maxDigits;
        if (maxDigits == "" || isNaN(maxDigits)) return false;
        var numDigits = countDigits(string);
        if (numDigits >= maxDigits) return true;
        return false
    }

    function isMaxDecimalsReached(string, settings) {
        var maxDecimalPlaces = settings.maxDecimalPlaces;
        if (maxDecimalPlaces == "" || isNaN(maxDecimalPlaces)) return false;
        var indexOfDecimalPoint = string.indexOf(DEC_SEP);
        if (indexOfDecimalPoint == -1) return false;
        var decimalSubstring = string.substring(indexOfDecimalPoint);
        var numDecimals = countDigits(decimalSubstring);
        if (numDecimals >= maxDecimalPlaces) return true;
        return false
    }

    function isMaxPreDecimalsReached(string, settings) {
        var maxPreDecimalPlaces = settings.maxPreDecimalPlaces;
        if (maxPreDecimalPlaces == "" || isNaN(maxPreDecimalPlaces)) return false;
        var indexOfDecimalPoint = string.indexOf(DEC_SEP);
        if (indexOfDecimalPoint >= 0) return false;
        var numPreDecimalDigits = countDigits(string);
        if (numPreDecimalDigits >= maxPreDecimalPlaces) return true;
        return false
    }

    function isGreaterThanMax(numericString, settings) {
        if (!settings.max || settings.max < 0) return false;
        var outputNumber = parseFloat(numericString);
        if (outputNumber > settings.max) return true;
        return false
    }

    function isLessThanMin(numericString, settings) {
        if (!settings.min || settings.min > 0) return false;
        var outputNumber = parseFloat(numericString);
        if (outputNumber < settings.min) return true;
        return false
    }

    function trimAlphaNum(inputString, settings) {
        if (typeof inputString !=
            "string") return inputString;
        var inChars = inputString.split("");
        var outChars = [];
        var i = 0;
        var Char;
        for (i = 0; i < inChars.length; i++) {
            Char = inChars[i];
            var validatedStringFragment = outChars.join("");
            if (alphanum_allowChar(validatedStringFragment, Char, settings)) outChars.push(Char)
        }
        var outputString = outChars.join("");
        if (settings.forceLower) outputString = outputString.toLowerCase();
        else if (settings.forceUpper) outputString = outputString.toUpperCase();
        return outputString
    }

    function trimNum(inputString, settings) {
        if (typeof inputString !=
            "string") return inputString;
        var inChars = inputString.split("");
        var outChars = [];
        var i = 0;
        var Char;
        for (i = 0; i < inChars.length; i++) {
            Char = inChars[i];
            var validatedStringFragment = outChars.join("");
            if (numeric_allowChar(validatedStringFragment, Char, settings)) outChars.push(Char)
        }
        return outChars.join("")
    }

    function removeUpperCase(inputString) {
        var charArray = inputString.split("");
        var i = 0;
        var outputArray = [];
        var Char;
        for (i = 0; i < charArray.length; i++) Char = charArray[i]
    }

    function removeLowerCase(inputString) {}

    function isUpper(Char) {
        var upper =
            Char.toUpperCase();
        var lower = Char.toLowerCase();
        if (Char == upper && upper != lower) return true;
        else return false
    }

    function isLower(Char) {
        var upper = Char.toUpperCase();
        var lower = Char.toLowerCase();
        if (Char == lower && upper != lower) return true;
        else return false
    }

    function isCaseless(Char) {
        if (Char.toUpperCase() == Char.toLowerCase()) return true;
        else return false
    }

    function getBlacklistSet(allow, disallow) {
        var setOfBadChars = new Set(BLACKLIST + disallow);
        var setOfGoodChars = new Set(allow);
        var blacklistSet = setOfBadChars.subtract(setOfGoodChars);
        return blacklistSet
    }

    function getDigitsMap() {
        var array = "0123456789".split("");
        var map = {};
        var i = 0;
        var digit;
        for (i = 0; i < array.length; i++) {
            digit = array[i];
            map[digit] = true
        }
        return map
    }

    function getLatinCharsSet() {
        var lower = "abcdefghijklmnopqrstuvwxyz";
        var upper = lower.toUpperCase();
        var azAZ = new Set(lower + upper);
        return azAZ
    }

    function allowThouSep(currentString, Char) {
        if (currentString.length == 0) return false;
        var posOfDecSep = currentString.indexOf(DEC_SEP);
        if (posOfDecSep >= 0) return false;
        var posOfFirstThouSep = currentString.indexOf(THOU_SEP);
        if (posOfFirstThouSep < 0) return true;
        var posOfLastThouSep = currentString.lastIndexOf(THOU_SEP);
        var charsSinceLastThouSep = currentString.length - posOfLastThouSep - 1;
        if (charsSinceLastThouSep < 3) return false;
        var digitsSinceFirstThouSep = countDigits(currentString.substring(posOfFirstThouSep));
        if (digitsSinceFirstThouSep % 3 > 0) return false;
        return true
    }

    function Set(elems) {
        if (typeof elems == "string") this.map = stringToMap(elems);
        else this.map = {}
    }
    Set.prototype.add = function(set) {
        var newSet = this.clone();
        for (var key in set.map) newSet.map[key] =
            true;
        return newSet
    };
    Set.prototype.subtract = function(set) {
        var newSet = this.clone();
        for (var key in set.map) delete newSet.map[key];
        return newSet
    };
    Set.prototype.contains = function(key) {
        if (this.map[key]) return true;
        else return false
    };
    Set.prototype.clone = function() {
        var newSet = new Set;
        for (var key in this.map) newSet.map[key] = true;
        return newSet
    };

    function stringToMap(string) {
        var map = {};
        var array = string.split("");
        var i = 0;
        var Char;
        for (i = 0; i < array.length; i++) {
            Char = array[i];
            map[Char] = true
        }
        return map
    }
    $.fn.alphanum.backdoorAlphaNum =
        function(inputString, settings) {
            var combinedSettings = getCombinedSettingsAlphaNum(settings);
            return trimAlphaNum(inputString, combinedSettings)
        };
    $.fn.alphanum.backdoorNumeric = function(inputString, settings) {
        var combinedSettings = getCombinedSettingsNum(settings);
        return trimNum(inputString, combinedSettings)
    };
    $.fn.alphanum.setNumericSeparators = function(settings) {
        if (settings.thousandsSeparator.length != 1) return;
        if (settings.decimalSeparator.length != 1) return;
        THOU_SEP = settings.thousandsSeparator;
        DEC_SEP = settings.decimalSeparator
    }
})(jQuery);
(function($) {
    function caretTo(el, index) {
        if (el.createTextRange) {
            var range = el.createTextRange();
            range.move("character", index);
            range.select()
        } else if (el.selectionStart != null) {
            el.focus();
            el.setSelectionRange(index, index)
        }
    }

    function caretPos(el) {
        if ("selection" in document) {
            var range = el.createTextRange();
            try {
                range.setEndPoint("EndToStart", document.selection.createRange())
            } catch (e) {
                return 0
            }
            return range.text.length
        } else if (el.selectionStart != null) return el.selectionStart
    }
    $.fn.alphanum_caret = function(index,
        offset) {
        if (typeof index === "undefined") return caretPos(this.get(0));
        return this.queue(function(next) {
            if (isNaN(index)) {
                var i = $(this).val().indexOf(index);
                if (offset === true) i += index.length;
                else if (typeof offset !== "undefined") i += offset;
                caretTo(this, i)
            } else caretTo(this, index);
            next()
        })
    }
})(jQuery);
(function(e) {
    var t = function(e) {
            return e.replace(/([a-z])([a-z]+)/gi, function(e, t, n) {
                return t + n.toLowerCase()
            }).replace(/_/g, "")
        },
        n = function(e) {
            return e.replace(/^([a-z]+)_TO_([a-z]+)/i, function(e, t, n) {
                return n + "_TO_" + t
            })
        },
        r = function(e) {
            return e ? e.ownerDocument.defaultView || e.ownerDocument.parentWindow : window
        },
        i = function(t, n) {
            var r = e.Range.current(t).clone(),
                i = e.Range(t).select(t);
            if (!r.overlaps(i)) return null;
            if (r.compare("START_TO_START", i) < 1) {
                startPos = 0;
                r.move("START_TO_START", i)
            } else {
                fromElementToCurrent =
                    i.clone();
                fromElementToCurrent.move("END_TO_START", r);
                startPos = fromElementToCurrent.toString().length
            }
            if (r.compare("END_TO_END", i) >= 0) endPos = i.toString().length;
            else endPos = startPos + r.toString().length;
            return {
                start: startPos,
                end: endPos
            }
        },
        s = function(t) {
            var n = r(t);
            if (t.selectionStart !== undefined) {
                if (document.activeElement && document.activeElement != t && t.selectionStart == t.selectionEnd && t.selectionStart == 0) return {
                    start: t.value.length,
                    end: t.value.length
                };
                return {
                    start: t.selectionStart,
                    end: t.selectionEnd
                }
            } else if (n.getSelection) return i(t,
                n);
            else try {
                if (t.nodeName.toLowerCase() == "input") {
                    var s = r(t).document.selection.createRange(),
                        o = t.createTextRange();
                    o.setEndPoint("EndToStart", s);
                    var u = o.text.length;
                    return {
                        start: u,
                        end: u + s.text.length
                    }
                } else {
                    var a = i(t, n);
                    if (!a) return a;
                    var f = e.Range.current().clone(),
                        l = f.clone().collapse().range,
                        c = f.clone().collapse(false).range;
                    l.moveStart("character", -1);
                    c.moveStart("character", -1);
                    if (a.startPos != 0 && l.text == "") a.startPos += 2;
                    if (a.endPos != 0 && c.text == "") a.endPos += 2;
                    return a
                }
            } catch (h) {
                return {
                    start: t.value.length,
                    end: t.value.length
                }
            }
        },
        o = function(e, t, n) {
            var i = r(e);
            if (e.setSelectionRange)
                if (n === undefined) {
                    e.focus();
                    e.setSelectionRange(t, t)
                } else {
                    e.select();
                    e.selectionStart = t;
                    e.selectionEnd = n
                } else if (e.createTextRange) {
                var s = e.createTextRange();
                s.moveStart("character", t);
                n = n || t;
                s.moveEnd("character", n - e.value.length);
                s.select()
            } else if (i.getSelection) {
                var o = i.document,
                    u = i.getSelection(),
                    f = o.createRange(),
                    l = [t, n !== undefined ? n : t];
                a([e], l);
                f.setStart(l[0].el, l[0].count);
                f.setEnd(l[1].el, l[1].count);
                u.removeAllRanges();
                u.addRange(f)
            } else if (i.document.body.createTextRange) {
                var f = document.body.createTextRange();
                f.moveToElementText(e);
                f.collapse();
                f.moveStart("character", t);
                f.moveEnd("character", n !== undefined ? n : t);
                f.select()
            }
        },
        u = function(e, t, n, r) {
            if (typeof n[0] === "number" && n[0] < t) n[0] = {
                el: r,
                count: n[0] - e
            };
            if (typeof n[1] === "number" && n[1] <= t) n[1] = {
                el: r,
                count: n[1] - e
            }
        },
        a = function(e, t, n) {
            var r, i;
            n = n || 0;
            for (var s = 0; e[s]; s++) {
                r = e[s];
                if (r.nodeType === 3 || r.nodeType === 4) {
                    i = n;
                    n += r.nodeValue.length;
                    u(i, n, t, r)
                } else if (r.nodeType !==
                    8) n = a(r.childNodes, t, n)
            }
            return n
        };
    jQuery.fn.selection = function(e, t) {
        if (e !== undefined) return this.each(function() {
            o(this, e, t)
        });
        else return s(this[0])
    };
    e.fn.selection.getCharElement = a
})(jQuery);
! function(o) {
    "object" == typeof module && "object" == typeof module.exports ? o(require("jquery"), window, document) : o(jQuery, window, document)
}(function(o, t, e, i) {
    var s = [],
        l = function() {
            return s.length ? s[s.length - 1] : null
        },
        n = function() {
            var o, t = !1;
            for (o = s.length - 1; o >= 0; o--) s[o].$blocker && (s[o].$blocker.toggleClass("current", !t).toggleClass("behind", t), t = !0)
        };
    o.modal = function(t, e) {
            var i, n;
            if (this.$body = o("body"), this.options = o.extend({}, o.modal.defaults, e), this.options.doFade = !isNaN(parseInt(this.options.fadeDuration,
                    10)), this.$blocker = null, this.options.closeExisting)
                for (; o.modal.isActive();) o.modal.close();
            if (s.push(this), t.is("a"))
                if (n = t.attr("href"), /^#/.test(n)) {
                    if (this.$elm = o(n), 1 !== this.$elm.length) return null;
                    this.$body.append(this.$elm), this.open()
                } else this.$elm = o("<div>"), this.$body.append(this.$elm), i = function(o, t) {
                    t.elm.remove()
                }, this.showSpinner(), t.trigger(o.modal.AJAX_SEND), o.get(n).done(function(e) {
                    if (o.modal.isActive()) {
                        t.trigger(o.modal.AJAX_SUCCESS);
                        var s = l();
                        s.$elm.empty().append(e).on(o.modal.CLOSE,
                            i), s.hideSpinner(), s.open(), t.trigger(o.modal.AJAX_COMPLETE)
                    }
                }).fail(function() {
                    t.trigger(o.modal.AJAX_FAIL);
                    var e = l();
                    e.hideSpinner(), s.pop(), t.trigger(o.modal.AJAX_COMPLETE)
                });
            else this.$elm = t, this.$body.append(this.$elm), this.open()
        }, o.modal.prototype = {
            constructor: o.modal,
            open: function() {
                var t = this;
                this.block(), this.options.doFade ? setTimeout(function() {
                    t.show()
                }, this.options.fadeDuration * this.options.fadeDelay) : this.show(), o(e).off("keydown.modal").on("keydown.modal", function(o) {
                    var t = l();
                    27 ==
                        o.which && t.options.escapeClose && t.close()
                }), this.options.clickClose && this.$blocker.click(function(t) {
                    t.target == this && o.modal.close()
                })
            },
            close: function() {
                s.pop(), this.unblock(), this.hide(), o.modal.isActive() || o(e).off("keydown.modal")
            },
            block: function() {
                this.$elm.trigger(o.modal.BEFORE_BLOCK, [this._ctx()]), this.$body.css("overflow", "hidden"), this.$blocker = o('<div class="jquery-modal blocker current"></div>').appendTo(this.$body), n(), this.options.doFade && this.$blocker.css("opacity", 0).animate({
                        opacity: 1
                    },
                    this.options.fadeDuration), this.$elm.trigger(o.modal.BLOCK, [this._ctx()])
            },
            unblock: function(t) {
                !t && this.options.doFade ? this.$blocker.fadeOut(this.options.fadeDuration, this.unblock.bind(this, !0)) : (this.$blocker.children().appendTo(this.$body), this.$blocker.remove(), this.$blocker = null, n(), o.modal.isActive() || this.$body.css("overflow", ""))
            },
            show: function() {
                this.$elm.trigger(o.modal.BEFORE_OPEN, [this._ctx()]), this.options.showClose && (this.closeButton = o('<a href="#close-modal" rel="modal:close" class="close-modal ' +
                    this.options.closeClass + '">' + this.options.closeText + "</a>"), this.$elm.append(this.closeButton)), this.$elm.addClass(this.options.modalClass).appendTo(this.$blocker), this.options.doFade ? this.$elm.css("opacity", 0).show().animate({
                    opacity: 1
                }, this.options.fadeDuration) : this.$elm.show(), this.$elm.trigger(o.modal.OPEN, [this._ctx()])
            },
            hide: function() {
                this.$elm.trigger(o.modal.BEFORE_CLOSE, [this._ctx()]), this.closeButton && this.closeButton.remove();
                var t = this;
                this.options.doFade ? this.$elm.fadeOut(this.options.fadeDuration,
                    function() {
                        t.$elm.trigger(o.modal.AFTER_CLOSE, [t._ctx()])
                    }) : this.$elm.hide(0, function() {
                    t.$elm.trigger(o.modal.AFTER_CLOSE, [t._ctx()])
                }), this.$elm.trigger(o.modal.CLOSE, [this._ctx()])
            },
            showSpinner: function() {
                this.options.showSpinner && (this.spinner = this.spinner || o('<div class="' + this.options.modalClass + '-spinner"></div>').append(this.options.spinnerHtml), this.$body.append(this.spinner), this.spinner.show())
            },
            hideSpinner: function() {
                this.spinner && this.spinner.remove()
            },
            _ctx: function() {
                return {
                    elm: this.$elm,
                    $blocker: this.$blocker,
                    options: this.options
                }
            }
        }, o.modal.close = function(t) {
            if (o.modal.isActive()) {
                t && t.preventDefault();
                var e = l();
                return e.close(), e.$elm
            }
        }, o.modal.isActive = function() {
            return s.length > 0
        }, o.modal.getCurrent = l, o.modal.defaults = {
            closeExisting: !0,
            escapeClose: !0,
            clickClose: !0,
            closeText: "Close",
            closeClass: "",
            modalClass: "modal",
            spinnerHtml: null,
            showSpinner: !0,
            showClose: !0,
            fadeDuration: null,
            fadeDelay: 1
        }, o.modal.BEFORE_BLOCK = "modal:before-block", o.modal.BLOCK = "modal:block", o.modal.BEFORE_OPEN =
        "modal:before-open", o.modal.OPEN = "modal:open", o.modal.BEFORE_CLOSE = "modal:before-close", o.modal.CLOSE = "modal:close", o.modal.AFTER_CLOSE = "modal:after-close", o.modal.AJAX_SEND = "modal:ajax:send", o.modal.AJAX_SUCCESS = "modal:ajax:success", o.modal.AJAX_FAIL = "modal:ajax:fail", o.modal.AJAX_COMPLETE = "modal:ajax:complete", o.fn.modal = function(t) {
            return 1 === this.length && new o.modal(this, t), this
        }, o(e).on("click.modal", 'a[rel~="modal:close"]', o.modal.close), o(e).on("click.modal", 'a[rel~="modal:open"]', function(t) {
            t.preventDefault(),
                o(this).modal()
        })
});
(function(t) {
    "function" == typeof define && define.amd ? define(["jquery"], t) : t(jQuery)
})(function(t) {
    t.ui = t.ui || {}, t.ui.version = "1.12.1";
    var e = 0,
        i = Array.prototype.slice;
    t.cleanData = function(e) {
            return function(i) {
                var s, n, o;
                for (o = 0; null != (n = i[o]); o++) try {
                    s = t._data(n, "events"), s && s.remove && t(n).triggerHandler("remove")
                } catch (a) {}
                e(i)
            }
        }(t.cleanData), t.widget = function(e, i, s) {
            var n, o, a, r = {},
                l = e.split(".")[0];
            e = e.split(".")[1];
            var h = l + "-" + e;
            return s || (s = i, i = t.Widget), t.isArray(s) && (s = t.extend.apply(null, [{}].concat(s))),
                t.expr[":"][h.toLowerCase()] = function(e) {
                    return !!t.data(e, h)
                }, t[l] = t[l] || {}, n = t[l][e], o = t[l][e] = function(t, e) {
                    return this._createWidget ? (arguments.length && this._createWidget(t, e), void 0) : new o(t, e)
                }, t.extend(o, n, {
                    version: s.version,
                    _proto: t.extend({}, s),
                    _childConstructors: []
                }), a = new i, a.options = t.widget.extend({}, a.options), t.each(s, function(e, s) {
                    return t.isFunction(s) ? (r[e] = function() {
                        function t() {
                            return i.prototype[e].apply(this, arguments)
                        }

                        function n(t) {
                            return i.prototype[e].apply(this, t)
                        }
                        return function() {
                            var e,
                                i = this._super,
                                o = this._superApply;
                            return this._super = t, this._superApply = n, e = s.apply(this, arguments), this._super = i, this._superApply = o, e
                        }
                    }(), void 0) : (r[e] = s, void 0)
                }), o.prototype = t.widget.extend(a, {
                    widgetEventPrefix: n ? a.widgetEventPrefix || e : e
                }, r, {
                    constructor: o,
                    namespace: l,
                    widgetName: e,
                    widgetFullName: h
                }), n ? (t.each(n._childConstructors, function(e, i) {
                    var s = i.prototype;
                    t.widget(s.namespace + "." + s.widgetName, o, i._proto)
                }), delete n._childConstructors) : i._childConstructors.push(o), t.widget.bridge(e, o), o
        }, t.widget.extend =
        function(e) {
            for (var s, n, o = i.call(arguments, 1), a = 0, r = o.length; r > a; a++)
                for (s in o[a]) n = o[a][s], o[a].hasOwnProperty(s) && void 0 !== n && (e[s] = t.isPlainObject(n) ? t.isPlainObject(e[s]) ? t.widget.extend({}, e[s], n) : t.widget.extend({}, n) : n);
            return e
        }, t.widget.bridge = function(e, s) {
            var n = s.prototype.widgetFullName || e;
            t.fn[e] = function(o) {
                var a = "string" == typeof o,
                    r = i.call(arguments, 1),
                    l = this;
                return a ? this.length || "instance" !== o ? this.each(function() {
                    var i, s = t.data(this, n);
                    return "instance" === o ? (l = s, !1) : s ? t.isFunction(s[o]) &&
                        "_" !== o.charAt(0) ? (i = s[o].apply(s, r), i !== s && void 0 !== i ? (l = i && i.jquery ? l.pushStack(i.get()) : i, !1) : void 0) : t.error("no such method '" + o + "' for " + e + " widget instance") : t.error("cannot call methods on " + e + " prior to initialization; " + "attempted to call method '" + o + "'")
                }) : l = void 0 : (r.length && (o = t.widget.extend.apply(null, [o].concat(r))), this.each(function() {
                    var e = t.data(this, n);
                    e ? (e.option(o || {}), e._init && e._init()) : t.data(this, n, new s(o, this))
                })), l
            }
        }, t.Widget = function() {}, t.Widget._childConstructors = [], t.Widget.prototype = {
            widgetName: "widget",
            widgetEventPrefix: "",
            defaultElement: "<div>",
            options: {
                classes: {},
                disabled: !1,
                create: null
            },
            _createWidget: function(i, s) {
                s = t(s || this.defaultElement || this)[0], this.element = t(s), this.uuid = e++, this.eventNamespace = "." + this.widgetName + this.uuid, this.bindings = t(), this.hoverable = t(), this.focusable = t(), this.classesElementLookup = {}, s !== this && (t.data(s, this.widgetFullName, this), this._on(!0, this.element, {
                        remove: function(t) {
                            t.target === s && this.destroy()
                        }
                    }), this.document =
                    t(s.style ? s.ownerDocument : s.document || s), this.window = t(this.document[0].defaultView || this.document[0].parentWindow)), this.options = t.widget.extend({}, this.options, this._getCreateOptions(), i), this._create(), this.options.disabled && this._setOptionDisabled(this.options.disabled), this._trigger("create", null, this._getCreateEventData()), this._init()
            },
            _getCreateOptions: function() {
                return {}
            },
            _getCreateEventData: t.noop,
            _create: t.noop,
            _init: t.noop,
            destroy: function() {
                var e = this;
                this._destroy(), t.each(this.classesElementLookup,
                    function(t, i) {
                        e._removeClass(i, t)
                    }), this.element.off(this.eventNamespace).removeData(this.widgetFullName), this.widget().off(this.eventNamespace).removeAttr("aria-disabled"), this.bindings.off(this.eventNamespace)
            },
            _destroy: t.noop,
            widget: function() {
                return this.element
            },
            option: function(e, i) {
                var s, n, o, a = e;
                if (0 === arguments.length) return t.widget.extend({}, this.options);
                if ("string" == typeof e)
                    if (a = {}, s = e.split("."), e = s.shift(), s.length) {
                        for (n = a[e] = t.widget.extend({}, this.options[e]), o = 0; s.length - 1 > o; o++) n[s[o]] =
                            n[s[o]] || {}, n = n[s[o]];
                        if (e = s.pop(), 1 === arguments.length) return void 0 === n[e] ? null : n[e];
                        n[e] = i
                    } else {
                        if (1 === arguments.length) return void 0 === this.options[e] ? null : this.options[e];
                        a[e] = i
                    }
                return this._setOptions(a), this
            },
            _setOptions: function(t) {
                var e;
                for (e in t) this._setOption(e, t[e]);
                return this
            },
            _setOption: function(t, e) {
                return "classes" === t && this._setOptionClasses(e), this.options[t] = e, "disabled" === t && this._setOptionDisabled(e), this
            },
            _setOptionClasses: function(e) {
                var i, s, n;
                for (i in e) n = this.classesElementLookup[i],
                    e[i] !== this.options.classes[i] && n && n.length && (s = t(n.get()), this._removeClass(n, i), s.addClass(this._classes({
                        element: s,
                        keys: i,
                        classes: e,
                        add: !0
                    })))
            },
            _setOptionDisabled: function(t) {
                this._toggleClass(this.widget(), this.widgetFullName + "-disabled", null, !!t), t && (this._removeClass(this.hoverable, null, "ui-state-hover"), this._removeClass(this.focusable, null, "ui-state-focus"))
            },
            enable: function() {
                return this._setOptions({
                    disabled: !1
                })
            },
            disable: function() {
                return this._setOptions({
                    disabled: !0
                })
            },
            _classes: function(e) {
                function i(i,
                    o) {
                    var a, r;
                    for (r = 0; i.length > r; r++) a = n.classesElementLookup[i[r]] || t(), a = e.add ? t(t.unique(a.get().concat(e.element.get()))) : t(a.not(e.element).get()), n.classesElementLookup[i[r]] = a, s.push(i[r]), o && e.classes[i[r]] && s.push(e.classes[i[r]])
                }
                var s = [],
                    n = this;
                return e = t.extend({
                    element: this.element,
                    classes: this.options.classes || {}
                }, e), this._on(e.element, {
                    remove: "_untrackClassesElement"
                }), e.keys && i(e.keys.match(/\S+/g) || [], !0), e.extra && i(e.extra.match(/\S+/g) || []), s.join(" ")
            },
            _untrackClassesElement: function(e) {
                var i =
                    this;
                t.each(i.classesElementLookup, function(s, n) {
                    -1 !== t.inArray(e.target, n) && (i.classesElementLookup[s] = t(n.not(e.target).get()))
                })
            },
            _removeClass: function(t, e, i) {
                return this._toggleClass(t, e, i, !1)
            },
            _addClass: function(t, e, i) {
                return this._toggleClass(t, e, i, !0)
            },
            _toggleClass: function(t, e, i, s) {
                s = "boolean" == typeof s ? s : i;
                var n = "string" == typeof t || null === t,
                    o = {
                        extra: n ? e : i,
                        keys: n ? t : e,
                        element: n ? this.element : t,
                        add: s
                    };
                return o.element.toggleClass(this._classes(o), s), this
            },
            _on: function(e, i, s) {
                var n, o = this;
                "boolean" !=
                typeof e && (s = i, i = e, e = !1), s ? (i = n = t(i), this.bindings = this.bindings.add(i)) : (s = i, i = this.element, n = this.widget()), t.each(s, function(s, a) {
                    function r() {
                        return e || o.options.disabled !== !0 && !t(this).hasClass("ui-state-disabled") ? ("string" == typeof a ? o[a] : a).apply(o, arguments) : void 0
                    }
                    "string" != typeof a && (r.guid = a.guid = a.guid || r.guid || t.guid++);
                    var l = s.match(/^([\w:-]*)\s*(.*)$/),
                        h = l[1] + o.eventNamespace,
                        c = l[2];
                    c ? n.on(h, c, r) : i.on(h, r)
                })
            },
            _off: function(e, i) {
                i = (i || "").split(" ").join(this.eventNamespace + " ") + this.eventNamespace,
                    e.off(i).off(i), this.bindings = t(this.bindings.not(e).get()), this.focusable = t(this.focusable.not(e).get()), this.hoverable = t(this.hoverable.not(e).get())
            },
            _delay: function(t, e) {
                function i() {
                    return ("string" == typeof t ? s[t] : t).apply(s, arguments)
                }
                var s = this;
                return setTimeout(i, e || 0)
            },
            _hoverable: function(e) {
                this.hoverable = this.hoverable.add(e), this._on(e, {
                    mouseenter: function(e) {
                        this._addClass(t(e.currentTarget), null, "ui-state-hover")
                    },
                    mouseleave: function(e) {
                        this._removeClass(t(e.currentTarget), null, "ui-state-hover")
                    }
                })
            },
            _focusable: function(e) {
                this.focusable = this.focusable.add(e), this._on(e, {

                    focusin: function(e) {
                        this._addClass(t(e.currentTarget), null, "ui-state-focus")
                    },
                    focusout: function(e) {
                        this._removeClass(t(e.currentTarget), null, "ui-state-focus")
                    }
                })
            },
            _trigger: function(e, i, s) {
                var n, o, a = this.options[e];
                if (s = s || {}, i = t.Event(i), i.type = (e === this.widgetEventPrefix ? e : this.widgetEventPrefix + e).toLowerCase(), i.target = this.element[0], o = i.originalEvent)
                    for (n in o) n in i || (i[n] = o[n]);
                return this.element.trigger(i, s), !(t.isFunction(a) &&
                    a.apply(this.element[0], [i].concat(s)) === !1 || i.isDefaultPrevented())
            }
        }, t.each({
            show: "fadeIn",
            hide: "fadeOut"
        }, function(e, i) {
            t.Widget.prototype["_" + e] = function(s, n, o) {
                "string" == typeof n && (n = {
                    effect: n
                });
                var a, r = n ? n === !0 || "number" == typeof n ? i : n.effect || i : e;
                n = n || {}, "number" == typeof n && (n = {
                    duration: n
                }), a = !t.isEmptyObject(n), n.complete = o, n.delay && s.delay(n.delay), a && t.effects && t.effects.effect[r] ? s[e](n) : r !== e && s[r] ? s[r](n.duration, n.easing, o) : s.queue(function(i) {
                    t(this)[e](), o && o.call(s[0]), i()
                })
            }
        }), t.widget,
        function() {
            function e(t, e, i) {
                return [parseFloat(t[0]) * (u.test(t[0]) ? e / 100 : 1), parseFloat(t[1]) * (u.test(t[1]) ? i / 100 : 1)]
            }

            function i(e, i) {
                return parseInt(t.css(e, i), 10) || 0
            }

            function s(e) {
                var i = e[0];
                return 9 === i.nodeType ? {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: 0,
                        left: 0
                    }
                } : t.isWindow(i) ? {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: e.scrollTop(),
                        left: e.scrollLeft()
                    }
                } : i.preventDefault ? {
                    width: 0,
                    height: 0,
                    offset: {
                        top: i.pageY,
                        left: i.pageX
                    }
                } : {
                    width: e.outerWidth(),
                    height: e.outerHeight(),
                    offset: e.offset()
                }
            }
            var n, o = Math.max,
                a = Math.abs,
                r = /left|center|right/,
                l = /top|center|bottom/,
                h = /[\+\-]\d+(\.[\d]+)?%?/,
                c = /^\w+/,
                u = /%$/,
                d = t.fn.position;
            t.position = {
                scrollbarWidth: function() {
                    if (void 0 !== n) return n;
                    var e, i, s = t("<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"),
                        o = s.children()[0];
                    return t("body").append(s), e = o.offsetWidth, s.css("overflow", "scroll"), i = o.offsetWidth, e === i && (i = s[0].clientWidth), s.remove(), n = e - i
                },
                getScrollInfo: function(e) {
                    var i =
                        e.isWindow || e.isDocument ? "" : e.element.css("overflow-x"),
                        s = e.isWindow || e.isDocument ? "" : e.element.css("overflow-y"),
                        n = "scroll" === i || "auto" === i && e.width < e.element[0].scrollWidth,
                        o = "scroll" === s || "auto" === s && e.height < e.element[0].scrollHeight;
                    return {
                        width: o ? t.position.scrollbarWidth() : 0,
                        height: n ? t.position.scrollbarWidth() : 0
                    }
                },
                getWithinInfo: function(e) {
                    var i = t(e || window),
                        s = t.isWindow(i[0]),
                        n = !!i[0] && 9 === i[0].nodeType,
                        o = !s && !n;
                    return {
                        element: i,
                        isWindow: s,
                        isDocument: n,
                        offset: o ? t(e).offset() : {
                            left: 0,
                            top: 0
                        },
                        scrollLeft: i.scrollLeft(),
                        scrollTop: i.scrollTop(),
                        width: i.outerWidth(),
                        height: i.outerHeight()
                    }
                }
            }, t.fn.position = function(n) {
                if (!n || !n.of) return d.apply(this, arguments);
                n = t.extend({}, n);
                var u, p, f, g, m, _, v = t(n.of),
                    b = t.position.getWithinInfo(n.within),
                    y = t.position.getScrollInfo(b),
                    w = (n.collision || "flip").split(" "),
                    k = {};
                return _ = s(v), v[0].preventDefault && (n.at = "left top"), p = _.width, f = _.height, g = _.offset, m = t.extend({}, g), t.each(["my", "at"], function() {
                    var t, e, i = (n[this] || "").split(" ");
                    1 === i.length && (i =
                        r.test(i[0]) ? i.concat(["center"]) : l.test(i[0]) ? ["center"].concat(i) : ["center", "center"]), i[0] = r.test(i[0]) ? i[0] : "center", i[1] = l.test(i[1]) ? i[1] : "center", t = h.exec(i[0]), e = h.exec(i[1]), k[this] = [t ? t[0] : 0, e ? e[0] : 0], n[this] = [c.exec(i[0])[0], c.exec(i[1])[0]]
                }), 1 === w.length && (w[1] = w[0]), "right" === n.at[0] ? m.left += p : "center" === n.at[0] && (m.left += p / 2), "bottom" === n.at[1] ? m.top += f : "center" === n.at[1] && (m.top += f / 2), u = e(k.at, p, f), m.left += u[0], m.top += u[1], this.each(function() {
                    var s, r, l = t(this),
                        h = l.outerWidth(),
                        c =
                        l.outerHeight(),
                        d = i(this, "marginLeft"),
                        _ = i(this, "marginTop"),
                        x = h + d + i(this, "marginRight") + y.width,
                        C = c + _ + i(this, "marginBottom") + y.height,
                        D = t.extend({}, m),
                        T = e(k.my, l.outerWidth(), l.outerHeight());
                    "right" === n.my[0] ? D.left -= h : "center" === n.my[0] && (D.left -= h / 2), "bottom" === n.my[1] ? D.top -= c : "center" === n.my[1] && (D.top -= c / 2), D.left += T[0], D.top += T[1], s = {
                        marginLeft: d,
                        marginTop: _
                    }, t.each(["left", "top"], function(e, i) {
                        t.ui.position[w[e]] && t.ui.position[w[e]][i](D, {
                            targetWidth: p,
                            targetHeight: f,
                            elemWidth: h,
                            elemHeight: c,
                            collisionPosition: s,
                            collisionWidth: x,
                            collisionHeight: C,
                            offset: [u[0] + T[0], u[1] + T[1]],
                            my: n.my,
                            at: n.at,
                            within: b,
                            elem: l
                        })
                    }), n.using && (r = function(t) {
                        var e = g.left - D.left,
                            i = e + p - h,

                            s = g.top - D.top,
                            r = s + f - c,
                            u = {
                                target: {
                                    element: v,
                                    left: g.left,
                                    top: g.top,
                                    width: p,
                                    height: f
                                },
                                element: {
                                    element: l,
                                    left: D.left,
                                    top: D.top,
                                    width: h,
                                    height: c
                                },
                                horizontal: 0 > i ? "left" : e > 0 ? "right" : "center",
                                vertical: 0 > r ? "top" : s > 0 ? "bottom" : "middle"
                            };
                        h > p && p > a(e + i) && (u.horizontal = "center"), c > f && f > a(s + r) && (u.vertical = "middle"), u.important = o(a(e), a(i)) > o(a(s),
                            a(r)) ? "horizontal" : "vertical", n.using.call(this, t, u)
                    }), l.offset(t.extend(D, {
                        using: r
                    }))
                })
            }, t.ui.position = {
                fit: {
                    left: function(t, e) {
                        var i, s = e.within,
                            n = s.isWindow ? s.scrollLeft : s.offset.left,
                            a = s.width,
                            r = t.left - e.collisionPosition.marginLeft,
                            l = n - r,
                            h = r + e.collisionWidth - a - n;
                        e.collisionWidth > a ? l > 0 && 0 >= h ? (i = t.left + l + e.collisionWidth - a - n, t.left += l - i) : t.left = h > 0 && 0 >= l ? n : l > h ? n + a - e.collisionWidth : n : l > 0 ? t.left += l : h > 0 ? t.left -= h : t.left = o(t.left - r, t.left)
                    },
                    top: function(t, e) {
                        var i, s = e.within,
                            n = s.isWindow ? s.scrollTop :
                            s.offset.top,
                            a = e.within.height,
                            r = t.top - e.collisionPosition.marginTop,
                            l = n - r,
                            h = r + e.collisionHeight - a - n;
                        e.collisionHeight > a ? l > 0 && 0 >= h ? (i = t.top + l + e.collisionHeight - a - n, t.top += l - i) : t.top = h > 0 && 0 >= l ? n : l > h ? n + a - e.collisionHeight : n : l > 0 ? t.top += l : h > 0 ? t.top -= h : t.top = o(t.top - r, t.top)
                    }
                },
                flip: {
                    left: function(t, e) {
                        var i, s, n = e.within,
                            o = n.offset.left + n.scrollLeft,
                            r = n.width,
                            l = n.isWindow ? n.scrollLeft : n.offset.left,
                            h = t.left - e.collisionPosition.marginLeft,
                            c = h - l,
                            u = h + e.collisionWidth - r - l,
                            d = "left" === e.my[0] ? -e.elemWidth : "right" ===
                            e.my[0] ? e.elemWidth : 0,
                            p = "left" === e.at[0] ? e.targetWidth : "right" === e.at[0] ? -e.targetWidth : 0,
                            f = -2 * e.offset[0];
                        0 > c ? (i = t.left + d + p + f + e.collisionWidth - r - o, (0 > i || a(c) > i) && (t.left += d + p + f)) : u > 0 && (s = t.left - e.collisionPosition.marginLeft + d + p + f - l, (s > 0 || u > a(s)) && (t.left += d + p + f))
                    },
                    top: function(t, e) {
                        var i, s, n = e.within,
                            o = n.offset.top + n.scrollTop,
                            r = n.height,
                            l = n.isWindow ? n.scrollTop : n.offset.top,
                            h = t.top - e.collisionPosition.marginTop,
                            c = h - l,
                            u = h + e.collisionHeight - r - l,
                            d = "top" === e.my[1],
                            p = d ? -e.elemHeight : "bottom" === e.my[1] ?
                            e.elemHeight : 0,
                            f = "top" === e.at[1] ? e.targetHeight : "bottom" === e.at[1] ? -e.targetHeight : 0,
                            g = -2 * e.offset[1];
                        0 > c ? (s = t.top + p + f + g + e.collisionHeight - r - o, (0 > s || a(c) > s) && (t.top += p + f + g)) : u > 0 && (i = t.top - e.collisionPosition.marginTop + p + f + g - l, (i > 0 || u > a(i)) && (t.top += p + f + g))
                    }
                },
                flipfit: {
                    left: function() {
                        t.ui.position.flip.left.apply(this, arguments), t.ui.position.fit.left.apply(this, arguments)
                    },
                    top: function() {
                        t.ui.position.flip.top.apply(this, arguments), t.ui.position.fit.top.apply(this, arguments)
                    }
                }
            }
        }(), t.ui.position, t.ui.keyCode = {
            BACKSPACE: 8,
            COMMA: 188,
            DELETE: 46,
            DOWN: 40,
            END: 35,
            ENTER: 13,
            ESCAPE: 27,
            HOME: 36,
            LEFT: 37,
            PAGE_DOWN: 34,
            PAGE_UP: 33,
            PERIOD: 190,
            RIGHT: 39,
            SPACE: 32,
            TAB: 9,
            UP: 38
        }, t.fn.extend({
            uniqueId: function() {
                var t = 0;
                return function() {
                    return this.each(function() {
                        this.id || (this.id = "ui-id-" + ++t)
                    })
                }
            }(),
            removeUniqueId: function() {
                return this.each(function() {
                    /^ui-id-\d+$/.test(this.id) && t(this).removeAttr("id")
                })
            }
        }), t.ui.safeActiveElement = function(t) {
            var e;
            try {
                e = t.activeElement
            } catch (i$5) {
                e = t.body
            }
            return e || (e = t.body), e.nodeName ||
                (e = t.body), e
        }, t.widget("ui.menu", {
            version: "1.12.1",
            defaultElement: "<ul>",
            delay: 300,
            options: {
                icons: {
                    submenu: "ui-icon-caret-1-e"
                },
                items: "> *",
                menus: "ul",
                position: {
                    my: "left top",
                    at: "right top"
                },
                role: "menu",
                blur: null,
                focus: null,
                select: null
            },
            _create: function() {
                this.activeMenu = this.element, this.mouseHandled = !1, this.element.uniqueId().attr({
                    role: this.options.role,
                    tabIndex: 0
                }), this._addClass("ui-menu", "ui-widget ui-widget-content"), this._on({
                    "mousedown .ui-menu-item": function(t) {
                        t.preventDefault()
                    },
                    "click .ui-menu-item": function(e) {
                        var i =
                            t(e.target),
                            s = t(t.ui.safeActiveElement(this.document[0]));
                        !this.mouseHandled && i.not(".ui-state-disabled").length && (this.select(e), e.isPropagationStopped() || (this.mouseHandled = !0), i.has(".ui-menu").length ? this.expand(e) : !this.element.is(":focus") && s.closest(".ui-menu").length && (this.element.trigger("focus", [!0]), this.active && 1 === this.active.parents(".ui-menu").length && clearTimeout(this.timer)))
                    },
                    "mouseenter .ui-menu-item": function(e) {
                        if (!this.previousFilter) {
                            var i = t(e.target).closest(".ui-menu-item"),
                                s = t(e.currentTarget);
                            i[0] === s[0] && (this._removeClass(s.siblings().children(".ui-state-active"), null, "ui-state-active"), this.focus(e, s))
                        }
                    },
                    mouseleave: "collapseAll",
                    "mouseleave .ui-menu": "collapseAll",
                    focus: function(t, e) {
                        var i = this.active || this.element.find(this.options.items).eq(0);
                        e || this.focus(t, i)
                    },
                    blur: function(e) {
                        this._delay(function() {
                            var i = !t.contains(this.element[0], t.ui.safeActiveElement(this.document[0]));
                            i && this.collapseAll(e)
                        })
                    },
                    keydown: "_keydown"
                }), this.refresh(), this._on(this.document, {
                    click: function(t) {
                        this._closeOnDocumentClick(t) && this.collapseAll(t), this.mouseHandled = !1
                    }
                })
            },
            _destroy: function() {
                var e = this.element.find(".ui-menu-item").removeAttr("role aria-disabled"),
                    i = e.children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");
                this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled tabIndex").removeUniqueId().show(), i.children().each(function() {
                    var e =
                        t(this);
                    e.data("ui-menu-submenu-caret") && e.remove()
                })
            },
            _keydown: function(e) {
                var i, s, n, o, a = !0;
                switch (e.keyCode) {
                    case t.ui.keyCode.PAGE_UP:
                        this.previousPage(e);
                        break;
                    case t.ui.keyCode.PAGE_DOWN:
                        this.nextPage(e);
                        break;
                    case t.ui.keyCode.HOME:
                        this._move("first", "first", e);
                        break;
                    case t.ui.keyCode.END:
                        this._move("last", "last", e);
                        break;
                    case t.ui.keyCode.UP:
                        this.previous(e);
                        break;
                    case t.ui.keyCode.DOWN:
                        this.next(e);
                        break;
                    case t.ui.keyCode.LEFT:
                        this.collapse(e);
                        break;
                    case t.ui.keyCode.RIGHT:
                        this.active && !this.active.is(".ui-state-disabled") &&
                            this.expand(e);
                        break;
                    case t.ui.keyCode.ENTER:
                    case t.ui.keyCode.SPACE:
                        this._activate(e);
                        break;
                    case t.ui.keyCode.ESCAPE:
                        this.collapse(e);
                        break;
                    default:
                        a = !1, s = this.previousFilter || "", o = !1, n = e.keyCode >= 96 && 105 >= e.keyCode ? "" + (e.keyCode - 96) : String.fromCharCode(e.keyCode), clearTimeout(this.filterTimer), n === s ? o = !0 : n = s + n, i = this._filterMenuItems(n), i = o && -1 !== i.index(this.active.next()) ? this.active.nextAll(".ui-menu-item") : i, i.length || (n = String.fromCharCode(e.keyCode), i = this._filterMenuItems(n)), i.length ? (this.focus(e,
                            i), this.previousFilter = n, this.filterTimer = this._delay(function() {
                            delete this.previousFilter
                        }, 1E3)) : delete this.previousFilter
                }
                a && e.preventDefault()
            },
            _activate: function(t) {
                this.active && !this.active.is(".ui-state-disabled") && (this.active.children("[aria-haspopup='true']").length ? this.expand(t) : this.select(t))
            },
            refresh: function() {
                var e, i, s, n, o, a = this,
                    r = this.options.icons.submenu,
                    l = this.element.find(this.options.menus);
                this._toggleClass("ui-menu-icons", null, !!this.element.find(".ui-icon").length), s = l.filter(":not(.ui-menu)").hide().attr({
                        role: this.options.role,
                        "aria-hidden": "true",
                        "aria-expanded": "false"
                    }).each(function() {
                        var e = t(this),
                            i = e.prev(),
                            s = t("<span>").data("ui-menu-submenu-caret", !0);
                        a._addClass(s, "ui-menu-icon", "ui-icon " + r), i.attr("aria-haspopup", "true").prepend(s), e.attr("aria-labelledby", i.attr("id"))
                    }), this._addClass(s, "ui-menu", "ui-widget ui-widget-content ui-front"), e = l.add(this.element), i = e.find(this.options.items), i.not(".ui-menu-item").each(function() {
                        var e = t(this);
                        a._isDivider(e) && a._addClass(e, "ui-menu-divider", "ui-widget-content")
                    }),
                    n = i.not(".ui-menu-item, .ui-menu-divider"), o = n.children().not(".ui-menu").uniqueId().attr({
                        tabIndex: -1,
                        role: this._itemRole()
                    }), this._addClass(n, "ui-menu-item")._addClass(o, "ui-menu-item-wrapper"), i.filter(".ui-state-disabled").attr("aria-disabled", "true"), this.active && !t.contains(this.element[0], this.active[0]) && this.blur()
            },
            _itemRole: function() {
                return {
                    menu: "menuitem",
                    listbox: "option"
                }[this.options.role]
            },
            _setOption: function(t, e) {
                if ("icons" === t) {
                    var i = this.element.find(".ui-menu-icon");
                    this._removeClass(i,
                        null, this.options.icons.submenu)._addClass(i, null, e.submenu)
                }
                this._super(t, e)
            },
            _setOptionDisabled: function(t) {
                this._super(t), this.element.attr("aria-disabled", t + ""), this._toggleClass(null, "ui-state-disabled", !!t)
            },
            focus: function(t, e) {
                var i, s, n;
                this.blur(t, t && "focus" === t.type), this._scrollIntoView(e), this.active = e.first(), s = this.active.children(".ui-menu-item-wrapper"), this._addClass(s, null, "ui-state-active"), this.options.role && this.element.attr("aria-activedescendant", s.attr("id")), n = this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper"),
                    this._addClass(n, null, "ui-state-active"), t && "keydown" === t.type ? this._close() : this.timer = this._delay(function() {
                        this._close()
                    }, this.delay), i = e.children(".ui-menu"), i.length && t && /^mouse/.test(t.type) && this._startOpening(i), this.activeMenu = e.parent(), this._trigger("focus", t, {
                        item: e
                    })
            },
            _scrollIntoView: function(e) {
                var i, s, n, o, a, r;
                this._hasScroll() && (i = parseFloat(t.css(this.activeMenu[0], "borderTopWidth")) || 0, s = parseFloat(t.css(this.activeMenu[0], "paddingTop")) || 0, n = e.offset().top - this.activeMenu.offset().top -
                    i - s, o = this.activeMenu.scrollTop(), a = this.activeMenu.height(), r = e.outerHeight(), 0 > n ? this.activeMenu.scrollTop(o + n) : n + r > a && this.activeMenu.scrollTop(o + n - a + r))
            },
            blur: function(t, e) {
                e || clearTimeout(this.timer), this.active && (this._removeClass(this.active.children(".ui-menu-item-wrapper"), null, "ui-state-active"), this._trigger("blur", t, {
                    item: this.active
                }), this.active = null)
            },
            _startOpening: function(t) {
                clearTimeout(this.timer), "true" === t.attr("aria-hidden") && (this.timer = this._delay(function() {
                    this._close(),
                        this._open(t)
                }, this.delay))
            },
            _open: function(e) {
                var i = t.extend({
                    of: this.active
                }, this.options.position);
                clearTimeout(this.timer), this.element.find(".ui-menu").not(e.parents(".ui-menu")).hide().attr("aria-hidden", "true"), e.show().removeAttr("aria-hidden").attr("aria-expanded", "true").position(i)
            },
            collapseAll: function(e, i) {
                clearTimeout(this.timer), this.timer = this._delay(function() {
                    var s = i ? this.element : t(e && e.target).closest(this.element.find(".ui-menu"));
                    s.length || (s = this.element), this._close(s), this.blur(e),
                        this._removeClass(s.find(".ui-state-active"), null, "ui-state-active"), this.activeMenu = s
                }, this.delay)
            },
            _close: function(t) {
                t || (t = this.active ? this.active.parent() : this.element), t.find(".ui-menu").hide().attr("aria-hidden", "true").attr("aria-expanded", "false")
            },
            _closeOnDocumentClick: function(e) {
                return !t(e.target).closest(".ui-menu").length
            },
            _isDivider: function(t) {
                return !/[^\-\u2014\u2013\s]/.test(t.text())
            },
            collapse: function(t) {
                var e = this.active && this.active.parent().closest(".ui-menu-item", this.element);
                e && e.length && (this._close(), this.focus(t, e))
            },
            expand: function(t) {
                var e = this.active && this.active.children(".ui-menu ").find(this.options.items).first();
                e && e.length && (this._open(e.parent()), this._delay(function() {
                    this.focus(t, e)
                }))
            },
            next: function(t) {
                this._move("next", "first", t)
            },
            previous: function(t) {
                this._move("prev", "last", t)
            },
            isFirstItem: function() {
                return this.active && !this.active.prevAll(".ui-menu-item").length
            },
            isLastItem: function() {
                return this.active && !this.active.nextAll(".ui-menu-item").length
            },
            _move: function(t, e, i) {
                var s;
                this.active && (s = "first" === t || "last" === t ? this.active["first" === t ? "prevAll" : "nextAll"](".ui-menu-item").eq(-1) : this.active[t + "All"](".ui-menu-item").eq(0)), s && s.length && this.active || (s = this.activeMenu.find(this.options.items)[e]()), this.focus(i, s)
            },
            nextPage: function(e) {
                var i, s, n;
                return this.active ? (this.isLastItem() || (this._hasScroll() ? (s = this.active.offset().top, n = this.element.height(), this.active.nextAll(".ui-menu-item").each(function() {
                    return i = t(this), 0 > i.offset().top -
                        s - n
                }), this.focus(e, i)) : this.focus(e, this.activeMenu.find(this.options.items)[this.active ? "last" : "first"]())), void 0) : (this.next(e), void 0)
            },
            previousPage: function(e) {
                var i, s, n;
                return this.active ? (this.isFirstItem() || (this._hasScroll() ? (s = this.active.offset().top, n = this.element.height(), this.active.prevAll(".ui-menu-item").each(function() {
                    return i = t(this), i.offset().top - s + n > 0
                }), this.focus(e, i)) : this.focus(e, this.activeMenu.find(this.options.items).first())), void 0) : (this.next(e), void 0)
            },
            _hasScroll: function() {
                return this.element.outerHeight() <
                    this.element.prop("scrollHeight")
            },
            select: function(e) {
                this.active = this.active || t(e.target).closest(".ui-menu-item");
                var i = {
                    item: this.active
                };
                this.active.has(".ui-menu").length || this.collapseAll(e, !0), this._trigger("select", e, i)
            },
            _filterMenuItems: function(e) {
                var i = e.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&"),
                    s = RegExp("^" + i, "i");
                return this.activeMenu.find(this.options.items).filter(".ui-menu-item").filter(function() {
                    return s.test(t.trim(t(this).children(".ui-menu-item-wrapper").text()))
                })
            }
        }), t.widget("ui.autocomplete", {
            version: "1.12.1",
            defaultElement: "<input>",
            options: {
                appendTo: null,
                autoFocus: !1,
                delay: 300,
                minLength: 1,
                position: {
                    my: "left top",
                    at: "left bottom",
                    collision: "none"
                },
                source: null,
                change: null,
                close: null,
                focus: null,
                open: null,
                response: null,
                search: null,
                select: null
            },
            requestIndex: 0,
            pending: 0,
            _create: function() {
                var e, i, s, n = this.element[0].nodeName.toLowerCase(),
                    o = "textarea" === n,
                    a = "input" === n;
                this.isMultiLine = o || !a && this._isContentEditable(this.element), this.valueMethod = this.element[o || a ? "val" : "text"], this.isNewMenu = !0, this._addClass("ui-autocomplete-input"), this.element.attr("autocomplete", "off"), this._on(this.element, {
                        keydown: function(n) {
                            if (this.element.prop("readOnly")) return e = !0, s = !0, i = !0, void 0;
                            e = !1, s = !1, i = !1;
                            var o = t.ui.keyCode;
                            switch (n.keyCode) {
                                case o.PAGE_UP:
                                    e = !0, this._move("previousPage", n);
                                    break;
                                case o.PAGE_DOWN:
                                    e = !0, this._move("nextPage", n);
                                    break;
                                case o.UP:
                                    e = !0, this._keyEvent("previous", n);
                                    break;
                                case o.DOWN:
                                    e = !0, this._keyEvent("next", n);
                                    break;
                                case o.ENTER:
                                    this.menu.active && (e = !0, n.preventDefault(),
                                        this.menu.select(n));
                                    break;
                                case o.TAB:
                                    this.menu.active && this.menu.select(n);
                                    break;
                                case o.ESCAPE:
                                    this.menu.element.is(":visible") && (this.isMultiLine || this._value(this.term), this.close(n), n.preventDefault());
                                    break;
                                default:
                                    i = !0, this._searchTimeout(n)
                            }
                        },
                        keypress: function(s) {
                            if (e) return e = !1, (!this.isMultiLine || this.menu.element.is(":visible")) && s.preventDefault(), void 0;
                            if (!i) {
                                var n = t.ui.keyCode;
                                switch (s.keyCode) {
                                    case n.PAGE_UP:
                                        this._move("previousPage", s);
                                        break;
                                    case n.PAGE_DOWN:
                                        this._move("nextPage",
                                            s);
                                        break;
                                    case n.UP:
                                        this._keyEvent("previous", s);
                                        break;
                                    case n.DOWN:
                                        this._keyEvent("next", s)
                                }
                            }
                        },
                        input: function(t) {
                            return s ? (s = !1, t.preventDefault(), void 0) : (this._searchTimeout(t), void 0)
                        },
                        focus: function() {
                            this.selectedItem = null, this.previous = this._value()
                        },
                        blur: function(t) {
                            return this.cancelBlur ? (delete this.cancelBlur, void 0) : (clearTimeout(this.searching), this.close(t), this._change(t), void 0)
                        }
                    }), this._initSource(), this.menu = t("<ul>").appendTo(this._appendTo()).menu({
                        role: null
                    }).hide().menu("instance"),
                    this._addClass(this.menu.element, "ui-autocomplete", "ui-front"), this._on(this.menu.element, {
                        mousedown: function(e) {
                            e.preventDefault(), this.cancelBlur = !0, this._delay(function() {
                                delete this.cancelBlur, this.element[0] !== t.ui.safeActiveElement(this.document[0]) && this.element.trigger("focus")
                            })
                        },
                        menufocus: function(e, i) {
                            var s, n;
                            return this.isNewMenu && (this.isNewMenu = !1, e.originalEvent && /^mouse/.test(e.originalEvent.type)) ? (this.menu.blur(), this.document.one("mousemove", function() {
                                    t(e.target).trigger(e.originalEvent)
                                }),
                                void 0) : (n = i.item.data("ui-autocomplete-item"), !1 !== this._trigger("focus", e, {
                                item: n
                            }) && e.originalEvent && /^key/.test(e.originalEvent.type) && this._value(n.value), s = i.item.attr("aria-label") || n.value, s && t.trim(s).length && (this.liveRegion.children().hide(), t("<div>").text(s).appendTo(this.liveRegion)), void 0)
                        },
                        menuselect: function(e, i) {
                            var s = i.item.data("ui-autocomplete-item"),
                                n = this.previous;
                            this.element[0] !== t.ui.safeActiveElement(this.document[0]) && (this.element.trigger("focus"), this.previous = n, this._delay(function() {
                                this.previous =
                                    n, this.selectedItem = s
                            })), !1 !== this._trigger("select", e, {
                                item: s
                            }) && this._value(s.value), this.term = this._value(), this.close(e), this.selectedItem = s
                        }
                    }), this.liveRegion = t("<div>", {
                        role: "status",
                        "aria-live": "assertive",
                        "aria-relevant": "additions"
                    }).appendTo(this.document[0].body), this._addClass(this.liveRegion, null, "ui-helper-hidden-accessible"), this._on(this.window, {
                        beforeunload: function() {
                            this.element.removeAttr("autocomplete")
                        }
                    })
            },
            _destroy: function() {
                clearTimeout(this.searching), this.element.removeAttr("autocomplete"),
                    this.menu.element.remove(), this.liveRegion.remove()
            },
            _setOption: function(t, e) {
                this._super(t, e), "source" === t && this._initSource(), "appendTo" === t && this.menu.element.appendTo(this._appendTo()), "disabled" === t && e && this.xhr && this.xhr.abort()
            },
            _isEventTargetInWidget: function(e) {
                var i = this.menu.element[0];
                return e.target === this.element[0] || e.target === i || t.contains(i, e.target)
            },
            _closeOnClickOutside: function(t) {
                this._isEventTargetInWidget(t) || this.close()
            },
            _appendTo: function() {
                var e = this.options.appendTo;
                return e &&
                    (e = e.jquery || e.nodeType ? t(e) : this.document.find(e).eq(0)), e && e[0] || (e = this.element.closest(".ui-front, dialog")), e.length || (e = this.document[0].body), e
            },
            _initSource: function() {
                var e, i, s = this;
                t.isArray(this.options.source) ? (e = this.options.source, this.source = function(i, s) {
                        s(t.ui.autocomplete.filter(e, i.term))
                    }) : "string" == typeof this.options.source ? (i = this.options.source, this.source = function(e, n) {
                        s.xhr && s.xhr.abort(), s.xhr = t.ajax({
                            url: i,
                            data: e,
                            dataType: "json",
                            success: function(t) {
                                n(t)
                            },
                            error: function() {
                                n([])
                            }
                        })
                    }) :
                    this.source = this.options.source
            },
            _searchTimeout: function(t) {
                clearTimeout(this.searching), this.searching = this._delay(function() {
                    var e = this.term === this._value(),
                        i = this.menu.element.is(":visible"),
                        s = t.altKey || t.ctrlKey || t.metaKey || t.shiftKey;
                    (!e || e && !i && !s) && (this.selectedItem = null, this.search(null, t))
                }, this.options.delay)
            },
            search: function(t, e) {
                return t = null != t ? t : this._value(), this.term = this._value(), t.length < this.options.minLength ? this.close(e) : this._trigger("search", e) !== !1 ? this._search(t) : void 0
            },
            _search: function(t) {
                this.pending++, this._addClass("ui-autocomplete-loading"), this.cancelSearch = !1, this.source({
                    term: t
                }, this._response())
            },
            _response: function() {
                var e = ++this.requestIndex;
                return t.proxy(function(t) {
                    e === this.requestIndex && this.__response(t), this.pending--, this.pending || this._removeClass("ui-autocomplete-loading")
                }, this)
            },
            __response: function(t) {
                t && (t = this._normalize(t)), this._trigger("response", null, {
                    content: t
                }), !this.options.disabled && t && t.length && !this.cancelSearch ? (this._suggest(t),
                    this._trigger("open")) : this._close()
            },
            close: function(t) {
                this.cancelSearch = !0, this._close(t)
            },
            _close: function(t) {
                this._off(this.document, "mousedown"), this.menu.element.is(":visible") && (this.menu.element.hide(), this.menu.blur(), this.isNewMenu = !0, this._trigger("close", t))
            },
            _change: function(t) {
                this.previous !== this._value() && this._trigger("change", t, {
                    item: this.selectedItem
                })
            },
            _normalize: function(e) {
                return e.length && e[0].label && e[0].value ? e : t.map(e, function(e) {
                    return "string" == typeof e ? {
                            label: e,
                            value: e
                        } :
                        t.extend({}, e, {
                            label: e.label || e.value,
                            value: e.value || e.label
                        })
                })
            },
            _suggest: function(e) {
                var i = this.menu.element.empty();
                this._renderMenu(i, e), this.isNewMenu = !0, this.menu.refresh(), i.show(), this._resizeMenu(), i.position(t.extend({
                    of: this.element
                }, this.options.position)), this.options.autoFocus && this.menu.next(), this._on(this.document, {
                    mousedown: "_closeOnClickOutside"
                })
            },
            _resizeMenu: function() {
                var t = this.menu.element;
                t.outerWidth(Math.max(t.width("").outerWidth() + 1, this.element.outerWidth()))
            },
            _renderMenu: function(e,
                i) {
                var s = this;
                t.each(i, function(t, i) {
                    s._renderItemData(e, i)
                })
            },
            _renderItemData: function(t, e) {
                return this._renderItem(t, e).data("ui-autocomplete-item", e)
            },
            _renderItem: function(e, i) {
                return t("<li>").append(t("<div>").text(i.label)).appendTo(e)
            },
            _move: function(t, e) {
                return this.menu.element.is(":visible") ? this.menu.isFirstItem() && /^previous/.test(t) || this.menu.isLastItem() && /^next/.test(t) ? (this.isMultiLine || this._value(this.term), this.menu.blur(), void 0) : (this.menu[t](e), void 0) : (this.search(null, e),
                    void 0)
            },
            widget: function() {
                return this.menu.element
            },
            _value: function() {
                return this.valueMethod.apply(this.element, arguments)
            },
            _keyEvent: function(t, e) {
                (!this.isMultiLine || this.menu.element.is(":visible")) && (this._move(t, e), e.preventDefault())
            },
            _isContentEditable: function(t) {
                if (!t.length) return !1;
                var e = t.prop("contentEditable");
                return "inherit" === e ? this._isContentEditable(t.parent()) : "true" === e
            }
        }), t.extend(t.ui.autocomplete, {
            escapeRegex: function(t) {
                return t.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&")
            },
            filter: function(e, i) {
                var s = RegExp(t.ui.autocomplete.escapeRegex(i), "i");
                return t.grep(e, function(t) {
                    return s.test(t.label || t.value || t)
                })
            }
        }), t.widget("ui.autocomplete", t.ui.autocomplete, {
            options: {
                messages: {
                    noResults: "No search results.",
                    results: function(t) {
                        return t + (t > 1 ? " results are" : " result is") + " available, use up and down arrow keys to navigate."
                    }
                }
            },
            __response: function(e) {
                var i;
                this._superApply(arguments), this.options.disabled || this.cancelSearch || (i = e && e.length ? this.options.messages.results(e.length) :
                    this.options.messages.noResults, this.liveRegion.children().hide(), t("<div>").text(i).appendTo(this.liveRegion))
            }
        }), t.ui.autocomplete
});
! function(a) {
    "function" == typeof define && define.amd ? define(["jquery"], a) : a(jQuery)
}(function(a) {
    function b(a) {
        if (a instanceof Date) return a;
        if (String(a).match(g)) return String(a).match(/^[0-9]*$/) && (a = Number(a)), String(a).match(/\-/) && (a = String(a).replace(/\-/g, "/")), new Date(a);
        throw new Error("Couldn't cast `" + a + "` to a date object.");
    }

    function c(a) {
        var b = a.toString().replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
        return new RegExp(b)
    }

    function d(a) {
        return function(b) {
            var d = b.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);
            if (d)
                for (var f = 0, g = d.length; f < g; ++f) {
                    var h = d[f].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/),
                        j = c(h[0]),
                        k = h[1] || "",
                        l = h[3] || "",
                        m = null;
                    h = h[2], i.hasOwnProperty(h) && (m = i[h], m = Number(a[m])), null !== m && ("!" === k && (m = e(l, m)), "" === k && m < 10 && (m = "0" + m.toString()), b = b.replace(j, m.toString()))
                }
            return b = b.replace(/%%/, "%")
        }
    }

    function e(a, b) {
        var c = "s",
            d = "";
        return a && (a = a.replace(/(:|;|\s)/gi, "").split(/,/), 1 === a.length ? c = a[0] : (d = a[0], c = a[1])), Math.abs(b) > 1 ? c : d
    }
    var f = [],
        g = [],
        h = {
            precision: 100,
            elapse: !1,
            defer: !1
        };
    g.push(/^[0-9]*$/.source),
        g.push(/([0-9]{1,2}\/){2}[0-9]{4}( [0-9]{1,2}(:[0-9]{2}){2})?/.source), g.push(/[0-9]{4}([\/\-][0-9]{1,2}){2}( [0-9]{1,2}(:[0-9]{2}){2})?/.source), g = new RegExp(g.join("|"));
    var i = {
            Y: "years",
            m: "months",
            n: "daysToMonth",
            d: "daysToWeek",
            w: "weeks",
            W: "weeksToMonth",
            H: "hours",
            M: "minutes",
            S: "seconds",
            D: "totalDays",
            I: "totalHours",
            N: "totalMinutes",
            T: "totalSeconds"
        },
        j = function(b, c, d) {
            this.el = b, this.$el = a(b), this.interval = null, this.offset = {}, this.options = a.extend({}, h), this.instanceNumber = f.length, f.push(this),
                this.$el.data("countdown-instance", this.instanceNumber), d && ("function" == typeof d ? (this.$el.on("update.countdown", d), this.$el.on("stoped.countdown", d), this.$el.on("finish.countdown", d)) : this.options = a.extend({}, h, d)), this.setFinalDate(c), this.options.defer === !1 && this.start()
        };
    a.extend(j.prototype, {
        start: function() {
            null !== this.interval && clearInterval(this.interval);
            var a = this;
            this.update(), this.interval = setInterval(function() {
                a.update.call(a)
            }, this.options.precision)
        },
        stop: function() {
            clearInterval(this.interval),
                this.interval = null, this.dispatchEvent("stoped")
        },
        toggle: function() {
            this.interval ? this.stop() : this.start()
        },
        pause: function() {
            this.stop()
        },
        resume: function() {
            this.start()
        },
        remove: function() {
            this.stop.call(this), f[this.instanceNumber] = null, delete this.$el.data().countdownInstance
        },
        setFinalDate: function(a) {
            this.finalDate = b(a)
        },
        update: function() {
            if (0 === this.$el.closest("html").length) return void this.remove();
            var b, c = void 0 !== a._data(this.el, "events"),
                d = new Date;
            b = this.finalDate.getTime() - d.getTime(), b =
                Math.ceil(b / 1E3), b = !this.options.elapse && b < 0 ? 0 : Math.abs(b), this.totalSecsLeft !== b && c && (this.totalSecsLeft = b, this.elapsed = d >= this.finalDate, this.offset = {
                    seconds: this.totalSecsLeft % 60,
                    minutes: Math.floor(this.totalSecsLeft / 60) % 60,
                    hours: Math.floor(this.totalSecsLeft / 60 / 60) % 24,
                    days: Math.floor(this.totalSecsLeft / 60 / 60 / 24) % 7,
                    daysToWeek: Math.floor(this.totalSecsLeft / 60 / 60 / 24) % 7,
                    daysToMonth: Math.floor(this.totalSecsLeft / 60 / 60 / 24 % 30.4368),
                    weeks: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 7),
                    weeksToMonth: Math.floor(this.totalSecsLeft /
                        60 / 60 / 24 / 7) % 4,
                    months: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 30.4368),
                    years: Math.abs(this.finalDate.getFullYear() - d.getFullYear()),
                    totalDays: Math.floor(this.totalSecsLeft / 60 / 60 / 24),
                    totalHours: Math.floor(this.totalSecsLeft / 60 / 60),
                    totalMinutes: Math.floor(this.totalSecsLeft / 60),
                    totalSeconds: this.totalSecsLeft
                }, this.options.elapse || 0 !== this.totalSecsLeft ? this.dispatchEvent("update") : (this.stop(), this.dispatchEvent("finish")))
        },
        dispatchEvent: function(b) {
            var c = a.Event(b + ".countdown");
            c.finalDate = this.finalDate,
                c.elapsed = this.elapsed, c.offset = a.extend({}, this.offset), c.strftime = d(this.offset), this.$el.trigger(c)
        }
    }), a.fn.countdown = function() {
        var b = Array.prototype.slice.call(arguments, 0);
        return this.each(function() {
            var c = a(this).data("countdown-instance");
            if (void 0 !== c) {
                var d = f[c],
                    e = b[0];
                j.prototype.hasOwnProperty(e) ? d[e].apply(d, b.slice(1)) : null === String(e).match(/^[$A-Z_][0-9A-Z_$]*$/i) ? (d.setFinalDate.call(d, e), d.start()) : a.error("Method %s does not exist on jQuery.countdown".replace(/%s/gi, e))
            } else new j(this,
                b[0], b[1])
        })
    }
});
! function(e) {
    "function" == typeof define && define.amd ? define(["./dependencyLibs/inputmask.dependencyLib", "./global/window", "./global/document"], e) : "object" == typeof exports ? module.exports = e(require("./dependencyLibs/inputmask.dependencyLib"), require("./global/window"), require("./global/document")) : window.Inputmask = e(window.dependencyLib || jQuery, window, document)
}(function(e, t, n, i) {
    function a(t, n, o) {
        if (!(this instanceof a)) return new a(t, n, o);
        this.el = i, this.events = {}, this.maskset = i, this.refreshValue = !1, !0 !== o && (e.isPlainObject(t) ? n = t : (n = n || {}).alias = t, this.opts = e.extend(!0, {}, this.defaults, n), this.noMasksCache = n && n.definitions !== i, this.userOptions = n || {}, this.isRTL = this.opts.numericInput, r(this.opts.alias, n, this.opts))
    }

    function r(t, n, o) {
        var s = a.prototype.aliases[t];
        return s ? (s.alias && r(s.alias, i, o), e.extend(!0, o, s), e.extend(!0, o, n), !0) : (null === o.mask && (o.mask = t), !1)
    }

    function o(t, n) {
        function r(t, r, o) {
            var s = !1;
            if (null !== t && "" !== t || ((s = null !== o.regex) ? t = (t = o.regex).replace(/^(\^)(.*)(\$)$/, "$2") : (s = !0, t = ".*")), 1 === t.length && !1 === o.greedy && 0 !== o.repeat && (o.placeholder = ""), o.repeat > 0 || "*" === o.repeat || "+" === o.repeat) {
                var l = "*" === o.repeat ? 0 : "+" === o.repeat ? 1 : o.repeat;
                t = o.groupmarker.start + t + o.groupmarker.end + o.quantifiermarker.start + l + "," + o.repeat + o.quantifiermarker.end
            }
            var c, u = s ? "regex_" + o.regex : o.numericInput ? t.split("").reverse().join("") : t;
            return a.prototype.masksCache[u] === i || !0 === n ? (c = {
                mask: t,
                maskToken: a.prototype.analyseMask(t, s, o),
                validPositions: {},
                _buffer: i,
                buffer: i,
                tests: {},
                metadata: r,
                maskLength: i
            }, !0 !== n && (a.prototype.masksCache[u] = c, c = e.extend(!0, {}, a.prototype.masksCache[u]))) : c = e.extend(!0, {}, a.prototype.masksCache[u]), c
        }
        if (e.isFunction(t.mask) && (t.mask = t.mask(t)), e.isArray(t.mask)) {
            if (t.mask.length > 1) {
                t.keepStatic = null === t.keepStatic || t.keepStatic;
                var o = t.groupmarker.start;
                return e.each(t.numericInput ? t.mask.reverse() : t.mask, function(n, a) {
                        o.length > 1 && (o += t.groupmarker.end + t.alternatormarker + t.groupmarker.start), a.mask === i || e.isFunction(a.mask) ? o += a : o += a.mask
                    }), o += t.groupmarker.end,
                    r(o, t.mask, t)
            }
            t.mask = t.mask.pop()
        }
        return t.mask && t.mask.mask !== i && !e.isFunction(t.mask.mask) ? r(t.mask.mask, t.mask, t) : r(t.mask, t.mask, t)
    }

    function s(r, o, l) {
        function h(e, t, n) {
            t = t || 0;
            var a, r, o, s = [],
                c = 0,
                u = v();
            do !0 === e && m().validPositions[c] ? (r = (o = m().validPositions[c]).match, a = o.locator.slice(), s.push(!0 === n ? o.input : !1 === n ? r.nativeDef : G(c, r))) : (r = (o = y(c, a, c - 1)).match, a = o.locator.slice(), (!1 === l.jitMasking || c < u || "number" == typeof l.jitMasking && isFinite(l.jitMasking) && l.jitMasking > c) && s.push(!1 === n ? r.nativeDef :
                G(c, r))), c++; while ((W === i || c < W) && (null !== r.fn || "" !== r.def) || t > c);
            return "" === s[s.length - 1] && s.pop(), m().maskLength = c + 1, s
        }

        function m() {
            return o
        }

        function d(e) {
            var t = m();
            t.buffer = i, !0 !== e && (t.validPositions = {}, t.p = 0)
        }

        function v(e, t, n) {
            var a = -1,
                r = -1,
                o = n || m().validPositions;
            e === i && (e = -1);
            for (var s in o) {
                var l = parseInt(s);
                o[l] && (t || !0 !== o[l].generatedInput) && (l <= e && (a = l), l >= e && (r = l))
            }
            return -1 !== a && e - a > 1 || r < e ? a : r
        }

        function g(t, n, a, r) {
            var o, s = t,
                c = e.extend(!0, {}, m().validPositions),
                u = !1;
            for (m().p = t, o = n - 1; o >=
                s; o--) m().validPositions[o] !== i && (!0 !== a && (!m().validPositions[o].match.optionality && function(e) {
                var t = m().validPositions[e];
                if (t !== i && null === t.match.fn) {
                    var n = m().validPositions[e - 1],
                        a = m().validPositions[e + 1];
                    return n !== i && a !== i
                }
                return !1
            }(o) || !1 === l.canClearPosition(m(), o, v(), r, l)) || delete m().validPositions[o]);
            for (d(!0), o = s + 1; o <= v();) {
                for (; m().validPositions[s] !== i;) s++;
                if (o < s && (o = s + 1), m().validPositions[o] === i && O(o)) o++;
                else {
                    var f = y(o);
                    !1 === u && c[s] && c[s].match.def === f.match.def ? (m().validPositions[s] =
                        e.extend(!0, {}, c[s]), m().validPositions[s].input = f.input, delete m().validPositions[o], o++) : P(s, f.match.def) ? !1 !== M(s, f.input || G(o), !0) && (delete m().validPositions[o], o++, u = !0) : O(o) || (o++, s--), s++
                }
            }
            d(!0)
        }

        function k(e, t) {
            for (var n, a = e, r = v(), o = m().validPositions[r] || E(0)[0], s = o.alternation !== i ? o.locator[o.alternation].toString().split(",") : [], c = 0; c < a.length && (!((n = a[c]).match && (l.greedy && !0 !== n.match.optionalQuantifier || (!1 === n.match.optionality || !1 === n.match.newBlockMarker) && !0 !== n.match.optionalQuantifier) &&
                    (o.alternation === i || o.alternation !== n.alternation || n.locator[o.alternation] !== i && w(n.locator[o.alternation].toString().split(","), s))) || !0 === t && (null !== n.match.fn || /[0-9a-bA-Z]/.test(n.match.def))); c++);
            return n
        }

        function y(e, t, n) {
            return m().validPositions[e] || k(E(e, t ? t.slice() : t, n))
        }

        function b(e) {
            return m().validPositions[e] ? m().validPositions[e] : E(e)[0]
        }

        function P(e, t) {
            for (var n = !1, i = E(e), a = 0; a < i.length; a++)
                if (i[a].match && i[a].match.def === t) {
                    n = !0;
                    break
                }
            return n
        }

        function E(t, n, a) {
            function r(n, a, o,
                c) {
                function f(o, c, v) {
                    function g(t, n) {
                        var i = 0 === e.inArray(t, n.matches);
                        return i || e.each(n.matches, function(e, a) {
                            if (!0 === a.isQuantifier && (i = g(t, n.matches[e - 1]))) return !1
                        }), i
                    }

                    function k(t, n, a) {
                        var r, o;
                        if (m().validPositions[t - 1] && a && m().tests[t])
                            for (var s = m().validPositions[t - 1].locator, l = m().tests[t][0].locator, c = 0; c < a; c++)
                                if (s[c] !== l[c]) return s.slice(a + 1);
                        return (m().tests[t] || m().validPositions[t]) && e.each(m().tests[t] || [m().validPositions[t]], function(e, t) {
                            var s = a !== i ? a : t.alternation,
                                l = t.locator[s] !==
                                i ? t.locator[s].toString().indexOf(n) : -1;
                            (o === i || l < o) && -1 !== l && (r = t, o = l)
                        }), r ? r.locator.slice((a !== i ? a : r.alternation) + 1) : a !== i ? k(t, n) : i
                    }
                    if (u > 1E4) throw "Inputmask: There is probably an error in your mask definition or in the code. Create an issue on github with an example of the mask you are using. " + m().mask;
                    if (u === t && o.matches === i) return p.push({
                        match: o,
                        locator: c.reverse(),
                        cd: d
                    }), !0;
                    if (o.matches !== i)
                        if (o.isGroup && v !== o) {
                            if (o = f(n.matches[e.inArray(o, n.matches) + 1], c)) return !0
                        } else if (o.isOptional) {
                        var y =
                            o;
                        if (o = r(o, a, c, v)) {
                            if (s = p[p.length - 1].match, !g(s, y)) return !0;
                            h = !0, u = t
                        }
                    } else if (o.isAlternator) {
                        var b, P = o,
                            E = [],
                            C = p.slice(),
                            A = c.length,
                            _ = a.length > 0 ? a.shift() : -1;
                        if (-1 === _ || "string" == typeof _) {
                            var x, w = u,
                                M = a.slice(),
                                O = [];
                            if ("string" == typeof _) O = _.split(",");
                            else
                                for (x = 0; x < P.matches.length; x++) O.push(x);
                            for (var S = 0; S < O.length; S++) {
                                if (x = parseInt(O[S]), p = [], a = k(u, x, A) || M.slice(), !0 !== (o = f(P.matches[x] || n.matches[x], [x].concat(c), v) || o) && o !== i && O[O.length - 1] < P.matches.length) {
                                    var D = e.inArray(o, n.matches) +
                                        1;
                                    n.matches.length > D && (o = f(n.matches[D], [D].concat(c.slice(1, c.length)), v)) && (O.push(D.toString()), e.each(p, function(e, t) {
                                        t.alternation = c.length - 1
                                    }))
                                }
                                b = p.slice(), u = w, p = [];
                                for (var j = 0; j < b.length; j++) {
                                    var T = b[j],
                                        G = !1;
                                    T.alternation = T.alternation || A;
                                    for (var L = 0; L < E.length; L++) {
                                        var B = E[L];
                                        if ("string" != typeof _ || -1 !== e.inArray(T.locator[T.alternation].toString(), O)) {
                                            if (function(e, t) {
                                                    return e.match.nativeDef === t.match.nativeDef || e.match.def === t.match.nativeDef || e.match.nativeDef === t.match.def
                                                }(T, B)) {
                                                G = !0,
                                                    T.alternation === B.alternation && -1 === B.locator[B.alternation].toString().indexOf(T.locator[T.alternation]) && (B.locator[B.alternation] = B.locator[B.alternation] + "," + T.locator[T.alternation], B.alternation = T.alternation), T.match.nativeDef === B.match.def && (T.locator[T.alternation] = B.locator[B.alternation], E.splice(E.indexOf(B), 1, T));
                                                break
                                            }
                                            if (T.match.def === B.match.def) {
                                                G = !1;
                                                break
                                            }
                                            if (function(e, n) {
                                                    return null === e.match.fn && null !== n.match.fn && n.match.fn.test(e.match.def, m(), t, !1, l, !1)
                                                }(T, B) || function(e, n) {
                                                    return null !==
                                                        e.match.fn && null !== n.match.fn && n.match.fn.test(e.match.def.replace(/[\[\]]/g, ""), m(), t, !1, l, !1)
                                                }(T, B)) {
                                                T.alternation === B.alternation && -1 === T.locator[T.alternation].toString().indexOf(B.locator[B.alternation].toString().split("")[0]) && (T.na = T.na || T.locator[T.alternation].toString(), -1 === T.na.indexOf(T.locator[T.alternation].toString().split("")[0]) && (T.na = T.na + "," + T.locator[B.alternation].toString().split("")[0]), G = !0, T.locator[T.alternation] = B.locator[B.alternation].toString().split("")[0] + "," + T.locator[T.alternation],
                                                    E.splice(E.indexOf(B), 0, T));
                                                break
                                            }
                                        }
                                    }
                                    G || E.push(T)
                                }
                            }
                            "string" == typeof _ && (E = e.map(E, function(t, n) {
                                if (isFinite(n)) {
                                    var a = t.alternation,
                                        r = t.locator[a].toString().split(",");
                                    t.locator[a] = i, t.alternation = i;
                                    for (var o = 0; o < r.length; o++) - 1 !== e.inArray(r[o], O) && (t.locator[a] !== i ? (t.locator[a] += ",", t.locator[a] += r[o]) : t.locator[a] = parseInt(r[o]), t.alternation = a);
                                    if (t.locator[a] !== i) return t
                                }
                            })), p = C.concat(E), u = t, h = p.length > 0, o = E.length > 0, a = M.slice()
                        } else o = f(P.matches[_] || n.matches[_], [_].concat(c), v);
                        if (o) return !0
                    } else if (o.isQuantifier &&
                        v !== n.matches[e.inArray(o, n.matches) - 1])
                        for (var I = o, F = a.length > 0 ? a.shift() : 0; F < (isNaN(I.quantifier.max) ? F + 1 : I.quantifier.max) && u <= t; F++) {
                            var N = n.matches[e.inArray(I, n.matches) - 1];
                            if (o = f(N, [F].concat(c), N)) {
                                if (s = p[p.length - 1].match, s.optionalQuantifier = F > I.quantifier.min - 1, g(s, N)) {
                                    if (F > I.quantifier.min - 1) {
                                        h = !0, u = t;
                                        break
                                    }
                                    return !0
                                }
                                return !0
                            }
                        } else {
                            if (o = r(o, a, c, v)) return !0
                        } else u++
                }
                for (var v = a.length > 0 ? a.shift() : 0; v < n.matches.length; v++)
                    if (!0 !== n.matches[v].isQuantifier) {
                        var g = f(n.matches[v], [v].concat(o),
                            c);
                        if (g && u === t) return g;
                        if (u > t) break
                    }
            }

            function o(e) {
                if (l.keepStatic && t > 0 && e.length > 1 + ("" === e[e.length - 1].match.def ? 1 : 0) && !0 !== e[0].match.optionality && !0 !== e[0].match.optionalQuantifier && null === e[0].match.fn && !/[0-9a-bA-Z]/.test(e[0].match.def)) {
                    if (m().validPositions[t - 1] === i) return [k(e)];
                    if (m().validPositions[t - 1].alternation === e[0].alternation) return [k(e)];
                    if (m().validPositions[t - 1]) return [k(e)]
                }
                return e
            }
            var s, c = m().maskToken,
                u = n ? a : 0,
                f = n ? n.slice() : [0],
                p = [],
                h = !1,
                d = n ? n.join("") : "";
            if (t > -1) {
                if (n ===
                    i) {
                    for (var v, g = t - 1;
                        (v = m().validPositions[g] || m().tests[g]) === i && g > -1;) g--;
                    v !== i && g > -1 && (f = function(t) {
                        var n = [];
                        return e.isArray(t) || (t = [t]), t.length > 0 && (t[0].alternation === i ? 0 === (n = k(t.slice()).locator.slice()).length && (n = t[0].locator.slice()) : e.each(t, function(e, t) {
                            if ("" !== t.def)
                                if (0 === n.length) n = t.locator.slice();
                                else
                                    for (var i = 0; i < n.length; i++) t.locator[i] && -1 === n[i].toString().indexOf(t.locator[i]) && (n[i] += "," + t.locator[i])
                        })), n
                    }(v), d = f.join(""), u = g)
                }
                if (m().tests[t] && m().tests[t][0].cd === d) return o(m().tests[t]);
                for (var y = f.shift(); y < c.length && !(r(c[y], f, [y]) && u === t || u > t); y++);
            }
            return (0 === p.length || h) && p.push({
                match: {
                    fn: null,
                    cardinality: 0,
                    optionality: !0,
                    casing: null,
                    def: "",
                    placeholder: ""
                },
                locator: [],
                cd: d
            }), n !== i && m().tests[t] ? o(e.extend(!0, [], p)) : (m().tests[t] = e.extend(!0, [], p), o(m().tests[t]))
        }

        function C() {
            return m()._buffer === i && (m()._buffer = h(!1, 1), m().buffer === i && (m().buffer = m()._buffer.slice())), m()._buffer
        }

        function A(e) {
            return m().buffer !== i && !0 !== e || (m().buffer = h(!0, v(), !0)), m().buffer
        }

        function _(e,
            t, n) {
            var a, r;
            if (!0 === e) d(), e = 0, t = n.length;
            else
                for (a = e; a < t; a++) delete m().validPositions[a];
            for (r = e, a = e; a < t; a++)
                if (d(!0), n[a] !== l.skipOptionalPartCharacter) {
                    var o = M(r, n[a], !0, !0);
                    !1 !== o && (d(!0), r = o.caret !== i ? o.caret : o.pos + 1)
                }
        }

        function x(t, n, i) {
            switch (l.casing || n.casing) {
                case "upper":
                    t = t.toUpperCase();
                    break;
                case "lower":
                    t = t.toLowerCase();
                    break;
                case "title":
                    var r = m().validPositions[i - 1];
                    t = 0 === i || r && r.input === String.fromCharCode(a.keyCode.SPACE) ? t.toUpperCase() : t.toLowerCase();
                    break;
                default:
                    if (e.isFunction(l.casing)) {
                        var o =
                            Array.prototype.slice.call(arguments);
                        o.push(m().validPositions), t = l.casing.apply(this, o)
                    }
            }
            return t
        }

        function w(t, n, a) {
            for (var r, o = l.greedy ? n : n.slice(0, 1), s = !1, c = a !== i ? a.split(",") : [], u = 0; u < c.length; u++) - 1 !== (r = t.indexOf(c[u])) && t.splice(r, 1);
            for (var f = 0; f < t.length; f++)
                if (-1 !== e.inArray(t[f], o)) {
                    s = !0;
                    break
                }
            return s
        }

        function M(t, n, r, o, s, c) {
            function u(e) {
                var t = z ? e.begin - e.end > 1 || e.begin - e.end == 1 : e.end - e.begin > 1 || e.end - e.begin == 1;
                return t && 0 === e.begin && e.end === m().maskLength ? "full" : t
            }

            function f(n, a, r) {
                var s = !1;
                return e.each(E(n), function(c, f) {
                    for (var h = f.match, k = a ? 1 : 0, y = "", b = h.cardinality; b > k; b--) y += j(n - (b - 1));
                    if (a && (y += a), A(!0), !1 !== (s = null != h.fn ? h.fn.test(y, m(), n, r, l, u(t)) : (a === h.def || a === l.skipOptionalPartCharacter) && "" !== h.def && {
                            c: G(n, h, !0) || h.def,
                            pos: n
                        })) {
                        var P = s.c !== i ? s.c : a;
                        P = P === l.skipOptionalPartCharacter && null === h.fn ? G(n, h, !0) || h.def : P;
                        var E = n,
                            C = A();
                        if (s.remove !== i && (e.isArray(s.remove) || (s.remove = [s.remove]), e.each(s.remove.sort(function(e, t) {
                                return t - e
                            }), function(e, t) {
                                g(t, t + 1, !0)
                            })), s.insert !==
                            i && (e.isArray(s.insert) || (s.insert = [s.insert]), e.each(s.insert.sort(function(e, t) {
                                return e - t
                            }), function(e, t) {
                                M(t.pos, t.c, !0, o)
                            })), s.refreshFromBuffer) {
                            var w = s.refreshFromBuffer;
                            if (_(!0 === w ? w : w.start, w.end, C), s.pos === i && s.c === i) return s.pos = v(), !1;
                            if ((E = s.pos !== i ? s.pos : n) !== n) return s = e.extend(s, M(E, P, !0, o)), !1
                        } else if (!0 !== s && s.pos !== i && s.pos !== n && (E = s.pos, _(n, E, A().slice()), E !== n)) return s = e.extend(s, M(E, P, !0)), !1;
                        return (!0 === s || s.pos !== i || s.c !== i) && (c > 0 && d(!0), p(E, e.extend({}, f, {
                                input: x(P, h, E)
                            }),
                            o, u(t)) || (s = !1), !1)
                    }
                }), s
            }

            function p(t, n, a, r) {
                if (r || l.insertMode && m().validPositions[t] !== i && a === i) {
                    var o, s = e.extend(!0, {}, m().validPositions),
                        c = v(i, !0);
                    for (o = t; o <= c; o++) delete m().validPositions[o];
                    m().validPositions[t] = e.extend(!0, {}, n);
                    var u, f = !0,
                        p = m().validPositions,
                        g = !1,
                        k = m().maskLength;
                    for (o = u = t; o <= c; o++) {
                        var y = s[o];
                        if (y !== i)
                            for (var b = u; b < m().maskLength && (null === y.match.fn && p[o] && (!0 === p[o].match.optionalQuantifier || !0 === p[o].match.optionality) || null != y.match.fn);) {
                                if (b++, !1 === g && s[b] && s[b].match.def ===
                                    y.match.def) m().validPositions[b] = e.extend(!0, {}, s[b]), m().validPositions[b].input = y.input, h(b), u = b, f = !0;
                                else if (P(b, y.match.def)) {
                                    var E = M(b, y.input, !0, !0);
                                    f = !1 !== E, u = E.caret || E.insert ? v() : b, g = !0
                                } else if (!(f = !0 === y.generatedInput) && b >= m().maskLength - 1) break;
                                if (m().maskLength < k && (m().maskLength = k), f) break
                            }
                        if (!f) break
                    }
                    if (!f) return m().validPositions = e.extend(!0, {}, s), d(!0), !1
                } else m().validPositions[t] = e.extend(!0, {}, n);
                return d(!0), !0
            }

            function h(t) {
                for (var n = t - 1; n > -1 && !m().validPositions[n]; n--);
                var a,
                    r;
                for (n++; n < t; n++) m().validPositions[n] === i && (!1 === l.jitMasking || l.jitMasking > n) && ("" === (r = E(n, y(n - 1).locator, n - 1).slice())[r.length - 1].match.def && r.pop(), (a = k(r)) && (a.match.def === l.radixPointDefinitionSymbol || !O(n, !0) || e.inArray(l.radixPoint, A()) < n && a.match.fn && a.match.fn.test(G(n), m(), n, !1, l)) && !1 !== (C = f(n, G(n, a.match, !0) || (null == a.match.fn ? a.match.def : "" !== G(n) ? G(n) : A()[n]), !0)) && (m().validPositions[C.pos || n].generatedInput = !0))
            }
            r = !0 === r;
            var b = t;
            t.begin !== i && (b = z && !u(t) ? t.end : t.begin);
            var C = !0,
                D = e.extend(!0, {}, m().validPositions);
            if (e.isFunction(l.preValidation) && !r && !0 !== o && !0 !== c && (C = l.preValidation(A(), b, n, u(t), l)), !0 === C) {
                if (h(b), u(t) && (K(i, a.keyCode.DELETE, t, !0, !0), b = m().p), b < m().maskLength && (W === i || b < W) && (C = f(b, n, r), (!r || !0 === o) && !1 === C && !0 !== c)) {
                    var T = m().validPositions[b];
                    if (!T || null !== T.match.fn || T.match.def !== n && n !== l.skipOptionalPartCharacter) {
                        if ((l.insertMode || m().validPositions[S(b)] === i) && !O(b, !0))
                            for (var L = b + 1, B = S(b); L <= B; L++)
                                if (!1 !== (C = f(L, n, r))) {
                                    ! function(t, n) {
                                        var a = m().validPositions[n];
                                        if (a)
                                            for (var r = a.locator, o = r.length, s = t; s < n; s++)
                                                if (m().validPositions[s] === i && !O(s, !0)) {
                                                    var l = E(s).slice(),
                                                        c = k(l, !0),
                                                        u = -1;
                                                    "" === l[l.length - 1].match.def && l.pop(), e.each(l, function(e, t) {
                                                        for (var n = 0; n < o; n++) {
                                                            if (t.locator[n] === i || !w(t.locator[n].toString().split(","), r[n].toString().split(","), t.na)) {
                                                                var a = r[n],
                                                                    s = c.locator[n],
                                                                    l = t.locator[n];
                                                                a - s > Math.abs(a - l) && (c = t);
                                                                break
                                                            }
                                                            u < n && (u = n, c = t)
                                                        }
                                                    }), (c = e.extend({}, c, {
                                                        input: G(s, c.match, !0) || c.match.def
                                                    })).generatedInput = !0, p(s, c, !0), m().validPositions[n] = i, f(n, a.input, !0)
                                                }
                                    }(b, C.pos !== i ? C.pos : L), b = L;
                                    break
                                }
                    } else C = {
                        caret: S(b)
                    }
                }!1 === C && l.keepStatic && !r && !0 !== s && (C = function(t, n, a) {
                    var r, s, c, u, f, p, h, g, k = e.extend(!0, {}, m().validPositions),
                        y = !1,
                        b = v();
                    for (u = m().validPositions[b]; b >= 0; b--)
                        if ((c = m().validPositions[b]) && c.alternation !== i) {
                            if (r = b, s = m().validPositions[r].alternation, u.locator[c.alternation] !== c.locator[c.alternation]) break;
                            u = c
                        }
                    if (s !== i) {
                        g = parseInt(r);
                        var P = u.locator[u.alternation || s] !== i ? u.locator[u.alternation || s] : h[0];
                        P.length > 0 && (P = P.split(",")[0]);
                        var C =
                            m().validPositions[g],
                            A = m().validPositions[g - 1];
                        e.each(E(g, A ? A.locator : i, g - 1), function(r, c) {
                            h = c.locator[s] ? c.locator[s].toString().split(",") : [];
                            for (var u = 0; u < h.length; u++) {
                                var b = [],
                                    E = 0,
                                    A = 0,
                                    _ = !1;
                                if (P < h[u] && (c.na === i || -1 === e.inArray(h[u], c.na.split(",")) || -1 === e.inArray(P.toString(), h))) {
                                    m().validPositions[g] = e.extend(!0, {}, c);
                                    var x = m().validPositions[g].locator;
                                    for (m().validPositions[g].locator[s] = parseInt(h[u]), null == c.match.fn ? (C.input !== c.match.def && (_ = !0, !0 !== C.generatedInput && b.push(C.input)),
                                            A++, m().validPositions[g].generatedInput = !/[0-9a-bA-Z]/.test(c.match.def), m().validPositions[g].input = c.match.def) : m().validPositions[g].input = C.input, f = g + 1; f < v(i, !0) + 1; f++)(p = m().validPositions[f]) && !0 !== p.generatedInput && /[0-9a-bA-Z]/.test(p.input) ? b.push(p.input) : f < t && E++, delete m().validPositions[f];
                                    for (_ && b[0] === c.match.def && b.shift(), d(!0), y = !0; b.length > 0;) {
                                        var w = b.shift();
                                        if (w !== l.skipOptionalPartCharacter && !(y = M(v(i, !0) + 1, w, !1, o, !0))) break
                                    }
                                    if (y) {
                                        m().validPositions[g].locator = x;
                                        var O = v(t) +
                                            1;
                                        for (f = g + 1; f < v() + 1; f++)((p = m().validPositions[f]) === i || null == p.match.fn) && f < t + (A - E) && A++;
                                        y = M((t += A - E) > O ? O : t, n, a, o, !0)
                                    }
                                    if (y) return !1;
                                    d(), m().validPositions = e.extend(!0, {}, k)
                                }
                            }
                        })
                    }
                    return y
                }(b, n, r)), !0 === C && (C = {
                    pos: b
                })
            }
            if (e.isFunction(l.postValidation) && !1 !== C && !r && !0 !== o && !0 !== c) {
                var I = l.postValidation(A(!0), C, l);
                if (I.refreshFromBuffer && I.buffer) {
                    var F = I.refreshFromBuffer;
                    _(!0 === F ? F : F.start, F.end, I.buffer)
                }
                C = !0 === I ? C : I
            }
            return C && C.pos === i && (C.pos = b), !1 !== C && !0 !== c || (d(!0), m().validPositions = e.extend(!0, {}, D)), C
        }

        function O(e, t) {
            var n = y(e).match;
            if ("" === n.def && (n = b(e).match), null != n.fn) return n.fn;
            if (!0 !== t && e > -1) {
                var i = E(e);
                return i.length > 1 + ("" === i[i.length - 1].match.def ? 1 : 0)
            }
            return !1
        }

        function S(e, t) {
            var n = m().maskLength;
            if (e >= n) return n;
            var i = e;
            for (E(n + 1).length > 1 && (h(!0, n + 1, !0), n = m().maskLength); ++i < n && (!0 === t && (!0 !== b(i).match.newBlockMarker || !O(i)) || !0 !== t && !O(i)););
            return i
        }

        function D(e, t) {
            var n, i = e;
            if (i <= 0) return 0;
            for (; --i > 0 && (!0 === t && !0 !== b(i).match.newBlockMarker || !0 !== t && !O(i) && ((n = E(i)).length <
                    2 || 2 === n.length && "" === n[1].match.def)););
            return i
        }

        function j(e) {
            return m().validPositions[e] === i ? G(e) : m().validPositions[e].input
        }

        function T(t, n, a, r, o) {
            if (r && e.isFunction(l.onBeforeWrite)) {
                var s = l.onBeforeWrite.call(Z, r, n, a, l);
                if (s) {
                    if (s.refreshFromBuffer) {
                        var c = s.refreshFromBuffer;
                        _(!0 === c ? c : c.start, c.end, s.buffer || n), n = A(!0)
                    }
                    a !== i && (a = s.caret !== i ? s.caret : a)
                }
            }
            t !== i && (t.inputmask._valueSet(n.join("")), a === i || r !== i && "blur" === r.type ? V(t, a, 0 === n.length) : p && r && "input" === r.type ? setTimeout(function() {
                I(t,
                    a)
            }, 0) : I(t, a), !0 === o && (J = !0, e(t).trigger("input")))
        }

        function G(t, n, a) {
            if ((n = n || b(t).match).placeholder !== i || !0 === a) return e.isFunction(n.placeholder) ? n.placeholder(l) : n.placeholder;
            if (null === n.fn) {
                if (t > -1 && m().validPositions[t] === i) {
                    var r, o = E(t),
                        s = [];
                    if (o.length > 1 + ("" === o[o.length - 1].match.def ? 1 : 0))
                        for (var c = 0; c < o.length; c++)
                            if (!0 !== o[c].match.optionality && !0 !== o[c].match.optionalQuantifier && (null === o[c].match.fn || r === i || !1 !== o[c].match.fn.test(r.match.def, m(), t, !0, l)) && (s.push(o[c]), null === o[c].match.fn &&
                                    (r = o[c]), s.length > 1 && /[0-9a-bA-Z]/.test(s[0].match.def))) return l.placeholder.charAt(t % l.placeholder.length)
                }
                return n.def
            }
            return l.placeholder.charAt(t % l.placeholder.length)
        }

        function L(t, r, o, s, c) {
            function u(e, t) {
                return -1 !== C().slice(e, S(e)).join("").indexOf(t) && !O(e) && b(e).match.nativeDef === t.charAt(t.length - 1)
            }
            var f = s.slice(),
                p = "",
                h = -1,
                g = i;
            if (d(), o || !0 === l.autoUnmask) h = S(h);
            else {
                var k = C().slice(0, S(-1)).join(""),
                    P = f.join("").match(new RegExp("^" + a.escapeRegex(k), "g"));
                P && P.length > 0 && (f.splice(0,
                    P.length * k.length), h = S(h))
            }
            if (-1 === h ? (m().p = S(h), h = 0) : m().p = h, e.each(f, function(n, a) {
                    if (a !== i)
                        if (m().validPositions[n] === i && f[n] === G(n) && O(n, !0) && !1 === M(n, f[n], !0, i, i, !0)) m().p++;
                        else {
                            var r = new e.Event("_checkval");
                            r.which = a.charCodeAt(0), p += a;
                            var s = v(i, !0),
                                c = m().validPositions[s],
                                k = y(s + 1, c ? c.locator.slice() : i, s);
                            if (!u(h, p) || o || l.autoUnmask) {
                                var b = o ? n : null == k.match.fn && k.match.optionality && s + 1 < m().p ? s + 1 : m().p;
                                g = ne.keypressEvent.call(t, r, !0, !1, o, b), h = b + 1, p = ""
                            } else g = ne.keypressEvent.call(t, r, !0, !1, !0, s + 1);
                            if (!1 !== g && !o && e.isFunction(l.onBeforeWrite)) {
                                var P = g;
                                if (g = l.onBeforeWrite.call(Z, r, A(), g.forwardPosition, l), (g = e.extend(P, g)) && g.refreshFromBuffer) {
                                    var E = g.refreshFromBuffer;
                                    _(!0 === E ? E : E.start, E.end, g.buffer), d(!0), g.caret && (m().p = g.caret, g.forwardPosition = g.caret)
                                }
                            }
                        }
                }), r) {
                var E = i;
                n.activeElement === t && g && (E = l.numericInput ? D(g.forwardPosition) : g.forwardPosition), T(t, A(), E, c || new e.Event("checkval"), c && "input" === c.type)
            }
        }

        function B(t) {
            if (t) {
                if (t.inputmask === i) return t.value;
                t.inputmask && t.inputmask.refreshValue &&
                    ne.setValueEvent.call(t)
            }
            var n = [],
                a = m().validPositions;
            for (var r in a) a[r].match && null != a[r].match.fn && n.push(a[r].input);
            var o = 0 === n.length ? "" : (z ? n.reverse() : n).join("");
            if (e.isFunction(l.onUnMask)) {
                var s = (z ? A().slice().reverse() : A()).join("");
                o = l.onUnMask.call(Z, s, o, l)
            }
            return o
        }

        function I(e, a, r, o) {
            function s(e) {
                return !0 === o || !z || "number" != typeof e || l.greedy && "" === l.placeholder || (e = A().join("").length - e), e
            }
            var u;
            if (a === i) return e.setSelectionRange ? (a = e.selectionStart, r = e.selectionEnd) : t.getSelection ?
                (u = t.getSelection().getRangeAt(0)).commonAncestorContainer.parentNode !== e && u.commonAncestorContainer !== e || (a = u.startOffset, r = u.endOffset) : n.selection && n.selection.createRange && (r = (a = 0 - (u = n.selection.createRange()).duplicate().moveStart("character", -e.inputmask._valueGet().length)) + u.text.length), {
                    begin: s(a),
                    end: s(r)
                };
            if (a.begin !== i && (r = a.end, a = a.begin), "number" == typeof a) {
                a = s(a), r = "number" == typeof(r = s(r)) ? r : a;
                var f = parseInt(((e.ownerDocument.defaultView || t).getComputedStyle ? (e.ownerDocument.defaultView ||
                    t).getComputedStyle(e, null) : e.currentStyle).fontSize) * r;
                if (e.scrollLeft = f > e.scrollWidth ? f : 0, c || !1 !== l.insertMode || a !== r || r++, e.setSelectionRange) e.selectionStart = a, e.selectionEnd = r;
                else if (t.getSelection) {
                    if (u = n.createRange(), e.firstChild === i || null === e.firstChild) {
                        var p = n.createTextNode("");
                        e.appendChild(p)
                    }
                    u.setStart(e.firstChild, a < e.inputmask._valueGet().length ? a : e.inputmask._valueGet().length), u.setEnd(e.firstChild, r < e.inputmask._valueGet().length ? r : e.inputmask._valueGet().length), u.collapse(!0);
                    var h = t.getSelection();
                    h.removeAllRanges(), h.addRange(u)
                } else e.createTextRange && ((u = e.createTextRange()).collapse(!0), u.moveEnd("character", r), u.moveStart("character", a), u.select());
                V(e, {
                    begin: a,
                    end: r
                })
            }
        }

        function F(t) {
            var n, a, r = A(),
                o = r.length,
                s = v(),
                l = {},
                c = m().validPositions[s],
                u = c !== i ? c.locator.slice() : i;
            for (n = s + 1; n < r.length; n++) u = (a = y(n, u, n - 1)).locator.slice(), l[n] = e.extend(!0, {}, a);
            var f = c && c.alternation !== i ? c.locator[c.alternation] : i;
            for (n = o - 1; n > s && (((a = l[n]).match.optionality || a.match.optionalQuantifier &&
                    a.match.newBlockMarker || f && (f !== l[n].locator[c.alternation] && null != a.match.fn || null === a.match.fn && a.locator[c.alternation] && w(a.locator[c.alternation].toString().split(","), f.toString().split(",")) && "" !== E(n)[0].def)) && r[n] === G(n, a.match)); n--) o--;
            return t ? {
                l: o,
                def: l[o] ? l[o].match : i
            } : o
        }

        function N(e) {
            for (var t, n = F(), a = e.length, r = m().validPositions[v()]; n < a && !O(n, !0) && (t = r !== i ? y(n, r.locator.slice(""), r) : b(n)) && !0 !== t.match.optionality && (!0 !== t.match.optionalQuantifier && !0 !== t.match.newBlockMarker ||
                    n + 1 === a && "" === (r !== i ? y(n + 1, r.locator.slice(""), r) : b(n + 1)).match.def);) n++;
            for (;
                (t = m().validPositions[n - 1]) && t && t.match.optionality && t.input === l.skipOptionalPartCharacter;) n--;
            return e.splice(n), e
        }

        function R(t) {
            if (e.isFunction(l.isComplete)) return l.isComplete(t, l);
            if ("*" === l.repeat) return i;
            var n = !1,
                a = F(!0),
                r = D(a.l);
            if (a.def === i || a.def.newBlockMarker || a.def.optionality || a.def.optionalQuantifier) {
                n = !0;
                for (var o = 0; o <= r; o++) {
                    var s = y(o).match;
                    if (null !== s.fn && m().validPositions[o] === i && !0 !== s.optionality &&
                        !0 !== s.optionalQuantifier || null === s.fn && t[o] !== G(o, s)) {
                        n = !1;
                        break
                    }
                }
            }
            return n
        }

        function K(t, n, r, o, s) {
            if ((l.numericInput || z) && (n === a.keyCode.BACKSPACE ? n = a.keyCode.DELETE : n === a.keyCode.DELETE && (n = a.keyCode.BACKSPACE), z)) {
                var c = r.end;
                r.end = r.begin, r.begin = c
            }
            n === a.keyCode.BACKSPACE && (r.end - r.begin < 1 || !1 === l.insertMode) ? (r.begin = D(r.begin), m().validPositions[r.begin] !== i && m().validPositions[r.begin].input === l.groupSeparator && r.begin--) : n === a.keyCode.DELETE && r.begin === r.end && (r.end = O(r.end, !0) && m().validPositions[r.end] &&
                m().validPositions[r.end].input !== l.radixPoint ? r.end + 1 : S(r.end) + 1, m().validPositions[r.begin] !== i && m().validPositions[r.begin].input === l.groupSeparator && r.end++), g(r.begin, r.end, !1, o), !0 !== o && function() {
                if (l.keepStatic) {
                    for (var n = [], a = v(-1, !0), r = e.extend(!0, {}, m().validPositions), o = m().validPositions[a]; a >= 0; a--) {
                        var s = m().validPositions[a];
                        if (s) {
                            if (!0 !== s.generatedInput && /[0-9a-bA-Z]/.test(s.input) && n.push(s.input), delete m().validPositions[a], s.alternation !== i && s.locator[s.alternation] !== o.locator[s.alternation]) break;
                            o = s
                        }
                    }
                    if (a > -1)
                        for (m().p = S(v(-1, !0)); n.length > 0;) {
                            var c = new e.Event("keypress");
                            c.which = n.pop().charCodeAt(0), ne.keypressEvent.call(t, c, !0, !1, !1, m().p)
                        } else m().validPositions = e.extend(!0, {}, r)
                }
            }();
            var u = v(r.begin, !0);
            if (u < r.begin) m().p = S(u);
            else if (!0 !== o && (m().p = r.begin, !0 !== s))
                for (; m().p < u && m().validPositions[m().p] === i;) m().p++
        }

        function U(i) {
            function a(e) {
                var t, a = n.createElement("span");
                for (var o in r) isNaN(o) && -1 !== o.indexOf("font") && (a.style[o] = r[o]);
                a.style.textTransform = r.textTransform, a.style.letterSpacing =
                    r.letterSpacing, a.style.position = "absolute", a.style.height = "auto", a.style.width = "auto", a.style.visibility = "hidden", a.style.whiteSpace = "nowrap", n.body.appendChild(a);
                var s, l = i.inputmask._valueGet(),
                    c = 0;
                for (t = 0, s = l.length; t <= s; t++) {
                    if (a.innerHTML += l.charAt(t) || "_", a.offsetWidth >= e) {
                        var u = e - c,
                            f = a.offsetWidth - e;
                        a.innerHTML = l.charAt(t), t = (u -= a.offsetWidth / 3) < f ? t - 1 : t;
                        break
                    }
                    c = a.offsetWidth
                }
                return n.body.removeChild(a), t
            }
            var r = (i.ownerDocument.defaultView || t).getComputedStyle(i, null),
                o = n.createElement("div");
            o.style.width = r.width, o.style.textAlign = r.textAlign, (q = n.createElement("div")).className = "im-colormask", i.parentNode.insertBefore(q, i), i.parentNode.removeChild(i), q.appendChild(o), q.appendChild(i), i.style.left = o.offsetLeft + "px", e(i).on("click", function(e) {
                return I(i, a(e.clientX)), ne.clickEvent.call(i, [e])
            }), e(i).on("keydown", function(e) {
                e.shiftKey || !1 === l.insertMode || setTimeout(function() {
                    V(i)
                }, 0)
            })
        }

        function V(e, t, a) {
            function r() {
                p || null !== s.fn && c.input !== i ? p && (null !== s.fn && c.input !== i || "" === s.def) &&
                    (p = !1, f += "</span>") : (p = !0, f += "<span class='im-static'>")
            }

            function o(i) {
                !0 !== i && h !== t.begin || n.activeElement !== e || (f += "<span class='im-caret' style='border-right-width: 1px;border-right-style: solid;'></span>")
            }
            var s, c, u, f = "",
                p = !1,
                h = 0;
            if (q !== i) {
                var d = A();
                if (t === i ? t = I(e) : t.begin === i && (t = {
                        begin: t,
                        end: t
                    }), !0 !== a) {
                    var g = v();
                    do o(), m().validPositions[h] ? (c = m().validPositions[h], s = c.match, u = c.locator.slice(), r(), f += d[h]) : (c = y(h, u, h - 1), s = c.match, u = c.locator.slice(), (!1 === l.jitMasking || h < g || "number" == typeof l.jitMasking &&
                        isFinite(l.jitMasking) && l.jitMasking > h) && (r(), f += G(h, s))), h++; while ((W === i || h < W) && (null !== s.fn || "" !== s.def) || g > h || p); - 1 === f.indexOf("im-caret") && o(!0), p && r()
                }
                var k = q.getElementsByTagName("div")[0];
                k.innerHTML = f, e.inputmask.positionColorMask(e, k)
            }
        }
        o = o || this.maskset, l = l || this.opts;
        var H, Q, W, q, Z = this,
            $ = this.el,
            z = this.isRTL,
            X = !1,
            J = !1,
            Y = !1,
            ee = !1,
            te = {
                on: function(t, n, r) {
                    var o = function(t) {
                        if (this.inputmask === i && "FORM" !== this.nodeName) {
                            var n = e.data(this, "_inputmask_opts");
                            n ? (new a(n)).mask(this) : te.off(this)
                        } else {
                            if ("setvalue" ===
                                t.type || "FORM" === this.nodeName || !(this.disabled || this.readOnly && !("keydown" === t.type && t.ctrlKey && 67 === t.keyCode || !1 === l.tabThrough && t.keyCode === a.keyCode.TAB))) {
                                switch (t.type) {
                                    case "input":
                                        if (!0 === J) return J = !1, t.preventDefault();
                                        break;
                                    case "keydown":
                                        X = !1, J = !1;
                                        break;
                                    case "keypress":
                                        if (!0 === X) return t.preventDefault();
                                        X = !0;
                                        break;
                                    case "click":
                                        if (u || f) {
                                            var o = this,
                                                s = arguments;
                                            return setTimeout(function() {
                                                r.apply(o, s)
                                            }, 0), !1
                                        }
                                }
                                var c = r.apply(this, arguments);
                                return !1 === c && (t.preventDefault(), t.stopPropagation()),
                                    c
                            }
                            t.preventDefault()
                        }
                    };
                    t.inputmask.events[n] = t.inputmask.events[n] || [], t.inputmask.events[n].push(o), -1 !== e.inArray(n, ["submit", "reset"]) ? null !== t.form && e(t.form).on(n, o) : e(t).on(n, o)
                },
                off: function(t, n) {
                    if (t.inputmask && t.inputmask.events) {
                        var i;
                        n ? (i = [])[n] = t.inputmask.events[n] : i = t.inputmask.events, e.each(i, function(n, i) {
                            for (; i.length > 0;) {
                                var a = i.pop(); - 1 !== e.inArray(n, ["submit", "reset"]) ? null !== t.form && e(t.form).off(n, a) : e(t).off(n, a)
                            }
                            delete t.inputmask.events[n]
                        })
                    }
                }
            },
            ne = {
                keydownEvent: function(t) {
                    var i =
                        this,
                        r = e(i),
                        o = t.keyCode,
                        s = I(i);
                    if (o === a.keyCode.BACKSPACE || o === a.keyCode.DELETE || f && o === a.keyCode.BACKSPACE_SAFARI || t.ctrlKey && o === a.keyCode.X && ! function(e) {
                            var t = n.createElement("input"),
                                i = "on" + e,
                                a = i in t;
                            return a || (t.setAttribute(i, "return;"), a = "function" == typeof t[i]), t = null, a
                        }("cut")) t.preventDefault(), K(i, o, s), T(i, A(!0), m().p, t, i.inputmask._valueGet() !== A().join("")), i.inputmask._valueGet() === C().join("") ? r.trigger("cleared") : !0 === R(A()) && r.trigger("complete");
                    else if (o === a.keyCode.END || o ===
                        a.keyCode.PAGE_DOWN) {
                        t.preventDefault();
                        var c = S(v());
                        l.insertMode || c !== m().maskLength || t.shiftKey || c--, I(i, t.shiftKey ? s.begin : c, c, !0)
                    } else o === a.keyCode.HOME && !t.shiftKey || o === a.keyCode.PAGE_UP ? (t.preventDefault(), I(i, 0, t.shiftKey ? s.begin : 0, !0)) : (l.undoOnEscape && o === a.keyCode.ESCAPE || 90 === o && t.ctrlKey) && !0 !== t.altKey ? (L(i, !0, !1, H.split("")), r.trigger("click")) : o !== a.keyCode.INSERT || t.shiftKey || t.ctrlKey ? !0 === l.tabThrough && o === a.keyCode.TAB ? (!0 === t.shiftKey ? (null === b(s.begin).match.fn && (s.begin = S(s.begin)),
                        s.end = D(s.begin, !0), s.begin = D(s.end, !0)) : (s.begin = S(s.begin, !0), s.end = S(s.begin, !0), s.end < m().maskLength && s.end--), s.begin < m().maskLength && (t.preventDefault(), I(i, s.begin, s.end))) : t.shiftKey || !1 === l.insertMode && (o === a.keyCode.RIGHT ? setTimeout(function() {
                        var e = I(i);
                        I(i, e.begin)
                    }, 0) : o === a.keyCode.LEFT && setTimeout(function() {
                        var e = I(i);
                        I(i, z ? e.begin + 1 : e.begin - 1)
                    }, 0)) : (l.insertMode = !l.insertMode, I(i, l.insertMode || s.begin !== m().maskLength ? s.begin : s.begin - 1));
                    l.onKeyDown.call(this, t, A(), I(i).begin, l), Y = -1 !== e.inArray(o, l.ignorables)
                },
                keypressEvent: function(t, n, r, o, s) {
                    var c = this,
                        u = e(c),
                        f = t.which || t.charCode || t.keyCode;
                    if (!(!0 === n || t.ctrlKey && t.altKey) && (t.ctrlKey || t.metaKey || Y)) return f === a.keyCode.ENTER && H !== A().join("") && (H = A().join(""), setTimeout(function() {
                        u.trigger("change")
                    }, 0)), !0;
                    if (f) {
                        46 === f && !1 === t.shiftKey && "" !== l.radixPoint && (f = l.radixPoint.charCodeAt(0));
                        var p, h = n ? {
                                begin: s,
                                end: s
                            } : I(c),
                            v = String.fromCharCode(f);
                        m().writeOutBuffer = !0;
                        var g = M(h, v, o);
                        if (!1 !== g && (d(!0), p = g.caret !== i ? g.caret :
                                n ? g.pos + 1 : S(g.pos), m().p = p), !1 !== r && (setTimeout(function() {
                                l.onKeyValidation.call(c, f, g, l)
                            }, 0), m().writeOutBuffer && !1 !== g)) {
                            var k = A();
                            T(c, k, l.numericInput && g.caret === i ? D(p) : p, t, !0 !== n), !0 !== n && setTimeout(function() {
                                !0 === R(k) && u.trigger("complete")
                            }, 0)
                        }
                        if (t.preventDefault(), n) return !1 !== g && (g.forwardPosition = p), g
                    }
                },
                pasteEvent: function(n) {
                    var i, a = this,
                        r = n.originalEvent || n,
                        o = e(a),
                        s = a.inputmask._valueGet(!0),
                        c = I(a);
                    z && (i = c.end, c.end = c.begin, c.begin = i);
                    var u = s.substr(0, c.begin),
                        f = s.substr(c.end, s.length);
                    if (u === (z ? C().reverse() : C()).slice(0, c.begin).join("") && (u = ""), f === (z ? C().reverse() : C()).slice(c.end).join("") && (f = ""), z && (i = u, u = f, f = i), t.clipboardData && t.clipboardData.getData) s = u + t.clipboardData.getData("Text") + f;
                    else {
                        if (!r.clipboardData || !r.clipboardData.getData) return !0;
                        s = u + r.clipboardData.getData("text/plain") + f
                    }
                    var p = s;
                    if (e.isFunction(l.onBeforePaste)) {
                        if (!1 === (p = l.onBeforePaste.call(Z, s, l))) return n.preventDefault();
                        p || (p = s)
                    }
                    return L(a, !1, !1, z ? p.split("").reverse() : p.toString().split("")),
                        T(a, A(), S(v()), n, H !== A().join("")), !0 === R(A()) && o.trigger("complete"), n.preventDefault()
                },
                inputFallBackEvent: function(t) {
                    var n = this,
                        i = n.inputmask._valueGet();
                    if (A().join("") !== i) {
                        var r = I(n);
                        if (!1 === function(t, n, i) {
                                if ("." === n.charAt(i.begin - 1) && "" !== l.radixPoint && ((n = n.split(""))[i.begin - 1] = l.radixPoint.charAt(0), n = n.join("")), n.charAt(i.begin - 1) === l.radixPoint && n.length > A().length) {
                                    var a = new e.Event("keypress");
                                    return a.which = l.radixPoint.charCodeAt(0), ne.keypressEvent.call(t, a, !0, !0, !1, i.begin - 1), !1
                                }
                            }(n, i, r)) return !1;
                        if (i = i.replace(new RegExp("(" + a.escapeRegex(C().join("")) + ")*"), ""), !1 === function(t, n, i) {
                                if (u) {
                                    var a = n.replace(A().join(""), "");
                                    if (1 === a.length) {
                                        var r = new e.Event("keypress");
                                        return r.which = a.charCodeAt(0), ne.keypressEvent.call(t, r, !0, !0, !1, m().validPositions[i.begin - 1] ? i.begin : i.begin - 1), !1
                                    }
                                }
                            }(n, i, r)) return !1;
                        r.begin > i.length && (I(n, i.length), r = I(n));
                        var o = A().join(""),
                            s = i.substr(0, r.begin),
                            c = i.substr(r.begin),
                            f = o.substr(0, r.begin),
                            p = o.substr(r.begin),
                            h = r,
                            d = "",
                            v = !1;
                        if (s !== f) {
                            h.begin =
                                0;
                            for (var g = (v = s.length >= f.length) ? s.length : f.length, k = 0; s.charAt(k) === f.charAt(k) && k < g; k++) h.begin++;
                            v && (d += s.slice(h.begin, h.end))
                        }
                        c !== p && (c.length > p.length ? v && (h.end = h.begin) : c.length < p.length ? h.end += p.length - c.length : c.charAt(0) !== p.charAt(0) && h.end++), T(n, A(), h), d.length > 0 ? e.each(d.split(""), function(t, i) {
                            var a = new e.Event("keypress");
                            a.which = i.charCodeAt(0), Y = !1, ne.keypressEvent.call(n, a)
                        }) : (h.begin === h.end - 1 && I(n, D(h.begin + 1), h.end), t.keyCode = a.keyCode.DELETE, ne.keydownEvent.call(n, t)), t.preventDefault()
                    }
                },
                setValueEvent: function(t) {
                    this.inputmask.refreshValue = !1;
                    var n = this,
                        i = n.inputmask._valueGet(!0);
                    e.isFunction(l.onBeforeMask) && (i = l.onBeforeMask.call(Z, i, l) || i), i = i.split(""), L(n, !0, !1, z ? i.reverse() : i), H = A().join(""), (l.clearMaskOnLostFocus || l.clearIncomplete) && n.inputmask._valueGet() === C().join("") && n.inputmask._valueSet("")
                },
                focusEvent: function(e) {
                    var t = this,
                        n = t.inputmask._valueGet();
                    l.showMaskOnFocus && (!l.showMaskOnHover || l.showMaskOnHover && "" === n) && (t.inputmask._valueGet() !== A().join("") ? T(t, A(),
                        S(v())) : !1 === ee && I(t, S(v()))), !0 === l.positionCaretOnTab && !1 === ee && "" !== n && (T(t, A(), I(t)), ne.clickEvent.apply(t, [e, !0])), H = A().join("")
                },
                mouseleaveEvent: function(e) {
                    var t = this;
                    if (ee = !1, l.clearMaskOnLostFocus && n.activeElement !== t) {
                        var i = A().slice(),
                            a = t.inputmask._valueGet();
                        a !== t.getAttribute("placeholder") && "" !== a && (-1 === v() && a === C().join("") ? i = [] : N(i), T(t, i))
                    }
                },
                clickEvent: function(t, a) {
                    function r(t) {
                        if ("" !== l.radixPoint) {
                            var n = m().validPositions;
                            if (n[t] === i || n[t].input === G(t)) {
                                if (t < S(-1)) return !0;
                                var a = e.inArray(l.radixPoint, A());
                                if (-1 !== a) {
                                    for (var r in n)
                                        if (a < r && n[r].input !== G(r)) return !1;
                                    return !0
                                }
                            }
                        }
                        return !1
                    }
                    var o = this;
                    setTimeout(function() {
                        if (n.activeElement === o) {
                            var e = I(o);
                            if (a && (z ? e.end = e.begin : e.begin = e.end), e.begin === e.end) switch (l.positionCaretOnClick) {
                                case "none":
                                    break;
                                case "radixFocus":
                                    if (r(e.begin)) {
                                        var t = A().join("").indexOf(l.radixPoint);
                                        I(o, l.numericInput ? S(t) : t);
                                        break
                                    }
                                default:
                                    var s = e.begin,
                                        c = v(s, !0),
                                        u = S(c);
                                    if (s < u) I(o, O(s, !0) || O(s - 1, !0) ? s : S(s));
                                    else {
                                        var f = m().validPositions[c],
                                            p = y(u, f ? f.match.locator : i, f),
                                            h = G(u, p.match);
                                        if ("" !== h && A()[u] !== h && !0 !== p.match.optionalQuantifier && !0 !== p.match.newBlockMarker || !O(u, !0) && p.match.def === h) {
                                            var d = S(u);
                                            (s >= d || s === u) && (u = d)
                                        }
                                        I(o, u)
                                    }
                            }
                        }
                    }, 0)
                },
                dblclickEvent: function(e) {
                    var t = this;
                    setTimeout(function() {
                        I(t, 0, S(v()))
                    }, 0)
                },
                cutEvent: function(i) {
                    var r = this,
                        o = e(r),
                        s = I(r),
                        l = i.originalEvent || i,
                        c = t.clipboardData || l.clipboardData,
                        u = z ? A().slice(s.end, s.begin) : A().slice(s.begin, s.end);
                    c.setData("text", z ? u.reverse().join("") : u.join("")), n.execCommand &&
                        n.execCommand("copy"), K(r, a.keyCode.DELETE, s), T(r, A(), m().p, i, H !== A().join("")), r.inputmask._valueGet() === C().join("") && o.trigger("cleared")
                },
                blurEvent: function(t) {
                    var n = e(this),
                        a = this;
                    if (a.inputmask) {
                        var r = a.inputmask._valueGet(),
                            o = A().slice();
                        "" !== r && (l.clearMaskOnLostFocus && (-1 === v() && r === C().join("") ? o = [] : N(o)), !1 === R(o) && (setTimeout(function() {
                            n.trigger("incomplete")
                        }, 0), l.clearIncomplete && (d(), o = l.clearMaskOnLostFocus ? [] : C().slice())), T(a, o, i, t)), H !== A().join("") && (H = o.join(""), n.trigger("change"))
                    }
                },
                mouseenterEvent: function(e) {
                    var t = this;
                    ee = !0, n.activeElement !== t && l.showMaskOnHover && t.inputmask._valueGet() !== A().join("") && T(t, A())
                },
                submitEvent: function(e) {
                    H !== A().join("") && Q.trigger("change"), l.clearMaskOnLostFocus && -1 === v() && $.inputmask._valueGet && $.inputmask._valueGet() === C().join("") && $.inputmask._valueSet(""), l.removeMaskOnSubmit && ($.inputmask._valueSet($.inputmask.unmaskedvalue(), !0), setTimeout(function() {
                        T($, A())
                    }, 0))
                },
                resetEvent: function(e) {
                    $.inputmask.refreshValue = !0, setTimeout(function() {
                            Q.trigger("setvalue")
                        },
                        0)
                }
            };
        a.prototype.positionColorMask = function(e, t) {
            e.style.left = t.offsetLeft + "px"
        };
        var ie;
        if (r !== i) switch (r.action) {
            case "isComplete":
                return $ = r.el, R(A());
            case "unmaskedvalue":
                return $ !== i && r.value === i || (ie = r.value, ie = (e.isFunction(l.onBeforeMask) ? l.onBeforeMask.call(Z, ie, l) || ie : ie).split(""), L(i, !1, !1, z ? ie.reverse() : ie), e.isFunction(l.onBeforeWrite) && l.onBeforeWrite.call(Z, i, A(), 0, l)), B($);
            case "mask":
                ! function(t) {
                    te.off(t);
                    var a = function(t, a) {
                        var r = t.getAttribute("type"),
                            o = "INPUT" === t.tagName && -1 !==
                            e.inArray(r, a.supportsInputType) || t.isContentEditable || "TEXTAREA" === t.tagName;
                        if (!o)
                            if ("INPUT" === t.tagName) {
                                var s = n.createElement("input");
                                s.setAttribute("type", r), o = "text" === s.type, s = null
                            } else o = "partial";
                        return !1 !== o ? function(t) {
                            function r() {
                                return this.inputmask ? this.inputmask.opts.autoUnmask ? this.inputmask.unmaskedvalue() : -1 !== v() || !0 !== a.nullable ? n.activeElement === this && a.clearMaskOnLostFocus ? (z ? N(A().slice()).reverse() : N(A().slice())).join("") : s.call(this) : "" : s.call(this)
                            }

                            function o(t) {
                                l.call(this,
                                    t), this.inputmask && e(this).trigger("setvalue")
                            }
                            var s, l;
                            if (!t.inputmask.__valueGet) {
                                if (!0 !== a.noValuePatching) {
                                    if (Object.getOwnPropertyDescriptor) {
                                        "function" != typeof Object.getPrototypeOf && (Object.getPrototypeOf = "object" == typeof "test".__proto__ ? function(e) {
                                            return e.__proto__
                                        } : function(e) {
                                            return e.constructor.prototype
                                        });
                                        var c = Object.getPrototypeOf ? Object.getOwnPropertyDescriptor(Object.getPrototypeOf(t), "value") : i;
                                        c && c.get && c.set ? (s = c.get, l = c.set, Object.defineProperty(t, "value", {
                                                get: r,
                                                set: o,
                                                configurable: !0
                                            })) :
                                            "INPUT" !== t.tagName && (s = function() {
                                                return this.textContent
                                            }, l = function(e) {
                                                this.textContent = e
                                            }, Object.defineProperty(t, "value", {
                                                get: r,
                                                set: o,
                                                configurable: !0
                                            }))
                                    } else n.__lookupGetter__ && t.__lookupGetter__("value") && (s = t.__lookupGetter__("value"), l = t.__lookupSetter__("value"), t.__defineGetter__("value", r), t.__defineSetter__("value", o));
                                    t.inputmask.__valueGet = s, t.inputmask.__valueSet = l
                                }
                                t.inputmask._valueGet = function(e) {
                                        return z && !0 !== e ? s.call(this.el).split("").reverse().join("") : s.call(this.el)
                                    }, t.inputmask._valueSet =
                                    function(e, t) {
                                        l.call(this.el, null === e || e === i ? "" : !0 !== t && z ? e.split("").reverse().join("") : e)
                                    }, s === i && (s = function() {
                                        return this.value
                                    }, l = function(e) {
                                        this.value = e
                                    }, function(t) {
                                        if (e.valHooks && (e.valHooks[t] === i || !0 !== e.valHooks[t].inputmaskpatch)) {
                                            var n = e.valHooks[t] && e.valHooks[t].get ? e.valHooks[t].get : function(e) {
                                                    return e.value
                                                },
                                                r = e.valHooks[t] && e.valHooks[t].set ? e.valHooks[t].set : function(e, t) {
                                                    return e.value = t, e
                                                };
                                            e.valHooks[t] = {
                                                get: function(e) {
                                                    if (e.inputmask) {
                                                        if (e.inputmask.opts.autoUnmask) return e.inputmask.unmaskedvalue();
                                                        var t = n(e);
                                                        return -1 !== v(i, i, e.inputmask.maskset.validPositions) || !0 !== a.nullable ? t : ""
                                                    }
                                                    return n(e)
                                                },
                                                set: function(t, n) {
                                                    var i, a = e(t);
                                                    return i = r(t, n), t.inputmask && a.trigger("setvalue"), i
                                                },
                                                inputmaskpatch: !0
                                            }
                                        }
                                    }(t.type), function(t) {
                                        te.on(t, "mouseenter", function(t) {
                                            var n = e(this);
                                            this.inputmask._valueGet() !== A().join("") && n.trigger("setvalue")
                                        })
                                    }(t))
                            }
                        }(t) : t.inputmask = i, o
                    }(t, l);
                    if (!1 !== a && ($ = t, Q = e($), -1 === (W = $ !== i ? $.maxLength : i) && (W = i), !0 === l.colorMask && U($), p && ($.hasOwnProperty("inputmode") && ($.inputmode =
                                l.inputmode, $.setAttribute("inputmode", l.inputmode)), "rtfm" === l.androidHack && (!0 !== l.colorMask && U($), $.type = "password")), !0 === a && (te.on($, "submit", ne.submitEvent), te.on($, "reset", ne.resetEvent), te.on($, "mouseenter", ne.mouseenterEvent), te.on($, "blur", ne.blurEvent), te.on($, "focus", ne.focusEvent), te.on($, "mouseleave", ne.mouseleaveEvent), !0 !== l.colorMask && te.on($, "click", ne.clickEvent), te.on($, "dblclick", ne.dblclickEvent), te.on($, "paste", ne.pasteEvent), te.on($, "dragdrop", ne.pasteEvent), te.on($, "drop",
                                ne.pasteEvent), te.on($, "cut", ne.cutEvent), te.on($, "complete", l.oncomplete), te.on($, "incomplete", l.onincomplete), te.on($, "cleared", l.oncleared), p || !0 === l.inputEventOnly ? $.removeAttribute("maxLength") : (te.on($, "keydown", ne.keydownEvent), te.on($, "keypress", ne.keypressEvent)), te.on($, "compositionstart", e.noop), te.on($, "compositionupdate", e.noop), te.on($, "compositionend", e.noop), te.on($, "keyup", e.noop), te.on($, "input", ne.inputFallBackEvent), te.on($, "beforeinput", e.noop)), te.on($, "setvalue", ne.setValueEvent),
                            H = C().join(""), "" !== $.inputmask._valueGet(!0) || !1 === l.clearMaskOnLostFocus || n.activeElement === $)) {
                        var r = e.isFunction(l.onBeforeMask) ? l.onBeforeMask.call(Z, $.inputmask._valueGet(!0), l) || $.inputmask._valueGet(!0) : $.inputmask._valueGet(!0);
                        "" !== r && L($, !0, !1, z ? r.split("").reverse() : r.split(""));
                        var o = A().slice();
                        H = o.join(""), !1 === R(o) && l.clearIncomplete && d(), l.clearMaskOnLostFocus && n.activeElement !== $ && (-1 === v() ? o = [] : N(o)), T($, o), n.activeElement === $ && I($, S(v()))
                    }
                }($);
                break;
            case "format":
                return ie = (e.isFunction(l.onBeforeMask) ?
                    l.onBeforeMask.call(Z, r.value, l) || r.value : r.value).split(""), L(i, !0, !1, z ? ie.reverse() : ie), r.metadata ? {
                    value: z ? A().slice().reverse().join("") : A().join(""),
                    metadata: s.call(this, {
                        action: "getmetadata"
                    }, o, l)
                } : z ? A().slice().reverse().join("") : A().join("");
            case "isValid":
                r.value ? (ie = r.value.split(""), L(i, !0, !0, z ? ie.reverse() : ie)) : r.value = A().join("");
                for (var ae = A(), re = F(), oe = ae.length - 1; oe > re && !O(oe); oe--);
                return ae.splice(re, oe + 1 - re), R(ae) && r.value === A().join("");
            case "getemptymask":
                return C().join("");
            case "remove":
                if ($ && $.inputmask) {
                    Q = e($), $.inputmask._valueSet(l.autoUnmask ? B($) : $.inputmask._valueGet(!0)), te.off($);
                    Object.getOwnPropertyDescriptor && Object.getPrototypeOf ? Object.getOwnPropertyDescriptor(Object.getPrototypeOf($), "value") && $.inputmask.__valueGet && Object.defineProperty($, "value", {
                        get: $.inputmask.__valueGet,
                        set: $.inputmask.__valueSet,
                        configurable: !0
                    }) : n.__lookupGetter__ && $.__lookupGetter__("value") && $.inputmask.__valueGet && ($.__defineGetter__("value", $.inputmask.__valueGet), $.__defineSetter__("value",
                        $.inputmask.__valueSet)), $.inputmask = i
                }
                return $;
            case "getmetadata":
                if (e.isArray(o.metadata)) {
                    var se = h(!0, 0, !1).join("");
                    return e.each(o.metadata, function(e, t) {
                        if (t.mask === se) return se = t, !1
                    }), se
                }
                return o.metadata
        }
    }
    var l = navigator.userAgent,
        c = /mobile/i.test(l),
        u = /iemobile/i.test(l),
        f = /iphone/i.test(l) && !u,
        p = /android/i.test(l) && !u;
    return a.prototype = {
            dataAttribute: "data-inputmask",
            defaults: {
                placeholder: "_",
                optionalmarker: {
                    start: "[",
                    end: "]"
                },
                quantifiermarker: {
                    start: "{",
                    end: "}"
                },
                groupmarker: {
                    start: "(",
                    end: ")"
                },
                alternatormarker: "|",
                escapeChar: "\\",
                mask: null,
                regex: null,
                oncomplete: e.noop,
                onincomplete: e.noop,
                oncleared: e.noop,
                repeat: 0,
                greedy: !0,
                autoUnmask: !1,
                removeMaskOnSubmit: !1,
                clearMaskOnLostFocus: !0,
                insertMode: !0,
                clearIncomplete: !1,
                alias: null,
                onKeyDown: e.noop,
                onBeforeMask: null,
                onBeforePaste: function(t, n) {
                    return e.isFunction(n.onBeforeMask) ? n.onBeforeMask.call(this, t, n) : t
                },
                onBeforeWrite: null,
                onUnMask: null,
                showMaskOnFocus: !0,
                showMaskOnHover: !0,
                onKeyValidation: e.noop,
                skipOptionalPartCharacter: " ",
                numericInput: !1,
                rightAlign: !1,
                undoOnEscape: !0,
                radixPoint: "",
                radixPointDefinitionSymbol: i,
                groupSeparator: "",
                keepStatic: null,
                positionCaretOnTab: !0,
                tabThrough: !1,
                supportsInputType: ["text", "tel", "password"],
                ignorables: [8, 9, 13, 19, 27, 33, 34, 35, 36, 37, 38, 39, 40, 45, 46, 93, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 0, 229],
                isComplete: null,
                canClearPosition: e.noop,
                preValidation: null,
                postValidation: null,
                staticDefinitionSymbol: i,
                jitMasking: !1,
                nullable: !0,
                inputEventOnly: !1,
                noValuePatching: !1,
                positionCaretOnClick: "lvp",
                casing: null,
                inputmode: "verbatim",
                colorMask: !1,
                androidHack: !1,
                importDataAttributes: !0
            },
            definitions: {
                9: {
                    validator: "[0-9\uff11-\uff19]",
                    cardinality: 1,
                    definitionSymbol: "*"
                },
                a: {
                    validator: "[A-Za-z\u0410-\u044f\u0401\u0451\u00c0-\u00ff\u00b5]",
                    cardinality: 1,
                    definitionSymbol: "*"
                },
                "*": {
                    validator: "[0-9\uff11-\uff19A-Za-z\u0410-\u044f\u0401\u0451\u00c0-\u00ff\u00b5]",
                    cardinality: 1
                }
            },
            aliases: {},
            masksCache: {},
            mask: function(l) {
                function c(n, a, o, s) {
                    function l(e, a) {
                        null !== (a = a !== i ? a : n.getAttribute(s + "-" + e)) && ("string" ==
                            typeof a && (0 === e.indexOf("on") ? a = t[a] : "false" === a ? a = !1 : "true" === a && (a = !0)), o[e] = a)
                    }
                    if (!0 === a.importDataAttributes) {
                        var c, u, f, p, h = n.getAttribute(s);
                        if (h && "" !== h && (h = h.replace(new RegExp("'", "g"), '"'), u = JSON.parse("{" + h + "}")), u) {
                            f = i;
                            for (p in u)
                                if ("alias" === p.toLowerCase()) {
                                    f = u[p];
                                    break
                                }
                        }
                        l("alias", f), o.alias && r(o.alias, o, a);
                        for (c in a) {
                            if (u) {
                                f = i;
                                for (p in u)
                                    if (p.toLowerCase() === c.toLowerCase()) {
                                        f = u[p];
                                        break
                                    }
                            }
                            l(c, f)
                        }
                    }
                    return e.extend(!0, a, o), ("rtl" === n.dir || a.rightAlign) && (n.style.textAlign = "right"), ("rtl" ===
                        n.dir || a.numericInput) && (n.dir = "ltr", n.removeAttribute("dir"), a.isRTL = !0), a
                }
                var u = this;
                return "string" == typeof l && (l = n.getElementById(l) || n.querySelectorAll(l)), l = l.nodeName ? [l] : l, e.each(l, function(t, n) {
                    var r = e.extend(!0, {}, u.opts);
                    c(n, r, e.extend(!0, {}, u.userOptions), u.dataAttribute);
                    var l = o(r, u.noMasksCache);
                    l !== i && (n.inputmask !== i && (n.inputmask.opts.autoUnmask = !0, n.inputmask.remove()), n.inputmask = new a(i, i, !0), n.inputmask.opts = r, n.inputmask.noMasksCache = u.noMasksCache, n.inputmask.userOptions = e.extend(!0, {}, u.userOptions), n.inputmask.isRTL = r.isRTL || r.numericInput, n.inputmask.el = n, n.inputmask.maskset = l, e.data(n, "_inputmask_opts", r), s.call(n.inputmask, {
                        action: "mask"
                    }))
                }), l && l[0] ? l[0].inputmask || this : this
            },
            option: function(t, n) {
                return "string" == typeof t ? this.opts[t] : "object" == typeof t ? (e.extend(this.userOptions, t), this.el && !0 !== n && this.mask(this.el), this) : void 0
            },
            unmaskedvalue: function(e) {
                return this.maskset = this.maskset || o(this.opts, this.noMasksCache), s.call(this, {
                    action: "unmaskedvalue",
                    value: e
                })
            },
            remove: function() {
                return s.call(this, {
                    action: "remove"
                })
            },
            getemptymask: function() {
                return this.maskset = this.maskset || o(this.opts, this.noMasksCache), s.call(this, {
                    action: "getemptymask"
                })
            },
            hasMaskedValue: function() {
                return !this.opts.autoUnmask
            },
            isComplete: function() {
                return this.maskset = this.maskset || o(this.opts, this.noMasksCache), s.call(this, {
                    action: "isComplete"
                })
            },
            getmetadata: function() {
                return this.maskset = this.maskset || o(this.opts, this.noMasksCache), s.call(this, {
                    action: "getmetadata"
                })
            },
            isValid: function(e) {
                return this.maskset = this.maskset ||
                    o(this.opts, this.noMasksCache), s.call(this, {
                        action: "isValid",
                        value: e
                    })
            },
            format: function(e, t) {
                return this.maskset = this.maskset || o(this.opts, this.noMasksCache), s.call(this, {
                    action: "format",
                    value: e,
                    metadata: t
                })
            },
            analyseMask: function(t, n, r) {
                function o(e, t, n, i) {
                    this.matches = [], this.openGroup = e || !1, this.alternatorGroup = !1, this.isGroup = e || !1, this.isOptional = t || !1, this.isQuantifier = n || !1, this.isAlternator = i || !1, this.quantifier = {
                        min: 1,
                        max: 1
                    }
                }

                function s(t, o, s) {
                    s = s !== i ? s : t.matches.length;
                    var l = t.matches[s - 1];
                    if (n) 0 === o.indexOf("[") || b && /\\d|\\s|\\w]/i.test(o) || "." === o ? t.matches.splice(s++, 0, {
                        fn: new RegExp(o, r.casing ? "i" : ""),
                        cardinality: 1,
                        optionality: t.isOptional,
                        newBlockMarker: l === i || l.def !== o,
                        casing: null,
                        def: o,
                        placeholder: i,
                        nativeDef: o
                    }) : (b && (o = o[o.length - 1]), e.each(o.split(""), function(e, n) {
                        l = t.matches[s - 1], t.matches.splice(s++, 0, {
                            fn: null,
                            cardinality: 0,
                            optionality: t.isOptional,
                            newBlockMarker: l === i || l.def !== n && null !== l.fn,
                            casing: null,
                            def: r.staticDefinitionSymbol || n,
                            placeholder: r.staticDefinitionSymbol !==
                                i ? n : i,
                            nativeDef: n
                        })
                    })), b = !1;
                    else {
                        var c = (r.definitions ? r.definitions[o] : i) || a.prototype.definitions[o];
                        if (c && !b) {
                            for (var u = c.prevalidator, f = u ? u.length : 0, p = 1; p < c.cardinality; p++) {
                                var h = f >= p ? u[p - 1] : [],
                                    m = h.validator,
                                    d = h.cardinality;
                                t.matches.splice(s++, 0, {
                                    fn: m ? "string" == typeof m ? new RegExp(m, r.casing ? "i" : "") : new function() {
                                        this.test = m
                                    } : new RegExp("."),
                                    cardinality: d || 1,
                                    optionality: t.isOptional,
                                    newBlockMarker: l === i || l.def !== (c.definitionSymbol || o),
                                    casing: c.casing,
                                    def: c.definitionSymbol || o,
                                    placeholder: c.placeholder,
                                    nativeDef: o
                                }), l = t.matches[s - 1]
                            }
                            t.matches.splice(s++, 0, {
                                fn: c.validator ? "string" == typeof c.validator ? new RegExp(c.validator, r.casing ? "i" : "") : new function() {
                                    this.test = c.validator
                                } : new RegExp("."),
                                cardinality: c.cardinality,
                                optionality: t.isOptional,
                                newBlockMarker: l === i || l.def !== (c.definitionSymbol || o),
                                casing: c.casing,
                                def: c.definitionSymbol || o,
                                placeholder: c.placeholder,
                                nativeDef: o
                            })
                        } else t.matches.splice(s++, 0, {
                            fn: null,
                            cardinality: 0,
                            optionality: t.isOptional,
                            newBlockMarker: l === i || l.def !== o && null !== l.fn,
                            casing: null,
                            def: r.staticDefinitionSymbol || o,
                            placeholder: r.staticDefinitionSymbol !== i ? o : i,
                            nativeDef: o
                        }), b = !1
                    }
                }

                function l(t) {
                    t && t.matches && e.each(t.matches, function(e, a) {
                        var o = t.matches[e + 1];
                        (o === i || o.matches === i || !1 === o.isQuantifier) && a && a.isGroup && (a.isGroup = !1, n || (s(a, r.groupmarker.start, 0), !0 !== a.openGroup && s(a, r.groupmarker.end))), l(a)
                    })
                }

                function c() {
                    if (E.length > 0) {
                        if (m = E[E.length - 1], s(m, p), m.isAlternator) {
                            d = E.pop();
                            for (var e = 0; e < d.matches.length; e++) d.matches[e].isGroup = !1;
                            E.length > 0 ? (m = E[E.length -
                                1]).matches.push(d) : P.matches.push(d)
                        }
                    } else s(P, p)
                }

                function u(e) {
                    e.matches = e.matches.reverse();
                    for (var t in e.matches)
                        if (e.matches.hasOwnProperty(t)) {
                            var n = parseInt(t);
                            if (e.matches[t].isQuantifier && e.matches[n + 1] && e.matches[n + 1].isGroup) {
                                var a = e.matches[t];
                                e.matches.splice(t, 1), e.matches.splice(n + 1, 0, a)
                            }
                            e.matches[t].matches !== i ? e.matches[t] = u(e.matches[t]) : e.matches[t] = function(e) {
                                return e === r.optionalmarker.start ? e = r.optionalmarker.end : e === r.optionalmarker.end ? e = r.optionalmarker.start : e === r.groupmarker.start ?
                                    e = r.groupmarker.end : e === r.groupmarker.end && (e = r.groupmarker.start), e
                            }(e.matches[t])
                        }
                    return e
                }
                var f, p, h, m, d, v, g, k = /(?:[?*+]|\{[0-9\+\*]+(?:,[0-9\+\*]*)?\})|[^.?*+^${[]()|\\]+|./g,
                    y = /\[\^?]?(?:[^\\\]]+|\\[\S\s]?)*]?|\\(?:0(?:[0-3][0-7]{0,2}|[4-7][0-7]?)?|[1-9][0-9]*|x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4}|c[A-Za-z]|[\S\s]?)|\((?:\?[:=!]?)?|(?:[?*+]|\{[0-9]+(?:,[0-9]*)?\})\??|[^.?*+^${[()|\\]+|./g,
                    b = !1,
                    P = new o,
                    E = [],
                    C = [];
                for (n && (r.optionalmarker.start = i, r.optionalmarker.end = i); f = n ? y.exec(t) : k.exec(t);) {
                    if (p =
                        f[0], n) switch (p.charAt(0)) {
                        case "?":
                            p = "{0,1}";
                            break;
                        case "+":
                        case "*":
                            p = "{" + p + "}"
                    }
                    if (b) c();
                    else switch (p.charAt(0)) {
                        case r.escapeChar:
                            b = !0, n && c();
                            break;
                        case r.optionalmarker.end:
                        case r.groupmarker.end:
                            if (h = E.pop(), h.openGroup = !1, h !== i)
                                if (E.length > 0) {
                                    if ((m = E[E.length - 1]).matches.push(h), m.isAlternator) {
                                        d = E.pop();
                                        for (var A = 0; A < d.matches.length; A++) d.matches[A].isGroup = !1, d.matches[A].alternatorGroup = !1;
                                        E.length > 0 ? (m = E[E.length - 1]).matches.push(d) : P.matches.push(d)
                                    }
                                } else P.matches.push(h);
                            else c();
                            break;
                        case r.optionalmarker.start:
                            E.push(new o(!1, !0));
                            break;
                        case r.groupmarker.start:
                            E.push(new o(!0));
                            break;
                        case r.quantifiermarker.start:
                            var _ = new o(!1, !1, !0),
                                x = (p = p.replace(/[{}]/g, "")).split(","),
                                w = isNaN(x[0]) ? x[0] : parseInt(x[0]),
                                M = 1 === x.length ? w : isNaN(x[1]) ? x[1] : parseInt(x[1]);
                            if ("*" !== M && "+" !== M || (w = "*" === M ? 0 : 1), _.quantifier = {
                                    min: w,
                                    max: M
                                }, E.length > 0) {
                                var O = E[E.length - 1].matches;
                                (f = O.pop()).isGroup || ((g = new o(!0)).matches.push(f), f = g), O.push(f), O.push(_)
                            } else(f = P.matches.pop()).isGroup || (n && null ===
                                f.fn && "." === f.def && (f.fn = new RegExp(f.def, r.casing ? "i" : "")), (g = new o(!0)).matches.push(f), f = g), P.matches.push(f), P.matches.push(_);
                            break;
                        case r.alternatormarker:
                            if (E.length > 0) {
                                var S = (m = E[E.length - 1]).matches[m.matches.length - 1];
                                v = m.openGroup && (S.matches === i || !1 === S.isGroup && !1 === S.isAlternator) ? E.pop() : m.matches.pop()
                            } else v = P.matches.pop();
                            if (v.isAlternator) E.push(v);
                            else if (v.alternatorGroup ? (d = E.pop(), v.alternatorGroup = !1) : d = new o(!1, !1, !1, !0), d.matches.push(v), E.push(d), v.openGroup) {
                                v.openGroup = !1;
                                var D = new o(!0);
                                D.alternatorGroup = !0, E.push(D)
                            }
                            break;
                        default:
                            c()
                    }
                }
                for (; E.length > 0;) h = E.pop(), P.matches.push(h);
                return P.matches.length > 0 && (l(P), C.push(P)), (r.numericInput || r.isRTL) && u(C[0]), C
            }
        }, a.extendDefaults = function(t) {
            e.extend(!0, a.prototype.defaults, t)
        }, a.extendDefinitions = function(t) {
            e.extend(!0, a.prototype.definitions, t)
        }, a.extendAliases = function(t) {
            e.extend(!0, a.prototype.aliases, t)
        }, a.format = function(e, t, n) {
            return a(t).format(e, n)
        }, a.unmask = function(e, t) {
            return a(t).unmaskedvalue(e)
        },
        a.isValid = function(e, t) {
            return a(t).isValid(e)
        }, a.remove = function(t) {
            e.each(t, function(e, t) {
                t.inputmask && t.inputmask.remove()
            })
        }, a.escapeRegex = function(e) {
            var t = ["/", ".", "*", "+", "?", "|", "(", ")", "[", "]", "{", "}", "\\", "$", "^"];
            return e.replace(new RegExp("(\\" + t.join("|\\") + ")", "gim"), "\\$1")
        }, a.keyCode = {
            ALT: 18,
            BACKSPACE: 8,
            BACKSPACE_SAFARI: 127,
            CAPS_LOCK: 20,
            COMMA: 188,
            COMMAND: 91,
            COMMAND_LEFT: 91,
            COMMAND_RIGHT: 93,
            CONTROL: 17,
            DELETE: 46,
            DOWN: 40,
            END: 35,
            ENTER: 13,
            ESCAPE: 27,
            HOME: 36,
            INSERT: 45,
            LEFT: 37,
            MENU: 93,
            NUMPAD_ADD: 107,
            NUMPAD_DECIMAL: 110,
            NUMPAD_DIVIDE: 111,
            NUMPAD_ENTER: 108,
            NUMPAD_MULTIPLY: 106,
            NUMPAD_SUBTRACT: 109,
            PAGE_DOWN: 34,
            PAGE_UP: 33,
            PERIOD: 190,
            RIGHT: 39,
            SHIFT: 16,
            SPACE: 32,
            TAB: 9,
            UP: 38,
            WINDOWS: 91,
            X: 88
        }, a
});
! function(t) {
    "function" == typeof define && define.amd ? define(["jquery", "./inputmask"], t) : "object" == typeof exports ? module.exports = t(require("jquery"), require("./inputmask")) : t(jQuery, window.Inputmask)
}(function(t, e) {
    return void 0 === t.fn.inputmask && (t.fn.inputmask = function(i, n) {
        var a, s = this[0];
        if (void 0 === n && (n = {}), "string" == typeof i) switch (i) {
            case "unmaskedvalue":
                return s && s.inputmask ? s.inputmask.unmaskedvalue() : t(s).val();
            case "remove":
                return this.each(function() {
                    this.inputmask && this.inputmask.remove()
                });
            case "getemptymask":
                return s && s.inputmask ? s.inputmask.getemptymask() : "";
            case "hasMaskedValue":
                return !(!s || !s.inputmask) && s.inputmask.hasMaskedValue();
            case "isComplete":
                return !s || !s.inputmask || s.inputmask.isComplete();
            case "getmetadata":
                return s && s.inputmask ? s.inputmask.getmetadata() : void 0;
            case "setvalue":
                t(s).val(n), s && void 0 === s.inputmask && t(s).triggerHandler("setvalue");
                break;
            case "option":
                if ("string" != typeof n) return this.each(function() {
                    if (void 0 !== this.inputmask) return this.inputmask.option(n)
                });
                if (s && void 0 !== s.inputmask) return s.inputmask.option(n);
                break;
            default:
                return n.alias = i, a = new e(n), this.each(function() {
                    a.mask(this)
                })
        } else {
            if ("object" == typeof i) return a = new e(i), void 0 === i.mask && void 0 === i.alias ? this.each(function() {
                if (void 0 !== this.inputmask) return this.inputmask.option(i);
                a.mask(this)
            }) : this.each(function() {
                a.mask(this)
            });
            if (void 0 === i) return this.each(function() {
                (a = new e(n)).mask(this)
            })
        }
    }), t.fn.inputmask
});
! function(a) {
    "function" == typeof define && define.amd ? define(["jquery"], a) : "object" == typeof module && module.exports ? module.exports = function(b, c) {
        return void 0 === c && (c = "undefined" != typeof window ? require("jquery") : require("jquery")(b)), a(c), c
    } : a(jQuery)
}(function(a) {
    var b = function() {
            if (a && a.fn && a.fn.select2 && a.fn.select2.amd) var b = a.fn.select2.amd;
            var b;
            return function() {
                if (!b || !b.requirejs) {
                    b ? c = b : b = {};
                    var a, c, d;
                    ! function(b) {
                        function e(a, b) {
                            return v.call(a, b)
                        }

                        function f(a, b) {
                            var c, d, e, f, g, h, i, j, k, l, m, n,
                                o = b && b.split("/"),
                                p = t.map,
                                q = p && p["*"] || {};
                            if (a) {
                                for (a = a.split("/"), g = a.length - 1, t.nodeIdCompat && x.test(a[g]) && (a[g] = a[g].replace(x, "")), "." === a[0].charAt(0) && o && (n = o.slice(0, o.length - 1), a = n.concat(a)), k = 0; k < a.length; k++)
                                    if ("." === (m = a[k])) a.splice(k, 1), k -= 1;
                                    else if (".." === m) {
                                    if (0 === k || 1 === k && ".." === a[2] || ".." === a[k - 1]) continue;
                                    k > 0 && (a.splice(k - 1, 2), k -= 2)
                                }
                                a = a.join("/")
                            }
                            if ((o || q) && p) {
                                for (c = a.split("/"), k = c.length; k > 0; k -= 1) {
                                    if (d = c.slice(0, k).join("/"), o)
                                        for (l = o.length; l > 0; l -= 1)
                                            if ((e = p[o.slice(0, l).join("/")]) &&
                                                (e = e[d])) {
                                                f = e, h = k;
                                                break
                                            }
                                    if (f) break;
                                    !i && q && q[d] && (i = q[d], j = k)
                                }!f && i && (f = i, h = j), f && (c.splice(0, h, f), a = c.join("/"))
                            }
                            return a
                        }

                        function g(a, c) {
                            return function() {
                                var d = w.call(arguments, 0);
                                return "string" != typeof d[0] && 1 === d.length && d.push(null), o.apply(b, d.concat([a, c]))
                            }
                        }

                        function h(a) {
                            return function(b) {
                                return f(b, a)
                            }
                        }

                        function i(a) {
                            return function(b) {
                                r[a] = b
                            }
                        }

                        function j(a) {
                            if (e(s, a)) {
                                var c = s[a];
                                delete s[a], u[a] = !0, n.apply(b, c)
                            }
                            if (!e(r, a) && !e(u, a)) throw new Error("No " + a);
                            return r[a]
                        }

                        function k(a) {
                            var b,
                                c = a ? a.indexOf("!") : -1;
                            return c > -1 && (b = a.substring(0, c), a = a.substring(c + 1, a.length)), [b, a]
                        }

                        function l(a) {
                            return a ? k(a) : []
                        }

                        function m(a) {
                            return function() {
                                return t && t.config && t.config[a] || {}
                            }
                        }
                        var n, o, p, q, r = {},
                            s = {},
                            t = {},
                            u = {},
                            v = Object.prototype.hasOwnProperty,
                            w = [].slice,
                            x = /\.js$/;
                        p = function(a, b) {
                                var c, d = k(a),
                                    e = d[0],
                                    g = b[1];
                                return a = d[1], e && (e = f(e, g), c = j(e)), e ? a = c && c.normalize ? c.normalize(a, h(g)) : f(a, g) : (a = f(a, g), d = k(a), e = d[0], a = d[1], e && (c = j(e))), {
                                    f: e ? e + "!" + a : a,
                                    n: a,
                                    pr: e,
                                    p: c
                                }
                            }, q = {
                                require: function(a) {
                                    return g(a)
                                },
                                exports: function(a) {
                                    var b = r[a];
                                    return void 0 !== b ? b : r[a] = {}
                                },
                                module: function(a) {
                                    return {
                                        id: a,
                                        uri: "",
                                        exports: r[a],
                                        config: m(a)
                                    }
                                }
                            }, n = function(a, c, d, f) {
                                var h, k, m, n, o, t, v, w = [],
                                    x = typeof d;
                                if (f = f || a, t = l(f), "undefined" === x || "function" === x) {
                                    for (c = !c.length && d.length ? ["require", "exports", "module"] : c, o = 0; o < c.length; o += 1)
                                        if (n = p(c[o], t), "require" === (k = n.f)) w[o] = q.require(a);
                                        else if ("exports" === k) w[o] = q.exports(a), v = !0;
                                    else if ("module" === k) h = w[o] = q.module(a);
                                    else if (e(r, k) || e(s, k) || e(u, k)) w[o] = j(k);
                                    else {
                                        if (!n.p) throw new Error(a +
                                            " missing " + k);
                                        n.p.load(n.n, g(f, !0), i(k), {}), w[o] = r[k]
                                    }
                                    m = d ? d.apply(r[a], w) : void 0, a && (h && h.exports !== b && h.exports !== r[a] ? r[a] = h.exports : m === b && v || (r[a] = m))
                                } else a && (r[a] = d)
                            }, a = c = o = function(a, c, d, e, f) {
                                if ("string" == typeof a) return q[a] ? q[a](c) : j(p(a, l(c)).f);
                                if (!a.splice) {
                                    if (t = a, t.deps && o(t.deps, t.callback), !c) return;
                                    c.splice ? (a = c, c = d, d = null) : a = b
                                }
                                return c = c || function() {}, "function" == typeof d && (d = e, e = f), e ? n(b, a, c, d) : setTimeout(function() {
                                    n(b, a, c, d)
                                }, 4), o
                            }, o.config = function(a) {
                                return o(a)
                            }, a._defined =
                            r, d = function(a, b, c) {
                                if ("string" != typeof a) throw new Error("See almond README: incorrect module build, no module name");
                                b.splice || (c = b, b = []), e(r, a) || e(s, a) || (s[a] = [a, b, c])
                            }, d.amd = {
                                jQuery: !0
                            }
                    }(), b.requirejs = a, b.require = c, b.define = d
                }
            }(), b.define("almond", function() {}), b.define("jquery", [], function() {
                var b = a || $;
                return null == b && console && console.error && console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."),
                    b
            }), b.define("select2/utils", ["jquery"], function(a) {
                function b(a) {
                    var b = a.prototype,
                        c = [];
                    for (var d in b) "function" == typeof b[d] && ("constructor" !== d && c.push(d));
                    return c
                }
                var c = {};
                c.Extend = function(a, b) {
                    function c() {
                        this.constructor = a
                    }
                    var d = {}.hasOwnProperty;
                    for (var e in b) d.call(b, e) && (a[e] = b[e]);
                    return c.prototype = b.prototype, a.prototype = new c, a.__super__ = b.prototype, a
                }, c.Decorate = function(a, c) {
                    function d() {
                        var b = Array.prototype.unshift,
                            d = c.prototype.constructor.length,
                            e = a.prototype.constructor;
                        d >
                            0 && (b.call(arguments, a.prototype.constructor), e = c.prototype.constructor), e.apply(this, arguments)
                    }

                    function e() {
                        this.constructor = d
                    }
                    var f = b(c),
                        g = b(a);
                    c.displayName = a.displayName, d.prototype = new e;
                    for (var h = 0; h < g.length; h++) {
                        var i = g[h];
                        d.prototype[i] = a.prototype[i]
                    }
                    for (var j = function(a) {
                            var b = function() {};
                            a in d.prototype && (b = d.prototype[a]);
                            var e = c.prototype[a];
                            return function() {
                                return Array.prototype.unshift.call(arguments, b), e.apply(this, arguments)
                            }
                        }, k = 0; k < f.length; k++) {
                        var l = f[k];
                        d.prototype[l] = j(l)
                    }
                    return d
                };
                var d = function() {
                    this.listeners = {}
                };
                d.prototype.on = function(a, b) {
                    this.listeners = this.listeners || {}, a in this.listeners ? this.listeners[a].push(b) : this.listeners[a] = [b]
                }, d.prototype.trigger = function(a) {
                    var b = Array.prototype.slice,
                        c = b.call(arguments, 1);
                    this.listeners = this.listeners || {}, null == c && (c = []), 0 === c.length && c.push({}), c[0]._type = a, a in this.listeners && this.invoke(this.listeners[a], b.call(arguments, 1)), "*" in this.listeners && this.invoke(this.listeners["*"], arguments)
                }, d.prototype.invoke = function(a,
                    b) {
                    for (var c = 0, d = a.length; c < d; c++) a[c].apply(this, b)
                }, c.Observable = d, c.generateChars = function(a) {
                    for (var b = "", c = 0; c < a; c++) b += Math.floor(36 * Math.random()).toString(36);
                    return b
                }, c.bind = function(a, b) {
                    return function() {
                        a.apply(b, arguments)
                    }
                }, c._convertData = function(a) {
                    for (var b in a) {
                        var c = b.split("-"),
                            d = a;
                        if (1 !== c.length) {
                            for (var e = 0; e < c.length; e++) {
                                var f = c[e];
                                f = f.substring(0, 1).toLowerCase() + f.substring(1), f in d || (d[f] = {}), e == c.length - 1 && (d[f] = a[b]), d = d[f]
                            }
                            delete a[b]
                        }
                    }
                    return a
                }, c.hasScroll = function(b,
                    c) {
                    var d = a(c),
                        e = c.style.overflowX,
                        f = c.style.overflowY;
                    return (e !== f || "hidden" !== f && "visible" !== f) && ("scroll" === e || "scroll" === f || (d.innerHeight() < c.scrollHeight || d.innerWidth() < c.scrollWidth))
                }, c.escapeMarkup = function(a) {
                    var b = {
                        "\\": "&#92;",
                        "&": "&amp;",
                        "<": "&lt;",
                        ">": "&gt;",
                        '"': "&quot;",
                        "'": "&#39;",
                        "/": "&#47;"
                    };
                    return "string" != typeof a ? a : String(a).replace(/[&<>"'\/\\]/g, function(a) {
                        return b[a]
                    })
                }, c.appendMany = function(b, c) {
                    if ("1.7" === a.fn.jquery.substr(0, 3)) {
                        var d = a();
                        a.map(c, function(a) {
                                d = d.add(a)
                            }),
                            c = d
                    }
                    b.append(c)
                }, c.__cache = {};
                var e = 0;
                return c.GetUniqueElementId = function(a) {
                        var b = a.getAttribute("data-select2-id");
                        return null == b && (a.id ? (b = a.id, a.setAttribute("data-select2-id", b)) : (a.setAttribute("data-select2-id", ++e), b = e.toString())), b
                    }, c.StoreData = function(a, b, d) {
                        var e = c.GetUniqueElementId(a);
                        c.__cache[e] || (c.__cache[e] = {}), c.__cache[e][b] = d
                    }, c.GetData = function(b, d) {
                        var e = c.GetUniqueElementId(b);
                        return d ? c.__cache[e] && null != c.__cache[e][d] ? c.__cache[e][d] : a(b).data(d) : c.__cache[e]
                    }, c.RemoveData =
                    function(a) {
                        var b = c.GetUniqueElementId(a);
                        null != c.__cache[b] && delete c.__cache[b]
                    }, c
            }), b.define("select2/results", ["jquery", "./utils"], function(a, b) {
                function c(a, b, d) {
                    this.$element = a, this.data = d, this.options = b, c.__super__.constructor.call(this)
                }
                return b.Extend(c, b.Observable), c.prototype.render = function() {
                        var b = a('<ul class="select2-results__options" role="tree"></ul>');
                        return this.options.get("multiple") && b.attr("aria-multiselectable", "true"), this.$results = b, b
                    }, c.prototype.clear = function() {
                        this.$results.empty()
                    },
                    c.prototype.displayMessage = function(b) {
                        var c = this.options.get("escapeMarkup");
                        this.clear(), this.hideLoading();
                        var d = a('<li role="treeitem" aria-live="assertive" class="select2-results__option"></li>'),
                            e = this.options.get("translations").get(b.message);
                        d.append(c(e(b.args))), d[0].className += " select2-results__message", this.$results.append(d)
                    }, c.prototype.hideMessages = function() {
                        this.$results.find(".select2-results__message").remove()
                    }, c.prototype.append = function(a) {
                        this.hideLoading();
                        var b = [];
                        if (null ==
                            a.results || 0 === a.results.length) return void(0 === this.$results.children().length && this.trigger("results:message", {
                            message: "noResults"
                        }));
                        a.results = this.sort(a.results);
                        for (var c = 0; c < a.results.length; c++) {
                            var d = a.results[c],
                                e = this.option(d);
                            b.push(e)
                        }
                        this.$results.append(b)
                    }, c.prototype.position = function(a, b) {
                        b.find(".select2-results").append(a)
                    }, c.prototype.sort = function(a) {
                        return this.options.get("sorter")(a)
                    }, c.prototype.highlightFirstItem = function() {
                        var a = this.$results.find(".select2-results__option[aria-selected]"),
                            b = a.filter("[aria-selected=true]");
                        b.length > 0 ? b.first().trigger("mouseenter") : a.first().trigger("mouseenter"), this.ensureHighlightVisible()
                    }, c.prototype.setClasses = function() {
                        var c = this;
                        this.data.current(function(d) {
                            var e = a.map(d, function(a) {
                                return a.id.toString()
                            });
                            c.$results.find(".select2-results__option[aria-selected]").each(function() {
                                var c = a(this),
                                    d = b.GetData(this, "data"),
                                    f = "" + d.id;
                                null != d.element && d.element.selected || null == d.element && a.inArray(f, e) > -1 ? c.attr("aria-selected", "true") : c.attr("aria-selected",
                                    "false")
                            })
                        })
                    }, c.prototype.showLoading = function(a) {
                        this.hideLoading();
                        var b = this.options.get("translations").get("searching"),
                            c = {
                                disabled: !0,
                                loading: !0,
                                text: b(a)
                            },
                            d = this.option(c);
                        d.className += " loading-results", this.$results.prepend(d)
                    }, c.prototype.hideLoading = function() {
                        this.$results.find(".loading-results").remove()
                    }, c.prototype.option = function(c) {
                        var d = document.createElement("li");
                        d.className = "select2-results__option";
                        var e = {
                            role: "treeitem",
                            "aria-selected": "false"
                        };
                        c.disabled && (delete e["aria-selected"],
                            e["aria-disabled"] = "true"), null == c.id && delete e["aria-selected"], null != c._resultId && (d.id = c._resultId), c.title && (d.title = c.title), c.children && (e.role = "group", e["aria-label"] = c.text, delete e["aria-selected"]);
                        for (var f in e) {
                            var g = e[f];
                            d.setAttribute(f, g)
                        }
                        if (c.children) {
                            var h = a(d),
                                i = document.createElement("strong");
                            i.className = "select2-results__group";
                            a(i);
                            this.template(c, i);
                            for (var j = [], k = 0; k < c.children.length; k++) {
                                var l = c.children[k],
                                    m = this.option(l);
                                j.push(m)
                            }
                            var n = a("<ul></ul>", {
                                class: "select2-results__options select2-results__options--nested"
                            });
                            n.append(j), h.append(i), h.append(n)
                        } else this.template(c, d);
                        return b.StoreData(d, "data", c), d
                    }, c.prototype.bind = function(c, d) {
                        var e = this,
                            f = c.id + "-results";
                        this.$results.attr("id", f), c.on("results:all", function(a) {
                                e.clear(), e.append(a.data), c.isOpen() && (e.setClasses(), e.highlightFirstItem())
                            }), c.on("results:append", function(a) {
                                e.append(a.data), c.isOpen() && e.setClasses()
                            }), c.on("query", function(a) {
                                e.hideMessages(), e.showLoading(a)
                            }), c.on("select", function() {
                                c.isOpen() && (e.setClasses(), e.highlightFirstItem())
                            }),
                            c.on("unselect", function() {
                                c.isOpen() && (e.setClasses(), e.highlightFirstItem())
                            }), c.on("open", function() {
                                e.$results.attr("aria-expanded", "true"), e.$results.attr("aria-hidden", "false"), e.setClasses(), e.ensureHighlightVisible()
                            }), c.on("close", function() {
                                e.$results.attr("aria-expanded", "false"), e.$results.attr("aria-hidden", "true"), e.$results.removeAttr("aria-activedescendant")
                            }), c.on("results:toggle", function() {
                                var a = e.getHighlightedResults();
                                0 !== a.length && a.trigger("mouseup")
                            }), c.on("results:select",
                                function() {
                                    var a = e.getHighlightedResults();
                                    if (0 !== a.length) {
                                        var c = b.GetData(a[0], "data");
                                        "true" == a.attr("aria-selected") ? e.trigger("close", {}) : e.trigger("select", {
                                            data: c
                                        })
                                    }
                                }), c.on("results:previous", function() {
                                var a = e.getHighlightedResults(),
                                    b = e.$results.find("[aria-selected]"),
                                    c = b.index(a);
                                if (!(c <= 0)) {
                                    var d = c - 1;
                                    0 === a.length && (d = 0);
                                    var f = b.eq(d);
                                    f.trigger("mouseenter");
                                    var g = e.$results.offset().top,
                                        h = f.offset().top,
                                        i = e.$results.scrollTop() + (h - g);
                                    0 === d ? e.$results.scrollTop(0) : h - g < 0 && e.$results.scrollTop(i)
                                }
                            }),
                            c.on("results:next", function() {
                                var a = e.getHighlightedResults(),
                                    b = e.$results.find("[aria-selected]"),
                                    c = b.index(a),
                                    d = c + 1;
                                if (!(d >= b.length)) {
                                    var f = b.eq(d);
                                    f.trigger("mouseenter");
                                    var g = e.$results.offset().top + e.$results.outerHeight(!1),
                                        h = f.offset().top + f.outerHeight(!1),
                                        i = e.$results.scrollTop() + h - g;
                                    0 === d ? e.$results.scrollTop(0) : h > g && e.$results.scrollTop(i)
                                }
                            }), c.on("results:focus", function(a) {
                                a.element.addClass("select2-results__option--highlighted")
                            }), c.on("results:message", function(a) {
                                e.displayMessage(a)
                            }),
                            a.fn.mousewheel && this.$results.on("mousewheel", function(a) {
                                var b = e.$results.scrollTop(),
                                    c = e.$results.get(0).scrollHeight - b + a.deltaY,
                                    d = a.deltaY > 0 && b - a.deltaY <= 0,
                                    f = a.deltaY < 0 && c <= e.$results.height();
                                d ? (e.$results.scrollTop(0), a.preventDefault(), a.stopPropagation()) : f && (e.$results.scrollTop(e.$results.get(0).scrollHeight - e.$results.height()), a.preventDefault(), a.stopPropagation())
                            }), this.$results.on("mouseup", ".select2-results__option[aria-selected]", function(c) {
                                var d = a(this),
                                    f = b.GetData(this, "data");
                                if ("true" === d.attr("aria-selected")) return void(e.options.get("multiple") ? e.trigger("unselect", {
                                    originalEvent: c,
                                    data: f
                                }) : e.trigger("close", {}));
                                e.trigger("select", {
                                    originalEvent: c,
                                    data: f
                                })
                            }), this.$results.on("mouseenter", ".select2-results__option[aria-selected]", function(c) {
                                var d = b.GetData(this, "data");
                                e.getHighlightedResults().removeClass("select2-results__option--highlighted"), e.trigger("results:focus", {
                                    data: d,
                                    element: a(this)
                                })
                            })
                    }, c.prototype.getHighlightedResults = function() {
                        return this.$results.find(".select2-results__option--highlighted")
                    },
                    c.prototype.destroy = function() {
                        this.$results.remove()
                    }, c.prototype.ensureHighlightVisible = function() {
                        var a = this.getHighlightedResults();
                        if (0 !== a.length) {
                            var b = this.$results.find("[aria-selected]"),
                                c = b.index(a),
                                d = this.$results.offset().top,
                                e = a.offset().top,
                                f = this.$results.scrollTop() + (e - d),
                                g = e - d;
                            f -= 2 * a.outerHeight(!1), c <= 2 ? this.$results.scrollTop(0) : (g > this.$results.outerHeight() || g < 0) && this.$results.scrollTop(f)
                        }
                    }, c.prototype.template = function(b, c) {
                        var d = this.options.get("templateResult"),
                            e = this.options.get("escapeMarkup"),
                            f = d(b, c);
                        null == f ? c.style.display = "none" : "string" == typeof f ? c.innerHTML = e(f) : a(c).append(f)
                    }, c
            }), b.define("select2/keys", [], function() {
                return {
                    BACKSPACE: 8,
                    TAB: 9,
                    ENTER: 13,
                    SHIFT: 16,
                    CTRL: 17,
                    ALT: 18,
                    ESC: 27,
                    SPACE: 32,
                    PAGE_UP: 33,
                    PAGE_DOWN: 34,
                    END: 35,
                    HOME: 36,
                    LEFT: 37,
                    UP: 38,
                    RIGHT: 39,
                    DOWN: 40,
                    DELETE: 46
                }
            }), b.define("select2/selection/base", ["jquery", "../utils", "../keys"], function(a, b, c) {
                function d(a, b) {
                    this.$element = a, this.options = b, d.__super__.constructor.call(this)
                }
                return b.Extend(d, b.Observable), d.prototype.render =
                    function() {
                        var c = a('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');
                        return this._tabindex = 0, null != b.GetData(this.$element[0], "old-tabindex") ? this._tabindex = b.GetData(this.$element[0], "old-tabindex") : null != this.$element.attr("tabindex") && (this._tabindex = this.$element.attr("tabindex")), c.attr("title", this.$element.attr("title")), c.attr("tabindex", this._tabindex), this.$selection = c, c
                    }, d.prototype.bind = function(a, b) {
                        var d = this,
                            e = (a.id, a.id + "-results");
                        this.container = a, this.$selection.on("focus", function(a) {
                                d.trigger("focus", a)
                            }), this.$selection.on("blur", function(a) {
                                d._handleBlur(a)
                            }), this.$selection.on("keydown", function(a) {
                                d.trigger("keypress", a), a.which === c.SPACE && a.preventDefault()
                            }), a.on("results:focus", function(a) {
                                d.$selection.attr("aria-activedescendant", a.data._resultId)
                            }), a.on("selection:update", function(a) {
                                d.update(a.data)
                            }), a.on("open", function() {
                                d.$selection.attr("aria-expanded", "true"), d.$selection.attr("aria-owns", e), d._attachCloseHandler(a)
                            }),
                            a.on("close", function() {
                                d.$selection.attr("aria-expanded", "false"), d.$selection.removeAttr("aria-activedescendant"), d.$selection.removeAttr("aria-owns"), d.$selection.focus(), window.setTimeout(function() {
                                    d.$selection.focus()
                                }, 0), d._detachCloseHandler(a)
                            }), a.on("enable", function() {
                                d.$selection.attr("tabindex", d._tabindex)
                            }), a.on("disable", function() {
                                d.$selection.attr("tabindex", "-1")
                            })
                    }, d.prototype._handleBlur = function(b) {
                        var c = this;
                        window.setTimeout(function() {
                            document.activeElement == c.$selection[0] ||
                                a.contains(c.$selection[0], document.activeElement) || c.trigger("blur", b)
                        }, 1)
                    }, d.prototype._attachCloseHandler = function(c) {
                        a(document.body).on("mousedown.select2." + c.id, function(c) {
                            var d = a(c.target),
                                e = d.closest(".select2");
                            a(".select2.select2-container--open").each(function() {
                                a(this), this != e[0] && b.GetData(this, "element").select2("close")
                            })
                        })
                    }, d.prototype._detachCloseHandler = function(b) {
                        a(document.body).off("mousedown.select2." + b.id)
                    }, d.prototype.position = function(a, b) {
                        b.find(".selection").append(a)
                    },
                    d.prototype.destroy = function() {
                        this._detachCloseHandler(this.container)
                    }, d.prototype.update = function(a) {
                        throw new Error("The `update` method must be defined in child classes.");
                    }, d
            }), b.define("select2/selection/single", ["jquery", "./base", "../utils", "../keys"], function(a, b, c, d) {
                function e() {
                    e.__super__.constructor.apply(this, arguments)
                }
                return c.Extend(e, b), e.prototype.render = function() {
                        var a = e.__super__.render.call(this);
                        return a.addClass("select2-selection--single"), a.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'),
                            a
                    }, e.prototype.bind = function(a, b) {
                        var c = this;
                        e.__super__.bind.apply(this, arguments);
                        var d = a.id + "-container";
                        this.$selection.find(".select2-selection__rendered").attr("id", d).attr("role", "textbox").attr("aria-readonly", "true"), this.$selection.attr("aria-labelledby", d), this.$selection.on("mousedown", function(a) {
                            1 === a.which && c.trigger("toggle", {
                                originalEvent: a
                            })
                        }), this.$selection.on("focus", function(a) {}), this.$selection.on("blur", function(a) {}), a.on("focus", function(b) {
                            a.isOpen() || c.$selection.focus()
                        })
                    },
                    e.prototype.clear = function() {
                        var a = this.$selection.find(".select2-selection__rendered");
                        a.empty(), a.removeAttr("title")
                    }, e.prototype.display = function(a, b) {
                        var c = this.options.get("templateSelection");
                        return this.options.get("escapeMarkup")(c(a, b))
                    }, e.prototype.selectionContainer = function() {
                        return a("<span></span>")
                    }, e.prototype.update = function(a) {
                        if (0 === a.length) return void this.clear();
                        var b = a[0],
                            c = this.$selection.find(".select2-selection__rendered"),
                            d = this.display(b, c);
                        c.empty().append(d), c.attr("title",
                            b.title || b.text)
                    }, e
            }), b.define("select2/selection/multiple", ["jquery", "./base", "../utils"], function(a, b, c) {
                function d(a, b) {
                    d.__super__.constructor.apply(this, arguments)
                }
                return c.Extend(d, b), d.prototype.render = function() {
                        var a = d.__super__.render.call(this);
                        return a.addClass("select2-selection--multiple"), a.html('<ul class="select2-selection__rendered"></ul>'), a
                    }, d.prototype.bind = function(b, e) {
                        var f = this;
                        d.__super__.bind.apply(this, arguments), this.$selection.on("click", function(a) {
                            f.trigger("toggle", {
                                originalEvent: a
                            })
                        }), this.$selection.on("click", ".select2-selection__choice__remove", function(b) {
                            if (!f.options.get("disabled")) {
                                var d = a(this),
                                    e = d.parent(),
                                    g = c.GetData(e[0], "data");
                                f.trigger("unselect", {
                                    originalEvent: b,
                                    data: g
                                })
                            }
                        })
                    }, d.prototype.clear = function() {
                        var a = this.$selection.find(".select2-selection__rendered");
                        a.empty(), a.removeAttr("title")
                    }, d.prototype.display = function(a, b) {
                        var c = this.options.get("templateSelection");
                        return this.options.get("escapeMarkup")(c(a, b))
                    }, d.prototype.selectionContainer =
                    function() {
                        return a('<li class="select2-selection__choice"><span class="select2-selection__choice__remove" role="presentation">&times;</span></li>')
                    }, d.prototype.update = function(a) {
                        if (this.clear(), 0 !== a.length) {
                            for (var b = [], d = 0; d < a.length; d++) {
                                var e = a[d],
                                    f = this.selectionContainer(),
                                    g = this.display(e, f);
                                f.append(g), f.attr("title", e.title || e.text), c.StoreData(f[0], "data", e), b.push(f)
                            }
                            var h = this.$selection.find(".select2-selection__rendered");
                            c.appendMany(h, b)
                        }
                    }, d
            }), b.define("select2/selection/placeholder", ["../utils"], function(a) {
                function b(a, b, c) {
                    this.placeholder = this.normalizePlaceholder(c.get("placeholder")), a.call(this, b, c)
                }
                return b.prototype.normalizePlaceholder = function(a, b) {
                    return "string" == typeof b && (b = {
                        id: "",
                        text: b
                    }), b
                }, b.prototype.createPlaceholder = function(a, b) {
                    var c = this.selectionContainer();
                    return c.html(this.display(b)), c.addClass("select2-selection__placeholder").removeClass("select2-selection__choice"), c
                }, b.prototype.update = function(a, b) {
                    var c = 1 == b.length && b[0].id != this.placeholder.id;
                    if (b.length > 1 || c) return a.call(this, b);
                    this.clear();
                    var d = this.createPlaceholder(this.placeholder);
                    this.$selection.find(".select2-selection__rendered").append(d)
                }, b
            }), b.define("select2/selection/allowClear", ["jquery", "../keys", "../utils"], function(a, b, c) {
                function d() {}
                return d.prototype.bind = function(a, b, c) {
                    var d = this;
                    a.call(this, b, c), null == this.placeholder && this.options.get("debug") && window.console && console.error && console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."),
                        this.$selection.on("mousedown", ".select2-selection__clear", function(a) {
                            d._handleClear(a)
                        }), b.on("keypress", function(a) {
                            d._handleKeyboardClear(a, b)
                        })
                }, d.prototype._handleClear = function(a, b) {
                    if (!this.options.get("disabled")) {
                        var d = this.$selection.find(".select2-selection__clear");
                        if (0 !== d.length) {
                            b.stopPropagation();
                            var e = c.GetData(d[0], "data"),
                                f = this.$element.val();
                            this.$element.val(this.placeholder.id);
                            var g = {
                                data: e
                            };
                            if (this.trigger("clear", g), g.prevented) return void this.$element.val(f);
                            for (var h =
                                    0; h < e.length; h++)
                                if (g = {
                                        data: e[h]
                                    }, this.trigger("unselect", g), g.prevented) return void this.$element.val(f);
                            this.$element.trigger("change"), this.trigger("toggle", {})
                        }
                    }
                }, d.prototype._handleKeyboardClear = function(a, c, d) {
                    d.isOpen() || c.which != b.DELETE && c.which != b.BACKSPACE || this._handleClear(c)
                }, d.prototype.update = function(b, d) {
                    if (b.call(this, d), !(this.$selection.find(".select2-selection__placeholder").length > 0 || 0 === d.length)) {
                        var e = a('<span class="select2-selection__clear">&times;</span>');
                        c.StoreData(e[0],
                            "data", d), this.$selection.find(".select2-selection__rendered").prepend(e)
                    }
                }, d
            }), b.define("select2/selection/search", ["jquery", "../utils", "../keys"], function(a, b, c) {
                function d(a, b, c) {
                    a.call(this, b, c)
                }
                return d.prototype.render = function(b) {
                    var c = a('<li class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="textbox" aria-autocomplete="list" /></li>');
                    this.$searchContainer =
                        c, this.$search = c.find("input");
                    var d = b.call(this);
                    return this._transferTabIndex(), d
                }, d.prototype.bind = function(a, d, e) {
                    var f = this;
                    a.call(this, d, e), d.on("open", function() {
                            f.$search.trigger("focus")
                        }), d.on("close", function() {
                            f.$search.val(""), f.$search.removeAttr("aria-activedescendant"), f.$search.trigger("focus")
                        }), d.on("enable", function() {
                            f.$search.prop("disabled", !1), f._transferTabIndex()
                        }), d.on("disable", function() {
                            f.$search.prop("disabled", !0)
                        }), d.on("focus", function(a) {
                            f.$search.trigger("focus")
                        }),
                        d.on("results:focus", function(a) {
                            f.$search.attr("aria-activedescendant", a.id)
                        }), this.$selection.on("focusin", ".select2-search--inline", function(a) {
                            f.trigger("focus", a)
                        }), this.$selection.on("focusout", ".select2-search--inline", function(a) {
                            f._handleBlur(a)
                        }), this.$selection.on("keydown", ".select2-search--inline", function(a) {
                            if (a.stopPropagation(), f.trigger("keypress", a), f._keyUpPrevented = a.isDefaultPrevented(), a.which === c.BACKSPACE && "" === f.$search.val()) {
                                var d = f.$searchContainer.prev(".select2-selection__choice");
                                if (d.length > 0) {
                                    var e = b.GetData(d[0], "data");
                                    f.searchRemoveChoice(e), a.preventDefault()
                                }
                            }
                        });
                    var g = document.documentMode,
                        h = g && g <= 11;
                    this.$selection.on("input.searchcheck", ".select2-search--inline", function(a) {
                        if (h) return void f.$selection.off("input.search input.searchcheck");
                        f.$selection.off("keyup.search")
                    }), this.$selection.on("keyup.search input.search", ".select2-search--inline", function(a) {
                        if (h && "input" === a.type) return void f.$selection.off("input.search input.searchcheck");
                        var b = a.which;
                        b != c.SHIFT &&
                            b != c.CTRL && b != c.ALT && b != c.TAB && f.handleSearch(a)
                    })
                }, d.prototype._transferTabIndex = function(a) {
                    this.$search.attr("tabindex", this.$selection.attr("tabindex")), this.$selection.attr("tabindex", "-1")
                }, d.prototype.createPlaceholder = function(a, b) {
                    this.$search.attr("placeholder", b.text)
                }, d.prototype.update = function(a, b) {
                    var c = this.$search[0] == document.activeElement;
                    if (this.$search.attr("placeholder", ""), a.call(this, b), this.$selection.find(".select2-selection__rendered").append(this.$searchContainer), this.resizeSearch(),
                        c) this.$element.find("[data-select2-tag]").length ? this.$element.focus() : this.$search.focus()
                }, d.prototype.handleSearch = function() {
                    if (this.resizeSearch(), !this._keyUpPrevented) {
                        var a = this.$search.val();
                        this.trigger("query", {
                            term: a
                        })
                    }
                    this._keyUpPrevented = !1
                }, d.prototype.searchRemoveChoice = function(a, b) {
                    this.trigger("unselect", {
                        data: b
                    }), this.$search.val(b.text), this.handleSearch()
                }, d.prototype.resizeSearch = function() {
                    this.$search.css("width", "25px");
                    var a = "";
                    if ("" !== this.$search.attr("placeholder")) a =
                        this.$selection.find(".select2-selection__rendered").innerWidth();
                    else a = .75 * (this.$search.val().length + 1) + "em";
                    this.$search.css("width", a)
                }, d
            }), b.define("select2/selection/eventRelay", ["jquery"], function(a) {
                function b() {}
                return b.prototype.bind = function(b, c, d) {
                    var e = this,
                        f = ["open", "opening", "close", "closing", "select", "selecting", "unselect", "unselecting", "clear", "clearing"],
                        g = ["opening", "closing", "selecting", "unselecting", "clearing"];
                    b.call(this, c, d), c.on("*", function(b, c) {
                        if (-1 !== a.inArray(b, f)) {
                            c =
                                c || {};
                            var d = a.Event("select2:" + b, {
                                params: c
                            });
                            e.$element.trigger(d), -1 !== a.inArray(b, g) && (c.prevented = d.isDefaultPrevented())
                        }
                    })
                }, b
            }), b.define("select2/translation", ["jquery", "require"], function(a, b) {
                function c(a) {
                    this.dict = a || {}
                }
                return c.prototype.all = function() {
                        return this.dict
                    }, c.prototype.get = function(a) {
                        return this.dict[a]
                    }, c.prototype.extend = function(b) {
                        this.dict = a.extend({}, b.all(), this.dict)
                    }, c._cache = {}, c.loadPath = function(a) {
                        if (!(a in c._cache)) {
                            var d = b(a);
                            c._cache[a] = d
                        }
                        return new c(c._cache[a])
                    },
                    c
            }), b.define("select2/diacritics", [], function() {
                return {
                    "\u24b6": "A",
                    "\uff21": "A",
                    "\u00c0": "A",
                    "\u00c1": "A",
                    "\u00c2": "A",
                    "\u1ea6": "A",
                    "\u1ea4": "A",
                    "\u1eaa": "A",
                    "\u1ea8": "A",
                    "\u00c3": "A",
                    "\u0100": "A",
                    "\u0102": "A",
                    "\u1eb0": "A",
                    "\u1eae": "A",
                    "\u1eb4": "A",
                    "\u1eb2": "A",
                    "\u0226": "A",
                    "\u01e0": "A",
                    "\u00c4": "A",
                    "\u01de": "A",
                    "\u1ea2": "A",
                    "\u00c5": "A",
                    "\u01fa": "A",
                    "\u01cd": "A",
                    "\u0200": "A",
                    "\u0202": "A",
                    "\u1ea0": "A",
                    "\u1eac": "A",
                    "\u1eb6": "A",
                    "\u1e00": "A",
                    "\u0104": "A",
                    "\u023a": "A",
                    "\u2c6f": "A",
                    "\ua732": "AA",
                    "\u00c6": "AE",
                    "\u01fc": "AE",
                    "\u01e2": "AE",
                    "\ua734": "AO",
                    "\ua736": "AU",
                    "\ua738": "AV",
                    "\ua73a": "AV",
                    "\ua73c": "AY",
                    "\u24b7": "B",
                    "\uff22": "B",
                    "\u1e02": "B",
                    "\u1e04": "B",
                    "\u1e06": "B",
                    "\u0243": "B",
                    "\u0182": "B",
                    "\u0181": "B",
                    "\u24b8": "C",
                    "\uff23": "C",
                    "\u0106": "C",
                    "\u0108": "C",
                    "\u010a": "C",
                    "\u010c": "C",
                    "\u00c7": "C",
                    "\u1e08": "C",
                    "\u0187": "C",
                    "\u023b": "C",
                    "\ua73e": "C",
                    "\u24b9": "D",
                    "\uff24": "D",
                    "\u1e0a": "D",
                    "\u010e": "D",
                    "\u1e0c": "D",
                    "\u1e10": "D",
                    "\u1e12": "D",
                    "\u1e0e": "D",
                    "\u0110": "D",
                    "\u018b": "D",
                    "\u018a": "D",
                    "\u0189": "D",
                    "\ua779": "D",
                    "\u01f1": "DZ",
                    "\u01c4": "DZ",
                    "\u01f2": "Dz",
                    "\u01c5": "Dz",
                    "\u24ba": "E",
                    "\uff25": "E",
                    "\u00c8": "E",
                    "\u00c9": "E",
                    "\u00ca": "E",
                    "\u1ec0": "E",
                    "\u1ebe": "E",
                    "\u1ec4": "E",
                    "\u1ec2": "E",
                    "\u1ebc": "E",
                    "\u0112": "E",
                    "\u1e14": "E",
                    "\u1e16": "E",
                    "\u0114": "E",
                    "\u0116": "E",
                    "\u00cb": "E",
                    "\u1eba": "E",
                    "\u011a": "E",
                    "\u0204": "E",
                    "\u0206": "E",
                    "\u1eb8": "E",
                    "\u1ec6": "E",
                    "\u0228": "E",
                    "\u1e1c": "E",
                    "\u0118": "E",
                    "\u1e18": "E",
                    "\u1e1a": "E",
                    "\u0190": "E",
                    "\u018e": "E",
                    "\u24bb": "F",
                    "\uff26": "F",
                    "\u1e1e": "F",
                    "\u0191": "F",
                    "\ua77b": "F",
                    "\u24bc": "G",
                    "\uff27": "G",
                    "\u01f4": "G",
                    "\u011c": "G",
                    "\u1e20": "G",
                    "\u011e": "G",
                    "\u0120": "G",
                    "\u01e6": "G",
                    "\u0122": "G",
                    "\u01e4": "G",
                    "\u0193": "G",
                    "\ua7a0": "G",
                    "\ua77d": "G",
                    "\ua77e": "G",
                    "\u24bd": "H",
                    "\uff28": "H",
                    "\u0124": "H",
                    "\u1e22": "H",
                    "\u1e26": "H",
                    "\u021e": "H",
                    "\u1e24": "H",
                    "\u1e28": "H",
                    "\u1e2a": "H",
                    "\u0126": "H",
                    "\u2c67": "H",
                    "\u2c75": "H",
                    "\ua78d": "H",
                    "\u24be": "I",
                    "\uff29": "I",
                    "\u00cc": "I",
                    "\u00cd": "I",
                    "\u00ce": "I",
                    "\u0128": "I",
                    "\u012a": "I",
                    "\u012c": "I",
                    "\u0130": "I",
                    "\u00cf": "I",
                    "\u1e2e": "I",
                    "\u1ec8": "I",
                    "\u01cf": "I",
                    "\u0208": "I",
                    "\u020a": "I",
                    "\u1eca": "I",
                    "\u012e": "I",
                    "\u1e2c": "I",
                    "\u0197": "I",
                    "\u24bf": "J",
                    "\uff2a": "J",
                    "\u0134": "J",
                    "\u0248": "J",
                    "\u24c0": "K",
                    "\uff2b": "K",
                    "\u1e30": "K",
                    "\u01e8": "K",
                    "\u1e32": "K",
                    "\u0136": "K",
                    "\u1e34": "K",
                    "\u0198": "K",
                    "\u2c69": "K",
                    "\ua740": "K",
                    "\ua742": "K",
                    "\ua744": "K",
                    "\ua7a2": "K",
                    "\u24c1": "L",
                    "\uff2c": "L",
                    "\u013f": "L",
                    "\u0139": "L",
                    "\u013d": "L",
                    "\u1e36": "L",
                    "\u1e38": "L",
                    "\u013b": "L",
                    "\u1e3c": "L",
                    "\u1e3a": "L",
                    "\u0141": "L",
                    "\u023d": "L",
                    "\u2c62": "L",
                    "\u2c60": "L",
                    "\ua748": "L",
                    "\ua746": "L",
                    "\ua780": "L",
                    "\u01c7": "LJ",
                    "\u01c8": "Lj",
                    "\u24c2": "M",
                    "\uff2d": "M",
                    "\u1e3e": "M",
                    "\u1e40": "M",
                    "\u1e42": "M",
                    "\u2c6e": "M",
                    "\u019c": "M",
                    "\u24c3": "N",
                    "\uff2e": "N",
                    "\u01f8": "N",
                    "\u0143": "N",
                    "\u00d1": "N",
                    "\u1e44": "N",
                    "\u0147": "N",
                    "\u1e46": "N",
                    "\u0145": "N",
                    "\u1e4a": "N",
                    "\u1e48": "N",
                    "\u0220": "N",
                    "\u019d": "N",
                    "\ua790": "N",
                    "\ua7a4": "N",
                    "\u01ca": "NJ",
                    "\u01cb": "Nj",
                    "\u24c4": "O",
                    "\uff2f": "O",
                    "\u00d2": "O",
                    "\u00d3": "O",
                    "\u00d4": "O",
                    "\u1ed2": "O",
                    "\u1ed0": "O",
                    "\u1ed6": "O",
                    "\u1ed4": "O",
                    "\u00d5": "O",
                    "\u1e4c": "O",
                    "\u022c": "O",
                    "\u1e4e": "O",
                    "\u014c": "O",
                    "\u1e50": "O",
                    "\u1e52": "O",
                    "\u014e": "O",
                    "\u022e": "O",
                    "\u0230": "O",
                    "\u00d6": "O",
                    "\u022a": "O",
                    "\u1ece": "O",
                    "\u0150": "O",
                    "\u01d1": "O",
                    "\u020c": "O",
                    "\u020e": "O",
                    "\u01a0": "O",
                    "\u1edc": "O",
                    "\u1eda": "O",
                    "\u1ee0": "O",
                    "\u1ede": "O",
                    "\u1ee2": "O",
                    "\u1ecc": "O",
                    "\u1ed8": "O",
                    "\u01ea": "O",
                    "\u01ec": "O",
                    "\u00d8": "O",
                    "\u01fe": "O",
                    "\u0186": "O",
                    "\u019f": "O",
                    "\ua74a": "O",
                    "\ua74c": "O",
                    "\u01a2": "OI",
                    "\ua74e": "OO",
                    "\u0222": "OU",
                    "\u24c5": "P",
                    "\uff30": "P",
                    "\u1e54": "P",
                    "\u1e56": "P",
                    "\u01a4": "P",
                    "\u2c63": "P",
                    "\ua750": "P",
                    "\ua752": "P",
                    "\ua754": "P",
                    "\u24c6": "Q",
                    "\uff31": "Q",
                    "\ua756": "Q",
                    "\ua758": "Q",
                    "\u024a": "Q",
                    "\u24c7": "R",
                    "\uff32": "R",
                    "\u0154": "R",
                    "\u1e58": "R",
                    "\u0158": "R",
                    "\u0210": "R",
                    "\u0212": "R",
                    "\u1e5a": "R",
                    "\u1e5c": "R",
                    "\u0156": "R",
                    "\u1e5e": "R",
                    "\u024c": "R",
                    "\u2c64": "R",
                    "\ua75a": "R",
                    "\ua7a6": "R",
                    "\ua782": "R",
                    "\u24c8": "S",
                    "\uff33": "S",
                    "\u1e9e": "S",
                    "\u015a": "S",
                    "\u1e64": "S",
                    "\u015c": "S",
                    "\u1e60": "S",
                    "\u0160": "S",
                    "\u1e66": "S",
                    "\u1e62": "S",
                    "\u1e68": "S",
                    "\u0218": "S",
                    "\u015e": "S",
                    "\u2c7e": "S",
                    "\ua7a8": "S",
                    "\ua784": "S",
                    "\u24c9": "T",
                    "\uff34": "T",
                    "\u1e6a": "T",
                    "\u0164": "T",
                    "\u1e6c": "T",
                    "\u021a": "T",
                    "\u0162": "T",
                    "\u1e70": "T",
                    "\u1e6e": "T",
                    "\u0166": "T",
                    "\u01ac": "T",
                    "\u01ae": "T",
                    "\u023e": "T",
                    "\ua786": "T",
                    "\ua728": "TZ",
                    "\u24ca": "U",
                    "\uff35": "U",
                    "\u00d9": "U",
                    "\u00da": "U",
                    "\u00db": "U",
                    "\u0168": "U",
                    "\u1e78": "U",
                    "\u016a": "U",
                    "\u1e7a": "U",
                    "\u016c": "U",
                    "\u00dc": "U",
                    "\u01db": "U",
                    "\u01d7": "U",
                    "\u01d5": "U",
                    "\u01d9": "U",
                    "\u1ee6": "U",
                    "\u016e": "U",
                    "\u0170": "U",
                    "\u01d3": "U",
                    "\u0214": "U",
                    "\u0216": "U",
                    "\u01af": "U",
                    "\u1eea": "U",
                    "\u1ee8": "U",
                    "\u1eee": "U",
                    "\u1eec": "U",
                    "\u1ef0": "U",
                    "\u1ee4": "U",
                    "\u1e72": "U",
                    "\u0172": "U",
                    "\u1e76": "U",
                    "\u1e74": "U",
                    "\u0244": "U",
                    "\u24cb": "V",
                    "\uff36": "V",
                    "\u1e7c": "V",
                    "\u1e7e": "V",
                    "\u01b2": "V",
                    "\ua75e": "V",
                    "\u0245": "V",
                    "\ua760": "VY",
                    "\u24cc": "W",
                    "\uff37": "W",
                    "\u1e80": "W",
                    "\u1e82": "W",
                    "\u0174": "W",
                    "\u1e86": "W",
                    "\u1e84": "W",
                    "\u1e88": "W",
                    "\u2c72": "W",
                    "\u24cd": "X",
                    "\uff38": "X",
                    "\u1e8a": "X",
                    "\u1e8c": "X",
                    "\u24ce": "Y",
                    "\uff39": "Y",
                    "\u1ef2": "Y",
                    "\u00dd": "Y",
                    "\u0176": "Y",
                    "\u1ef8": "Y",
                    "\u0232": "Y",
                    "\u1e8e": "Y",
                    "\u0178": "Y",
                    "\u1ef6": "Y",
                    "\u1ef4": "Y",
                    "\u01b3": "Y",
                    "\u024e": "Y",
                    "\u1efe": "Y",
                    "\u24cf": "Z",
                    "\uff3a": "Z",
                    "\u0179": "Z",
                    "\u1e90": "Z",
                    "\u017b": "Z",
                    "\u017d": "Z",
                    "\u1e92": "Z",
                    "\u1e94": "Z",
                    "\u01b5": "Z",
                    "\u0224": "Z",
                    "\u2c7f": "Z",
                    "\u2c6b": "Z",
                    "\ua762": "Z",
                    "\u24d0": "a",
                    "\uff41": "a",
                    "\u1e9a": "a",
                    "\u00e0": "a",
                    "\u00e1": "a",
                    "\u00e2": "a",
                    "\u1ea7": "a",
                    "\u1ea5": "a",
                    "\u1eab": "a",
                    "\u1ea9": "a",
                    "\u00e3": "a",
                    "\u0101": "a",
                    "\u0103": "a",
                    "\u1eb1": "a",
                    "\u1eaf": "a",
                    "\u1eb5": "a",
                    "\u1eb3": "a",
                    "\u0227": "a",
                    "\u01e1": "a",
                    "\u00e4": "a",
                    "\u01df": "a",
                    "\u1ea3": "a",
                    "\u00e5": "a",
                    "\u01fb": "a",
                    "\u01ce": "a",
                    "\u0201": "a",
                    "\u0203": "a",
                    "\u1ea1": "a",
                    "\u1ead": "a",
                    "\u1eb7": "a",
                    "\u1e01": "a",
                    "\u0105": "a",
                    "\u2c65": "a",
                    "\u0250": "a",
                    "\ua733": "aa",
                    "\u00e6": "ae",
                    "\u01fd": "ae",
                    "\u01e3": "ae",
                    "\ua735": "ao",
                    "\ua737": "au",
                    "\ua739": "av",
                    "\ua73b": "av",
                    "\ua73d": "ay",
                    "\u24d1": "b",
                    "\uff42": "b",
                    "\u1e03": "b",
                    "\u1e05": "b",
                    "\u1e07": "b",
                    "\u0180": "b",
                    "\u0183": "b",
                    "\u0253": "b",
                    "\u24d2": "c",
                    "\uff43": "c",
                    "\u0107": "c",
                    "\u0109": "c",
                    "\u010b": "c",
                    "\u010d": "c",
                    "\u00e7": "c",
                    "\u1e09": "c",
                    "\u0188": "c",
                    "\u023c": "c",
                    "\ua73f": "c",
                    "\u2184": "c",
                    "\u24d3": "d",
                    "\uff44": "d",
                    "\u1e0b": "d",
                    "\u010f": "d",
                    "\u1e0d": "d",
                    "\u1e11": "d",
                    "\u1e13": "d",
                    "\u1e0f": "d",
                    "\u0111": "d",
                    "\u018c": "d",
                    "\u0256": "d",
                    "\u0257": "d",
                    "\ua77a": "d",
                    "\u01f3": "dz",
                    "\u01c6": "dz",
                    "\u24d4": "e",
                    "\uff45": "e",
                    "\u00e8": "e",
                    "\u00e9": "e",
                    "\u00ea": "e",
                    "\u1ec1": "e",
                    "\u1ebf": "e",
                    "\u1ec5": "e",
                    "\u1ec3": "e",
                    "\u1ebd": "e",
                    "\u0113": "e",
                    "\u1e15": "e",
                    "\u1e17": "e",
                    "\u0115": "e",
                    "\u0117": "e",
                    "\u00eb": "e",
                    "\u1ebb": "e",
                    "\u011b": "e",
                    "\u0205": "e",
                    "\u0207": "e",
                    "\u1eb9": "e",
                    "\u1ec7": "e",
                    "\u0229": "e",
                    "\u1e1d": "e",
                    "\u0119": "e",
                    "\u1e19": "e",
                    "\u1e1b": "e",
                    "\u0247": "e",
                    "\u025b": "e",
                    "\u01dd": "e",
                    "\u24d5": "f",
                    "\uff46": "f",
                    "\u1e1f": "f",
                    "\u0192": "f",
                    "\ua77c": "f",
                    "\u24d6": "g",
                    "\uff47": "g",
                    "\u01f5": "g",
                    "\u011d": "g",
                    "\u1e21": "g",
                    "\u011f": "g",
                    "\u0121": "g",
                    "\u01e7": "g",
                    "\u0123": "g",
                    "\u01e5": "g",
                    "\u0260": "g",
                    "\ua7a1": "g",
                    "\u1d79": "g",
                    "\ua77f": "g",
                    "\u24d7": "h",
                    "\uff48": "h",
                    "\u0125": "h",
                    "\u1e23": "h",
                    "\u1e27": "h",
                    "\u021f": "h",
                    "\u1e25": "h",
                    "\u1e29": "h",
                    "\u1e2b": "h",
                    "\u1e96": "h",
                    "\u0127": "h",
                    "\u2c68": "h",
                    "\u2c76": "h",
                    "\u0265": "h",
                    "\u0195": "hv",
                    "\u24d8": "i",
                    "\uff49": "i",
                    "\u00ec": "i",
                    "\u00ed": "i",
                    "\u00ee": "i",
                    "\u0129": "i",
                    "\u012b": "i",
                    "\u012d": "i",
                    "\u00ef": "i",
                    "\u1e2f": "i",
                    "\u1ec9": "i",
                    "\u01d0": "i",
                    "\u0209": "i",
                    "\u020b": "i",
                    "\u1ecb": "i",
                    "\u012f": "i",
                    "\u1e2d": "i",
                    "\u0268": "i",
                    "\u0131": "i",
                    "\u24d9": "j",
                    "\uff4a": "j",
                    "\u0135": "j",
                    "\u01f0": "j",
                    "\u0249": "j",
                    "\u24da": "k",
                    "\uff4b": "k",
                    "\u1e31": "k",
                    "\u01e9": "k",
                    "\u1e33": "k",
                    "\u0137": "k",
                    "\u1e35": "k",
                    "\u0199": "k",
                    "\u2c6a": "k",
                    "\ua741": "k",
                    "\ua743": "k",
                    "\ua745": "k",
                    "\ua7a3": "k",
                    "\u24db": "l",
                    "\uff4c": "l",
                    "\u0140": "l",
                    "\u013a": "l",
                    "\u013e": "l",
                    "\u1e37": "l",
                    "\u1e39": "l",
                    "\u013c": "l",
                    "\u1e3d": "l",
                    "\u1e3b": "l",
                    "\u017f": "l",
                    "\u0142": "l",
                    "\u019a": "l",
                    "\u026b": "l",
                    "\u2c61": "l",
                    "\ua749": "l",
                    "\ua781": "l",
                    "\ua747": "l",
                    "\u01c9": "lj",
                    "\u24dc": "m",
                    "\uff4d": "m",
                    "\u1e3f": "m",
                    "\u1e41": "m",
                    "\u1e43": "m",
                    "\u0271": "m",
                    "\u026f": "m",
                    "\u24dd": "n",
                    "\uff4e": "n",
                    "\u01f9": "n",
                    "\u0144": "n",
                    "\u00f1": "n",
                    "\u1e45": "n",
                    "\u0148": "n",
                    "\u1e47": "n",
                    "\u0146": "n",
                    "\u1e4b": "n",
                    "\u1e49": "n",
                    "\u019e": "n",
                    "\u0272": "n",
                    "\u0149": "n",
                    "\ua791": "n",
                    "\ua7a5": "n",
                    "\u01cc": "nj",
                    "\u24de": "o",
                    "\uff4f": "o",
                    "\u00f2": "o",
                    "\u00f3": "o",
                    "\u00f4": "o",
                    "\u1ed3": "o",
                    "\u1ed1": "o",
                    "\u1ed7": "o",
                    "\u1ed5": "o",
                    "\u00f5": "o",
                    "\u1e4d": "o",
                    "\u022d": "o",
                    "\u1e4f": "o",
                    "\u014d": "o",
                    "\u1e51": "o",
                    "\u1e53": "o",
                    "\u014f": "o",
                    "\u022f": "o",
                    "\u0231": "o",
                    "\u00f6": "o",
                    "\u022b": "o",
                    "\u1ecf": "o",
                    "\u0151": "o",
                    "\u01d2": "o",
                    "\u020d": "o",
                    "\u020f": "o",
                    "\u01a1": "o",
                    "\u1edd": "o",
                    "\u1edb": "o",
                    "\u1ee1": "o",
                    "\u1edf": "o",
                    "\u1ee3": "o",
                    "\u1ecd": "o",
                    "\u1ed9": "o",
                    "\u01eb": "o",
                    "\u01ed": "o",
                    "\u00f8": "o",
                    "\u01ff": "o",
                    "\u0254": "o",
                    "\ua74b": "o",
                    "\ua74d": "o",
                    "\u0275": "o",
                    "\u01a3": "oi",
                    "\u0223": "ou",
                    "\ua74f": "oo",
                    "\u24df": "p",
                    "\uff50": "p",
                    "\u1e55": "p",
                    "\u1e57": "p",
                    "\u01a5": "p",
                    "\u1d7d": "p",
                    "\ua751": "p",
                    "\ua753": "p",
                    "\ua755": "p",
                    "\u24e0": "q",
                    "\uff51": "q",
                    "\u024b": "q",
                    "\ua757": "q",
                    "\ua759": "q",
                    "\u24e1": "r",
                    "\uff52": "r",
                    "\u0155": "r",
                    "\u1e59": "r",
                    "\u0159": "r",
                    "\u0211": "r",
                    "\u0213": "r",
                    "\u1e5b": "r",
                    "\u1e5d": "r",
                    "\u0157": "r",
                    "\u1e5f": "r",
                    "\u024d": "r",
                    "\u027d": "r",
                    "\ua75b": "r",
                    "\ua7a7": "r",
                    "\ua783": "r",
                    "\u24e2": "s",
                    "\uff53": "s",
                    "\u00df": "s",
                    "\u015b": "s",
                    "\u1e65": "s",
                    "\u015d": "s",
                    "\u1e61": "s",
                    "\u0161": "s",
                    "\u1e67": "s",
                    "\u1e63": "s",
                    "\u1e69": "s",
                    "\u0219": "s",
                    "\u015f": "s",
                    "\u023f": "s",
                    "\ua7a9": "s",
                    "\ua785": "s",
                    "\u1e9b": "s",
                    "\u24e3": "t",
                    "\uff54": "t",
                    "\u1e6b": "t",
                    "\u1e97": "t",
                    "\u0165": "t",
                    "\u1e6d": "t",
                    "\u021b": "t",
                    "\u0163": "t",
                    "\u1e71": "t",
                    "\u1e6f": "t",
                    "\u0167": "t",
                    "\u01ad": "t",
                    "\u0288": "t",
                    "\u2c66": "t",
                    "\ua787": "t",
                    "\ua729": "tz",
                    "\u24e4": "u",
                    "\uff55": "u",
                    "\u00f9": "u",
                    "\u00fa": "u",
                    "\u00fb": "u",
                    "\u0169": "u",
                    "\u1e79": "u",
                    "\u016b": "u",
                    "\u1e7b": "u",
                    "\u016d": "u",
                    "\u00fc": "u",
                    "\u01dc": "u",
                    "\u01d8": "u",
                    "\u01d6": "u",
                    "\u01da": "u",
                    "\u1ee7": "u",
                    "\u016f": "u",
                    "\u0171": "u",
                    "\u01d4": "u",
                    "\u0215": "u",
                    "\u0217": "u",
                    "\u01b0": "u",
                    "\u1eeb": "u",
                    "\u1ee9": "u",
                    "\u1eef": "u",
                    "\u1eed": "u",
                    "\u1ef1": "u",
                    "\u1ee5": "u",
                    "\u1e73": "u",
                    "\u0173": "u",
                    "\u1e77": "u",
                    "\u1e75": "u",
                    "\u0289": "u",
                    "\u24e5": "v",
                    "\uff56": "v",
                    "\u1e7d": "v",
                    "\u1e7f": "v",
                    "\u028b": "v",
                    "\ua75f": "v",
                    "\u028c": "v",
                    "\ua761": "vy",
                    "\u24e6": "w",
                    "\uff57": "w",
                    "\u1e81": "w",
                    "\u1e83": "w",
                    "\u0175": "w",
                    "\u1e87": "w",
                    "\u1e85": "w",
                    "\u1e98": "w",
                    "\u1e89": "w",
                    "\u2c73": "w",
                    "\u24e7": "x",
                    "\uff58": "x",
                    "\u1e8b": "x",
                    "\u1e8d": "x",
                    "\u24e8": "y",
                    "\uff59": "y",
                    "\u1ef3": "y",
                    "\u00fd": "y",
                    "\u0177": "y",
                    "\u1ef9": "y",
                    "\u0233": "y",
                    "\u1e8f": "y",
                    "\u00ff": "y",
                    "\u1ef7": "y",
                    "\u1e99": "y",
                    "\u1ef5": "y",
                    "\u01b4": "y",
                    "\u024f": "y",
                    "\u1eff": "y",
                    "\u24e9": "z",
                    "\uff5a": "z",
                    "\u017a": "z",
                    "\u1e91": "z",
                    "\u017c": "z",
                    "\u017e": "z",
                    "\u1e93": "z",
                    "\u1e95": "z",
                    "\u01b6": "z",
                    "\u0225": "z",
                    "\u0240": "z",
                    "\u2c6c": "z",
                    "\ua763": "z",
                    "\u0386": "\u0391",
                    "\u0388": "\u0395",
                    "\u0389": "\u0397",
                    "\u038a": "\u0399",
                    "\u03aa": "\u0399",
                    "\u038c": "\u039f",
                    "\u038e": "\u03a5",
                    "\u03ab": "\u03a5",
                    "\u038f": "\u03a9",
                    "\u03ac": "\u03b1",
                    "\u03ad": "\u03b5",
                    "\u03ae": "\u03b7",
                    "\u03af": "\u03b9",
                    "\u03ca": "\u03b9",
                    "\u0390": "\u03b9",
                    "\u03cc": "\u03bf",
                    "\u03cd": "\u03c5",
                    "\u03cb": "\u03c5",
                    "\u03b0": "\u03c5",
                    "\u03c9": "\u03c9",
                    "\u03c2": "\u03c3"
                }
            }), b.define("select2/data/base", ["../utils"], function(a) {
                function b(a,
                    c) {
                    b.__super__.constructor.call(this)
                }
                return a.Extend(b, a.Observable), b.prototype.current = function(a) {
                    throw new Error("The `current` method must be defined in child classes.");
                }, b.prototype.query = function(a, b) {
                    throw new Error("The `query` method must be defined in child classes.");
                }, b.prototype.bind = function(a, b) {}, b.prototype.destroy = function() {}, b.prototype.generateResultId = function(b, c) {
                    var d = b.id + "-result-";
                    return d += a.generateChars(4), null != c.id ? d += "-" + c.id.toString() : d += "-" + a.generateChars(4),
                        d
                }, b
            }), b.define("select2/data/select", ["./base", "../utils", "jquery"], function(a, b, c) {
                function d(a, b) {
                    this.$element = a, this.options = b, d.__super__.constructor.call(this)
                }
                return b.Extend(d, a), d.prototype.current = function(a) {
                    var b = [],
                        d = this;
                    this.$element.find(":selected").each(function() {
                        var a = c(this),
                            e = d.item(a);
                        b.push(e)
                    }), a(b)
                }, d.prototype.select = function(a) {
                    var b = this;
                    if (a.selected = !0, c(a.element).is("option")) return a.element.selected = !0, void this.$element.trigger("change");
                    if (this.$element.prop("multiple")) this.current(function(d) {
                        var e = [];
                        a = [a], a.push.apply(a, d);
                        for (var f = 0; f < a.length; f++) {
                            var g = a[f].id; - 1 === c.inArray(g, e) && e.push(g)
                        }
                        b.$element.val(e), b.$element.trigger("change")
                    });
                    else {
                        var d = a.id;
                        this.$element.val(d), this.$element.trigger("change")
                    }
                }, d.prototype.unselect = function(a) {
                    var b = this;
                    if (this.$element.prop("multiple")) {
                        if (a.selected = !1, c(a.element).is("option")) return a.element.selected = !1, void this.$element.trigger("change");
                        this.current(function(d) {
                            for (var e = [], f = 0; f < d.length; f++) {
                                var g = d[f].id;
                                g !== a.id && -1 === c.inArray(g,
                                    e) && e.push(g)
                            }
                            b.$element.val(e), b.$element.trigger("change")
                        })
                    }
                }, d.prototype.bind = function(a, b) {
                    var c = this;
                    this.container = a, a.on("select", function(a) {
                        c.select(a.data)
                    }), a.on("unselect", function(a) {
                        c.unselect(a.data)
                    })
                }, d.prototype.destroy = function() {
                    this.$element.find("*").each(function() {
                        b.RemoveData(this)
                    })
                }, d.prototype.query = function(a, b) {
                    var d = [],
                        e = this;
                    this.$element.children().each(function() {
                            var b = c(this);
                            if (b.is("option") || b.is("optgroup")) {
                                var f = e.item(b),
                                    g = e.matches(a, f);
                                null !== g && d.push(g)
                            }
                        }),
                        b({
                            results: d
                        })
                }, d.prototype.addOptions = function(a) {
                    b.appendMany(this.$element, a)
                }, d.prototype.option = function(a) {
                    var d;
                    a.children ? (d = document.createElement("optgroup"), d.label = a.text) : (d = document.createElement("option"), void 0 !== d.textContent ? d.textContent = a.text : d.innerText = a.text), void 0 !== a.id && (d.value = a.id), a.disabled && (d.disabled = !0), a.selected && (d.selected = !0), a.title && (d.title = a.title);
                    var e = c(d),
                        f = this._normalizeItem(a);
                    return f.element = d, b.StoreData(d, "data", f), e
                }, d.prototype.item = function(a) {
                    var d = {};
                    if (null != (d = b.GetData(a[0], "data"))) return d;
                    if (a.is("option")) d = {
                        id: a.val(),
                        text: a.text(),
                        disabled: a.prop("disabled"),
                        selected: a.prop("selected"),
                        title: a.prop("title")
                    };
                    else if (a.is("optgroup")) {
                        d = {
                            text: a.prop("label"),
                            children: [],
                            title: a.prop("title")
                        };
                        for (var e = a.children("option"), f = [], g = 0; g < e.length; g++) {
                            var h = c(e[g]),
                                i = this.item(h);
                            f.push(i)
                        }
                        d.children = f
                    }
                    return d = this._normalizeItem(d), d.element = a[0], b.StoreData(a[0], "data", d), d
                }, d.prototype._normalizeItem = function(a) {
                    a !== Object(a) && (a = {
                        id: a,
                        text: a
                    }), a = c.extend({}, {
                        text: ""
                    }, a);
                    var b = {
                        selected: !1,
                        disabled: !1
                    };
                    return null != a.id && (a.id = a.id.toString()), null != a.text && (a.text = a.text.toString()), null == a._resultId && a.id && null != this.container && (a._resultId = this.generateResultId(this.container, a)), c.extend({}, b, a)
                }, d.prototype.matches = function(a, b) {
                    return this.options.get("matcher")(a, b)
                }, d
            }), b.define("select2/data/array", ["./select", "../utils", "jquery"], function(a, b, c) {
                function d(a, b) {
                    var c = b.get("data") || [];
                    d.__super__.constructor.call(this,
                        a, b), this.addOptions(this.convertToOptions(c))
                }
                return b.Extend(d, a), d.prototype.select = function(a) {
                    var b = this.$element.find("option").filter(function(b, c) {
                        return c.value == a.id.toString()
                    });
                    0 === b.length && (b = this.option(a), this.addOptions(b)), d.__super__.select.call(this, a)
                }, d.prototype.convertToOptions = function(a) {
                    function d(a) {
                        return function() {
                            return c(this).val() == a.id
                        }
                    }
                    for (var e = this, f = this.$element.find("option"), g = f.map(function() {
                            return e.item(c(this)).id
                        }).get(), h = [], i = 0; i < a.length; i++) {
                        var j =
                            this._normalizeItem(a[i]);
                        if (c.inArray(j.id, g) >= 0) {
                            var k = f.filter(d(j)),
                                l = this.item(k),
                                m = c.extend(!0, {}, j, l),
                                n = this.option(m);
                            k.replaceWith(n)
                        } else {
                            var o = this.option(j);
                            if (j.children) {
                                var p = this.convertToOptions(j.children);
                                b.appendMany(o, p)
                            }
                            h.push(o)
                        }
                    }
                    return h
                }, d
            }), b.define("select2/data/ajax", ["./array", "../utils", "jquery"], function(a, b, c) {
                function d(a, b) {
                    this.ajaxOptions = this._applyDefaults(b.get("ajax")), null != this.ajaxOptions.processResults && (this.processResults = this.ajaxOptions.processResults),
                        d.__super__.constructor.call(this, a, b)
                }
                return b.Extend(d, a), d.prototype._applyDefaults = function(a) {
                    var b = {
                        data: function(a) {
                            return c.extend({}, a, {
                                q: a.term
                            })
                        },
                        transport: function(a, b, d) {
                            var e = c.ajax(a);
                            return e.then(b), e.fail(d), e
                        }
                    };
                    return c.extend({}, b, a, !0)
                }, d.prototype.processResults = function(a) {
                    return a
                }, d.prototype.query = function(a, b) {
                    function d() {
                        var d = f.transport(f, function(d) {
                            var f = e.processResults(d, a);
                            e.options.get("debug") && window.console && console.error && (f && f.results && c.isArray(f.results) ||
                                console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")), b(f)
                        }, function() {
                            "status" in d && (0 === d.status || "0" === d.status) || e.trigger("results:message", {
                                message: "errorLoading"
                            })
                        });
                        e._request = d
                    }
                    var e = this;
                    null != this._request && (c.isFunction(this._request.abort) && this._request.abort(), this._request = null);
                    var f = c.extend({
                        type: "GET"
                    }, this.ajaxOptions);
                    "function" == typeof f.url && (f.url = f.url.call(this.$element, a)), "function" == typeof f.data && (f.data = f.data.call(this.$element,
                        a)), this.ajaxOptions.delay && null != a.term ? (this._queryTimeout && window.clearTimeout(this._queryTimeout), this._queryTimeout = window.setTimeout(d, this.ajaxOptions.delay)) : d()
                }, d
            }), b.define("select2/data/tags", ["jquery"], function(a) {
                function b(b, c, d) {
                    var e = d.get("tags"),
                        f = d.get("createTag");
                    void 0 !== f && (this.createTag = f);
                    var g = d.get("insertTag");
                    if (void 0 !== g && (this.insertTag = g), b.call(this, c, d), a.isArray(e))
                        for (var h = 0; h < e.length; h++) {
                            var i = e[h],
                                j = this._normalizeItem(i),
                                k = this.option(j);
                            this.$element.append(k)
                        }
                }
                return b.prototype.query = function(a, b, c) {
                    function d(a, f) {
                        for (var g = a.results, h = 0; h < g.length; h++) {
                            var i = g[h],
                                j = null != i.children && !d({
                                    results: i.children
                                }, !0);
                            if ((i.text || "").toUpperCase() === (b.term || "").toUpperCase() || j) return !f && (a.data = g, void c(a))
                        }
                        if (f) return !0;
                        var k = e.createTag(b);
                        if (null != k) {
                            var l = e.option(k);
                            l.attr("data-select2-tag", !0), e.addOptions([l]), e.insertTag(g, k)
                        }
                        a.results = g, c(a)
                    }
                    var e = this;
                    if (this._removeOldTags(), null == b.term || null != b.page) return void a.call(this, b, c);
                    a.call(this, b,
                        d)
                }, b.prototype.createTag = function(b, c) {
                    var d = a.trim(c.term);
                    return "" === d ? null : {
                        id: d,
                        text: d
                    }
                }, b.prototype.insertTag = function(a, b, c) {
                    b.unshift(c)
                }, b.prototype._removeOldTags = function(b) {
                    this._lastTag;
                    this.$element.find("option[data-select2-tag]").each(function() {
                        this.selected || a(this).remove()
                    })
                }, b
            }), b.define("select2/data/tokenizer", ["jquery"], function(a) {
                function b(a, b, c) {
                    var d = c.get("tokenizer");
                    void 0 !== d && (this.tokenizer = d), a.call(this, b, c)
                }
                return b.prototype.bind = function(a, b, c) {
                    a.call(this,
                        b, c), this.$search = b.dropdown.$search || b.selection.$search || c.find(".select2-search__field")
                }, b.prototype.query = function(b, c, d) {
                    function e(b) {
                        var c = g._normalizeItem(b);
                        if (!g.$element.find("option").filter(function() {
                                return a(this).val() === c.id
                            }).length) {
                            var d = g.option(c);
                            d.attr("data-select2-tag", !0), g._removeOldTags(), g.addOptions([d])
                        }
                        f(c)
                    }

                    function f(a) {
                        g.trigger("select", {
                            data: a
                        })
                    }
                    var g = this;
                    c.term = c.term || "";
                    var h = this.tokenizer(c, this.options, e);
                    h.term !== c.term && (this.$search.length && (this.$search.val(h.term),
                        this.$search.focus()), c.term = h.term), b.call(this, c, d)
                }, b.prototype.tokenizer = function(b, c, d, e) {
                    for (var f = d.get("tokenSeparators") || [], g = c.term, h = 0, i = this.createTag || function(a) {
                            return {
                                id: a.term,
                                text: a.term
                            }
                        }; h < g.length;) {
                        var j = g[h];
                        if (-1 !== a.inArray(j, f)) {
                            var k = g.substr(0, h),
                                l = a.extend({}, c, {
                                    term: k
                                }),
                                m = i(l);
                            null != m ? (e(m), g = g.substr(h + 1) || "", h = 0) : h++
                        } else h++
                    }
                    return {
                        term: g
                    }
                }, b
            }), b.define("select2/data/minimumInputLength", [], function() {
                function a(a, b, c) {
                    this.minimumInputLength = c.get("minimumInputLength"),
                        a.call(this, b, c)
                }
                return a.prototype.query = function(a, b, c) {
                    if (b.term = b.term || "", b.term.length < this.minimumInputLength) return void this.trigger("results:message", {
                        message: "inputTooShort",
                        args: {
                            minimum: this.minimumInputLength,
                            input: b.term,
                            params: b
                        }
                    });
                    a.call(this, b, c)
                }, a
            }), b.define("select2/data/maximumInputLength", [], function() {
                function a(a, b, c) {
                    this.maximumInputLength = c.get("maximumInputLength"), a.call(this, b, c)
                }
                return a.prototype.query = function(a, b, c) {
                    if (b.term = b.term || "", this.maximumInputLength > 0 &&
                        b.term.length > this.maximumInputLength) return void this.trigger("results:message", {
                        message: "inputTooLong",
                        args: {
                            maximum: this.maximumInputLength,
                            input: b.term,
                            params: b
                        }
                    });
                    a.call(this, b, c)
                }, a
            }), b.define("select2/data/maximumSelectionLength", [], function() {
                function a(a, b, c) {
                    this.maximumSelectionLength = c.get("maximumSelectionLength"), a.call(this, b, c)
                }
                return a.prototype.query = function(a, b, c) {
                    var d = this;
                    this.current(function(e) {
                        var f = null != e ? e.length : 0;
                        if (d.maximumSelectionLength > 0 && f >= d.maximumSelectionLength) return void d.trigger("results:message", {
                            message: "maximumSelected",
                            args: {
                                maximum: d.maximumSelectionLength
                            }
                        });
                        a.call(d, b, c)
                    })
                }, a
            }), b.define("select2/dropdown", ["jquery", "./utils"], function(a, b) {
                function c(a, b) {
                    this.$element = a, this.options = b, c.__super__.constructor.call(this)
                }
                return b.Extend(c, b.Observable), c.prototype.render = function() {
                    var b = a('<span class="select2-dropdown"><span class="select2-results"></span></span>');
                    return b.attr("dir", this.options.get("dir")), this.$dropdown = b, b
                }, c.prototype.bind = function() {}, c.prototype.position = function(a,
                    b) {}, c.prototype.destroy = function() {
                    this.$dropdown.remove()
                }, c
            }), b.define("select2/dropdown/search", ["jquery", "../utils"], function(a, b) {
                function c() {}
                return c.prototype.render = function(b) {
                    var c = b.call(this),
                        d = a('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="textbox" /></span>');
                    return this.$searchContainer = d, this.$search = d.find("input"), c.prepend(d),
                        c
                }, c.prototype.bind = function(b, c, d) {
                    var e = this;
                    b.call(this, c, d), this.$search.on("keydown", function(a) {
                            e.trigger("keypress", a), e._keyUpPrevented = a.isDefaultPrevented()
                        }), this.$search.on("input", function(b) {
                            a(this).off("keyup")
                        }), this.$search.on("keyup input", function(a) {
                            e.handleSearch(a)
                        }), c.on("open", function() {
                            e.$search.attr("tabindex", 0), e.$search.focus(), window.setTimeout(function() {
                                e.$search.focus()
                            }, 0)
                        }), c.on("close", function() {
                            e.$search.attr("tabindex", -1), e.$search.val(""), e.$search.blur()
                        }),
                        c.on("focus", function() {
                            c.isOpen() || e.$search.focus()
                        }), c.on("results:all", function(a) {
                            if (null == a.query.term || "" === a.query.term) e.showSearch(a) ? e.$searchContainer.removeClass("select2-search--hide") : e.$searchContainer.addClass("select2-search--hide")
                        })
                }, c.prototype.handleSearch = function(a) {
                    if (!this._keyUpPrevented) {
                        var b = this.$search.val();
                        this.trigger("query", {
                            term: b
                        })
                    }
                    this._keyUpPrevented = !1
                }, c.prototype.showSearch = function(a, b) {
                    return !0
                }, c
            }), b.define("select2/dropdown/hidePlaceholder", [], function() {
                function a(a,
                    b, c, d) {
                    this.placeholder = this.normalizePlaceholder(c.get("placeholder")), a.call(this, b, c, d)
                }
                return a.prototype.append = function(a, b) {
                    b.results = this.removePlaceholder(b.results), a.call(this, b)
                }, a.prototype.normalizePlaceholder = function(a, b) {
                    return "string" == typeof b && (b = {
                        id: "",
                        text: b
                    }), b
                }, a.prototype.removePlaceholder = function(a, b) {
                    for (var c = b.slice(0), d = b.length - 1; d >= 0; d--) {
                        var e = b[d];
                        this.placeholder.id === e.id && c.splice(d, 1)
                    }
                    return c
                }, a
            }), b.define("select2/dropdown/infiniteScroll", ["jquery"], function(a) {
                function b(a,
                    b, c, d) {
                    this.lastParams = {}, a.call(this, b, c, d), this.$loadingMore = this.createLoadingMore(), this.loading = !1
                }
                return b.prototype.append = function(a, b) {
                    this.$loadingMore.remove(), this.loading = !1, a.call(this, b), this.showLoadingMore(b) && this.$results.append(this.$loadingMore)
                }, b.prototype.bind = function(b, c, d) {
                    var e = this;
                    b.call(this, c, d), c.on("query", function(a) {
                        e.lastParams = a, e.loading = !0
                    }), c.on("query:append", function(a) {
                        e.lastParams = a, e.loading = !0
                    }), this.$results.on("scroll", function() {
                        var b = a.contains(document.documentElement,
                            e.$loadingMore[0]);
                        if (!e.loading && b) e.$results.offset().top + e.$results.outerHeight(!1) + 50 >= e.$loadingMore.offset().top + e.$loadingMore.outerHeight(!1) && e.loadMore()
                    })
                }, b.prototype.loadMore = function() {
                    this.loading = !0;
                    var b = a.extend({}, {
                        page: 1
                    }, this.lastParams);
                    b.page++, this.trigger("query:append", b)
                }, b.prototype.showLoadingMore = function(a, b) {
                    return b.pagination && b.pagination.more
                }, b.prototype.createLoadingMore = function() {
                    var b = a('<li class="select2-results__option select2-results__option--load-more"role="treeitem" aria-disabled="true"></li>'),
                        c = this.options.get("translations").get("loadingMore");
                    return b.html(c(this.lastParams)), b
                }, b
            }), b.define("select2/dropdown/attachBody", ["jquery", "../utils"], function(a, b) {
                function c(b, c, d) {
                    this.$dropdownParent = d.get("dropdownParent") || a(document.body), b.call(this, c, d)
                }
                return c.prototype.bind = function(a, b, c) {
                    var d = this,
                        e = !1;
                    a.call(this, b, c), b.on("open", function() {
                        d._showDropdown(), d._attachPositioningHandler(b), e || (e = !0, b.on("results:all", function() {
                            d._positionDropdown(), d._resizeDropdown()
                        }), b.on("results:append",
                            function() {
                                d._positionDropdown(), d._resizeDropdown()
                            }))
                    }), b.on("close", function() {
                        d._hideDropdown(), d._detachPositioningHandler(b)
                    }), this.$dropdownContainer.on("mousedown", function(a) {
                        a.stopPropagation()
                    })
                }, c.prototype.destroy = function(a) {
                    a.call(this), this.$dropdownContainer.remove()
                }, c.prototype.position = function(a, b, c) {
                    b.attr("class", c.attr("class")), b.removeClass("select2"), b.addClass("select2-container--open"), b.css({
                        position: "absolute",
                        top: -999999
                    }), this.$container = c
                }, c.prototype.render = function(b) {
                    var c =
                        a("<span></span>"),
                        d = b.call(this);
                    return c.append(d), this.$dropdownContainer = c, c
                }, c.prototype._hideDropdown = function(a) {
                    this.$dropdownContainer.detach()
                }, c.prototype._attachPositioningHandler = function(c, d) {
                    var e = this,
                        f = "scroll.select2." + d.id,
                        g = "resize.select2." + d.id,
                        h = "orientationchange.select2." + d.id,
                        i = this.$container.parents().filter(b.hasScroll);
                    i.each(function() {
                        b.StoreData(this, "select2-scroll-position", {
                            x: a(this).scrollLeft(),
                            y: a(this).scrollTop()
                        })
                    }), i.on(f, function(c) {
                        var d = b.GetData(this,
                            "select2-scroll-position");
                        a(this).scrollTop(d.y)
                    }), a(window).on(f + " " + g + " " + h, function(a) {
                        e._positionDropdown(), e._resizeDropdown()
                    })
                }, c.prototype._detachPositioningHandler = function(c, d) {
                    var e = "scroll.select2." + d.id,
                        f = "resize.select2." + d.id,
                        g = "orientationchange.select2." + d.id;
                    this.$container.parents().filter(b.hasScroll).off(e), a(window).off(e + " " + f + " " + g)
                }, c.prototype._positionDropdown = function() {
                    var b = a(window),
                        c = this.$dropdown.hasClass("select2-dropdown--above"),
                        d = this.$dropdown.hasClass("select2-dropdown--below"),
                        e = null,
                        f = this.$container.offset();
                    f.bottom = f.top + this.$container.outerHeight(!1);
                    var g = {
                        height: this.$container.outerHeight(!1)
                    };
                    g.top = f.top, g.bottom = f.top + g.height;
                    var h = {
                            height: this.$dropdown.outerHeight(!1)
                        },
                        i = {
                            top: b.scrollTop(),
                            bottom: b.scrollTop() + b.height()
                        },
                        j = i.top < f.top - h.height,
                        k = i.bottom > f.bottom + h.height,
                        l = {
                            left: f.left,
                            top: g.bottom
                        },
                        m = this.$dropdownParent;
                    "static" === m.css("position") && (m = m.offsetParent());
                    var n = m.offset();
                    l.top -= n.top, l.left -= n.left, c || d || (e = "below"), k || !j || c ? !j && k && c &&
                        (e = "below") : e = "above", ("above" == e || c && "below" !== e) && (l.top = g.top - n.top - h.height), null != e && (this.$dropdown.removeClass("select2-dropdown--below select2-dropdown--above").addClass("select2-dropdown--" + e), this.$container.removeClass("select2-container--below select2-container--above").addClass("select2-container--" + e)), this.$dropdownContainer.css(l)
                }, c.prototype._resizeDropdown = function() {
                    var a = {
                        width: this.$container.outerWidth(!1) + "px"
                    };
                    this.options.get("dropdownAutoWidth") && (a.minWidth = a.width, a.position =
                        "relative", a.width = "auto"), this.$dropdown.css(a)
                }, c.prototype._showDropdown = function(a) {
                    this.$dropdownContainer.appendTo(this.$dropdownParent), this._positionDropdown(), this._resizeDropdown()
                }, c
            }), b.define("select2/dropdown/minimumResultsForSearch", [], function() {
                function a(b) {
                    for (var c = 0, d = 0; d < b.length; d++) {
                        var e = b[d];
                        e.children ? c += a(e.children) : c++
                    }
                    return c
                }

                function b(a, b, c, d) {
                    this.minimumResultsForSearch = c.get("minimumResultsForSearch"), this.minimumResultsForSearch < 0 && (this.minimumResultsForSearch =
                        1 / 0), a.call(this, b, c, d)
                }
                return b.prototype.showSearch = function(b, c) {
                    return !(a(c.data.results) < this.minimumResultsForSearch) && b.call(this, c)
                }, b
            }), b.define("select2/dropdown/selectOnClose", ["../utils"], function(a) {
                function b() {}
                return b.prototype.bind = function(a, b, c) {
                    var d = this;
                    a.call(this, b, c), b.on("close", function(a) {
                        d._handleSelectOnClose(a)
                    })
                }, b.prototype._handleSelectOnClose = function(b, c) {
                    if (c && null != c.originalSelect2Event) {
                        var d = c.originalSelect2Event;
                        if ("select" === d._type || "unselect" === d._type) return
                    }
                    var e =
                        this.getHighlightedResults();
                    if (!(e.length < 1)) {
                        var f = a.GetData(e[0], "data");
                        null != f.element && f.element.selected || null == f.element && f.selected || this.trigger("select", {
                            data: f
                        })
                    }
                }, b
            }), b.define("select2/dropdown/closeOnSelect", [], function() {
                function a() {}
                return a.prototype.bind = function(a, b, c) {
                    var d = this;
                    a.call(this, b, c), b.on("select", function(a) {
                        d._selectTriggered(a)
                    }), b.on("unselect", function(a) {
                        d._selectTriggered(a)
                    })
                }, a.prototype._selectTriggered = function(a, b) {
                    var c = b.originalEvent;
                    c && c.ctrlKey || this.trigger("close", {
                        originalEvent: c,
                        originalSelect2Event: b
                    })
                }, a
            }), b.define("select2/i18n/en", [], function() {
                return {
                    errorLoading: function() {
                        return "The results could not be loaded."
                    },
                    inputTooLong: function(a) {
                        var b = a.input.length - a.maximum,
                            c = "Please delete " + b + " character";
                        return 1 != b && (c += "s"), c
                    },
                    inputTooShort: function(a) {
                        return "Please enter " + (a.minimum - a.input.length) + " or more characters"
                    },
                    loadingMore: function() {
                        return "Loading more results\u2026"
                    },
                    maximumSelected: function(a) {
                        var b = "You can only select " + a.maximum + " item";
                        return 1 != a.maximum && (b += "s"), b
                    },
                    noResults: function() {
                        return "No results found"
                    },
                    searching: function() {
                        return "Searching\u2026"
                    }
                }
            }), b.define("select2/defaults", ["jquery", "require", "./results", "./selection/single", "./selection/multiple", "./selection/placeholder", "./selection/allowClear", "./selection/search", "./selection/eventRelay", "./utils", "./translation", "./diacritics", "./data/select", "./data/array", "./data/ajax", "./data/tags", "./data/tokenizer", "./data/minimumInputLength", "./data/maximumInputLength",
                "./data/maximumSelectionLength", "./dropdown", "./dropdown/search", "./dropdown/hidePlaceholder", "./dropdown/infiniteScroll", "./dropdown/attachBody", "./dropdown/minimumResultsForSearch", "./dropdown/selectOnClose", "./dropdown/closeOnSelect", "./i18n/en"
            ], function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, A, B, C) {
                function D() {
                    this.reset()
                }
                return D.prototype.apply = function(l) {
                    if (l = a.extend(!0, {}, this.defaults, l), null == l.dataAdapter) {
                        if (null != l.ajax ? l.dataAdapter = o : null != l.data ? l.dataAdapter = n : l.dataAdapter =
                            m, l.minimumInputLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, r)), l.maximumInputLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, s)), l.maximumSelectionLength > 0 && (l.dataAdapter = j.Decorate(l.dataAdapter, t)), l.tags && (l.dataAdapter = j.Decorate(l.dataAdapter, p)), null == l.tokenSeparators && null == l.tokenizer || (l.dataAdapter = j.Decorate(l.dataAdapter, q)), null != l.query) {
                            var C = b(l.amdBase + "compat/query");
                            l.dataAdapter = j.Decorate(l.dataAdapter, C)
                        }
                        if (null != l.initSelection) {
                            var D = b(l.amdBase + "compat/initSelection");
                            l.dataAdapter = j.Decorate(l.dataAdapter, D)
                        }
                    }
                    if (null == l.resultsAdapter && (l.resultsAdapter = c, null != l.ajax && (l.resultsAdapter = j.Decorate(l.resultsAdapter, x)), null != l.placeholder && (l.resultsAdapter = j.Decorate(l.resultsAdapter, w)), l.selectOnClose && (l.resultsAdapter = j.Decorate(l.resultsAdapter, A))), null == l.dropdownAdapter) {
                        if (l.multiple) l.dropdownAdapter = u;
                        else {
                            var E = j.Decorate(u, v);
                            l.dropdownAdapter = E
                        }
                        if (0 !== l.minimumResultsForSearch && (l.dropdownAdapter = j.Decorate(l.dropdownAdapter, z)), l.closeOnSelect &&
                            (l.dropdownAdapter = j.Decorate(l.dropdownAdapter, B)), null != l.dropdownCssClass || null != l.dropdownCss || null != l.adaptDropdownCssClass) {
                            var F = b(l.amdBase + "compat/dropdownCss");
                            l.dropdownAdapter = j.Decorate(l.dropdownAdapter, F)
                        }
                        l.dropdownAdapter = j.Decorate(l.dropdownAdapter, y)
                    }
                    if (null == l.selectionAdapter) {
                        if (l.multiple ? l.selectionAdapter = e : l.selectionAdapter = d, null != l.placeholder && (l.selectionAdapter = j.Decorate(l.selectionAdapter, f)), l.allowClear && (l.selectionAdapter = j.Decorate(l.selectionAdapter, g)), l.multiple &&
                            (l.selectionAdapter = j.Decorate(l.selectionAdapter, h)), null != l.containerCssClass || null != l.containerCss || null != l.adaptContainerCssClass) {
                            var G = b(l.amdBase + "compat/containerCss");
                            l.selectionAdapter = j.Decorate(l.selectionAdapter, G)
                        }
                        l.selectionAdapter = j.Decorate(l.selectionAdapter, i)
                    }
                    if ("string" == typeof l.language)
                        if (l.language.indexOf("-") > 0) {
                            var H = l.language.split("-"),
                                I = H[0];
                            l.language = [l.language, I]
                        } else l.language = [l.language];
                    if (a.isArray(l.language)) {
                        var J = new k;
                        l.language.push("en");
                        for (var K =
                                l.language, L = 0; L < K.length; L++) {
                            var M = K[L],
                                N = {};
                            try {
                                N = k.loadPath(M)
                            } catch (a$7) {
                                try {
                                    M = this.defaults.amdLanguageBase + M, N = k.loadPath(M)
                                } catch (a$6) {
                                    l.debug && window.console && console.warn && console.warn('Select2: The language file for "' + M + '" could not be automatically loaded. A fallback will be used instead.');
                                    continue
                                }
                            }
                            J.extend(N)
                        }
                        l.translations = J
                    } else {
                        var O = k.loadPath(this.defaults.amdLanguageBase + "en"),
                            P = new k(l.language);
                        P.extend(O), l.translations = P
                    }

                    return l
                }, D.prototype.reset = function() {
                    function b(a) {
                        function b(a) {
                            return l[a] ||
                                a
                        }
                        return a.replace(/[^\u0000-\u007E]/g, b)
                    }

                    function c(d, e) {
                        if ("" === a.trim(d.term)) return e;
                        if (e.children && e.children.length > 0) {
                            for (var f = a.extend(!0, {}, e), g = e.children.length - 1; g >= 0; g--) null == c(d, e.children[g]) && f.children.splice(g, 1);
                            return f.children.length > 0 ? f : c(d, f)
                        }
                        var h = b(e.text).toUpperCase(),
                            i = b(d.term).toUpperCase();
                        return h.indexOf(i) > -1 ? e : null
                    }
                    this.defaults = {
                        amdBase: "./",
                        amdLanguageBase: "./i18n/",
                        closeOnSelect: !0,
                        debug: !1,
                        dropdownAutoWidth: !1,
                        escapeMarkup: j.escapeMarkup,
                        language: C,
                        matcher: c,
                        minimumInputLength: 0,
                        maximumInputLength: 0,
                        maximumSelectionLength: 0,
                        minimumResultsForSearch: 0,
                        selectOnClose: !1,
                        sorter: function(a) {
                            return a
                        },
                        templateResult: function(a) {
                            return a.text
                        },
                        templateSelection: function(a) {
                            return a.text
                        },
                        theme: "default",
                        width: "resolve"
                    }
                }, D.prototype.set = function(b, c) {
                    var d = a.camelCase(b),
                        e = {};
                    e[d] = c;
                    var f = j._convertData(e);
                    a.extend(!0, this.defaults, f)
                }, new D
            }), b.define("select2/options", ["require", "jquery", "./defaults", "./utils"], function(a, b, c, d) {
                function e(b, e) {
                    if (this.options =
                        b, null != e && this.fromElement(e), this.options = c.apply(this.options), e && e.is("input")) {
                        var f = a(this.get("amdBase") + "compat/inputData");
                        this.options.dataAdapter = d.Decorate(this.options.dataAdapter, f)
                    }
                }
                return e.prototype.fromElement = function(a) {
                    var c = ["select2"];
                    null == this.options.multiple && (this.options.multiple = a.prop("multiple")), null == this.options.disabled && (this.options.disabled = a.prop("disabled")), null == this.options.language && (a.prop("lang") ? this.options.language = a.prop("lang").toLowerCase() : a.closest("[lang]").prop("lang") &&
                        (this.options.language = a.closest("[lang]").prop("lang"))), null == this.options.dir && (a.prop("dir") ? this.options.dir = a.prop("dir") : a.closest("[dir]").prop("dir") ? this.options.dir = a.closest("[dir]").prop("dir") : this.options.dir = "ltr"), a.prop("disabled", this.options.disabled), a.prop("multiple", this.options.multiple), d.GetData(a[0], "select2Tags") && (this.options.debug && window.console && console.warn && console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'),
                        d.StoreData(a[0], "data", d.GetData(a[0], "select2Tags")), d.StoreData(a[0], "tags", !0)), d.GetData(a[0], "ajaxUrl") && (this.options.debug && window.console && console.warn && console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."), a.attr("ajax--url", d.GetData(a[0], "ajaxUrl")), d.StoreData(a[0], "ajax-Url", d.GetData(a[0], "ajaxUrl")));
                    var e = {};
                    e = b.fn.jquery && "1." == b.fn.jquery.substr(0, 2) && a[0].dataset ?
                        b.extend(!0, {}, a[0].dataset, d.GetData(a[0])) : d.GetData(a[0]);
                    var f = b.extend(!0, {}, e);
                    f = d._convertData(f);
                    for (var g in f) b.inArray(g, c) > -1 || (b.isPlainObject(this.options[g]) ? b.extend(this.options[g], f[g]) : this.options[g] = f[g]);
                    return this
                }, e.prototype.get = function(a) {
                    return this.options[a]
                }, e.prototype.set = function(a, b) {
                    this.options[a] = b
                }, e
            }), b.define("select2/core", ["jquery", "./options", "./utils", "./keys"], function(a, b, c, d) {
                var e = function(a, d) {
                    null != c.GetData(a[0], "select2") && c.GetData(a[0], "select2").destroy(),
                        this.$element = a, this.id = this._generateId(a), d = d || {}, this.options = new b(d, a), e.__super__.constructor.call(this);
                    var f = a.attr("tabindex") || 0;
                    c.StoreData(a[0], "old-tabindex", f), a.attr("tabindex", "-1");
                    var g = this.options.get("dataAdapter");
                    this.dataAdapter = new g(a, this.options);
                    var h = this.render();
                    this._placeContainer(h);
                    var i = this.options.get("selectionAdapter");
                    this.selection = new i(a, this.options), this.$selection = this.selection.render(), this.selection.position(this.$selection, h);
                    var j = this.options.get("dropdownAdapter");
                    this.dropdown = new j(a, this.options), this.$dropdown = this.dropdown.render(), this.dropdown.position(this.$dropdown, h);
                    var k = this.options.get("resultsAdapter");
                    this.results = new k(a, this.options, this.dataAdapter), this.$results = this.results.render(), this.results.position(this.$results, this.$dropdown);
                    var l = this;
                    this._bindAdapters(), this._registerDomEvents(), this._registerDataEvents(), this._registerSelectionEvents(), this._registerDropdownEvents(), this._registerResultsEvents(), this._registerEvents(), this.dataAdapter.current(function(a) {
                        l.trigger("selection:update", {
                            data: a
                        })
                    }), a.addClass("select2-hidden-accessible"), a.attr("aria-hidden", "true"), this._syncAttributes(), c.StoreData(a[0], "select2", this), a.data("select2", this)
                };
                return c.Extend(e, c.Observable), e.prototype._generateId = function(a) {
                        var b = "";
                        return b = null != a.attr("id") ? a.attr("id") : null != a.attr("name") ? a.attr("name") + "-" + c.generateChars(2) : c.generateChars(4), b = b.replace(/(:|\.|\[|\]|,)/g, ""), b = "select2-" + b
                    }, e.prototype._placeContainer = function(a) {
                        a.insertAfter(this.$element);
                        var b = this._resolveWidth(this.$element,
                            this.options.get("width"));
                        null != b && a.css("width", b)
                    }, e.prototype._resolveWidth = function(a, b) {
                        var c = /^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;
                        if ("resolve" == b) {
                            var d = this._resolveWidth(a, "style");
                            return null != d ? d : this._resolveWidth(a, "element")
                        }
                        if ("element" == b) {
                            var e = a.outerWidth(!1);
                            return e <= 0 ? "auto" : e + "px"
                        }
                        if ("style" == b) {
                            var f = a.attr("style");
                            if ("string" != typeof f) return null;
                            for (var g = f.split(";"), h = 0, i = g.length; h < i; h += 1) {
                                var j = g[h].replace(/\s/g, ""),
                                    k = j.match(c);
                                if (null !==
                                    k && k.length >= 1) return k[1]
                            }
                            return null
                        }
                        return b
                    }, e.prototype._bindAdapters = function() {
                        this.dataAdapter.bind(this, this.$container), this.selection.bind(this, this.$container), this.dropdown.bind(this, this.$container), this.results.bind(this, this.$container)
                    }, e.prototype._registerDomEvents = function() {
                        var b = this;
                        this.$element.on("change.select2", function() {
                                b.dataAdapter.current(function(a) {
                                    b.trigger("selection:update", {
                                        data: a
                                    })
                                })
                            }), this.$element.on("focus.select2", function(a) {
                                b.trigger("focus", a)
                            }), this._syncA =
                            c.bind(this._syncAttributes, this), this._syncS = c.bind(this._syncSubtree, this), this.$element[0].attachEvent && this.$element[0].attachEvent("onpropertychange", this._syncA);
                        var d = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver;
                        null != d ? (this._observer = new d(function(c) {
                            a.each(c, b._syncA), a.each(c, b._syncS)
                        }), this._observer.observe(this.$element[0], {
                            attributes: !0,
                            childList: !0,
                            subtree: !1
                        })) : this.$element[0].addEventListener && (this.$element[0].addEventListener("DOMAttrModified",
                            b._syncA, !1), this.$element[0].addEventListener("DOMNodeInserted", b._syncS, !1), this.$element[0].addEventListener("DOMNodeRemoved", b._syncS, !1))
                    }, e.prototype._registerDataEvents = function() {
                        var a = this;
                        this.dataAdapter.on("*", function(b, c) {
                            a.trigger(b, c)
                        })
                    }, e.prototype._registerSelectionEvents = function() {
                        var b = this,
                            c = ["toggle", "focus"];
                        this.selection.on("toggle", function() {
                            b.toggleDropdown()
                        }), this.selection.on("focus", function(a) {
                            b.focus(a)
                        }), this.selection.on("*", function(d, e) {
                            -1 === a.inArray(d, c) &&
                                b.trigger(d, e)
                        })
                    }, e.prototype._registerDropdownEvents = function() {
                        var a = this;
                        this.dropdown.on("*", function(b, c) {
                            a.trigger(b, c)
                        })
                    }, e.prototype._registerResultsEvents = function() {
                        var a = this;
                        this.results.on("*", function(b, c) {
                            a.trigger(b, c)
                        })
                    }, e.prototype._registerEvents = function() {
                        var a = this;
                        this.on("open", function() {
                                a.$container.addClass("select2-container--open")
                            }), this.on("close", function() {
                                a.$container.removeClass("select2-container--open")
                            }), this.on("enable", function() {
                                a.$container.removeClass("select2-container--disabled")
                            }),
                            this.on("disable", function() {
                                a.$container.addClass("select2-container--disabled")
                            }), this.on("blur", function() {
                                a.$container.removeClass("select2-container--focus")
                            }), this.on("query", function(b) {
                                a.isOpen() || a.trigger("open", {}), this.dataAdapter.query(b, function(c) {
                                    a.trigger("results:all", {
                                        data: c,
                                        query: b
                                    })
                                })
                            }), this.on("query:append", function(b) {
                                this.dataAdapter.query(b, function(c) {
                                    a.trigger("results:append", {
                                        data: c,
                                        query: b
                                    })
                                })
                            }), this.on("keypress", function(b) {
                                var c = b.which;
                                a.isOpen() ? c === d.ESC || c ===
                                    d.TAB || c === d.UP && b.altKey ? (a.close(), b.preventDefault()) : c === d.ENTER ? (a.trigger("results:select", {}), b.preventDefault()) : c === d.SPACE && b.ctrlKey ? (a.trigger("results:toggle", {}), b.preventDefault()) : c === d.UP ? (a.trigger("results:previous", {}), b.preventDefault()) : c === d.DOWN && (a.trigger("results:next", {}), b.preventDefault()) : (c === d.ENTER || c === d.SPACE || c === d.DOWN && b.altKey) && (a.open(), b.preventDefault())
                            })
                    }, e.prototype._syncAttributes = function() {
                        this.options.set("disabled", this.$element.prop("disabled")),
                            this.options.get("disabled") ? (this.isOpen() && this.close(), this.trigger("disable", {})) : this.trigger("enable", {})
                    }, e.prototype._syncSubtree = function(a, b) {
                        var c = !1,
                            d = this;
                        if (!a || !a.target || "OPTION" === a.target.nodeName || "OPTGROUP" === a.target.nodeName) {
                            if (b)
                                if (b.addedNodes && b.addedNodes.length > 0)
                                    for (var e = 0; e < b.addedNodes.length; e++) {
                                        var f = b.addedNodes[e];
                                        f.selected && (c = !0)
                                    } else b.removedNodes && b.removedNodes.length > 0 && (c = !0);
                                else c = !0;
                            c && this.dataAdapter.current(function(a) {
                                d.trigger("selection:update", {
                                    data: a
                                })
                            })
                        }
                    }, e.prototype.trigger = function(a, b) {
                        var c = e.__super__.trigger,
                            d = {
                                open: "opening",
                                close: "closing",
                                select: "selecting",
                                unselect: "unselecting",
                                clear: "clearing"
                            };
                        if (void 0 === b && (b = {}), a in d) {
                            var f = d[a],
                                g = {
                                    prevented: !1,
                                    name: a,
                                    args: b
                                };
                            if (c.call(this, f, g), g.prevented) return void(b.prevented = !0)
                        }
                        c.call(this, a, b)
                    }, e.prototype.toggleDropdown = function() {
                        this.options.get("disabled") || (this.isOpen() ? this.close() : this.open())
                    }, e.prototype.open = function() {
                        this.isOpen() || this.trigger("query", {})
                    }, e.prototype.close =
                    function() {
                        this.isOpen() && this.trigger("close", {})
                    }, e.prototype.isOpen = function() {
                        return this.$container.hasClass("select2-container--open")
                    }, e.prototype.hasFocus = function() {
                        return this.$container.hasClass("select2-container--focus")
                    }, e.prototype.focus = function(a) {
                        this.hasFocus() || (this.$container.addClass("select2-container--focus"), this.trigger("focus", {}))
                    }, e.prototype.enable = function(a) {
                        this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.'),
                            null != a && 0 !== a.length || (a = [!0]);
                        var b = !a[0];
                        this.$element.prop("disabled", b)
                    }, e.prototype.data = function() {
                        this.options.get("debug") && arguments.length > 0 && window.console && console.warn && console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');
                        var a = [];
                        return this.dataAdapter.current(function(b) {
                            a = b
                        }), a
                    }, e.prototype.val = function(b) {
                        if (this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'),
                            null == b || 0 === b.length) return this.$element.val();
                        var c = b[0];
                        a.isArray(c) && (c = a.map(c, function(a) {
                            return a.toString()
                        })), this.$element.val(c).trigger("change")
                    }, e.prototype.destroy = function() {
                        this.$container.remove(), this.$element[0].detachEvent && this.$element[0].detachEvent("onpropertychange", this._syncA), null != this._observer ? (this._observer.disconnect(), this._observer = null) : this.$element[0].removeEventListener && (this.$element[0].removeEventListener("DOMAttrModified", this._syncA, !1), this.$element[0].removeEventListener("DOMNodeInserted",
                                this._syncS, !1), this.$element[0].removeEventListener("DOMNodeRemoved", this._syncS, !1)), this._syncA = null, this._syncS = null, this.$element.off(".select2"), this.$element.attr("tabindex", c.GetData(this.$element[0], "old-tabindex")), this.$element.removeClass("select2-hidden-accessible"), this.$element.attr("aria-hidden", "false"), c.RemoveData(this.$element[0]), this.$element.removeData("select2"), this.dataAdapter.destroy(), this.selection.destroy(), this.dropdown.destroy(), this.results.destroy(), this.dataAdapter =
                            null, this.selection = null, this.dropdown = null, this.results = null
                    }, e.prototype.render = function() {
                        var b = a('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');
                        return b.attr("dir", this.options.get("dir")), this.$container = b, this.$container.addClass("select2-container--" + this.options.get("theme")), c.StoreData(b[0], "element", this.$element), b
                    }, e
            }), b.define("jquery-mousewheel", ["jquery"], function(a) {
                return a
            }), b.define("jquery.select2", ["jquery", "jquery-mousewheel", "./select2/core", "./select2/defaults", "./select2/utils"], function(a, b, c, d, e) {
                if (null == a.fn.select2) {
                    var f = ["open", "close", "destroy"];
                    a.fn.select2 = function(b) {
                        if ("object" == typeof(b = b || {})) return this.each(function() {
                            var d = a.extend(!0, {}, b);
                            new c(a(this), d)
                        }), this;
                        if ("string" == typeof b) {
                            var d, g = Array.prototype.slice.call(arguments, 1);
                            return this.each(function() {
                                var a = e.GetData(this, "select2");
                                null == a && window.console && console.error && console.error("The select2('" + b + "') method was called on an element that is not using Select2."),
                                    d = a[b].apply(a, g)
                            }), a.inArray(b, f) > -1 ? this : d
                        }
                        throw new Error("Invalid arguments for Select2: " + b);
                    }
                }
                return null == a.fn.select2.defaults && (a.fn.select2.defaults = d), c
            }), {
                define: b.define,
                require: b.require
            }
        }(),
        c = b.require("jquery.select2");
    return a.fn.select2.amd = b, c
});

function EmailAutocompletePlugin(form) {
    
}

function EmailValidationClassPlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.name !== "email") return;
        form.controls.email.on("change", function() {
            if ($(this).val()) $(this).addClass("has-value");
            else $(this).removeClass("has-value")
        })
    })
}

function InputMaskPlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.params.mask) form.setInputMask(data.name, data.params.mask)
    })
}

function RenderPostcodePlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.name !== "postcode") return;
        if (data.params.list !== undefined) $("#postcode").html(_.template($("#t-postcode-list").html())({
            postcodes: data.params.list
        }));
        if (data.params.alphanum) form.getControl("postcode").alphanum(data.params.alphanum)
    })
}

function RenderStatePlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.name !== "id_state") return;
        if (data.params.list === undefined) console.error("states list is empty for 'id_state'");
        $("#state").html(_.template($("#t-state-list").html())({
            states: data.params.list
        }))
    })
}

function StreetAutocompletePlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.name !== "street") return;
        if (data.params.autocomplete) form.controls.street.autocomplete({
            source: function(request, response) {
                form.findStreets(form.locale, form.getPostCode(), form.getCity(), request.term, function(streets) {
                    response(streets)
                })
            },
            change: function(event, ui) {
                if (data.params.autocompleteListOnly === true) {
                    var value = ui.item ? ui.item.value : "";
                    form.setStreet(value)
                }
            },
            open: function(event,
                ui) {
                $(".ui-autocomplete").off("menufocus hover mouseover mouseenter")
            },
            select: function(event, ui) {
                setTimeout(function() {
                    form.controls.street.trigger("change")
                }, 50)
            }
        })
    })
}

function BirthDateFieldExpandPlugin(form) {
    $(form).on(form.events.EVENT_BEFORE_CONTROL_ADD, function(e) {
        var data = e.eventData;
        if (data.name !== "birthDate") return;
        e.preventDefault();
        form.addControl(data.step, "birthDateDay", $.extend(data.params["_day"] || {}, data.params));
        form.addControl(data.step, "birthDateMonth", $.extend(data.params["_month"] || {}, data.params));
        form.addControl(data.step, "birthDateYear", $.extend(data.params["_year"] || {}, data.params))
    })
}

function ValidateAddedControlsPlugin(form) {
    $(form).on(form.events.EVENT_CONTROLS_ADDED, function(e) {
        var controls = e.eventData.controls;
        for (var key in controls)
            if (form.getControlValue(controls[key])) form.validate(controls[key])
    })
}

function AlphanumSettingsPlugin(form) {
    $(form).on(form.events.EVENT_CONTROL_ADDED, function(e) {
        var data = e.eventData;
        if (data.params.alphanumSettings) data.control.alphanum(data.params.alphanumSettings)
    })
}

/* funzione non in uso - Broly 
function AdvancedTermsAgreePlugin(form) {
    var termsAgreeStateChanged = false;

    function validateTerms() {
        if (form.controls.termsAgree.is(":checked") === false && form.controls.termsAgree2.is(":checked") === false) {
            form.controlsData.termsAgree.isValid = true;
            form.controlsData.termsAgree.value = 1;
            form.controlsData.termsAgree2.isValid = true;
            form.controlsData.termsAgree2.value = 1
        }
        if (form.controls.termsAgree.is(":checked") === true && form.controls.termsAgree2.is(":checked") === false) {
            form.controlsData.termsAgree2.isValid = true;
            form.controlsData.termsAgree2.value = 1
        }
        if (form.controls.termsAgree.is(":checked") === false && form.controls.termsAgree2.is(":checked") === true) {
            form.controlsData.termsAgree.isValid = true;
            form.controlsData.termsAgree.value = 0;
            form.controlsData.termsAgree2.isValid = true;
            form.controlsData.termsAgree2.value = 1
        }
    }
    $(form).on(form.events.EVENT_AFTER_FORM_INITED, function(e) {
        if (form.controls.termsAgree !== undefined && form.controls.termsAgree2 !== undefined) {
            $(form.controls.termsAgree).on("change", function(e) {
                termsAgreeStateChanged =
                    true;
                validateTerms()
            });
            $(form.controls.termsAgree2).on("change", function(e) {
                validateTerms()
            })
        }
    });
    $(form).on(form.events.EVENT_BEFORE_SEND_VALUES, function(e) {
        var values = e.eventData.values;
        if (values["termsAgree"] !== undefined && values["termsAgree2"] !== undefined)
            if (!!values["declinedOptIn"] === false) {
                if (!!values["termsAgree"] === false && !!values["termsAgree2"] === false) {
                    values["termsAgree"] = true;
                    values["termsAgree2"] = true
                }
                if (!!values["termsAgree"] === false) values["declinedOptIn"] = 1;
                e.eventData.values = values
            }
    });
    $(form).on(form.events.EVENT_BEFORE_FORM_SUBMIT, function(e) {
        if (form.controls.termsAgree !== undefined && form.controls.termsAgree2 !== undefined)
            if (termsAgreeStateChanged && form.controls.termsAgree.is(":checked") === false) {
                e.stopPropagation();
                form.onNoOptinClick();
                return false
            }
        form.ignoreTermsAgreeToAutoCheckSponsorsPopup = true
    })
}
*/ 

function CheckBoxPlugin(form)
{
    
    $(".showPrivacy").on('click',function(){
        
        $("#checkContainer").toggle()
    });

    $("#terms-agree").on('click',function(){
        if($(this).is(":checked"))
        {
            
            for(f=2;f<=4;f++)
            {
               $("#terms-agree"+f).prop('checked',true).change()
            }
        }
        else
        {
            for(f=2;f<=4;f++)
            {
                $("#terms-agree"+f).prop('checked',false).change()
            }
               
        }
    });

     
}

function AdvancedStreetElementPlugin(form) {
    var selectTemplate, inputTemplate;
    var streetSelector = "#street";
    var $select = $("#t-advanced-street-select");
    var $input = $("#t-advanced-street-input");
    var $container = $("#advanced-street-container");
    if ($select.length) selectTemplate = _.template($select.html());
    if ($input.length) inputTemplate = _.template($input.html());

    function setStreetValue(streets) {
        if (streets.length > 1) {
            form.setStreets(streets);
            form.controls.street.attr("disabled", false);
            form.controls.street.attr("readonly",
                false)
        }
        if (streets.length === 1) form.setStreet(streets[0])
    }
    $(form).on(form.events.EVENT_AFTER_STREET_FIND, function(e) {
        var streets = e.eventData.streets;
        if (!$container.length) return;
        form.controls.street.closest(".form-group").removeClass("-success");
        form.controls.street.closest(".form-group").addClass("ignore-validation-state");
        if (streets.length > 1 && selectTemplate) {
            form.controls.street.closest(".form-group").removeClass("ignore-validation-state");
            $container.html(selectTemplate())
        }
        if (streets.length === 1 &&
            inputTemplate) $container.html(inputTemplate());
        form.controls.street = $(streetSelector);
        setStreetValue(streets)
    })
}

function SetDefaultOnClickGenderPlugin(form) {
    $(form).on(form.events.EVENT_CONTROLS_ADDED, function(e) {
        var $gender = form.controls.gender;
        var $genderMask = $gender.find(".gender-mask");
        var $email = form.controls.email;

        function processGender() {
            if (false === $genderMask.hasClass("no-check")) {
                $email.focus();
                $(".radio-gender label", $gender).css("opacity", "1");
                $(".mask", $gender).hide();
                $(".mask-label", $gender).addClass("mask-label-float");
                $(".mask", $gender).addClass("mask-check");
                $(".error-mask", $gender).addClass("no-check");
                $('input[name="gender"]', $gender).filter("[value='Female']").click()
            }
        }
        $(".mask", $gender).on("focus", function() {
            processGender()
        });
        $gender.on("click", function() {
            processGender()
        })
    })
}

function BaseForm(locale, externalId) {
    var self = this;
    this.events = {
        EVENT_AFTER_FORM_INITED: "after-form-inited",
        EVENT_BEFORE_CONTROL_ADD: "before-control-add",
        EVENT_CONTROL_ADDED: "control-added",
        EVENT_CONTROLS_ADDED: "controls-added",
        EVENT_BEFORE_SEND_VALUES: "before-send-values",
        EVENT_BEFORE_FORM_SUBMIT: "before-form-submit",
        EVENT_AFTER_STREET_FIND: "after-street-find"
    };
    this.plugins = [];
    this.locale = locale;
    this.externalId = externalId;
    this.availableControls = {};
    this.controls = {};
    this.controlsData = {};
    this.step =
        1;
    this.stepsCount = undefined;
    this.cosponsorsStepTypes = undefined;
    this.focused = undefined;
    this.validator = undefined;
    this.validationInProgress = false;
    this.nextInProgress = false;
    this.coregContainers = undefined;
    this.coregTemplate = undefined;
    this.cityTemplate = undefined;
    this.addressTemplate = undefined;
    this.streetTemplate = undefined;
    this.houseNumberTemplate = undefined;
    this.loadedCosponsors = undefined;
    this.findStreetsRequestInProgress = undefined;
    this.citiesRequestInProgress = undefined;
    this.ignoreTermsAgreeToAutoCheckSponsorsPopup =
        undefined;
    this.sponsorsTracking = {
        canTrack: false,
        popupShowed: 0,
        sponsorsMap: {}
    };
    this.fbTracks = undefined;
    this.declinedOptIn = false;
    this.finishedCallback = undefined;
    this.isControlExist = function(control) {
        return self.controls[control]
    };
    this.getControl = function(control) {
        if (!self.isControlExist(control)) throw new Error("Invalid control " + control);
        return self.controls[control]
    };
    this.getBirthDateFields = function() {
        return ["birthDateDay", "birthDateMonth", "birthDateYear"]
    };
    this.isBirthDateField = function(controlName) {
        return this.getBirthDateFields().indexOf(controlName) !==
            -1
    };
    this.getGender = function(defaultValue) {
        return self.getControlValue("gender", defaultValue)
    };
    this.getFirstName = function(defaultValue) {
        return self.getControlValue("firstName", defaultValue)
    };
    this.getLastName = function(defaultValue) {
        return self.getControlValue("lastName", defaultValue)
    };
    this.getEmail = function(defaultValue) {
        return self.getControlValue("email", defaultValue)
    };
    this.getBirthDateDay = function(defaultValue) {
        return self.getControlValue("birthDateDay", defaultValue)
    };
    this.getBirthDateMonth = function(defaultValue) {
        return self.getControlValue("birthDateMonth",
            defaultValue)
    };
    this.getBirthDateYear = function(defaultValue) {
        return self.getControlValue("birthDateYear", defaultValue)
    };
    this.getPostCode = function(defaultValue) {
        return self.getControlValue("postcode", defaultValue)
    };
    this.getCity = function(defaultValue) {
        return self.getControlValue("city", defaultValue)
    };
    this.getPhone = function(defaultValue) {
        return self.getControlValue("phone", defaultValue)
    };
    this.getTermsAgree = function(defaultValue) {
        return self.getControlValue("termsAgree", defaultValue)
    };
    this.getTermsAgree2 = function(defaultValue) {
        return self.getControlValue("termsAgree2", defaultValue)
    };
    this.getTermsAgree3 = function(defaultValue) {
        return self.getControlValue("termsAgree3", defaultValue)
    };
    this.getTermsAgree4 = function(defaultValue) {
        return self.getControlValue("termsAgree4", defaultValue)
    };
    this.getTermsAgree5 = function(defaultValue) {
        return self.getControlValue("termsAgree5", defaultValue)
    };
    this.getTermsAgree6 = function(defaultValue) {
        return self.getControlValue("termsAgree6", defaultValue)
    };
    this.getTermsAgree7 = function(defaultValue) {
        return self.getControlValue("termsAgree7", defaultValue)
    };
    this.getTermsAgree8 = function(defaultValue) {
        return self.getControlValue("termsAgree8", defaultValue)
    };
    this.getStreet = function(defaultValue) {
        return self.getControlValue("street",defaultValue)
    };
    this.getAddress = function(defaultValue) {
        return self.getControlValue("address", defaultValue)
    };
    this.getHouseNumber = function(defaultValue) {
        return self.getControlValue("houseNumber", defaultValue)
    };
    this.getNationality = function(defaultValue) {
        return self.getControlValue("nationality", defaultValue)
    };
    this.getHouseNumberAddition = function(defaultValue) {
        return self.getControlValue("houseNumberAddition", defaultValue)
    };
    this.getBirthDate = function() {
        var d = self.getBirthDateDay(),
            m = self.getBirthDateMonth(),
            y = self.getBirthDateYear();
        d = d.length === 1 ? "0" + d : d;
        m = m.length === 1 ? "0" + m : m;
        if (!y && !m && !d) return null;
        else return y + "-" + m + "-" + d
    };
    this.setControlValue = function(control, value) {
        this.getControl(control).val(value);
        this.validate(control)
    };
    this.setCity = function(value) {
        this.setControlValue("city", value)
    };
    this.setStreet = function(value) {
        this.setControlValue("street", value)
    };
    this.setAddress = function(value) {
        this.setControlValue("address", value)
    };
    this.getPopupTracking = function() {
        $('.sponsor-overlay .sponsor-item input[name="sponsor"]').each(function() {
            var id =
                $(this).val();
            if ($(this).prop("checked")) {
                if (self.sponsorsTracking.sponsorsMap[id] !== "checked") self.sponsorsTracking.sponsorsMap[id] = "autochecked"
            } else self.sponsorsTracking.sponsorsMap[id] = "unchecked"
        });
        return self.sponsorsTracking
    };
    this.getCoSponsorList = function(callback) {
		/*
        var self = this;
        if (this.loadedCosponsors !== undefined) callback(this.loadedCosponsors);
        else $.get("/co-sponsor?externalId=" + self.externalId, function(res) {
                self.loadedCosponsors = [];
                if (res.success) self.loadedCosponsors = res.items;
                callback(self.loadedCosponsors)
            },
            "json")
			*/
    };
    this.trackCoSponsor = function(campaignId, answerId) {
        var self = this;
		/*
        $.post("/co-sponsor/track?externalId=" + self.externalId, {
            campaignId: campaignId,
            answerId: answerId
        }, function(res) {}, "json")
		*/
    };
    this.findStreets = function(locale, postcode, city, term, successCallback) {
        var self = this;
		
		/* bypass del check strade /*/
        self.findStreetsRequestInProgress = true;
        $.post("../services/streets.php", {
            locale: locale,
            postcode: postcode,
            city: city,
            term: term
        }, function(res) {
            var streets = res && res.streets ? res.streets : [];
            self.findStreetsRequestInProgress = false;
            var afterStreetFindEvent = $.Event(self.events.EVENT_AFTER_STREET_FIND);
            afterStreetFindEvent.eventData = {
                streets: streets
            };
            $(self).trigger(afterStreetFindEvent);
            successCallback(streets)
        }, "json").fail(function() {
            self.findStreetsRequestInProgress = false
        })
		
		
		//$(self).trigger(afterStreetFindEvent);
        //successCallback('{"success":false,"streets":[]}');
    };
    this.getNotFilledFields = function(excludeControlName, controlNames) {
        var resultsReuired = [];
        var resultsNotReuired = [];
        if (controlNames === undefined) {
            controlNames = [];
            for (controlName in this.controlsData) controlNames.push(controlName)
        }
        for (var i = 0; i < controlNames.length; i++) {
            var controlName =
                controlNames[i];
            if (excludeControlName === controlName) continue;
            if (self.isOnCurrentStep(controlName) && !self.isFilled(controlName))
                if (this.controlsData[controlName].params.required === false) resultsNotReuired.push(controlName);
                else resultsReuired.push(controlName)
        }
        return resultsReuired.concat(resultsNotReuired)
    };
    this.getNotFilledDateFields = function(excludeControlName) {
        return this.getNotFilledFields(excludeControlName, this.getBirthDateFields())
    };
    this.isFilled = function(controlName) {
        var result;
        var control =
            this.controlsData[controlName];
        if (control.value === undefined) result = false;
        else result = control.isValid;
        return result
    };
    this.isOnCurrentStep = function(controlName) {
        return this.step === this.controlsData[controlName].step
    };
    this.canFocus = function(controlName) {
        var controlParams = this.controlsData[controlName].params;
        var canFocus = true;
        if (controlParams.type === "radio") canFocus = false;
        else if (controlParams.readOnly === true) canFocus = false;
        return canFocus
    };
    this.onFocus = function(controlName) {
        $(".form-submit-group").each(function() {
            if ($(this).find("button").hasClass("disabled")) $(this).addClass("not-fixed")
        });
        if (this.citiesRequestInProgress || this.findStreetsRequestInProgress) return;
        if (!this.controlsData[controlName].isValid) this.resetValid(controlName);
        if (this.controlsData[controlName].params.readonly) {
            var toFocus = this.getNotFilledFields(controlName);
            for (var i = 0; i < toFocus.length; i++)
                if (this.canFocus(toFocus[i])) {
                    this.getControl(toFocus[i]).focus();
                    break
                }
        }
        if (this.controlsData[controlName].params.requires !== undefined) {
            var requires = this.controlsData[controlName].params.requires;
            if (this.isFilled(requires) ===
                false) this.getControl(requires).focus()
        }
    };
    this.onInput = function(controlName) {
        this.controlsData[controlName].onInput = true;
        if (this.isBirthDateField(controlName)) this.validate("birthDate", {
            markAsInvalid: false
        }, function() {
            self.getControl(controlName).change()
        });
        if (this.canChangeFocus(controlName)) this.changeFocus(controlName)
    };
    this.canChangeFocus = function(controlName) {
        var result = false;
        if (this.controlsData[controlName].params["type"] === "input") {
            var value = this.getControlValue(controlName);
            if (controlName ===
                "birthDateDay") {
                if (value.length === 1 && parseInt(value) > 3) result = true
            } else if (controlName === "birthDateMonth")
                if (value.length === 1 && parseInt(value) > 1) result = true;
            if (this.controlsData[controlName].params["maxLength"]) {
                var maxLength = this.controlsData[controlName].params["maxLength"];
                if (value.length >= maxLength) result = true
            } else if (this.controlsData[controlName].params["length"]) {
                var length = this.controlsData[controlName].params["length"];
                if (value.length >= length) result = true
            }
        }
        return result
    };
    this.changeFocus =
        function(controlName) {
            var toFocus = [];
            if (this.isBirthDateField(controlName)) toFocus = this.getNotFilledDateFields(controlName);
            if (!toFocus.length) toFocus = this.getNotFilledFields(controlName);
            if (toFocus.length)
                for (var i = 0; i < toFocus.length; i++)
                    if (this.canFocus(toFocus[i])) {
                        this.getControl(toFocus[i]).focus();
                        break
                    }
        };
    this.scrollTop = function(top) {
        $("html, body").animate({
            scrollTop: top
        }, 400)
    }
}
BaseForm.prototype.registerPlugin = function(plugin) {
    this.plugins.push(plugin)
};
BaseForm.prototype.initValidator = function(validationMessages) {
    this.validator = new Validator(this.externalId);
    this.validator.setValidationMessages(validationMessages)
};
BaseForm.prototype.init = function(finishedCallback) {
    this.finishedCallback = finishedCallback;
    this.coregContainers = $(".coreg-container");
    this.coregTemplate = _.template($("#t-coreg-list").html());
    this.cityTemplate = _.template($("#t-city-list").html());
    this.postcodeTemplate = _.template($("#t-postcode-list").html());
    this.addressTemplate = _.template($("#t-address-list").html());
    this.streetTemplate = _.template($("#t-street-list").html());
    this.houseNumberTemplate = _.template($("#t-house-number-list").html());
    this.hideCoregContainers();
    // probabile parte da modificare per cambiare la validazione in base ai campi visibili 
    if (this.controls.firstName) this.controls.firstName.change(this.validate.bind(this, "firstName"));
    this.controls.gender.change(this.validate.bind(this, "gender"));
    this.controls.lastName.change(this.validate.bind(this, "lastName"));
    this.controls.email.change(this.validate.bind(this, "email"));
    this.controls.birthDateDay.change(this.validate.bind(this, "birthDateDay"));
    this.controls.birthDateMonth.change(this.validate.bind(this, "birthDateMonth"));
    this.controls.birthDateYear.change(this.validate.bind(this, "birthDateYear"));
    this.controls.phone.change(this.validate.bind(this, "phone"));
    this.controls.termsAgree.change(this.validate.bind(this, "termsAgree"));
    // validazione al change delle checkbox
    if (this.controls.termsAgree2) this.controls.termsAgree2.change(this.validate.bind(this, "termsAgree2"));
    if (this.controls.termsAgree3) this.controls.termsAgree3.change(this.validate.bind(this, "termsAgree3"));
    if (this.controls.termsAgree4) this.controls.termsAgree4.change(this.validate.bind(this, "termsAgree4"));
    // test
    if (this.controls.termsAgree5) this.controls.termsAgree5.change(this.validate.bind(this, "termsAgree5"));
    if (this.controls.termsAgree6) this.controls.termsAgree6.change(this.validate.bind(this, "termsAgree6"));
    if (this.controls.termsAgree7) this.controls.termsAgree7.change(this.validate.bind(this, "termsAgree7"));
    if (this.controls.termsAgree8) this.controls.termsAgree8.change(this.validate.bind(this, "termsAgree8"));
    if (this.controls.postcode) this.controls.postcode.change(this.validate.bind(this, "postcode"));
    if (this.controls.id_state) this.controls.id_state.change(this.validate.bind(this, "id_state"));
    if (this.controls.city) this.controls.city.change(this.validate.bind(this, "city"));
    if (this.controls.address) this.controls.address.change(this.validate.bind(this, "address"));
    if (this.controls.street) this.controls.street.change(this.validate.bind(this, "street"));
    if (this.controls.houseNumber) this.controls.houseNumber.change(this.validate.bind(this, "houseNumber"));
    if (this.controls.houseNumberAddition) this.controls.houseNumberAddition.change(this.validate.bind(this, "houseNumberAddition"));
    if (this.controls.nationality) this.controls.nationality.change(this.validate.bind(this, "nationality"));
    var self = this;
    setInterval(function() {
        for (controlName in self.controlsData) {
            var value = self.getControlValue(controlName);
            if (self.controlsData[controlName].value === undefined && self.controlsData[controlName].onInput !== true && value !== undefined && value !== 0 && controlName !== "phone" && value !== "") {
                self.controlsData[controlName].onInput = true;
                self.validate(controlName)
            }
        }
    }, 500)
};
BaseForm.prototype.addControls = function(data, stepsCount, cosponsorsStepTypes) {
    var self = this;
    var controls = [];
    self.stepsCount = stepsCount;
    self.cosponsorsStepTypes = cosponsorsStepTypes;
    _.each(data, function(fields, step) {
        step = parseInt(step);
        _.each(fields, function(params, field) {
            controls.push(field);
            self.addControl(step, field, params)
        })
    });
    var controlsAddedEvent = $.Event(this.events.EVENT_CONTROLS_ADDED);
    controlsAddedEvent.eventData = {
        controls: controls
    };
    $(this).trigger(controlsAddedEvent)
};
BaseForm.prototype.resetValidAll = function() {
    var self = this;
    _.each(this.controls, function(name, control) {
        self.resetValid(control)
    })
};
BaseForm.prototype.addControl = function(step, name, params) {
    var self = this;
    var beforeControlAddEvent = $.Event(this.events.EVENT_BEFORE_CONTROL_ADD);
    beforeControlAddEvent.eventData = {
        name: name,
        params: params,
        step: step
    };
    $(self).trigger(beforeControlAddEvent);
    if (beforeControlAddEvent.isDefaultPrevented()) return;
    var control = this.availableControls[name];
    this.controls[name] = control;
    this.controlsData[name] = {
        step: step,
        isValid: !params.required,
        value: undefined,
        message: this.validator.getValidationMessageFor(name, "empty"),
        params: params
    };
    control.on(control.is("input:radio") ? "change" : "focus", {}, function(e) {
        if (self.focused !== name) {
            self.focused = name;
            self.onFocus(name)
        }
    });
    control.on("focusout", {}, function(e) {
        $(".form-submit-group").each(function() {
            $(this).removeClass("not-fixed")
        });
        self.focused = undefined
    });
    control.on("input", {}, function(e) {
        self.onInput(name)
    });
    var controlAddedEvent = $.Event(this.events.EVENT_CONTROL_ADDED);
    controlAddedEvent.eventData = {
        control: control,
        name: name,
        params: params,
        step: step
    };
    $(self).trigger(controlAddedEvent)
};
BaseForm.prototype.onNoOptinClick = function() {
    $(".terms-agree-container").hide();
    this.declinedOptIn = true;
    this.removeControl("termsAgree");
    this.removeControl("termsAgree2");
	this.removeControl("termsAgree3");
    this.removeControl("termsAgree4");
    this.removeControl("termsAgree5");
    this.removeControl("termsAgree6");
    this.removeControl("termsAgree7");
    this.removeControl("termsAgree8");
};
BaseForm.prototype.removeControl = function(name) {
    if (this.controls[name]) delete this.controls[name];
    if (this.controlsData[name]) delete this.controlsData[name]
};
BaseForm.prototype.getControl = function(name) {
    return this.controls[name]
};
BaseForm.prototype.setInputMask = function(input, mask) {
    this.controls[input].inputmask(mask)
};
BaseForm.prototype.getCitiesByPostcode = function(postcode, successCallback) {
    var self = this;

	// bypass ricerca città per cap (non più necessario, abbiamo agganciato il db dei cap)
    self.citiesRequestInProgress = true;
    $.post("../services/cities.php", {
        locale: "it_IT",
        postcode: postcode
    }, function(res) {
        self.citiesRequestInProgress = false;
        if (successCallback) successCallback(res.cities)
    }, "json").fail(function() {
        self.citiesRequestInProgress = false
    })
	
	
	
};
BaseForm.prototype.getCityByPostcode = function(postcode, successCallback) {
    this.getCitiesByPostcode(postcode, function(cities) {
        if (cities.length) successCallback(cities[0])
    })
};
BaseForm.prototype.getAddressesByPostcode = function(postcode, successCallback) {
    $.post("/postcode/addresses", {
        locale: this.locale,
        postcode: postcode
    }, function(res) {
        if (res.success)
            if (successCallback) successCallback(res.addresses)
    }, "json")
};
BaseForm.prototype.getStreetsByPostcode = function(postcode, successCallback) {
    $.post("/postcode/streets", {
        locale: this.locale,
        postcode: postcode
    }, function(res) {
        if (res.success)
            if (successCallback) successCallback(res.streets)
    }, "json")
};
BaseForm.prototype.getHouseNumbers = function(postcode, city, street, successCallback) {
    $.post("/postcode/get-house-numbers", {
        locale: this.locale,
        postcode: postcode,
        city: city,
        street: street
    }, function(res) {
        if (res.success && successCallback) successCallback(res.houseNumbers)
    }, "json")
};
BaseForm.prototype.setCities = function(list) {
    this.controls.city.html(this.cityTemplate({
        cities: list
    }))
};
BaseForm.prototype.showPostcode = function() {
    this.controls.postcode.parent().parent().show()
};
BaseForm.prototype.hidePostcode = function() {
    this.controls.postcode.parent().parent().hide()
};
BaseForm.prototype.showCities = function() {
    this.controls.city.parent().parent().show()
};
BaseForm.prototype.hideCities = function() {
    this.controls.city.parent().parent().hide()
};
BaseForm.prototype.setAddresses = function(list) {
    this.controls.address.html(this.addressTemplate({
        addresses: list
    }))
};
BaseForm.prototype.showAddresses = function() {
    this.controls.address.parent().parent().show()
};
BaseForm.prototype.hideAddresses = function() {
    this.controls.address.parent().parent().hide()
};
BaseForm.prototype.setStreets = function(list) {
    this.controls.street.html(this.streetTemplate({
        streets: list
    }))
};
BaseForm.prototype.showStreet = function() {
    if (this.controlsData.street.params.type === "select") this.controls.street.parent().parent().show();
    else if (this.controlsData.street.params.type === "input") this.controls.street.parent().show()
};
BaseForm.prototype.hideStreet = function() {
    if (this.controlsData.street.params.type === "select") this.controls.street.parent().parent().hide();
    else if (this.controlsData.street.params.type === "input") this.controls.street.parent().hide()
};
BaseForm.prototype.clearStreet = function() {
    this.controls.street.val("")
};
BaseForm.prototype.setHouseNumbers = function(list) {
    this.controls.houseNumber.html(this.houseNumberTemplate({
        range: list
    }))
};
BaseForm.prototype.showHouseNumbers = function() {
    if (this.controlsData.houseNumber.params.type === "select") this.controls.houseNumber.parent().parent().show();
    else if (this.controlsData.houseNumber.params.type === "input") this.controls.houseNumber.parent().show()
};
BaseForm.prototype.hideHouseNumber = function() {
    if (this.controlsData.houseNumber.params.type === "select") this.controls.houseNumber.parent().parent().hide();
    else if (this.controlsData.houseNumber.params.type === "input") this.controls.houseNumber.parent().hide()
};
BaseForm.prototype.showHouseNumbersAdditional = function() {
    this.controls.houseNumberAddition.parent().show()
};
BaseForm.prototype.hideHouseNumbersAdditional = function() {
    this.controls.houseNumberAddition.parent().hide()
};
BaseForm.prototype.getControlValue = function(control, defaultValue) {
    if (control === "birthDate") return this.getBirthDate();
    if (typeof defaultValue !== "undefined" && !this.isControlExist(control)) return defaultValue;
    var el = this.getControl(control),
        val;
    if (el.is("input") && $.inArray(el.prop("type"), ["text", "email", "password", "tel", "number", "hidden"]) !== -1 || el.is("select") || el.is("textarea")) val = $.trim(el.val());
    else if (el.is("input:radio")) el.each(function() {
        if ($(this).is(":checked")) val = $(this).attr("value")
    });
    else if (el.is("input:checkbox")) val = el.is(":checked") ? 1 : 0;
    else throw new Error("Can not get control value " + control);
    if (control === "phone") val = val.replace(/\s+/g, "");
    return val
};
BaseForm.prototype.beforeValidate = function(controlName) {
	
    this.validationInProgress = true
};
BaseForm.prototype.afterValidate = function(controlName, value, success, message) {
    var self = this;
	
    if (this.controlsData[controlName]) {
        this.controlsData[controlName].isValid = success;
        this.controlsData[controlName].value = value;
        if (message !== undefined) this.controlsData[controlName].message = message
    }
    this.validationInProgress = false;
    if (controlName === "birthDate")
        if (this.controlsData["birthDateDay"] && this.controlsData["birthDateDay"].value && this.controlsData["birthDateMonth"] && this.controlsData["birthDateMonth"].value &&
            this.controlsData["birthDateYear"] && this.controlsData["birthDateYear"].value) {
            this.controlsData["birthDateDay"].isValid = success;
            this.controlsData["birthDateMonth"].isValid = success;
            this.controlsData["birthDateYear"].isValid = success
        }
    if (controlName === "id_state")
        if (success)
            if (this.controls["city"]) {
                var cities = this.controlsData.city.params.list[value];
                this.controls.city.html(this.cityTemplate({
                    cities: cities
                }));
                this.controlsData["city"].isValid = false;
                this.controlsData["city"].value = null
            }
    if (controlName ===
        "city")
        if (success)
            if (this.controls["postcode"] && this.controlsData.postcode.params.list) {
                var postcodes = [];
                if (this.controlsData.postcode.params.list[value]) postcodes = this.controlsData.postcode.params.list[value];
                if (postcodes.length !== 1) {
                    this.controlsData["postcode"].isValid = false;
                    this.controlsData["postcode"].value = null
                } else {
                    this.controlsData["postcode"].isValid = true;
                    this.controlsData["postcode"].value = postcodes[0];
                    this.setValid("postcode")
                }
                this.controls.postcode.html(this.postcodeTemplate({
                    postcodes: postcodes
                }))
            }
    if (self.controlsData[controlName] &&
        self.controlsData[controlName].params && self.controlsData[controlName].params["set"]) _.each(self.controlsData[controlName].params["set"], function(toSetParams, toSet) {
        if (toSetParams.requires !== undefined)
            if (self.isFilled(toSetParams.requires) === false) return;
        if (self.controlsData[toSet].params.autocompleteListOnly) {
            self.setControlValue(toSet, "");
            self.resetValid(toSet)
        } else if (success && toSetParams.delay !== undefined) setTimeout(function() {
            self.autoSetControl(toSet, success)
        }, toSetParams.delay);
        else self.autoSetControl(toSet,
            success)
    });
    if (self.controlsData[controlName] && self.controlsData[controlName].params && self.controlsData[controlName].params["show"]) _.each(self.controlsData[controlName].params["show"], function(toShow) {
        if (toShow === "city" && self.controls["city"])
            if (success) self.showCities();
            else self.hideCities();
        if (toShow === "postcode" && self.controls["postcode"])
            if (success) self.showPostcode();
            else self.hidePostcode();
        if (toShow === "street" && self.controls["street"])
            if (success) self.showStreet();
            else self.hideStreet();
        if (toShow ===
            "houseNumber" && self.controls["houseNumber"])
            if (success) self.showHouseNumbers();
            else self.hideHouseNumber();
        if (toShow === "houseNumberAddition" && self.controls["houseNumberAddition"])
            if (success) self.showHouseNumbersAdditional();
            else self.hideHouseNumbersAdditional();
        if (toShow === "address" && self.controls["address"])
            if (success) self.showAddresses();
            else self.hideAddresses()
    });
    self.updatePageState()
	
	
};
BaseForm.prototype.autoSetControl = function(controlName, success) {
    var self = this;
    if (self.controls[controlName] !== undefined) {
        if (controlName === "city")
            if (success)
                if (self.controlsData.city.params.type === "select") self.getCitiesByPostcode(self.getPostCode(), function(list) {
                    if (list.length) {
                        self.setCities(list);
                        if (list.length === 1) {
                            self.setCity(list[0]);
                            self.validate("city")
                        }
                    } else self.setCities([])
                });
                else self.getCityByPostcode(self.getPostCode(), function(city) {
                    self.setCity(city)
                });
        else if (self.controlsData.city.params.type ===
            "select") {
            self.controlsData.city.isValid = false;
            self.setCities([]);
            self.resetValid("city")
        } else {
            self.controlsData.city.isValid = false;
            self.setCity(undefined);
            self.resetValid("city")
        }
        if (controlName === "street")
            if (success)
                if (self.controlsData.street.params.type === "select") self.getStreetsByPostcode(self.getPostCode(), function(list) {
                    self.setStreets(list)
                });
                else {
                    if (self.controlsData.street.params.type === "input") self.findStreets(self.locale, self.getPostCode(), self.getCity(), "", function(streets) {
                        if (streets.length) self.setStreet(streets[0]);
                        else {
                            self.setStreet("");
                            self.resetValid(controlName)
                        }
                    })
                } else {
            if (self.controlsData.street.params.type === "select") self.setStreets([]);
            else if (self.controlsData.street.params.type === "input") self.clearStreet();
            self.resetValid(controlName)
        }
        if (controlName === "houseNumber")
            if (success)
                if (self.controlsData.houseNumber.params.type === "select") {
                    var postcode = self.getPostCode();
                    var city = self.isControlExist("city") ? self.getCity() : undefined;
                    var street = self.isControlExist("street") ? self.getStreet() : undefined;
                    self.getHouseNumbers(postcode,
                        city, street,
                        function(list) {
                            self.setHouseNumbers(list)
                        })
                } else {
                    if (self.controlsData.houseNumber.params["type"] === "input");
                } else self.setHouseNumbers([]);
        if (controlName === "address")
            if (success)
                if (self.controlsData.address.params["type"] === "select") self.getAddressesByPostcode(self.getPostCode(), function(list) {
                    if (list.length) {
                        self.setAddresses(list);
                        if (list.length === 1) self.validate("address")
                    } else self.setAddresses([])
                });
                else {
                    if (self.controlsData.houseNumber.params["type"] === "input");
                } else {
            if (self.controlsData.address.params["type"] ===
                "select") self.setAddresses([]);
            else self.setAddresses(undefined);
            self.controlsData.address.isValid = false;
            self.resetValid("address")
        }
    }
};
BaseForm.prototype.updatePageState = function(controlName) {};
BaseForm.prototype.validate = function(controlName, params, successCallback) {
    var self = this;
    this.beforeValidate(controlName);
    var value = this.getControlValue(controlName);
    this.validator.check(value, controlName, function() {
        self.setValid(controlName);
        self.afterValidate(controlName, value, true);
        if (successCallback) successCallback()
    }, function(result) {
        var message = "";
        if (result.errors && result.errors[controlName]) message = result.errors[controlName];
        else if (result.message) message = result.message;
        if (params === undefined ||
            params && params.markAsInvalid !== false) self.setInvalid(controlName, message);
        self.afterValidate(controlName, value, false, message)
    })
};
BaseForm.prototype.getInvalidControls = function() {
    var self = this;
    var list = [];
    _.each(this.controlsData, function(data, key) {
        if (self.step === data.step)
            if (!data.isValid) list.push(key)
    });
    return list
};
BaseForm.prototype.showErrors = function() {
    var self = this;
    _.each(this.controlsData, function(data, key) {
        if (self.step === data.step)
            if (data.isValid) self.setValid(key);
            else self.setInvalid(key, data.message)
    })
};
BaseForm.prototype.showFirstError = function() {
    var self = this;
    var invalidControl = undefined;
    _.each(this.controlsData, function(data, key) {
        if (self.step === data.step)
            if (data.isValid) self.setValid(key);
            else {
                self.resetValid(key);
                if (invalidControl === undefined) {
                    self.setInvalid(key, data.message);
                    invalidControl = key;
                    var control = self.getControl(key);
                    self.scrollTop(control.offset().top - ($(window).height() - control.outerHeight() - 70) + "px")
                }
            }
    });
    if (this.stepHasCosponsors()) this.markCosponsorsInvalid();
    return invalidControl
};
BaseForm.prototype.showControlErrors = function(errors) {
    var self = this;
    _.each(errors, function(message, controlName) {
        if (typeof(self.controls[controlName] !== "undefined")) {
            self.setInvalid(controlName, message);
            self.afterValidate(controlName, self.getControlValue(controlName), false, message)
        }
    })
};
BaseForm.prototype.next = function(successCallback, failedCallback, invalidCallback) {
    var self = this;
    var timerId = setTimeout(function tick() {
        if (self.validationInProgress) timerId = setTimeout(tick, 100);
        else {
            if (self.nextInProgress === true) return false;
            if (self.getInvalidControls().length > 0) {
                self.showFirstError();
                invalidCallback()
            } else {
                self.beforeLeadUpdate();
                if (self.step === 1) self.createLead(self.getValues(), function() {
                    self.afterLeadUpdate(self.step);
                    successCallback()
                }, function(response) {
                    self.nextSuccess(response)
                }, function(res) {
                    if (res.errors)
                        for (fieldName in res.errors) {
                            var message = res.errors[fieldName];
                            self.afterValidate(fieldName, self.getControlValue(fieldName), false, message);
                            self.setInvalid(fieldName, message)
                        }
                    failedCallback()
                });
                else self.updateLead(self.getValues(), function() {
                        self.afterLeadUpdate(self.step)
                    }, function(response) {
                        if (response && response.fbTracks !== undefined) self.fbTracks = response.fbTracks;
                        self.nextSuccess(response);
                        successCallback()
                    },
                    function(res) {
                        if (res.errors.length)
                            for (fieldName in res.errors) {
                                var message = res.errors[fieldName];
                                self.afterValidate(fieldName, self.getControlValue(fieldName), false, message);
                                self.setInvalid(fieldName, message)
                            }
                        failedCallback()
                    })
            }
        }
    }, 100)
};
BaseForm.prototype.nextSuccess = function(response) {
	
    var self = this;
    this.scrollTop(0);
    $("#input" + self.step).hide();
    if (self.stepsCount !== self.step) {
        self.step++;
        $("#input" + self.step).show();
        $("#input" + self.step).removeClass("hidden");
        self.resetValidAll();
        if (self.isStepHasInputs() === false) self.nextSuccess(response)
    } else this.finishedCallback(response)
};
BaseForm.prototype.hideCoregContainers = function() {
    for (var step in this.cosponsorsStepTypes) $(".coreg-container-" + step).hide()
};
BaseForm.prototype.getCurrentCosponsorStepType = function() {
    var result = null;
    for (var step in this.cosponsorsStepTypes)
        if (this.step === parseInt(step)) {
            result = this.cosponsorsStepTypes[step];
            if (result === null) result = "default";
            break
        }
    return result
};
BaseForm.prototype.getCosponsorCurrentsCoregContainer = function() {
    var result = null;
    if (this.stepHasCosponsors()) result = $(".coreg-container-" + this.step);
    return result
};
BaseForm.prototype.atLeastOneCheckboxCosponsorValid = function() {
    var result = false;
    if (this.stepHasCosponsors()) {
        var container = this.getCosponsorCurrentsCoregContainer();
        $.each($(".cosponsor-checkbox input", container), function() {
            if ($(this).prop("checked")) result = true
        })
    }
    return result
};
BaseForm.prototype.areCosponsorsValid = function() {
    var result = true;
    if (this.stepHasCosponsors()) {
        var container = this.getCosponsorCurrentsCoregContainer();
        $.each($(".cosponsor-checkbox input", container), function() {
            if (!$(this).prop("checked")) result = false
        });
        $.each($("select.coreg-sponsor-dd", container), function() {
            if (!$(this).val()) result = false
        })
    }
    return result
};
BaseForm.prototype.listHasCampaignsForType = function(list, type) {
    var hasCampaigns = false;
    for (var key in list) {
        if (type === "select")
            if (list[key].layout === "DropDown" || list[key].layout === "DropDown") hasCampaigns = true;
        if (type === "checkbox")
            if (list[key].layout === "Checkbox") hasCampaigns = true
    }
    if (type === "default") hasCampaigns = true;
    return hasCampaigns
};
BaseForm.prototype.markCosponsorsInvalid = function() {
    var container = this.getCosponsorCurrentsCoregContainer();
    $.each($(".cosponsor-checkbox input", container), function() {
        if (!$(this).prop("checked")) $(this).addClass("invalid")
    });
    $.each($("select.coreg-sponsor-dd", container), function() {
        if (!$(this).val()) $(this).addClass("invalid")
    })
};
BaseForm.prototype.stepHasCosponsors = function() {
    return this.getCurrentCosponsorStepType() !== null
};
BaseForm.prototype.isStepHasInputs = function() {
    for (var i in this.controlsData)
        if (this.controlsData[i].step === this.step) return true;
    return false
};
BaseForm.prototype.beforeLeadUpdate = function() {
    this.nextInProgress = true
};
BaseForm.prototype.afterLeadUpdate = function() {
    this.nextInProgress = false
};
BaseForm.prototype.getValues = function() {
    var self = this;
    var values = {};
    _.each(this.controlsData, function(data, key) {
        if (self.step >= data.step) {
            var value = data.value;
            if (value === undefined && data.params.defaultValue !== undefined) value = data.params.defaultValue;
            values[key] = value
        }
    });
    values["url"] = window.location.protocol + "//" + window.location.host + window.location.pathname + "?go";
    values["declinedOptIn"] = this.declinedOptIn ? 1 : 0;
    if (typeof pmGlobal !== "undefined") values["fraudStatus"] = pmGlobal.status;
    else values["fraudStatus"] =
        "unknown";
    if (this.controlsData.address && this.controlsData.address.params.type === "select" && this.controls.address.val()) {
        var data = this.controls.address.find(":selected").data();
        if (data.houseNumber) values.houseNumber = data.houseNumber;
        if (data.street) values.street = data.street
    }
    if (self.sponsorsTracking.canTrack) values["sponsorsPopupTracking"] = this.getPopupTracking();
    if (this.controls["talon"]) values["talon"] = this.getControlValue("talon");
    var beforeSendValueEvent = $.Event(this.events.EVENT_BEFORE_SEND_VALUES);
    beforeSendValueEvent.eventData = {
        values: values
    };
    $(self).trigger(beforeSendValueEvent);
    return beforeSendValueEvent.eventData.values
};
BaseForm.prototype.createLead = function(values, callback, successCallback, failCallback) {
	console.log(values)
	//console.log(successCallback);
    var self = this;
	
	$.post("../scripts/createLead.php",{values:values});
	
	/* bypass primo step lead
    $.post("lead/create", {
        externalId: self.externalId,
        values: values
    }, function(res) {
        if (res.redirect) window.location.replace(res.redirect);
        else {
            if (callback) callback(res);
            if (res.success) {
                $(window).trigger("onLeadCreated", values);
                if (successCallback) successCallback(res)
            } else {
                if (typeof res.errors !== "undefined") self.showControlErrors(res.errors);
                if (failCallback) failCallback(res)
            }
        }
    }, "json")
	
	*/
	
	
	$(window).trigger("onLeadCreated", values);
	callback('{"success":true,"redirect":false}');
	successCallback('{"success":true,"redirect":false}');
};
BaseForm.prototype.updateLead = function(values, callback, successCallback, failCallback) {
    var self = this;
	
	$.post("../scripts/updateLead.php",{values:values});
	
	/* bypass update lead
    $.post("/lead/update", {
        externalId: self.externalId,
        values: values
    }, function(res) {
        if (res.redirect) window.location.replace(res.redirect);
        else {
            if (callback) callback(res);
            if (res.success && successCallback) successCallback(res);
            else {
                if (typeof res.errors !== "undefined") self.showControlErrors(res.errors);
                if (failCallback) failCallback(res)
            }
        }
    }, "json")
	*/
	
	callback('{"success":true,"redirect":false,"fbTracks":[],"leadEmailDomain":"gmail.com"}');
	successCallback('{"success":true,"redirect":false,"fbTracks":[],"leadEmailDomain":"gmail.com"}');
	
	console.log("----")
	console.log(callback);
	console.log(successCallback);
	
};
BaseForm.prototype.getPage = function() {
    return $("#input" + this.step)
};
BaseForm.prototype.getNextPage = function() {
    var nextStep = this.step + 1;
    if (this.stepsCount >= nextStep) return $("#input" + nextStep)
};
BaseForm.prototype.renderCoSponsors = function(items, type) {
    if (items.length && this.getCosponsorCurrentsCoregContainer() !== null) this.getCosponsorCurrentsCoregContainer().html(this.coregTemplate({
        items: items,
        type: type
    })).show()
};

function Question(locale, externalId, container, completeCallback) {
    var self = this;
    this.locale = locale;
    this.externalId = externalId;
    this.template = undefined;
    this.container = {
        progress: container.find(".questions-progress"),
        body: container.find(".questions-in")
    };
    this.questions = [];
    this.followUps = [];
    this.endUrl = "";
    this.popOut = {};
    this.currentQuestionNum = 0;
    this.questionNum = 0;
    this.setEndUrl = function(url) {
        this.endUrl = url
    };
    this.getEndUrl = function() {
        return this.endUrl
    };
    this.blockQuestion = function() {
        self.container.body.addClass("waiting")
    };
    this.unblockQuestion = function() {
        self.container.body.removeClass("waiting")
    };
    this.getAnswer = function(el) {
        var block = el.closest(".question-block");
        var data = {
            questionId: block.data("id"),
            layout: block.data("layout")
        };
        if (data.layout === "YesNo") data.answerId = el.data("id");
        else if (data.layout === "DropDown" || data.layout === "SearchDropDown") data.answerId = block.find(".answer-dropdown").val();
        else if (data.layout === "MultipleSearchDropDown") data.answerIds = block.find(".answer-multi-dropdown").val();
        else if (data.layout ===
            "RadioButtons") data.answerId = block.find(".answer-radio:checked").val();
        else if (data.layout === "Popup") data.answerId = el.data("id");
        else if (data.layout === "Checkboxes") {
            data.answerIds = [];
            block.find(".answer-checkbox").each(function() {
                if ($(this).prop("checked")) data.answerIds.push($(this).val())
            })
        } else if (data.layout === "TextArea" || data.layout === "TextInput") data.answer = block.find(".answer-text").val();
        else if (data.layout === "Signature" && window.signature) data.answer = window.signature.getEncodedSvg();
        else if (data.layout ===
            "DateSelect") {
            var dtd = block.find(".answer-ds-day").val() || (new Date).getDate(),
                dtm = block.find(".answer-ds-month").val() || (new Date).getMonth() + 1,
                dty = block.find(".answer-ds-year").val() || (new Date).getFullYear();
            if (dtm < 10) dtm = "0" + dtm;
            if (dtd < 10) dtd = "0" + dtd;
            data.answer = [dtd, dtm, dty].join("/")
        }
        return data
    };
    this.sendAnswer = function(answer, successCallback, failCallback) {
        answer.externalId = self.externalId;
        $.post("../services/answer.php", answer, function(res) {
            if (res && res.success) {
                if (res.followUps && res.followUps.length) _.each(res.followUps,
                    function(fu) {
                        self.questions.unshift(fu)
                    });
                if (successCallback) successCallback(res)
            } else if (failCallback) failCallback(res)
        }, "json")
    };
    this.getList = function(successCallback, failCallback) {
		
		/* bypass lista domande */
        
        $.post("../services/list.php", {
            locale: self.locale,
            externalId: self.externalId
        }, function(res) {
            if (res.success && res.questions) {
                self.questions = res.questions;
                self.questionNum = self.questions.length;
                if (successCallback) successCallback()
            } else if (failCallback) failCallback()
        }, "json").fail(function() {
            if (failCallback) failCallback()
        })
		
		
		//successCallback();
		
    };
    this.getProgressStatus =
        function() {
            return {
                currentQuestionNum: self.currentQuestionNum,
                questionNum: self.questionNum,
                progress: Math.round(self.currentQuestionNum / self.questionNum * 100)
            }
        };
    this.isLastQuestion = function() {
        return self.currentQuestionNum === self.questionNum
    };
    this.getQuestion = function(id, successCallback, failCallback) {
        $.post("../services/view.php", {
            externalId: self.externalId,
            id: id
        }, function(res) {
            if (res.success) successCallback(res.question);
            else if (failCallback) failCallback(res)
        }, "json").fail(function() {
            if (failCallback) failCallback()
        })
    };
    this.getNext = function(successCallback, failCallback, notExistsCallback) {
        var q = self.questions.shift();
        if (!q) notExistsCallback();
        else self.getQuestion(q, function(question) {
            if (!question.isFollowUp) self.currentQuestionNum++;
            successCallback(question)
        }, function(question) {
            self.currentQuestionNum++;
            failCallback(question)
        })
    };
    this.finish = function() {
		
        $.post("../services/finish.php", {
            externalId: self.externalId
        }, function(res) {
            window.location.href = self.getEndUrl()
        })
		
    }
}

function SignatureInput($signature, onChange) {
    this.$signature = $signature;
    var self = this;
    this.init = function() {
        var width = 300;
        var height = 370;
        $(document).ready(function() {
            if (self.$signature.data("width")) width = self.$signature.data("width");
            if (self.$signature.data("height")) height = self.$signature.data("height");
            self.$signature.jSignature({
                width: width,
                height: height
            });
            $(".jSignature", self.$signature).css({
                "opacity": 0
            });
            self.$signature.bind("mousedown", function() {
                $(".jSignature", self.$signature).css({
                    "opacity": 1
                })
            });
            if (onChange) self.$signature.bind("change", onChange)
        })
    };
    this.isModified = function() {
        return self.$signature.jSignature("isModified")
    };
    this.reset = function() {
        self.$signature.jSignature("reset");
        $(".jSignature", self.$signature).css({
            "opacity": 0
        })
    };
    this.getEncodedSvg = function() {
        return self.$signature.jSignature("getData", "svgbase64")[1]
    }
}
(function() {
    function q(a) {
        var b = a.css("color"),
            c;
        a = a[0];
        for (var g = !1; a && !c && !g;) {
            try {
                var d = $(a).css("background-color")
            } catch (l) {
                d = "transparent"
            }
            "transparent" !== d && "rgba(0, 0, 0, 0)" !== d && (c = d);
            g = a.body;
            a = a.parentNode
        }
        a = /rgb[a]*\((\d+),\s*(\d+),\s*(\d+)/;
        g = /#([AaBbCcDdEeFf\d]{2})([AaBbCcDdEeFf\d]{2})([AaBbCcDdEeFf\d]{2})/;
        d = void 0;
        if (d = b.match(a)) var m = {
            r: parseInt(d[1], 10),
            g: parseInt(d[2], 10),
            b: parseInt(d[3], 10)
        };
        else(d = b.match(g)) && (m = {
            r: parseInt(d[1], 16),
            g: parseInt(d[2], 16),
            b: parseInt(d[3], 16)
        });
        if (c)
            if (d = void 0, d = c.match(a)) var e = {
                r: parseInt(d[1], 10),
                g: parseInt(d[2], 10),
                b: parseInt(d[3], 10)
            };
            else(d = c.match(g)) && (e = {
                r: parseInt(d[1], 16),
                g: parseInt(d[2], 16),
                b: parseInt(d[3], 16)
            });
        else e = m ? 127 < Math.max.apply(null, [m.r, m.g, m.b]) ? {
            r: 0,
            g: 0,
            b: 0
        } : {
            r: 255,
            g: 255,
            b: 255
        } : {
            r: 255,
            g: 255,
            b: 255
        };
        d = function(a) {
            return "rgb(" + [a.r, a.g, a.b].join(", ") + ")"
        };
        m && e ? (a = Math.max.apply(null, [m.r, m.g, m.b]), m = Math.max.apply(null, [e.r, e.g, e.b]), m = Math.round(m + -.75 * (m - a)), m = {
            r: m,
            g: m,
            b: m
        }) : m ? (m = Math.max.apply(null, [m.r, m.g,
            m.b
        ]), a = 1, 127 < m && (a = -1), m = Math.round(m + 96 * a), m = {
            r: m,
            g: m,
            b: m
        }) : m = {
            r: 191,
            g: 191,
            b: 191
        };
        return {
            color: b,
            "background-color": e ? d(e) : c,
            "decor-color": d(m)
        }
    }

    function k(a, b) {
        this.x = a;
        this.y = b;
        this.reverse = function() {
            return new this.constructor(-1 * this.x, -1 * this.y)
        };
        this._length = null;
        this.getLength = function() {
            this._length || (this._length = Math.sqrt(Math.pow(this.x, 2) + Math.pow(this.y, 2)));
            return this._length
        };
        var c = function(a) {
            return Math.round(a / Math.abs(a))
        };
        this.resizeTo = function(a) {
            if (0 === this.x && 0 === this.y) this._length =
                0;
            else if (0 === this.x) this._length = a, this.y = a * c(this.y);
            else if (0 === this.y) this._length = a, this.x = a * c(this.x);
            else {
                var b = Math.abs(this.y / this.x),
                    g = Math.sqrt(Math.pow(a, 2) / (1 + Math.pow(b, 2)));
                b *= g;
                this._length = a;
                this.x = g * c(this.x);
                this.y = b * c(this.y)
            }
            return this
        };
        this.angleTo = function(a) {
            var b = this.getLength() * a.getLength();
            return 0 === b ? 0 : Math.acos(Math.min(Math.max((this.x * a.x + this.y * a.y) / b, -1), 1)) / Math.PI
        }
    }

    function h(a, b) {
        this.x = a;
        this.y = b;
        this.getVectorToCoordinates = function(a, b) {
            return new k(a - this.x,
                b - this.y)
        };
        this.getVectorFromCoordinates = function(a, b) {
            return this.getVectorToCoordinates(a, b).reverse()
        };
        this.getVectorToPoint = function(a) {
            return new k(a.x - this.x, a.y - this.y)
        };
        this.getVectorFromPoint = function(a) {
            return this.getVectorToPoint(a).reverse()
        }
    }

    function p(a, b, c, g, d) {
        this.data = a;
        this.context = b;
        if (a.length)
            for (var m = a.length, e, l, f = 0; f < m; f++) {
                e = a[f];
                l = e.x.length;
                c.call(b, e);
                for (var t = 1; t < l; t++) g.call(b, e, t);
                d.call(b, e)
            }
        this.changed = function() {};
        this.startStrokeFn = c;
        this.addToStrokeFn = g;
        this.endStrokeFn =
            d;
        this.inStroke = !1;
        this._stroke = this._lastPoint = null;
        this.startStroke = function(a) {
            if (a && "number" == typeof a.x && "number" == typeof a.y) {
                this._stroke = {
                    x: [a.x],
                    y: [a.y]
                };
                this.data.push(this._stroke);
                this._lastPoint = a;
                this.inStroke = !0;
                var b = this._stroke,
                    c = this.startStrokeFn,
                    d = this.context;
                setTimeout(function() {
                    c.call(d, b)
                }, 3);
                return a
            }
            return null
        };
        this.addToStroke = function(a) {
            if (this.inStroke && "number" === typeof a.x && "number" === typeof a.y && 4 < Math.abs(a.x - this._lastPoint.x) + Math.abs(a.y - this._lastPoint.y)) {
                var b =
                    this._stroke.x.length;
                this._stroke.x.push(a.x);
                this._stroke.y.push(a.y);
                this._lastPoint = a;
                var c = this._stroke,
                    d = this.addToStrokeFn,
                    g = this.context;
                setTimeout(function() {
                    d.call(g, c, b)
                }, 3);
                return a
            }
            return null
        };
        this.endStroke = function() {
            var a = this.inStroke;
            this.inStroke = !1;
            this._lastPoint = null;
            if (a) {
                var b = this._stroke,
                    c = this.endStrokeFn,
                    d = this.context,
                    g = this.changed;
                setTimeout(function() {
                    c.call(d, b);
                    g.call(d)
                }, 3);
                return !0
            }
            return null
        }
    }

    function n(a, b, c, g) {
        if ("ratio" === b || "%" === b.split("")[b.length - 1]) this.eventTokens[c +
            ".parentresized"] = g.subscribe(c + ".parentresized", function(b, m, e, l) {
            return function() {
                var d = m.width();
                if (d !== e) {
                    for (var l in b) b.hasOwnProperty(l) && (g.unsubscribe(b[l]), delete b[l]);
                    var f = a.settings;
                    a.$parent.children().remove();
                    for (l in a) a.hasOwnProperty(l) && delete a[l];
                    l = f.data;
                    d = 1 * d / e;
                    var r = [],
                        D, E;
                    var h = 0;
                    for (D = l.length; h < D; h++) {
                        var k = l[h];
                        var n = {
                            x: [],
                            y: []
                        };
                        var p = 0;
                        for (E = k.x.length; p < E; p++) n.x.push(k.x[p] * d), n.y.push(k.y[p] * d);
                        r.push(n)
                    }
                    f.data = r;
                    m[c](f)
                }
            }
        }(this.eventTokens, this.$parent, this.$parent.width(),
            1 * this.canvas.width / this.canvas.height))
    }

    function w(a, b, c) {
        var g = this.$parent = $(a);
        a = this.eventTokens = {};
        this.events = new u(this);
        var d = $.fn.jSignature("globalEvents"),
            e = {
                width: "ratio",
                height: "ratio",
                sizeRatio: 4,
                color: "#000",
                "background-color": "#fff",
                "decor-color": "#eee",
                lineWidth: 0,
                minFatFingerCompensation: -10,
                showUndoButton: !1,
                readOnly: !1,
                data: [],
                signatureLine: !1
            };
        $.extend(e, q(g));
        b && $.extend(e, b);
        this.settings = e;
        for (var f in c) c.hasOwnProperty(f) && c[f].call(this, f);
        this.events.publish("jSignature.initializing");
        this.$controlbarUpper = $('<div style="padding:0 !important; margin:0 !important;width: 100% !important; height: 0 !important; -ms-touch-action: none; touch-action: none;margin-top:-1em !important; margin-bottom:1em !important;"></div>').appendTo(g);
        this.isCanvasEmulator = !1;
        b = this.canvas = this.initializeCanvas(e);
        c = $(b);
        this.$controlbarLower = $('<div style="padding:0 !important; margin:0 !important;width: 100% !important; height: 0 !important; -ms-touch-action: none; touch-action: none;margin-top:-1.5em !important; margin-bottom:1.5em !important; position: relative;"></div>').appendTo(g);
        this.canvasContext = b.getContext("2d");
        c.data("jSignature.this", this);
        e.lineWidth = function(a, b) {
            return a ? a : Math.max(Math.round(b / 400), 2)
        }(e.lineWidth, b.width);
        this.lineCurveThreshold = 3 * e.lineWidth;
        e.cssclass && "" != $.trim(e.cssclass) && c.addClass(e.cssclass);
        this.fatFingerCompensation = 0;
        g = function(a) {
            var b, c, d = function(d) {
                    d = d.changedTouches && 0 < d.changedTouches.length ? d.changedTouches[0] : d;
                    return new h(Math.round(d.pageX + b), Math.round(d.pageY + c) + a.fatFingerCompensation)
                },
                g = new v(750, function() {
                    a.dataEngine.endStroke()
                });
            this.drawEndHandler = function(b) {
                if (!a.settings.readOnly) {
                    try {
                        b.preventDefault()
                    } catch (A) {}
                    g.clear();
                    a.dataEngine.endStroke()
                }
            };
            this.drawStartHandler = function(e) {
                if (!a.settings.readOnly) {
                    e.preventDefault();
                    var m = $(a.canvas).offset();
                    b = -1 * m.left;
                    c = -1 * m.top;
                    a.dataEngine.startStroke(d(e));
                    g.kick()
                }
            };
            this.drawMoveHandler = function(b) {
                a.settings.readOnly || (b.preventDefault(), a.dataEngine.inStroke && (a.dataEngine.addToStroke(d(b)), g.kick()))
            };
            return this
        }.call({}, this);
        (function(a, b, c) {
            var d = this.canvas,
                g =
                $(d);
            if (this.isCanvasEmulator) g.bind("mousemove.jSignature", c), g.bind("mouseup.jSignature", a), g.bind("mousedown.jSignature", b);
            else {
                var m = "function" === typeof d.addEventListener;
                this.ontouchstart = function(g) {
                    d.onmousedown = d.onmouseup = d.onmousemove = void 0;
                    this.fatFingerCompensation = e.minFatFingerCompensation && -3 * e.lineWidth > e.minFatFingerCompensation ? -3 * e.lineWidth : e.minFatFingerCompensation;
                    b(g);
                    m ? (d.addEventListener("touchend", a), d.addEventListener("touchstart", b), d.addEventListener("touchmove", c)) :
                        (d.ontouchend = a, d.ontouchstart = b, d.ontouchmove = c)
                };
                m ? d.addEventListener("touchstart", this.ontouchstart) : d.ontouchstart = ontouchstart;
                d.onmousedown = function(g) {
                    m ? d.removeEventListener("touchstart", this.ontouchstart) : d.ontouchstart = d.ontouchend = d.ontouchmove = void 0;
                    b(g);
                    d.onmousedown = b;
                    d.onmouseup = a;
                    d.onmousemove = c
                };
                window.navigator.msPointerEnabled && (d.onmspointerdown = b, d.onmspointerup = a, d.onmspointermove = c)
            }
        }).call(this, g.drawEndHandler, g.drawStartHandler, g.drawMoveHandler);
        a["jSignature.windowmouseup"] =
            d.subscribe("jSignature.windowmouseup", g.drawEndHandler);
        this.events.publish("jSignature.attachingEventHandlers");
        n.call(this, this, e.width.toString(10), "jSignature", d);
        this.resetCanvas(e.data);
        this.events.publish("jSignature.initialized");
        return this
    }

    function x(a) {
        if (a.getContext) return !1;
        var b = a.ownerDocument.parentWindow,
            c = b.FlashCanvas ? a.ownerDocument.parentWindow.FlashCanvas : "undefined" === typeof FlashCanvas ? void 0 : FlashCanvas;
        if (c) {
            a = c.initElement(a);
            c = 1;
            b && b.screen && b.screen.deviceXDPI && b.screen.logicalXDPI &&
                (c = 1 * b.screen.deviceXDPI / b.screen.logicalXDPI);
            if (1 !== c) try {
                $(a).children("object").get(0).resize(Math.ceil(a.width * c), Math.ceil(a.height * c)), a.getContext("2d").scale(c, c)
            } catch (g) {}
            return !0
        }
        throw Error("Canvas element does not support 2d context. jSignature cannot proceed.");
    }
    var v = function(a, b) {
            var c;
            this.kick = function() {
                clearTimeout(c);
                c = setTimeout(b, a)
            };
            this.clear = function() {
                clearTimeout(c)
            };
            return this
        },
        u = function(a) {
            this.topics = {};
            this.context = a ? a : this;
            this.publish = function(a, c, g, d) {
                if (this.topics[a]) {
                    var b =
                        this.topics[a],
                        e = Array.prototype.slice.call(arguments, 1),
                        f = [],
                        h = [],
                        t;
                    var k = 0;
                    for (t = b.length; k < t; k++) {
                        var r = b[k];
                        var D = r[0];
                        r[1] && (r[0] = function() {}, f.push(k));
                        h.push(D)
                    }
                    k = 0;
                    for (t = f.length; k < t; k++) b.splice(f[k], 1);
                    k = 0;
                    for (t = h.length; k < t; k++) h[k].apply(this.context, e)
                }
            };
            this.subscribe = function(a, c, g) {
                this.topics[a] ? this.topics[a].push([c, g]) : this.topics[a] = [
                    [c, g]
                ];
                return {
                    topic: a,
                    callback: c
                }
            };
            this.unsubscribe = function(a) {
                if (this.topics[a.topic])
                    for (var b = this.topics[a.topic], g = 0, d = b.length; g < d; g++) b[g] &&
                        b[g][0] === a.callback && b.splice(g, 1)
            }
        },
        y = function(a, b, c, g, d) {
            a.beginPath();
            a.moveTo(b, c);
            a.lineTo(g, d);
            a.closePath();
            a.stroke()
        },
        C = function(a) {
            var b = this.canvasContext,
                c = a.x[0];
            a = a.y[0];
            var g = this.settings.lineWidth,
                d = b.fillStyle;
            b.fillStyle = b.strokeStyle;
            b.fillRect(c + g / -2, a + g / -2, g, g);
            b.fillStyle = d
        },
        f = function(a, b) {
            var c = new h(a.x[b - 1], a.y[b - 1]),
                g = new h(a.x[b], a.y[b]),
                d = c.getVectorToPoint(g);
            if (1 < b) {
                var e = new h(a.x[b - 2], a.y[b - 2]),
                    f = e.getVectorToPoint(c);
                if (f.getLength() > this.lineCurveThreshold) {
                    var l =
                        2 < b ? (new h(a.x[b - 3], a.y[b - 3])).getVectorToPoint(e) : new k(0, 0);
                    var n = .35 * f.getLength(),
                        t = f.angleTo(l.reverse()),
                        p = d.angleTo(f.reverse());
                    l = (new k(l.x + f.x, l.y + f.y)).resizeTo(Math.max(.05, t) * n);
                    var r = (new k(f.x + d.x, f.y + d.y)).reverse().resizeTo(Math.max(.05, p) * n);
                    f = this.canvasContext;
                    n = e.x;
                    p = e.y;
                    t = c.x;
                    var D = c.y,
                        A = e.x + l.x;
                    e = e.y + l.y;
                    l = c.x + r.x;
                    r = c.y + r.y;
                    f.beginPath();
                    f.moveTo(n, p);
                    f.bezierCurveTo(A, e, l, r, t, D);
                    f.closePath();
                    f.stroke()
                }
            }
            d.getLength() <= this.lineCurveThreshold && y(this.canvasContext, c.x, c.y,
                g.x, g.y)
        },
        e = function(a) {
            var b = a.x.length - 1;
            if (0 < b) {
                var c = new h(a.x[b], a.y[b]),
                    e = new h(a.x[b - 1], a.y[b - 1]),
                    d = e.getVectorToPoint(c);
                if (d.getLength() > this.lineCurveThreshold)
                    if (1 < b) {
                        a = (new h(a.x[b - 2], a.y[b - 2])).getVectorToPoint(e);
                        var f = (new k(a.x + d.x, a.y + d.y)).resizeTo(d.getLength() / 2);
                        d = this.canvasContext;
                        a = e.x;
                        b = e.y;
                        var E = c.x,
                            l = c.y,
                            n = e.x + f.x;
                        e = e.y + f.y;
                        f = c.x;
                        c = c.y;
                        d.beginPath();
                        d.moveTo(a, b);
                        d.bezierCurveTo(n, e, f, c, E, l);
                        d.closePath();
                        d.stroke()
                    } else y(this.canvasContext, e.x, e.y, c.x, c.y)
            }
        };
    w.prototype.resetCanvas =
        function(a, b) {
            var c = this.canvas,
                g = this.settings,
                d = this.canvasContext,
                m = this.isCanvasEmulator,
                h = c.width,
                l = c.height;
            b || d.clearRect(0, 0, h + 30, l + 30);
            d.shadowColor = d.fillStyle = g["background-color"];
            m && d.fillRect(0, 0, h + 30, l + 30);
            d.lineWidth = Math.ceil(parseInt(g.lineWidth, 10));
            d.lineCap = d.lineJoin = "round";
            if (g.signatureLine) {
                if (null != g["decor-color"]) {
                    d.strokeStyle = g["decor-color"];
                    d.shadowOffsetX = 0;
                    d.shadowOffsetY = 0;
                    var k = Math.round(l / 5);
                    y(d, 1.5 * k, l - k, h - 1.5 * k, l - k)
                }
                m || (d.shadowColor = d.strokeStyle, d.shadowOffsetX =
                    .5 * d.lineWidth, d.shadowOffsetY = -.6 * d.lineWidth, d.shadowBlur = 0)
            }
            d.strokeStyle = g.color;
            a || (a = []);
            d = this.dataEngine = new p(a, this, C, f, e);
            g.data = a;
            $(c).data("jSignature.data", a).data("jSignature.settings", g);
            d.changed = function(a, b, d) {
                return function() {
                    b.publish(d + ".change");
                    a.trigger("change")
                }
            }(this.$parent, this.events, "jSignature");
            d.changed();
            return !0
        };
    w.prototype.initializeCanvas = function(a) {
        var b = document.createElement("canvas"),
            c = $(b);
        a.width === a.height && "ratio" === a.height && (a.width = "100%");
        c.css({
            margin: 0,
            padding: 0,
            border: "none",
            height: "ratio" !== a.height && a.height ? a.height.toString(10) : 1,
            width: "ratio" !== a.width && a.width ? a.width.toString(10) : 1,
            "-ms-touch-action": "none",
            "touch-action": "none",
            "background-color": a["background-color"]
        });
        c.appendTo(this.$parent);
        "ratio" === a.height ? c.css("height", Math.round(c.width() / a.sizeRatio)) : "ratio" === a.width && c.css("width", Math.round(c.height() * a.sizeRatio));
        c.addClass("jSignature");
        b.width = c.width();
        b.height = c.height();
        this.isCanvasEmulator = x(b);
        b.onselectstart = function(a) {
            a &&
                a.preventDefault && a.preventDefault();
            a && a.stopPropagation && a.stopPropagation();
            return !1
        };
        return b
    };
    (function(a) {
        function b(a, b, d) {
            var c = new Image,
                e = this;
            c.onload = function() {
                var a = e.getContext("2d"),
                    b = a.shadowColor;
                a.shadowColor = "transparent";
                a.drawImage(c, 0, 0, c.width < e.width ? c.width : e.width, c.height < e.height ? c.height : e.height);
                a.shadowColor = b
            };
            c.src = "data:" + b + "," + a
        }

        function c(a, b) {
            this.find("canvas.jSignature").add(this.filter("canvas.jSignature")).data("jSignature.this").resetCanvas(a, b);
            return this
        }

        function e(a, b) {
            if (void 0 === b && "string" === typeof a && "data:" === a.substr(0, 5) && (b = a.slice(5).split(",")[0], a = a.slice(6 + b.length), b === a)) return;
            var c = this.find("canvas.jSignature").add(this.filter("canvas.jSignature"));
            if (l.hasOwnProperty(b)) 0 !== c.length && l[b].call(c[0], a, b, function(a) {
                return function() {
                    return a.resetCanvas.apply(a, arguments)
                }
            }(c.data("jSignature.this")));
            else throw Error("jSignature is unable to find import plugin with for format '" + String(b) + "'");
            return this
        }
        var d = new u;
        (function(a,
            b, c, d) {
            var e, g = function() {
                a.publish(b + ".parentresized")
            };
            c(d).bind("resize." + b, function() {
                e && clearTimeout(e);
                e = setTimeout(g, 500)
            }).bind("mouseup." + b, function(c) {
                a.publish(b + ".windowmouseup")
            })
        })(d, "jSignature", $, a);
        var f = {},
            h = {
                "default": function(a) {
                    return this.toDataURL()
                },
                "native": function(a) {
                    return a
                },
                image: function(a) {
                    a = this.toDataURL();
                    if ("string" === typeof a && 4 < a.length && "data:" === a.slice(0, 5) && -1 !== a.indexOf(",")) {
                        var b = a.indexOf(",");
                        return [a.slice(5, b), a.substr(b + 1)]
                    }
                    return []
                }
            },
            l = {
                "native": function(a,
                    b, c) {
                    c(a)
                },
                image: b,
                "image/png;base64": b,
                "image/jpeg;base64": b,
                "image/jpg;base64": b
            },
            k = function(a) {
                var b = !1;
                for (a = a.parentNode; a && !b;) b = a.body, a = a.parentNode;
                return !b
            },
            n = {
                "export": h,
                "import": l,
                instance: f
            },
            p = {
                init: function(a) {
                    return this.each(function() {
                        k(this) || new w(this, a, f)
                    })
                },
                destroy: function() {
                    return this.each(function() {
                        if (!k(this)) {
                            var a = $(this).find("canvas").data("jSignature.this");
                            if (a) {
                                a.$controlbarLower.remove();
                                a.$controlbarUpper.remove();
                                $(a.canvas).remove();
                                for (var b in a.eventTokens) a.eventTokens.hasOwnProperty(b) &&
                                    d.unsubscribe(a.eventTokens[b])
                            }
                        }
                    })
                },
                getSettings: function() {
                    return this.find("canvas.jSignature").add(this.filter("canvas.jSignature")).data("jSignature.this").settings
                },
                isModified: function() {
                    return null !== this.find("canvas.jSignature").add(this.filter("canvas.jSignature")).data("jSignature.this").dataEngine._stroke
                },
                updateSetting: function(a, b, c) {
                    var d = this.find("canvas.jSignature").add(this.filter("canvas.jSignature")).data("jSignature.this");
                    d.settings[a] = b;
                    d.resetCanvas(c ? null : d.settings.data, !0);
                    return d.settings[a]
                },
                clear: c,
                reset: c,
                addPlugin: function(a, b, c) {
                    n.hasOwnProperty(a) && (n[a][b] = c);
                    return this
                },
                listPlugins: function(a) {
                    var b = [];
                    if (n.hasOwnProperty(a)) {
                        a = n[a];
                        for (var c in a) a.hasOwnProperty(c) && b.push(c)
                    }
                    return b
                },
                getData: function(a) {
                    var b = this.find("canvas.jSignature").add(this.filter("canvas.jSignature"));
                    void 0 === a && (a = "default");
                    if (0 !== b.length && h.hasOwnProperty(a)) return h[a].call(b.get(0), b.data("jSignature.data"), b.data("jSignature.settings"))
                },
                importData: e,
                setData: e,
                globalEvents: function() {
                    return d
                },
                disable: function() {
                    this.find("input").attr("disabled", 1);
                    this.find("canvas.jSignature").addClass("disabled").data("jSignature.this").settings.readOnly = !0
                },
                enable: function() {
                    this.find("input").removeAttr("disabled");
                    this.find("canvas.jSignature").removeClass("disabled").data("jSignature.this").settings.readOnly = !1
                },
                events: function() {
                    return this.find("canvas.jSignature").add(this.filter("canvas.jSignature")).data("jSignature.this").events
                }
            };
        $.fn.jSignature = function(a) {
            if (a && "object" !== typeof a) {
                if ("string" ===
                    typeof a && p[a]) return p[a].apply(this, Array.prototype.slice.call(arguments, 1));
                $.error("Method " + String(a) + " does not exist on jQuery.jSignature")
            } else return p.init.apply(this, arguments)
        }
    })(window)
})();
(function() {
    function q(k, h, p) {
        k = k.call(this);
        (function(h, k, p) {
            h.events.subscribe(p + ".change", function() {
                h.dataEngine.data.length ? k.show() : k.hide()
            })
        })(this, k, h);
        (function(h, k, p) {
            var n = p + ".undo";
            k.bind("click", function() {
                h.events.publish(n)
            });
            h.events.subscribe(n, function() {
                var k = h.dataEngine.data;
                k.length && (k.pop(), h.resetCanvas(k))
            })
        })(this, k, this.events.topics.hasOwnProperty(h + ".undo") ? p : h)
    }
    $.fn.jSignature("addPlugin", "instance", "UndoButton", function(k) {
        this.events.subscribe("jSignature.attachingEventHandlers",
            function() {
                if (this.settings[k]) {
                    var h = this.settings[k];
                    "function" !== typeof h && (h = function() {
                        var h = $('<input type="button" value="Undo last stroke" style="position:absolute;display:none;margin:0 !important;top:auto" />').appendTo(this.$controlbarLower),
                            k = h.width();
                        h.css("left", Math.round((this.canvas.width - k) / 2));
                        k !== h.width() && h.width(k);
                        return h
                    });
                    q.call(this, h, "jSignature", k)
                }
            })
    })
})();
(function() {
    for (var q = {}, k = {}, h = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWX".split(""), p = h.length / 2, n = p - 1; - 1 < n; n--) q[h[n]] = h[n + p], k[h[n + p]] = h[n];
    var w = function(e) {
            e = e.split("");
            for (var a = e.length, b = 1; b < a; b++) e[b] = q[e[b]];
            return e.join("")
        },
        x = function(e) {
            for (var a = [], b = 0, c = 1, g = e.length, d, f, h = 0; h < g; h++) d = Math.round(e[h]), f = d - b, b = d, 0 > f && 0 < c ? (c = -1, a.push("Z")) : 0 < f && 0 > c && (c = 1, a.push("Y")), d = Math.abs(f), d >= p ? a.push(w(d.toString(p))) : a.push(d.toString(p));
            return a.join("")
        },
        v = function(e) {
            var a = [];
            e = e.split("");
            for (var b = e.length, c, g = 1, d = [], f = 0, h = 0; h < b; h++) c = e[h], c in q || "Z" === c || "Y" === c ? (0 !== d.length && (d = parseInt(d.join(""), p) * g + f, a.push(d), f = d), "Z" === c ? (g = -1, d = []) : "Y" === c ? (g = 1, d = []) : d = [c]) : d.push(k[c]);
            a.push(parseInt(d.join(""), p) * g + f);
            return a
        },
        u = function(e) {
            for (var a = [], b = e.length, c, g = 0; g < b; g++) c = e[g], a.push(x(c.x)), a.push(x(c.y));
            return a.join("_")
        },
        y = function(e) {
            var a = [];
            e = e.split("_");
            for (var b = e.length / 2, c = 0; c < b; c++) a.push({
                x: v(e[2 * c]),
                y: v(e[2 * c + 1])
            });
            return a
        },
        C = function(e) {
            return ["image/jsignature;base30",
                u(e)
            ]
        },
        f = function(e, a, b) {
            "string" === typeof e && ("image/jsignature;base30" === e.substring(0, 23).toLowerCase() && (e = e.substring(24)), b(y(e)))
        };
    if (null == this.jQuery) throw Error("We need jQuery for some of the functionality. jQuery is not detected. Failing to initialize...");
    (function(e) {
        e = e.fn.jSignature;
        e("addPlugin", "export", "base30", C);
        e("addPlugin", "export", "image/jsignature;base30", C);
        e("addPlugin", "import", "base30", f);
        e("addPlugin", "import", "image/jsignature;base30", f)
    })(this.jQuery);
    this.jSignatureDebug &&
        (this.jSignatureDebug.base30 = {
            remapTailChars: w,
            compressstrokeleg: x,
            uncompressstrokeleg: v,
            compressstrokes: u,
            uncompressstrokes: y,
            charmap: q
        })

}).call("undefined" !== typeof window ? window : this);
(function() {
    function q(f, e) {
        this.x = f;
        this.y = e;
        this.reverse = function() {
            return new this.constructor(-1 * this.x, -1 * this.y)
        };
        this._length = null;
        this.getLength = function() {
            this._length || (this._length = Math.sqrt(Math.pow(this.x, 2) + Math.pow(this.y, 2)));
            return this._length
        };
        var a = function(a) {
            return Math.round(a / Math.abs(a))
        };
        this.resizeTo = function(b) {
            if (0 === this.x && 0 === this.y) this._length = 0;
            else if (0 === this.x) this._length = b, this.y = b * a(this.y);
            else if (0 === this.y) this._length = b, this.x = b * a(this.x);
            else {
                var c = Math.abs(this.y /
                        this.x),
                    e = Math.sqrt(Math.pow(b, 2) / (1 + Math.pow(c, 2)));
                c *= e;
                this._length = b;
                this.x = e * a(this.x);
                this.y = c * a(this.y)
            }
            return this
        };
        this.angleTo = function(a) {
            var b = this.getLength() * a.getLength();
            return 0 === b ? 0 : Math.acos(Math.min(Math.max((this.x * a.x + this.y * a.y) / b, -1), 1)) / Math.PI
        }
    }

    function k(f, e) {
        this.x = f;
        this.y = e;
        this.getVectorToCoordinates = function(a, b) {
            return new q(a - this.x, b - this.y)
        };
        this.getVectorFromCoordinates = function(a, b) {
            return this.getVectorToCoordinates(a, b).reverse()
        };
        this.getVectorToPoint = function(a) {
            return new q(a.x -
                this.x, a.y - this.y)
        };
        this.getVectorFromPoint = function(a) {
            return this.getVectorToPoint(a).reverse()
        }
    }

    function h(f, e) {
        var a = Math.pow(10, e);
        return Math.round(f * a) / a
    }

    function p(f, e, a) {
        e += 1;
        var b = new k(f.x[e - 1], f.y[e - 1]),
            c = new k(f.x[e], f.y[e]);
        c = b.getVectorToPoint(c);
        var g = new k(f.x[e - 2], f.y[e - 2]);
        b = g.getVectorToPoint(b);
        return b.getLength() > a ? (a = 2 < e ? (new k(f.x[e - 3], f.y[e - 3])).getVectorToPoint(g) : new q(0, 0), f = .35 * b.getLength(), g = b.angleTo(a.reverse()), e = c.angleTo(b.reverse()), a = (new q(a.x + b.x, a.y + b.y)).resizeTo(Math.max(.05,
            g) * f), c = (new q(b.x + c.x, b.y + c.y)).reverse().resizeTo(Math.max(.05, e) * f), c = new q(b.x + c.x, b.y + c.y), ["c", h(a.x, 2), h(a.y, 2), h(c.x, 2), h(c.y, 2), h(b.x, 2), h(b.y, 2)]) : ["l", h(b.x, 2), h(b.y, 2)]
    }

    function n(f, e) {
        var a = f.x.length - 1,
            b = new k(f.x[a], f.y[a]),
            c = new k(f.x[a - 1], f.y[a - 1]);
        b = c.getVectorToPoint(b);
        if (1 < a && b.getLength() > e) {
            a = (new k(f.x[a - 2], f.y[a - 2])).getVectorToPoint(c);
            c = b.angleTo(a.reverse());
            var g = .35 * b.getLength();
            a = (new q(a.x + b.x, a.y + b.y)).resizeTo(Math.max(.05, c) * g);
            return ["c", h(a.x, 2), h(a.y, 2), h(b.x,
                2), h(b.y, 2), h(b.x, 2), h(b.y, 2)]
        }
        return ["l", h(b.x, 2), h(b.y, 2)]
    }

    function w(f, e, a) {
        e = ["M", h(f.x[0] - e, 2), h(f.y[0] - a, 2)];
        a = 1;
        for (var b = f.x.length - 1; a < b; a++) e.push.apply(e, p(f, a, 1));
        0 < b ? e.push.apply(e, n(f, a, 1)) : 0 === b && e.push.apply(e, ["l", 1, 1]);
        return e.join(" ")
    }

    function x(f) {
        for (var e = [], a = [
                ["fill", void 0, "none"],
                ["stroke", "color", "#000000"],
                ["stroke-width", "lineWidth", 2],
                ["stroke-linecap", void 0, "round"],
                ["stroke-linejoin", void 0, "round"]
            ], b = a.length - 1; 0 <= b; b--) {
            var c = a[b][1],
                g = a[b][2];
            e.push(a[b][0] +
                '="' + (c in f && f[c] ? f[c] : g) + '"')
        }
        return e.join(" ")
    }

    function v(f, e) {
        var a = ['<?xml version="1.0" encoding="UTF-8" standalone="no"?>', '<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">'],
            b, c = f.length,
            g, d = [],
            h = [],
            k = g = b = 0,
            l = 0,
            p = [];
        if (0 !== c) {
            for (b = 0; b < c; b++) {
                g = f[b];
                var n = [],
                    q = {
                        x: [],
                        y: []
                    };
                l = 0;
                for (k = g.x.length; l < k; l++) n.push({
                    x: g.x[l],
                    y: g.y[l]
                });
                n = simplify(n, .7, !0);
                l = 0;
                for (k = n.length; l < k; l++) q.x.push(n[l].x), q.y.push(n[l].y);
                g = q;
                p.push(g);
                d = d.concat(g.x);
                h =
                    h.concat(g.y)
            }
            c = Math.min.apply(null, d) - 1;
            b = Math.max.apply(null, d) + 1;
            d = Math.min.apply(null, h) - 1;
            h = Math.max.apply(null, h) + 1;
            k = 0 > c ? 0 : c;
            l = 0 > d ? 0 : d;
            b -= c;
            g = h - d
        }
        a.push('<svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="' + b.toString() + '" height="' + g.toString() + '">');
        b = 0;
        for (c = p.length; b < c; b++) g = p[b], a.push("<path " + x(e) + ' d="' + w(g, k, l) + '"/>');
        a.push("</svg>");
        return a.join("")
    }

    function u(f, e) {
        return ["image/svg+xml", v(f, e)]
    }

    function y(f, e) {
        return ["image/svg+xml;base64", C(v(f, e))]
    }(function(f, e) {
        f.simplify =
            function(a, b, c) {
                b = b !== e ? b * b : 1;
                if (!c) {
                    var g = a.length,
                        d = a[0],
                        f = [d];
                    for (c = 1; c < g; c++) {
                        var h = a[c];
                        var k = h.x - d.x,
                            n = h.y - d.y;
                        k * k + n * n > b && (f.push(h), d = h)
                    }
                    a = (d !== h && f.push(h), f)
                }
                h = a;
                c = h.length;
                g = new(typeof Uint8Array != e + "" ? Uint8Array : Array)(c);
                d = 0;
                f = c - 1;
                var p, q = [],
                    r = [],
                    y = [];
                for (g[d] = g[f] = 1; f;) {
                    n = 0;
                    for (k = d + 1; k < f; k++) {
                        var A = h[k];
                        var z = h[d],
                            w = h[f],
                            u = z.x,
                            v = z.y;
                        z = w.x - u;
                        var B = w.y - v;
                        if (0 !== z || 0 !== B) {
                            var x = ((A.x - u) * z + (A.y - v) * B) / (z * z + B * B);
                            1 < x ? (u = w.x, v = w.y) : 0 < x && (u += z * x, v += B * x)
                        }
                        A = (z = A.x - u, B = A.y - v, z * z + B * B);
                        A > n && (p = k,
                            n = A)
                    }
                    n > b && (g[p] = 1, q.push(d), r.push(p), q.push(p), r.push(f));
                    d = q.pop();
                    f = r.pop()
                }
                for (k = 0; k < c; k++) g[k] && y.push(h[k]);
                return a = y, a
            }
    })(window);
    if ("function" !== typeof C) var C = function(f) {
        var e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".split(""),
            a = 0,
            b = 0,
            c = [];
        do {
            var g = f.charCodeAt(a++);
            var d = f.charCodeAt(a++);
            var h = f.charCodeAt(a++);
            var k = g << 16 | d << 8 | h;
            g = k >> 18 & 63;
            d = k >> 12 & 63;
            h = k >> 6 & 63;
            k &= 63;
            c[b++] = e[g] + e[d] + e[h] + e[k]
        } while (a < f.length);
        e = c.join("");
        f = f.length % 3;
        return (f ? e.slice(0, f -
            3) : e) + "===".slice(f || 3)
    };
    if ("undefined" === typeof $) throw Error("We need jQuery for some of the functionality. jQuery is not detected. Failing to initialize...");
    (function(f) {
        f = f.fn.jSignature;
        f("addPlugin", "export", "svg", u);
        f("addPlugin", "export", "image/svg+xml", u);
        f("addPlugin", "export", "svgbase64", y);
        f("addPlugin", "export", "image/svg+xml;base64", y)
    })($)
})();

function Validator(externalId) {
    var self = this;
    this.validationMessages = {};
    this.externalId = externalId;
    this.setValidationMessages = function(messages) {
        this.validationMessages = messages
    };
    this.getValidationMessageFor = function(control, errorType) {
        var el = control;
        if ($.inArray(el, ["birthDateDay", "birthDateMonth", "birthDateYear"]) !== -1) el = "birthDate";
        if (this.validationMessages[el] && this.validationMessages[el][errorType]) return this.validationMessages[el][errorType];
        else return ""
    };
    this.check = function(value, validatorName,
        successCallback, failCallback) {
        if (!self[validatorName]) successCallback();
        else self[validatorName](value, successCallback, failCallback)
    };
    this.firstName = function(value, successCallback, failCallback) {
        if (value) self.validateServerSide({
            firstName: value
        }, successCallback, failCallback);
        else failCallback({
            message: this.getValidationMessageFor("firstName", "empty")
        })
    };
    this.lastName = function(value, successCallback, failCallback) {
        if (value) self.validateServerSide({
            lastName: value
        }, successCallback, failCallback);
        else failCallback({
            message: this.getValidationMessageFor("lastName",
                "empty")
        })
    };
    this.email = function(value, successCallback, failCallback) {
        var re = /^(([^<>()\[\]\.,;:\s@"]+(\.[^<>()\[\]\.,;:\s@"]+)*)|(".+"))@(([^<>()[\]\.,;:\s@"]+\.)+[^<>()[\]\.,;:\s@"]{2,})$/i;
        if (value)
            if (!re.test(value)) failCallback({
                message: this.getValidationMessageFor("email", "invalid")
            });
            else self.validateServerSide({
                email: value
            }, successCallback, failCallback);
        else failCallback({
            message: this.getValidationMessageFor("email", "empty")
        })
    };
    this.checkEmpty = function(name, value, successCallback, failCallback) {
        if (value) successCallback();
        else failCallback({
            message: this.getValidationMessageFor(name, "empty")
        })
    };
    this.gender = function(value, successCallback, failCallback) {
        this.checkEmpty("gender", value, successCallback, failCallback)
    };
    this.city = function(value, successCallback, failCallback) {
        this.checkEmpty("city", value, successCallback, failCallback)
    };
    this.id_state = function(value, successCallback, failCallback) {
        this.checkEmpty("id_state", value, successCallback, failCallback)
    };
    this.address = function(value, successCallback, failCallback) {
        this.checkEmpty("address",
            value, successCallback, failCallback)
    };
    this.street = function(value, successCallback, failCallback) {
        this.checkEmpty("street", value, successCallback, failCallback)
    };
    this.houseNumber = function(value, successCallback, failCallback) {
        this.checkEmpty("houseNumber", value, successCallback, failCallback)
    };
    this.houseNumberAdditional = function(value, successCallback, failCallback) {
        successCallback()
    };
    this.birthDateDay = function(value, successCallback, failCallback) {
        var day = parseInt(value);
        if (day >= 1 && day <= 31) successCallback();
        else failCallback({
            message: this.getValidationMessageFor("birthDateDay",
                "invalid")
        })
    };
    this.birthDateMonth = function(value, successCallback, failCallback) {
        var month = parseInt(value);
        if (month >= 1 && month <= 12) successCallback();
        else failCallback({
            message: this.getValidationMessageFor("birthDateMonth", "invalid")
        })
    };
    this.birthDateYear = function(value, successCallback, failCallback) {
        var year = parseInt(value);
        if (year >= 1900) successCallback();
        else failCallback({
            message: this.getValidationMessageFor("birthDateYear", "invalid")
        })
    };
    this.termsAgree = function(value, successCallback, failCallback) {
        this.checkEmpty("termsAgree",value, successCallback, failCallback)
    };
    this.termsAgree2 = function(value, successCallback, failCallback) {
        this.checkEmpty("termsAgree2", value, successCallback, failCallback)
    };

    
    this.nationality = function(value, successCallback, failCallback) {
        this.checkEmpty("nationality", value, successCallback, failCallback)
    };
    this.birthDate = function(value, successCallback, failCallback) {
        var success = true;
        if (this.isValidDate(value)) {
            var age = this.getAge(value);
            if (age < 18 || age > 90) success = false
        } else success = false;
        if (success) successCallback();
        else failCallback({
            message: this.getValidationMessageFor("birthDateYear", "invalid")
        })
    };
    this.isValidDate = function(date) {
        var matches = /^(\d{4})[-\/](\d{1,2})[-\/](\d{1,2})$/.exec(date);
        if (!matches) return false;
        var d = parseInt(matches[3]);
        var m = parseInt(matches[2] - 1);
        var y = parseInt(matches[1]);
        var composedDate = new Date(y, m, d);
        return composedDate.getDate() === d && composedDate.getMonth() === m && composedDate.getFullYear() === y
    };
    this.getAge = function(bdate) {
        var today = new Date;
        var birthDate = new Date(bdate);
        var age =
            today.getFullYear() - birthDate.getFullYear();
        var m = today.getMonth() - birthDate.getMonth();
        if (m < 0 || m === 0 && today.getDate() < birthDate.getDate()) age--;
        return age
    };
    this.phone = function(value, successCallback, failCallback) {
        if (value) self.validateServerSide({
            phone: value
        }, successCallback, failCallback);
        else failCallback({
            message: this.getValidationMessageFor("phone", "empty")
        })
    };
    this.postcode = function(value, successCallback, failCallback) {
        if (value) self.validateServerSide({
            postcode: value
        }, successCallback, failCallback);
        else failCallback({
            message: this.getValidationMessageFor("postcode", "empty")
        })
    };
    this.state = function(value, successCallback, failCallback) {
        successCallback()
    };
    this.validateServerSide = function(values, successCallback, failCallback) {
		
        // la validazione ora viene eseguita da un PHP interno e non viene più bypassata
        console.log(values)
		$.post("../services/validate_nogeo.php", {
            externalId: self.externalId,
            values: values
        }, function(res) {
            if (res.success)
                if (res.redirect) window.location = res.redirect;
                else {
                    if (successCallback) successCallback(res)
                } else failCallback(res)
        }, "json")
		
		//successCallback('{"success":true,"results":{' + values[0] + ':{"isValid":true}}}')
    }
}

function Landing(locale, externalId) {
    var self = this;
    this.sponsorsModalChanged = false;
    this.questionsApi = undefined;
    this.formApi = undefined;
    this.isDoiRequired = false;
    this.useDoiBlockScreen = false;
    this.externalId = externalId;
    this.locale = locale;
    this.lead = undefined;
    this.sponsorsLoaded = false;
    this.redirectUrl = undefined;
    this.setLead = function(lead) {
        this.lead = lead;
        $.each($(".onLeadCreated"), function() {
            var text = $(this).html();
            text = text.replace("%name", self.lead.firstName);
            $(this).html(text)
        })
    };
    this.initFormApi = function(validationMessages,
        controls, stepsCount, cosponsorsStepTypes, jsPlugins) {
		
        self.formApi = new Form(this.locale, this.externalId);
        for (var key in jsPlugins)
            if (typeof window[jsPlugins[key]] === "function") {
                var plugin = window[jsPlugins[key]];
                self.formApi.registerPlugin(new plugin(self.formApi))
            } else console.error("JS plugin does not exists: " + jsPlugins[key]);
        self.formApi.initValidator(validationMessages);
        self.formApi.addControls(controls, stepsCount, cosponsorsStepTypes);
        self.formApi.init(function(response) {
            if (self.useDoiBlockScreen) self.showDoiBlockScreen();
            else self.startQuestions(response);
        });
        handle();
        var afterFormInited = $.Event(self.formApi.events.EVENT_AFTER_FORM_INITED);
        afterFormInited.eventData = {
            form: self.formApi
        };
        $(self.formApi).trigger(afterFormInited)
    };

    function handle() {
        handleFormSubmit();
    }

    function trackFormErrors(element) {
		
        var longFormErrors = [],
            shortFormErrors = [];
        var dobFields = ["bdate-year", "bdate-day", "bdate-month"];
        var shortFormFields = ["gender", "first-name", "last-name", "email", "terms-agree"];
        var longFormFields = ["poscode", "street", "house-number", "phone", "postcode"];
        $(".invalid").each(function() {
            var field = $(this).attr("name");
			
            if (field === undefined) field = $(this).attr("id");
            if (dobFields.indexOf(field) !== -1) shortFormErrors.push("dob");
            if (shortFormFields.indexOf(field) !== -1) shortFormErrors.push(field);
            if (longFormFields.indexOf(field) !== -1) longFormErrors.push(field)
        });
        shortFormErrors = _.uniq(shortFormErrors);
        longFormErrors = _.uniq(longFormErrors);
        var eventName;
        if (self.formApi.stepsCount === 1) eventName = "06. onestepform-error";
        else if (self.formApi.step === 1) eventName = "06. shortform-error";
        else if (self.formApi.step === 2 || self.formApi.step === 3) eventName = "07. longform-error";
        
    }

    function trackFormSubmit(element, declinedOptIn) {
        var coregCount =
            0,
            coregChecked = 0;
        var eventLabel = "with-data-consent";
        if (declinedOptIn) eventLabel = "without-data-consent";
        $(".coreg-sponsor").each(function() {
            var el = $(this);
            coregCount++;
            if (el.is(":checked")) coregChecked++
        });
        $(".coreg-sponsor-dd").each(function() {
            coregCount++;
            coregChecked++
        });
        
    }

    function handleTracking() {
        $("#exit-url, #no-optin").click(function() {
            
        });
        $("a[href='#modal-terms-and-conditions']").click(function() {
            
        });
        $("a[href='#modal-privacy-policy']").click(function() {
            
        })
    }

    function handleCoregAnswersTracking() {
        $(document).on("click", ".answer-submit", function() {
            
        });
        $(document).on("change", ".answer-radio, .answer-dropdown", function() {
            
        })
    }

    function handleFormSubmit() {
        $("#form-submit-step1, #form-submit-step2, .form-submit-step, #form-submit").click(function() {
            
			
			var element = $(this);
            var beforeFormSubmitEvent = $.Event(self.formApi.events.EVENT_BEFORE_FORM_SUBMIT);
			
            beforeFormSubmitEvent.eventData = {
                form: self.formApi
            };
            $(self.formApi).trigger(beforeFormSubmitEvent);
            //enableSponsorsPopupTracking();
           // var needAutoCheckAllSponsors = self.formApi.declinedOptIn === false && self.formApi.sponsorsTracking.canTrack === true && self.atLeastOneChecked() === false && (self.formApi.ignoreTermsAgreeToAutoCheckSponsorsPopup === true || self.formApi.getTermsAgree());
            //if (needAutoCheckAllSponsors) self.enableAllSponsors();
            self.formApi.next(function() {
                trackFormSubmit(element, self.formApi.declinedOptIn);
                window.scrollTo(0, 0)
            }, function() {}, function() {
                trackFormErrors(element)
            })
			
        })
		
    }

    function enableSponsorsPopupTracking() {
        self.formApi.sponsorsTracking.canTrack = false;
        if (self.formApi.stepsCount === 4 && self.formApi.step === 2) self.formApi.sponsorsTracking.canTrack = true;
        else if (self.formApi.stepsCount < 4 && self.formApi.step === 1) self.formApi.sponsorsTracking.canTrack = true
    }
    this.initQuestionsApi = function(questionsWrap, endUrl) {
        
        self.questionsApi =
            new Question(this.locale, this.externalId, questionsWrap);
        self.questionsApi.setEndUrl(endUrl);
        
        self.questionsApi.template = _.template($("#t-question").html());
        self.redirectUrl = endUrl;
        
        $(document).on("click", ".answer-submit", function() {
            self.processAnswer($(this))
        });

        $(document).on("click", ".questionblock .button", function() {
            self.processAnswerPREFORM($(this))
        });
        
        $(document).on("click", ".answer-skip", function() {
            self.questionnaireNext()
        });
        
        $(document).on("change", ".answer-radio, .answer-dropdown", function() {
            self.processAnswer($(this))
        });
        
        $("#modal-question").on($.modal.BEFORE_CLOSE, function(event, modal) {
            self.questionnaireNext()
        });
        
        handleCoregAnswersTracking()
        
    };

    this.processAnswerPREFORM = function(el){
        console.log("risposta PRE FORM")
        var data = {
        questionId : el.data('qid'),
        answerId : el.data('aid')
        }
        self.sendAnswerPREFORM(data)

    }

    this.sendAnswerPREFORM = function(answer, successCallback, failCallback) {
        answer.externalId = self.externalId;
        $.post("../services/answer_pf.php", answer, function(res) {
            
        }, "json")
    };

    this.processAnswer = function(el) {
        self.questionsApi.blockQuestion();
        var answer = self.questionsApi.getAnswer(el);
        self.questionsApi.sendAnswer(answer, function() {
            self.questionsApi.unblockQuestion();
            if (answer.layout === "Popup") $.modal.close();
            else self.questionnaireNext()
        }, function() {
            self.questionsApi.unblockQuestion();
            var textAnswer = el.closest(".question-block").find(".answer-text");
            if (textAnswer.length) textAnswer.addClass("invalid")
        });
        self.processPopOut(answer)
    };
    this.processPopOut =
        function(answer) {
            if (!answer || !answer.answerId) return null;
            if (self.popOut && self.popOut[answer.answerId]) window.open(self.popOut[answer.answerId], "_blank")
        };
    this.startQuestions = function(response) {
		
        self.hideSignupForm();
        if (self.isDoiRequired) self.setConfirmMailLink(false, response);
        self.questionsApi.getList(function() {
            self.questionnaireNext();
            $("#questions").show();
            $("#questions").removeClass("hidden")
        }, function() {
            window.location.href = self.questionsApi.getEndUrl()
        })
    };
    this.hideSignupForm = function() {
        $("#page1, #input1, #main-section").hide();
        if (!self.isCompliant) $(".terms").hide()
    };
    this.showDoiBlockScreen = function(isConfirmed) {
        self.hideSignupForm();
        $(".doi-wrapper").show();
        if (isConfirmed) self.showDoiConfirmCode();
        else self.setConfirmMailLink(true)
    };
    this.questionnaireNext = function() {
        self.questionsApi.getNext(self.questionnaireProcess, self.questionnaireNext, self.questionnaireFinish)
    };
    this.questionnaireProcess = function(question) {
        var progressStatus = self.questionsApi.getProgressStatus();
        $("#question-container").find("#question-progress-bar, .loading").css("width",
            progressStatus.progress + "%");
        $(".question-progress-num").text(progressStatus.progress + "%");
        $(".questions-progress-wrap").removeClass("hide");
        self.popOut = {};
        if (question.answers) _.each(question.answers, function(a) {
            if (a.popOutUrl) self.popOut[a.id] = a.popOutUrl
        });
        var questionNum = "" + self.questionsApi.currentQuestionNum;
        var qbody = $(self.questionsApi.template({
            question: question,
            questionNum: "00".substring(0, "00".length - questionNum.length) + questionNum,
            isLast: self.questionsApi.isLastQuestion()
        }));
        self.questionsApi.container.body.hide();
        if (question.layout === "IFrame") {
            self.questionsApi.container.body.html(qbody);
            qbody.find(".iframe-wrap iframe").ready(function() {
                self.questionsApi.container.body.show()
            })
        } else if (question.layout === "Popup") $("#modal-question").html(qbody).modal({
            escapeClose: false,
            clickClose: false
        });
        else {
            self.questionsApi.container.body.html(qbody);
            self.questionsApi.container.body.show()
        }
        if (question.answerRule && question.answerRule.mask) {
            var qel = qbody.find(".answer-text"),
                mask = question.answerRule.mask;
            mask.clearIncomplete =
                false;
            qel.inputmask(mask).data("mask", 1)
        }
        if ($(".custom-js").length) eval($(".custom-js").text());
        var signature = $("#signature");
        if (signature.length) self.setUpSignature(signature, qbody);
        $("html, body").animate({
            scrollTop: 0
        }, 400);
        $(".select2").each(function() {
            var closeOnSelect = true;
            if (typeof $(this).data("closeOnSelect") !== "undefined") closeOnSelect = !!$(this).data("closeOnSelect");
            $(this).select2({
                placeholder: $(this).data("placeholder"),
                closeOnSelect: closeOnSelect
            })
        });
        $(".read-more").on("click", function() {
            if ($(".read-more-text").height() ==
                0) $(".read-more-text").css("max-height", "5000px");
            else $(".read-more-text").css("max-height", "0")
        });
        if (question.premiumLogoUrl || question.premiumText) $(".questions-progress-wrap").addClass("hide")
    };
    this.questionnaireFinish = function() {
		/* fine questionario post-form */
        $.post("../services/finish.php", {
            externalId: self.externalId
        }, function(response) {
            var url = self.redirectUrl;
            if (response.redirect) url = response.redirect;
            window.location.replace(url)
        })
		
    };
    this.startForm = function() {
        //self.loadSponsors()
    };
    this.setUpSignature = function(signature, qbody) {
        var submitBtn =
            qbody.find(".answer-submit"),
            placeholder = $("#signature-background"),
            wrapper = qbody.find(".question-signature");

        function showPlaceholder() {
            if (signatureInput.isModified() === false) placeholder.show()
        }

        function hidePlaceholder() {
            placeholder.hide()
        }

        function showError() {
            wrapper.addClass("-error")
        }

        function resetError() {
            wrapper.removeClass("-error")
        }

        function activateBtn() {
            submitBtn.addClass("active")
        }

        function deactivateBtn() {
            submitBtn.removeClass("active")
        }
        var signatureInput = new SignatureInput(signature, function() {
            resetError();
            activateBtn()
        });
        signatureInput.init();
        signature.mousedown(hidePlaceholder).mouseup(showPlaceholder).on("touchstart", hidePlaceholder).on("touchend", showPlaceholder);
        $("#clear-signature").click(function() {
            signatureInput.reset();
            showPlaceholder();
            resetError();
            deactivateBtn()
        });
        submitBtn.click(function(e) {
            if ($(this).hasClass("active") === false) {
                showError();
                e.stopPropagation();
                return false
            }
        });
        window.signature = signatureInput
    };
    
    this.showDoiHeader = function() {
        $("#doi-wrap").removeClass("hide").fadeIn()
    };
    this.hideTopHeader = function() {
        $(".top-header").addClass("doi-warning-on")
    };
    this.setConfirmMailLink = function(useBlockScreen, response) {
        var self = this;
        $.get("/lead/get-confirm-mail-link", {
            externalId: self.externalId
        }, function(res) {
            if (res && res.link) {
                $(".warning-envelope-wrap, .doi-warning-message, #open-email").click(function() {
                    window.open(res.link, useBlockScreen ? "_self" : "_blank")
                });
                if (useBlockScreen === false) {
                    self.hideTopHeader();
                    self.showDoiHeader()
                }
            } else {
                var emailDomain = "unknown";
                if (response && response.leadEmailDomain) emailDomain = response.leadEmailDomain;
            }
        }, "json")
    };
    this.onTermsChanged = function() {
        self.disableAllSponsors();
        //self.setSponsors()
    };
    this.atLeastOneChecked = function() {
        return $("input[type=checkbox][name=sponsor]:checked").length >
            0
    };
    this.enableAllSponsors = function() {
        var sponsorsOverlay = $(".sponsor-overlay");
        sponsorsOverlay.find(".toggleAll").data("enabled", 1);
        sponsorsOverlay.find("input[type=checkbox]").prop("checked", 1)
    };
    this.disableAllSponsors = function() {
        var sponsorsOverlay = $(".sponsor-overlay");
        sponsorsOverlay.find(".toggleAll").data("enabled", 0);
        sponsorsOverlay.find("input[type=checkbox]").prop("checked", 0)
    };
    this.setSponsors = function() {
        var ids = [];
        $("input[type=checkbox][name=sponsor]").each(function() {
            if ($(this).prop("checked")) ids.push($(this).val())
        });
        $(window).trigger("onSponsorsListChanged", {
            count: _.uniq(ids).length
        });
        $.post("/sponsor/set?externalId=" + self.externalId, {
            ids: ids
        }, function(res) {
            if (res && res.sponsors) {
                var t = _.template($("#t-sponsors").html());
                $(".sponsor-container").html(t({
                    sponsors: res.sponsors
                }));
                $(".sponsor-overlay .sponsorTab.active").click()
            }
        }, "json")
    };
    this.setSponsorPopupTrackingData = function() {
        $(".sponsor-overlay input[type=checkbox][name=sponsor]").each(function() {
            if ($(this).prop("checked")) self.formApi.sponsorsTracking.sponsorsMap[$(this).val()] =
                "checked";
            else delete self.formApi.sponsorsTracking.sponsorsMap[$(this).val()]
        })
    };
    this.loadSponsors = function(successCallback) {
		/*
        if (!self.sponsorsLoaded) $.get("/sponsor?externalId=" + self.externalId, function(res) {
            if (res && res.sponsors) {
                var t = _.template($("#t-sponsors").html());
                $(".sponsor-container").html(t({
                    sponsors: res.sponsors
                }));
                $(".sponsor-overlay .sponsorTab.active").click();
                self.sponsorsLoaded = true;
                if (successCallback) successCallback();
                self.onTermsChanged()
            }
        }, "json");
        self.formApi.controls.termsAgree.change(function() {
            self.onTermsChanged()
        })
		*/
    };
    this.showDoiConfirmCode = function() {
        setTimeout(function() {
            function randomIntFromInterval(min, max) {
                return Math.floor(Math.random() * (max - min + 1) + min)
            }
            var digits = {
                    1: ".digit-one",
                    2: ".digit-two",
                    3: ".digit-three",
                    4: ".digit-four"
                },
                handlers = {};
            _.each(digits, function(el, ind) {
                var digit = $(el);
                handlers[ind] = setInterval(function() {
                    var currentNumber = parseInt(digit.text());
                    var randomNumber = randomIntFromInterval(0, 9);
                    if (randomNumber === currentNumber) digit.text(currentNumber !== 7 ? 7 : 3);
                    else digit.text(randomNumber)
                }, 100)
            });
            setTimeout(function() {
                clearInterval(handlers[1]);
                $(".digit.digit-one").text(8);
                setTimeout(function() {
                    clearInterval(handlers[2]);
                    $(".digit.digit-two").text(5);
                    setTimeout(function() {
                        clearInterval(handlers[3]);
                        $(".digit.digit-three").text(2);
                        setTimeout(function() {
                            clearInterval(handlers[4]);
                            $(".digit.digit-four").text(0);
                            setTimeout(function() {
                                $(".doi-submit-wrapper").show();
                                $(".doi-confirm-code").append('<div class="shineAnimation"></div>')
                            }, 600)
                        }, 600)
                    }, 600)
                }, 600)
            }, 1500)
        }, 500)
    };
    $("#sponsor-list, #sponsor-list-footer").click(function(e) {
        e.preventDefault();
        self.formApi.sponsorsTracking.popupShowed = 1;
        self.loadSponsors()
    });
    $(".sponsor-overlay").on("click", ".toggleAll", function() {
        var button = $(this);
        if (button.data("enabled")) {
            button.data("enabled", 0);
            $("input[type=checkbox]").prop("checked", 0)
        } else {
            button.data("enabled", 1);
            $("input[type=checkbox]").prop("checked", 1)
        }
        //self.setSponsors()
    });
    $(".sponsor-overlay").on("click", ".toggleType", function() {
        var checkbox = $(this).find("input[type=checkbox]");
        var type = $(this).data("type");
        var state;
        if (checkbox.prop("checked")) {
            state =
                0;
            checkbox.prop("checked", state)
        } else {
            state = 1;
            checkbox.prop("checked", state)
        }
        $.each($("tr.sponsor-item." + type + " input[type=checkbox]"), function() {
            $(this).prop("checked", state);
            $("input[type=checkbox][value=" + $(this).prop("value") + "]").prop("checked", state)
        });
       // self.setSponsors()
    });
    $(".sponsor-overlay").on("click", ".sponsorTab", function() {
        var tab = $(this);
        $(".sponsorTab.active").removeClass("active");
        tab.addClass("active");
        $("tr.sponsor-item").hide();
        $("tr.sponsor-item." + tab.data("type")).show();
        $("label.toggleType").hide();
        $("label.toggleType." + tab.data("type")).show()
    });
    $(".sponsor-overlay").on("change", "input[type=checkbox][name=sponsor]", function() {
       // self.setSponsors();
        self.setSponsorPopupTrackingData();
        $("input[type=checkbox][value=" + $(this).prop("value") + "]").prop("checked", $(this).prop("checked"))
    });
    $(document).on("click", ".skip-iframe-btn", function() {
        self.questionnaireNext()
    });
    $("#no-optin").click(function() {
        self.formApi.onNoOptinClick();
        return false
    });
    $("#modal-sponsors").on("modal:open", function(event, modal) {
        self.sponsorsModalChanged =
            false;
        self.formApi.resetValid("termsAgree");
        modal.elm.find('.sponsor-item input[name="sponsor"]').each(function() {
            $(this).change(function() {
                self.sponsorsModalChanged = true
            })
        });
        modal.elm.find(".toggleAll").click(function() {
            self.sponsorsModalChanged = true
        });
        var atLeastOneChecked = false;
        modal.elm.find('.sponsor-item input[name="sponsor"]').each(function() {
            if ($(this).prop("checked")) atLeastOneChecked = true
        });
        if (atLeastOneChecked === false && $("#terms-agree").is(":checked")) {
            self.enableAllSponsors();
            self.setSponsorPopupTrackingData()
        }
    });
    $("#modal-sponsors").on("modal:close", function(event, modal) {
        var nothingChecked = true;
        var allChecked = true;
        modal.elm.find('.sponsor-item input[name="sponsor"]').each(function() {
            if ($(this).prop("checked")) nothingChecked = false;
            else allChecked = false
        });
        if (allChecked === false) self.formApi.controls.termsAgree.prop("checked", true);
        if (self.sponsorsModalChanged && nothingChecked) self.formApi.validate("termsAgree");
        if (nothingChecked === false && allChecked === false) {
            self.formApi.controls.termsAgree.prop("checked", true);
            self.formApi.setValid("termsAgree");
            self.formApi.afterValidate("termsAgree", true, true)
        } else if (allChecked === false) self.formApi.controls.termsAgree.prop("checked", false)
    });
    $(window).on("onSponsorsListChanged", function(event, data) {
        $.each($(".companies-count"), function() {
            $(this).html(data.count)
        })
    })
}
window.onerror = function(msg, url, lineNo) {
    /* bypass report errori
    var xmlhttp = new XMLHttpRequest;
    xmlhttp.open("POST", "/error/report");
    xmlhttp.setRequestHeader("Content-Type", "application/json");
    xmlhttp.send(JSON.stringify({
        msg: msg,
        url: url,
        lineNo: lineNo
    }));
    return false
    */
};

function exitBack(exitUrl) {
    try {
        var e = decodeURIComponent(location.search);
        history.replaceState(null, document.title, location.pathname + "#/!"), history.pushState(null, document.title, location.pathname + "" + e)
    } catch (t) {}
    window.addEventListener("popstate", function() {
        "#/!" === location.hash && (history.replaceState(null, document.title, location.pathname + "" + e), setTimeout(function() {
            window.location = exitUrl
        }, 0))
    }, !1)
}
$(document).ready(function() {
    $(".select").each(function() {
        $(this).select2({
            placeholder: $(this).data("placeholder")
        })
    });
    $(".item-timer").each(function() {
        setTimer($(this))
    });
    $(".item-countdown").each(function() {
        setCountdown($(this))
    });

    function setTimer(self) {
        self.countdown((new Date).getTime() + self.data("time") * 1E3, function(event) {
            self.text(event.strftime("%M:%S"))
        }).on("finish.countdown", function() {
            var date = (new Date).getTime() + self.data("time") * 1E3;
            self.countdown(date)
        })
    }

    function setCountdown(el) {
        var val =
            el.data("value"),
            self = el,
            interval = el.data("interval");
        if (!interval || isNaN(el.html())) return;
        var si = setInterval(function() {
            if (val == 4) clearInterval(si);
            else $(self).html(--val)
        }, interval)
    }
    $("#prelander-webpush-confirm").click(function() {
        if ("serviceWorker" in navigator && "PushManager" in window) {
            var wpm = new WebPushManager,
                externalId = $(this).data("externalId");
            wpm.init(function() {
                wpm.subscribeUser(function(subscription) {
                    trackSubscription(subscription, externalId)
                })
            })
        }
    });

    function companyLogos() {
        if ($(window).width() >
            768) $("body").css("margin-bottom", $(".companyLogosWrap").height() + 10);
        else $("body").css("margin-bottom", "0")
    }
    if ($(".companyLogosWrap").length) {
        companyLogos();
        $(window).resize(function() {
            companyLogos()
        })
    }
});
$(window).on("onLeadCreated", function(event, data) {
    $.each($(".onLeadCreated"), function() {
        var text = $(this).html();
        text = text.replace("%name", data.firstName ? data.firstName : data.lastName);
        $(this).html(text)
    })
});
"use strict";

function WebPushManager() {
    var self = this;
    self.swRegistration = null;
    self.isSubscribed = null;
    self.publicKey = "BDE3WO6wwPHIJs_gsiEpuuCwx-A-2xlFZGZOOKLVWDIiGOmz1k4f6S6UheflauLBDtqUNCAeroGICKx0s3gUYTc";
    self.init = function(callback) {
        return navigator.serviceWorker.register("/worker.js").then(function(registration) {
            self.swRegistration = registration;
            return registration.pushManager.getSubscription()
        }).then(function(subscription) {
            self.isSubscribed = !!subscription;
            if (callback) callback()
        })
    };
    self.subscribeUser = function(callback) {
        return self.swRegistration.pushManager.getSubscription().then(function(subscription) {
            if (!subscription) {
                var subscribeOptions = {
                    userVisibleOnly: true,
                    applicationServerKey: self.urlBase64ToUint8Array(self.publicKey)
                };
                return self.swRegistration.pushManager.subscribe(subscribeOptions)
            } else return null
        }).then(function(pushSubscription) {
            self.isSubscribed = !!pushSubscription;
            if (!pushSubscription) return null;
            console.log("Received PushSubscription: ", JSON.stringify(pushSubscription));
            self.sendSubscriptionToBackEnd(pushSubscription, false);
            if (callback) callback(pushSubscription);
            return pushSubscription
        })
    };
    self.unsubscribeUser = function(callback) {
        if (!self.swRegistration ||
            !self.isSubscribed) return null;
        self.swRegistration.pushManager.getSubscription().then(function(subscription) {
            if (subscription) {
                self.sendSubscriptionToBackEnd(subscription, true);
                return subscription.unsubscribe()
            }
        }).catch(function(error) {
            console.log("Error unsubscribing", error)
        }).then(function() {
            console.log("User is unsubscribed.");
            self.isSubscribed = false;
            if (callback) callback()
        })
    };
    self.urlBase64ToUint8Array = function(base64String) {
        var padding = "=".repeat((4 - base64String.length % 4) % 4);
        var base64 = (base64String +
            padding).replace(/\-/g, "+").replace(/_/g, "/");
        var rawData = window.atob(base64);
        var outputArray = new Uint8Array(rawData.length);
        for (var i = 0; i < rawData.length; ++i) outputArray[i] = rawData.charCodeAt(i);
        return outputArray
    };
    self.sendSubscriptionToBackEnd = function(subscription, unsubscribe) {
        //var xmlhttp = new XMLHttpRequest;
        //xmlhttp.open("POST", unsubscribe ? "https://webpushbuilder.com/subscription/62qdAtfW/unsubscribe" : "https://webpushbuilder.com/subscription/62qdAtfW/subscribe");
        //xmlhttp.setRequestHeader("Content-Type","application/json");
        //xmlhttp.send(JSON.stringify(subscription))
    }
}

function trackSubscription(subscription, externalId) {
    //var xmlhttp = new XMLHttpRequest;
    //xmlhttp.open("POST", "/web-push/track-subscription?externalId=" + encodeURIComponent(externalId));
    //xmlhttp.setRequestHeader("Content-Type", "application/json");
    //xmlhttp.send(JSON.stringify(subscription))
};