<script type="text/template" id="t-city-list">
    <% if (!_.isEmpty(cities)) { %>
            <option selected="" value="" disabled="disabled">Città</option>
        <% if (cities.length === undefined) { %>
            <% _.each(cities, function (value, key) { %>
                <option value="<%- key %>"><%- value %></option>
            <% }) %>
        <% } else { %>
            <% _.each(cities, function (value) { %>
                <option value="<%- value %>"><%- value %></option>
            <% }) %>
        <% } %>
    <% } else { %>
        <option selected="" disabled="" value="">Città</option>
    <% } %>
</script>

<script type="text/template" id="t-postcode-list">
    <option selected="selected" disabled="disabled" value="">Codice Postale (CAP)</option>
    <% if (postcodes.length) { %>
        <% _.each(postcodes, function (postcode) { %>
            <option value="<%- postcode %>" <% if (postcodes.length === 1) { %> selected <% } %> ><%- postcode %></option>
        <% }) %>
    <% } %>
</script>

<script type="text/template" id="t-state-list">
    <option selected="selected" disabled="disabled" value=""></option>
    <% if (!_.isEmpty(states)) { %>
        <% if (states.length === undefined) { %>
            <% _.each(states, function (value, key) { %>
                <option value="<%- key %>"><%- value %></option>
            <% }) %>
        <% } else { %>
            <% _.each(states, function (value) { %>
                <option value="<%- value %>"><%- value %></option>
            <% }) %>
        <% } %>
    <% } %>
</script>

<script type="text/template" id="t-address-list">
    <% if (addresses.length) { %>
        <% if (addresses.length > 1) { %>
            <option selected="selected" disabled="" value="">Seleziona...</option>
        <% } %>
        <% _.each(addresses, function (item) { %>
            <option value="<%- item.address %>" data-house-number="<%- item.houseNumber %>" data-street="<%- item.street %>"><%- item.address %></option>
        <% }) %>
    <% } else { %>
        <option selected="selected" disabled="" value="">Seleziona...</option>
    <% } %>
</script>

<script type="text/template" id="t-street-list">
    <% if (streets.length) { %>
        <% _.each(streets, function (street) { %>
            <option value="<%- street %>"><%- street %></option>
        <% }) %>
    <% } else { %>
        <option selected="" disabled="disabled" value="">Seleziona...</option>
    <% } %>
</script>

<script type="text/template" id="t-house-number-list">
    <% if (range.length) { %>
        <% _.each(range, function (houseNumber) { %>
            <option value="<%- houseNumber %>"><%- houseNumber %></option>
        <% }) %>
    <% } else { %>
        <option selected="" disabled="disabled" value="">Seleziona...</option>
    <% } %>
</script>

<script type="text/template" id="t-question">

    <% if (question.extraCss) { %>
    <style>
        <%= question.extraCss %>
    </style>
    <% } %>
    <% if (question.extraJs) { %>
        <div class="custom-js " style="display:none"><%= question.extraJs %></div>
    <% } %>

    <% if (question.layoutId == 10) { %>
        <div class="question-modal question-block" data-id="<%- question.id %>" data-layout="<%- question.layout %>">
            <div class="h3"><%= question.question %></div>
            <% _.each (question.answers, function (answer, ind) { %>
                <button data-ga-action="05. coreg-<%= questionNum %>" class="btn btn-md answer-submit" rel="modal:close" data-id="<%- answer.id %>"><%= answer.answer %></button>
            <% }) %>
        </div>
    <% } else {%>
        <div
            <% if (question.premiumTextColor || question.premiumBackgroundColor) {%> style="<% if (question.premiumTextColor) {%> color: <%=question.premiumTextColor%>;<% } %> <% if (question.premiumBackgroundColor) {%> background: <%=question.premiumBackgroundColor%>;<% } %>" <% } %>
            class="question-position <% if (question.premiumLogoUrl) { %> question-premium  <% } %>question-block" id="question-<%- question.id %>" data-id="<%- question.id %>" data-layout="<%- question.layout %>"
        >
            <% if (question.premiumLogoUrl || question.premiumText) { %>
                <div class="question-premium-top">
                    <% if (question.premiumLogoUrl) { %>
                        <div class="question-premium-img">
                            <img src="<%= question.premiumLogoUrl %>" alt="">
                        </div>
                    <% } %>
                    <% if (question.premiumText) { %>
                        <div class="question-premium-description">
                            <p><%= question.premiumText %></p>
                        </div>
                    <% } %>
                </div>
            <% } %>
            <% if (question.logoUrl) { %>
                <div class="question-logo">
                    <img src="<%- question.logoUrl %>" alt="">
                </div>
            <% } %>
            <div class="question-text">
                <div class="question-title"><%= question.title %></div>
                <% if (question.question) { %>
                    <div class="question-subtitle"><%= question.question %></div>
                <% } %>
                <% if (question.layoutId == 1 ) { %>
                    <div class="q-btns">
                        <% _.each(question.answers, function(answer) { %>
                            <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn answer-submit <%= answer.isPositive == '1' ? '' : 'q-btn-grey' %>" data-id="<%- answer.id %>"><%= answer.answer %></button>
                        <% }) %>
                    </div>
                <% } else if (question.layoutId == 8) { %>
                    <div class="question-iframe-container">
                        <div class="rel">
                            <div class="iframe-question"></div>
                            <div class="iframe-wrap">
                                <iframe frameborder="0" src="<%- question.iframeUrl %>"></iframe>
                            </div>
                            <div class="iframe-skip">
                                <a href="javascript: void(0);" class="skip-iframe-btn">Salta la domanda</a>
                            </div>
                        </div>
                    </div>
                <% } else if (question.layoutId == 2 || question.layoutId == 12 || question.layoutId == 14) { %>
                    <div class="q-select-wrap">
                        <% if (question.layoutId != 14) {%>
                            <select data-ga-action="05. coreg-<%= questionNum %>" class="q-select answer-dropdown <% if (question.layoutId == 12) {%> select2 <% } %>" <% if (question.layoutId == 12) {%> style="width: 100%;" <% } %> >
                            <option value="NONE" selected="selected" disabled="disabled">Seleziona...</option>
                        <% } else { %>
                            <select data-ga-action="05. coreg-<%= questionNum %>" data-placeholder="Seleziona..." multiple class="q-select answer-multi-dropdown select2" style="width: 100%;" >
                        <% } %>
                            <% _.each(question.answers, function(answer) { %>
                                <option value="<%- answer.id %>"><%= answer.answer %></option>
                            <% }) %>
                        </select>
                    </div>
                    <% if (question.layoutId == 14) {%>
                        <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn q-btn-lg answer-submit">Continua</button>
                        <button class="q-btn q-btn-block q-btn-transparent answer-skip" data-type="skip">Salta</button>
                    <% } %>

                <% } else if (question.layoutId == 9) { %>
                    <!-- empty body -->
                <% } else if (question.layoutId == 6) { %>
                    <ul class="unstyle-list <%= question.answers.length > 3 ? 'unstyle-list-2-col' : 'unstyle-list' %>">
                        <% _.each (question.answers, function (answer, ind) { %>
                            <li>
                                <label class="checkbox">
                                    <input type="checkbox" class="answer-checkbox" value="<%- answer.id %>">
                                    <span><%= answer.answer %></span>
                                </label>
                            </li>
                        <% }) %>
                    </ul>

                    <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn q-btn-lg answer-submit">Continua</button>
                <% } else if (question.layoutId == 7) { %>
                    <ul class="unstyle-list">
                        <% _.each (question.answers, function (answer, ind) { %>
                            <li>
                                <label class="radio">
                                    <input type="radio" data-ga-action="05. coreg-<%= questionNum %>" class="answer-radio" value="<%- answer.id %>">
                                    <span><%= answer.answer %></span>
                                </label>
                            </li>
                        <% }) %>
                    </ul>
                <% } else if (question.layoutId == 3) { %>
                    <textarea class="q-textarea answer-text" cols="30" rows="10" placeholder=""><%= question.answer.answer %></textarea>
                    <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn q-btn-lg answer-submit" data-type="send">Continua</button>
                    <button class="q-btn q-btn-block q-btn-transparent answer-skip" data-type="skip">Salta</button>
                <% } else if (question.layoutId == 4) { %>
                    <input type="text" placeholder="" class="answer-text" value="<%= question.answer.answer %>" data-mask="0">
                    <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn q-btn-lg answer-submit" data-type="send">Continua</button>
                    <button class="q-btn q-btn-block q-btn-transparent answer-skip" data-type="skip">Salta</button>
                <% } else if (question.layoutId == 13) { %>
                    <div data-layout="signature">
                        <div class="q-btns">
                            <button id="clear-signature" class="q-btn q-btn-grey">
                                                            </button>
                        </div>

                        <div class="question-signature">
                            <div id="signature" class="answer-text">
                                <div id="signature-background"></div>
                            </div>
                        </div>
                        <div class="q-btns">
                            <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn answer-submit" data-type="send">
                                Continua                            </button>
                            <button id="skip-new" class="answer-skip" data-type="skip">Salta</button>

                        </div>
                    </div>
                <% } else if (question.layoutId == 5) { %>
                    <div class="q-selects">
                        <div class="q-select-wrap">
                            <select class="q-select answer-ds-day">
                                <option value="NONE" selected="true" disabled="disabled"></option>
                                                                    <option value="1">1</option>
                                                                    <option value="2">2</option>
                                                                    <option value="3">3</option>
                                                                    <option value="4">4</option>
                                                                    <option value="5">5</option>
                                                                    <option value="6">6</option>
                                                                    <option value="7">7</option>
                                                                    <option value="8">8</option>
                                                                    <option value="9">9</option>
                                                                    <option value="10">10</option>
                                                                    <option value="11">11</option>
                                                                    <option value="12">12</option>
                                                                    <option value="13">13</option>
                                                                    <option value="14">14</option>
                                                                    <option value="15">15</option>
                                                                    <option value="16">16</option>
                                                                    <option value="17">17</option>
                                                                    <option value="18">18</option>
                                                                    <option value="19">19</option>
                                                                    <option value="20">20</option>
                                                                    <option value="21">21</option>
                                                                    <option value="22">22</option>
                                                                    <option value="23">23</option>
                                                                    <option value="24">24</option>
                                                                    <option value="25">25</option>
                                                                    <option value="26">26</option>
                                                                    <option value="27">27</option>
                                                                    <option value="28">28</option>
                                                                    <option value="29">29</option>
                                                                    <option value="30">30</option>
                                                                    <option value="31">31</option>
                                                            </select>
                        </div>
                        <div class="q-select-wrap">
                            <select class="q-select answer-ds-month">
                                <option value="" selected="true" disabled="disabled"></option>
                                                                    <option value="1">Gennaio</option>
                                                                    <option value="2">Febbraio</option>
                                                                    <option value="3">Marzo</option>
                                                                    <option value="4">Aprile</option>
                                                                    <option value="5">Maggio</option>
                                                                    <option value="6">Giugno</option>
                                                                    <option value="7">Luglio</option>
                                                                    <option value="8">Agosto</option>
                                                                    <option value="9">Settembre</option>
                                                                    <option value="10">Ottobre</option>
                                                                    <option value="11">Novembre</option>
                                                                    <option value="12">Dicembre</option>
                                                            </select>
                        </div>
                        <div class="q-select-wrap">
                            <select class="q-select answer-ds-year">
                                <option value="" selected="true" disabled="disabled"></option>
                                                                    <option value="2020">2020</option>
                                                                    <option value="2019">2019</option>
                                                                    <option value="2018">2018</option>
                                                                    <option value="2017">2017</option>
                                                            </select>
                        </div>
                    </div>
                    <button data-ga-action="05. coreg-<%= questionNum %>" class="q-btn q-btn-lg answer-submit" data-type="send">Continua</button>
                    <button class="q-btn q-btn-block q-btn-transparent answer-skip" data-type="skip">Salta</button>
                <% } else if (question.layoutId == 11) { %>
                    <div class="embed-responsive embed-responsive-16by9">
                        <iframe class="embed-responsive-item" src="<%- question.iframeUrl %>" allowfullscreen></iframe>
                    </div>
                    <button class="q-btn q-btn-lg answer-skip" data-type="skip">Continua</button>
                    <button class="q-btn q-btn-block q-btn-transparent answer-skip" data-type="skip">Salta</button>
                <% } else { %>
                    <pre><%- JSON.stringify(question) %></pre>
                <% } %>
                <% if (question.disclaimer || question.readMoreTextEnabled) { %>
                    <div class="q-terms">
                        <%= question.disclaimer %>
                        <% if (question.readMoreTextEnabled) { %>
                                <span class="read-more" style="cursor: pointer"></span>
                                <div class="read-more-text" ><%= question.readMoreText %></div>
                        <% } %>
                    </div>
                <% } %>
            </div>
        </div>
    <% } %>
</script>